% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page.R
\name{page}
\alias{page}
\alias{page_fluid}
\alias{page_fixed}
\title{Modern Bootstrap page layouts}
\usage{
page(..., title = NULL, theme = bs_theme(), lang = NULL)

page_fluid(..., title = NULL, theme = bs_theme(), lang = NULL)

page_fixed(..., title = NULL, theme = bs_theme(), lang = NULL)
}
\arguments{
\item{...}{UI elements for the page. Named arguments become HTML attributes.}

\item{title}{The browser window title (defaults to the host URL of the page)}

\item{theme}{A \code{\link[=bs_theme]{bs_theme()}} object.}

\item{lang}{ISO 639-1 language code for the HTML page, such as "en" or "ko".
This will be used as the lang in the \code{<html>} tag, as in \code{<html lang="en">}.
The default (NULL) results in an empty string.}
}
\description{
These functions are small wrappers around shiny's page constructors (i.e.,
\code{\link[shiny:fluidPage]{shiny::fluidPage()}}, \code{\link[shiny:navbarPage]{shiny::navbarPage()}}, etc) that differ in two ways:
\itemize{
\item The \code{theme} parameter defaults bslib's recommended version of Bootstrap (for new projects).
\item The return value is rendered as an static HTML page when printed interactively at the console.
}
}
\section{Functions}{
\itemize{
\item \code{page_fluid()}: A \pkg{bslib} wrapper for \code{\link[shiny:fluidPage]{shiny::fluidPage()}}, a fluid
Bootstrap-based page layout that extends to the full viewport width.

\item \code{page_fixed()}: A \pkg{bslib} wrapper for \code{\link[shiny:fixedPage]{shiny::fixedPage()}}, a fixed
Bootstrap-based page layout where the page content container is centered
horizontally and its width is constrained.

}}
\seealso{
Dashboard-style pages: \code{\link[=page_sidebar]{page_sidebar()}}, \code{\link[=page_navbar]{page_navbar()}},
\code{\link[=page_fillable]{page_fillable()}}.
}
