% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_context_menu}
\alias{hot_context_menu}
\title{Handsontable widget}
\usage{
hot_context_menu(hot, allowRowEdit = TRUE, allowColEdit = TRUE,
  allowReadOnly = FALSE, allowComments = FALSE,
  allowCustomBorders = FALSE, customOpts = NULL, ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{allowRowEdit}{logical enabling row editing}

\item{allowColEdit}{logical enabling column editing. Note that
Handsontable does not support column add/remove when column types
are defined (i.e. useTypes == TRUE in rhandsontable).}

\item{allowReadOnly}{logical enabling read-only toggle}

\item{allowComments}{logical enabling comments}

\item{allowCustomBorders}{logical enabling custom borders}

\item{customOpts}{list}

\item{...}{ignored}
}
\description{
Configure the options for the right-click context menu.  See
 \href{http://docs.handsontable.com/0.16.1/demo-context-menu.html}{Context Menu} and
 \href{http://swisnl.github.io/jQuery-contextMenu/docs.html}{jquery contextMenu}
 for details.
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF) \%>\%
  hot_context_menu(allowRowEdit = FALSE, allowColEdit = FALSE)
}
