% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_class.R
\name{Request}
\alias{Request}
\title{The request of an HTTPInteraction}
\description{
object that handled all aspects of a request
}
\examples{
url <- "https://eu.httpbin.org/post"
body <- list(foo = "bar")
headers <- list(
  `User-Agent` = "libcurl/7.54.0 r-curl/3.2 crul/0.5.2",
  `Accept-Encoding` = "gzip, deflate",
  Accept = "application/json, text/xml, application/xml, */*"
)

(x <- Request$new("POST", url, body, headers))
x$body
x$method
x$uri
x$host
x$path
x$headers
h <- x$to_hash()
x$from_hash(h)
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{method}}{(character) http method}

\item{\code{uri}}{(character) a uri}

\item{\code{scheme}}{(character) scheme (http or https)}

\item{\code{host}}{(character) host (e.g., stuff.org)}

\item{\code{path}}{(character) path (e.g., foo/bar)}

\item{\code{query}}{(character) query params, named list}

\item{\code{body}}{(character) named list}

\item{\code{headers}}{(character) named list}

\item{\code{skip_port_stripping}}{(logical) whether to strip thhe port}

\item{\code{hash}}{(character) a named list - internal use}

\item{\code{opts}}{(character) options - internal use}

\item{\code{disk}}{(logical) xx}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Request$new()}}
\item \href{#method-to_hash}{\code{Request$to_hash()}}
\item \href{#method-from_hash}{\code{Request$from_hash()}}
\item \href{#method-clone}{\code{Request$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{Request} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$new(method, uri, body, headers, opts, disk)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{(character) the HTTP method (i.e. head, options, get,
post, put, patch or delete)}

\item{\code{uri}}{(character) request URI}

\item{\code{body}}{(character) request body}

\item{\code{headers}}{(named list) request headers}

\item{\code{opts}}{(named list) options internal use}

\item{\code{disk}}{boolean, is body a file on disk}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Request} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_hash"></a>}}
\subsection{Method \code{to_hash()}}{
Convert the request to a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$to_hash()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-from_hash"></a>}}
\subsection{Method \code{from_hash()}}{
Convert the request to a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$from_hash(hash)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hash}}{a list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{Request} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
