// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GatewaySensorManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.JsonRpc.peripheral.GatewaySensorManager {
  public class ValueEncoding_ValObjCodec : ValueObjectCodec
 {

    public static new void Register() {
      ValueObjectCodec.RegisterCodec(Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding.typeInfo, new ValueEncoding_ValObjCodec());
    }

    public override void EncodeValObj(LightJson.JsonObject json, ValueObject vo) {
      var inst = (Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding)vo;
      json["encodingId"] = inst.encodingId;
      json["type"] = (int)inst.type;
      json["invertState"] = inst.invertState;
      json["interpretationRules"] = new JsonArray(inst.interpretationRules.Select(
        _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
    }

    public override ValueObject DecodeValObj(ValueObject vo, LightJson.JsonObject json, Agent agent) {
      Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding inst;
      if (vo == null) {
        inst = new Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding();
      } else {
        inst = (Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding)vo;
      }
      inst.encodingId = (string)json["encodingId"];
      inst.type = (Com.Raritan.Idl.peripheral.GatewaySensorManager.EncodingType)(int)json["type"];
      inst.invertState = (bool)json["invertState"];
      inst.interpretationRules = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule>(json["interpretationRules"].AsJsonArray.Select(
        _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule.typeInfo))));
      return inst;
    }

  }
}
