/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef DIRECTOR_DETECTION_TABLES_H
#define DIRECTOR_DETECTION_TABLES_H

static const PlainGameDescriptor directorGames[] = {

	// Macromedia Sample Projectors
	{ "director",			"Macromedia Director Game" },
	{ "directortest",		"Macromedia Director Test Target" },
	{ "directortest-all",	"Macromedia Director All Movies Test Target" },
	{ "theapartment",		"The Apartment, Interactive demo" },
	{ "dirmacromedia",		"Macromedia Director" },
	{ "dirmacromind",		"MacroMind Director" },
	{ "lingoexpo",			"Director 4 Lingo Expo and Sample Titles"},

	// Commercially released games
	{ "10plus2",			"10+2" },
	{ "1stcdtoddler",		"My First CD-ROM: Toddler School" },
	{ "3bessones",			"Les Tres Bessones: Jugar i Aprendre" }, // Catalan title, English selectable in game
	{ "abclunch",		    "My Alphabet Lunch" },
	{ "abcpalsafety",		"Safety Scavenger Hunt" }, // Alphabet Pals
	{ "abductthis",			"Abduct This!" },
	{ "afiles",				"The A-Files" },
	{ "agapito",			"Agapito's Crazy Adventure" },
	{ "alice",				"Alice: An Interactive Museum" },
	{ "alphabet",			"The Interactive Alphabet" },
	{ "amandastories",		"AmandaStories" },
	{ "amber",				"AMBER: Journeys Beyond" },
	{ "amertailmb",			"An American Tail Interactive MovieBook" },
	{ "arcadeairattack",	"Classic Arcade Air Attack" },
	{ "arcadeboing",		"Classic Arcade Boing" },
	{ "arcadehockey",		"Classic Arcade Air Hockey" },
	{ "arcadelander",		"Classic Arcade Lander" },
	{ "arcadesubs",			"Classic Arcade Subs" },
	{ "arcofdoom",			"Arc of Doom" },
	{ "artrageous",			"ArtRageous!" },
	{ "atvrally",			"ATV Rally" },
	{ "artus1",				"Artus against the Demon of the Museum" },
	{ "babarcoins",			"Babar and the Royal Coin Caper" },
	{ "babesintoyland",		"Babes in Toyland: An Interactive Adventure" },
	{ "badday",				"Bad Day on the Midway" },
	{ "badmilk",			"Bad Milk" },
	{ "bananasfun",			"Bananas in Pyjamas: It's Fun Time" },
	{ "bananaspack",		"Bananas in Pyjamas: Fun Pack" },
	{ "bananasparty",		"Bananas in Pyjamas: It's Party Time" },
	{ "barbnail",			"Barbie Nail Designer" },
	{ "barbpauper",			"Barbie as the Princess and the Pauper" },
	{ "barbrapunzel",		"Barbie as Rapunzel: A Creative Adventure" },
	{ "barbswanlake",		"Barbie of Swan Lake: The Enchanted Forest" },
	{ "basilbaker",			"Venice Under Glass: A Basil Baker Mystery Adventure"},
	{ "bbbighelpers",		"Little Bears Make Big Helpers: Life's Little Lessons with the Berenstain Bears"},
	{ "bearfamily",			"A Bear Family Adventure" },
	{ "beautyorbeast",		"Beauty or the Beast" },
	{ "betterd",			"The Better Dead Ratification" },
	{ "beyondthewall",		"Beyond the Wall of Stars" },
	{ "birdlife",     		"Shelley Duvall's It's a Bird's Life" },
	{ "blinkybill1",		"Blinky Bill's Ghost Cave" },
	{ "blinkyps",			"Blinky Bill: Play and Learn - Preschool" },
	{ "blinkyk1",			"Blinky Bill: Play and Learn - Kindergarten" },
	{ "blinkyy1",			"Blinky Bill: Play and Learn - Year 1" },
	{ "bobcastle",			"Bob the Builder: Bob's Castle Adventure" },
	{ "bodypark",			"Body Park" },
	{ "brer",				"Brer Rabbit and the Wonderful Tar Baby" },
	{ "buzz1",				"Buzz Lightyear 1st Grade" },
	{ "casino",				"Casino!" },
	{ "casinoblackjack",	"Casino Black Jack" },
	{ "casinokeno",			"Casino Keno" },
	{ "casinopoker",		"Casino Poker" },
	{ "casinoslots",		"Casino Slots" },
	{ "casperact",			"Casper Activity Center" },
	{ "cassandra",			"The Cassandra Galleries" },
	{ "catcameback",		"The Cat Came Back" },
	{ "catshats",			"Black Cats and Pointed Hats" },
	{ "cbible",				"Children's Bible Stories" },
	{ "cclown",				"A Color Clown Comes to Town" },
	{ "ceremony",			"Ceremony of Innocence" },
	{ "chaos",				"The C.H.A.O.S. Continuum" },
	{ "checkersvillage",   	"Checkers' Village" },
	{ "chopsuey",   		"Chop Suey" },
	{ "circus",				"Circus!" },
	{ "connections",   		"Connections" },
	{ "crusader",   		"Crusader: A Conspiracy in the Kingdom of Jerusalem" },
	{ "crusader2000",   	"Crusader: Edition 2000" },
	{ "daedalus",			"The Daedalus Encounter" },
	{ "darkeye",			"The Dark Eye" },
	{ "dazzeloids",			"Dazzeloids" },
	{ "dcanyon",			"Devil's Canyon: A Dinamation Adventure" },
	{ "deathstar",			"Death Star Destructo" },
	{ "derratsorcerum",		"Derrat Sorcerum" },
	{ "devo",				"DEVO Presents: Adventures of the Smart Patrol" },
	{ "digby",				"Digby's Adventures: Tales of a 1-Pound Dog" },
	{ "dimensionq",			"Iz and Auggie: Escape from Dimension Q" },
	{ "dinosafari",			"Dinosaur Safari" },
	{ "dispix2and3",		"Disney Pixar Learning: 2nd & 3rd Grade" },
	{ "donnamatrix",		"Donna Matrix" },
	{ "draculassecret",		"Dracula's Secret" },
	{ "easternmind",		"Eastern Mind: The Lost Souls of Tong Nou" },
	{ "eddieminx",			"Eddie & Minx: Waking Up the Magic" },
	{ "elmopreschool",		"Elmo's Preschool" },
	{ "elroybug",			"Elroy Goes Bugzerk" },
	{ "elroycostume",		"Elroy's Costume Closet" },
	{ "elroypave",			"Elroy Hits the Pavement" },
	{ "erdisaster",			"Emergency Room: Disaster Strikes" },
	{ "fct",				"Big Top's Cartoon Toolbox Starring Felix the Cat" },
	{ "fctplayer",			"Felix Cartoon Player" },
	{ "fctexport",			"Felix's Cartoon Transformer" },
	{ "fff",				"Four Footed Friends" },
	{ "fishwish",			"The Fish Who Could Wish" },
	{ "flipper",			"Flipper" },
	{ "flipper1",           "The Three Worlds of Flipper & Lopaka" },
	{ "flipper2",           "Flipper & Lopaka: Secrets of the Deep" },
	{ "foocastle",			"Foo Castle" },
	{ "forestia",			"Forestia: The Great Adventure" },
	{ "fpairport",			"Fisher-Price Little People: Discovery Airport" },
	{ "fpbaxter",			"Fisher-Price Read & Play: Baxter's Birthday" },
	{ "fpcastle2",			"Great Adventures by Fisher-Price: Castle (1998)" },
	{ "fpcon",				"Fisher-Price Big Action Construction" },
	{ "fpdollhouse",		"Fisher-Price Time to Play: Grand Dollhouse" },
	{ "fpgarage",			"Fisher-Price Big Action Garage" },
	{ "fppirates",			"Great Adventures by Fisher-Price: Pirates" },
	{ "fpreadyt",			"Fisher-Price Ready for School: Toddler" },
	{ "fpreadyk",			"Fisher-Price Ready for School: Kindergarten" },
	{ "fpready1",			"Fisher-Price Ready for School: First Grade" },
	{ "fpwestern",			"Great Adventures by Fisher-Price: Wild Western Town" },
	{ "fpxmas",				"Fisher-Price Little People: Christmas Activity Center" },
	{ "fpyolanda",			"Fisher-Price Read & Play: Yolanda Yellsalot" },
	{ "frankenstein",		"Frankenstein: Through the Eyes of the Monster" },
	{ "frankac",			"Franklin's Activity Center" },
	{ "franklm",			"Franklin Learns Math" },
	{ "frankrw",			"Franklin's Reading World" },
	{ "freakshow",			"Freak Show" },
	{ "fsky",				"A Field Trip to the Sky" },
	{ "fuzzyfloppybee",		"Fuzzy & Floppy: The Adventure of the Golden Bee" },
	{ "gadget",				"Gadget: Invention, Travel & Adventure" },
	{ "gadgetpaf",			"Gadget: Past as Future" },
	{ "garage",				"Garage: Bad Dream Adventure" }, // English fan translation
	{ "garfieldmadcats",	"Garfield: Mad about Cats" },
	{ "garygadget1",		"Building Cars with Gary Gadget" }, // Sequels list under Swedish
	{ "generations",		"Generations" },
	{ "getaheadmath",		"Math Heads" },
	{ "getaheadmathcr",		"Math Heads Creator" },
	{ "getaheadstrat",		"Strategy Heads" },
	{ "getaheadstratcr",	"Strategy Heads Creator" },
	{ "ggmd",				"The Great Green Mouse Disaster" },
	{ "ggmdmaze",			"The Great Green Mouse Disaster: Mouse Maze" },
	{ "ggmdpics",			"The Great Green Mouse Disaster: Gallery" },
	{ "ggmdsuper",			"The Great Green Mouse Disaster: Super Game" },
	{ "gigglecity",   		"Infinity City" },
	{ "gigglefarm",   		"AlphaBonk Farm" },
	{ "giggletour",			"The Gigglebone Gang World Tour" },
	{ "gigglevania",		"Pantsylvania: The Kingdom of the Fancy Pants" },
	{ "goldilocks",			"Goldilocks Gamebook" },
	{ "gordak",				"Gord@k" },
	{ "grammarplaytime2",	"Grammar Playtime Vol.2: Asking Questions" },
	{ "gundam0079",			"Gundam 0079: The War for Earth" },
	{ "guscarn",			"Gus Goes to the Kooky Carnival" },
	{ "gusolis",			"Gus Goes to Cyberopolis" },
	{ "guspark",			"Gus Goes to CyberStone Park" },
	{ "gussshc",			"Gus and the CyberBuds Software SchoolHouse Collection" },
	{ "gustown",			"Gus Goes to Cybertown" },
	{ "hamletmurder",		"Hamlet: A Murder Mystery" },
	{ "hamsterland1",		"Busy People of Hamsterland" },
	{ "hamsterland2",		"Hamsterland: The Time Machine" },
	{ "heidi",				"Heidi: Your World is the Mountains" },
	{ "hellcab",			"Hell Cab" },
	{ "hhouse",				"Gahan Wilson's The Ultimate Haunted House" },
	{ "hkbigfun",			"Hello Kitty Big Fun Deluxe" },
	{ "horrortour1",		"Zeddas: Servant of Sheol" },
	{ "id4p1",     			"iD4 Mission Disk 1 - Alien Supreme Commander" },
	{ "id4p2",      		"iD4 Mission Disk 2 - Alien Science Officer" },
	{ "id4p3",      		"iD4 Mission Disk 3 - Warrior Alien" },
	{ "id4p4",      		"iD4 Mission Disk 4 - Alien Navigator" },
	{ "id4p5",      		"iD4 Mission Disk 5 - Captain Steve Hiller" },
	{ "id4p6",      		"iD4 Mission Disk 6 - Dave's Computer" },
	{ "id4p7",      		"iD4 Mission Disk 7 - President Whitmore" },
	{ "id4p8",      		"iD4 Mission Disk 8 - Alien Attack Fighter" },
	{ "id4p9",      		"iD4 Mission Disk 9 - FA-18 Fighter Jet" },
	{ "id4p10",     		"iD4 Mission Disk 10 - Alien Bomber" },
	{ "id4p11",     		"iD4 Mission Disk 11 - Area 51" },
	{ "improv",     		"Don't Quit Your Day Job" },
	{ "ingenious",     		"Ingenious!" },
	{ "ingenioused",     	"Ingenious! Education Resources" },
	{ "ironhelix",			"Iron Helix" },
	{ "isis",				"Isis" },
	{ "ispy",				"I Spy" },
	{ "ispyschool",			"I Spy School Days" },
	{ "ispyspooky",			"I Spy Spooky Mansion" },
	{ "jewels1",			"Jewels of the Oracle" },
	{ "jewels2",			"Gems of Darkness" }, // Jewels II
	{ "jman",				"The Journeyman Project" },
	{ "jman2",				"The Journeyman Project 2: Buried in Time" },
	{ "jmmd",       		"Just Me & My Dad" },
	{ "js123",				"JumpStart Numbers" },
	{ "jsabc",				"JumpStart ABC's" },
	{ "jsmusic",			"JumpStart Music" },
	{ "jsspanish",			"JumpStart Spanish" },
	{ "jsworldp",			"JumpStart World: Preschool" },
	{ "jsworldk",			"JumpStart World: Kindergarten" },
	{ "jsworld1",			"JumpStart World: First Grade" },
	{ "jsworld1t",			"JumpStart World: Teacher Control Panel 1st Grade" },
	{ "jsworld2",			"JumpStart World: Second Grade" },
	{ "jsworld2t",			"JumpStart World: Teacher Control Panel 2nd Grade" },
	{ "jumpaheadss2000at",  "Jump Ahead Starting School 2000: Assessment Test" },
	{ "jumpaheadss2000wb",  "Jump Ahead Starting School 2000: Workbook" },
	{ "karma",				"Karma: Curse of the 12 Caves" },
	{ "kellyparade",		"Kelly Club Pet Parade" },
	{ "keroppi",			"Keroppi Day Hopper" },
	{ "kidsmathsquest",		"Kid's Maths Quest" },
	{ "kingandi",			"The King and I: Animated Thinking Adventure" },
	{ "kyoto",				"Cosmology of Kyoto" },
	{ "lbkinder",			"Maurice Sendak's Little Bear Kindergarten Thinking Adventures" },
	{ "lbpre",				"Maurice Sendak's Little Bear Preschool Thinking Adventures" },
	{ "lbtpreschool",		"The Land Before Time: Preschool Adventure" },
	{ "legendsofoz",		"The Legends of Oz" },
	{ "letters",			"Letters" },
	{ "louiscatorze",		"Louis Cat Orze: The Mystery of the Queen's Necklace" },
	{ "madcc12",			"Madeline Classroom Companion: 1st & 2nd Grade" },
	{ "madccpk",			"Madeline Classroom Companion: Preschool & Kindergarten" },
	{ "madpup",				"Madeline and the Magnificent Puppet Show: A Learning Journey" },
	{ "madtg",				"Madeline Thinking Games" },
	{ "majestic",			"Majestic Part I: Alien Encounter" },
	{ "maniacsports",		"Maniac Sports" },
	{ "mastermansion",		"Masterpiece Mansion" },
	{ "mastermansionex",	"Masterpiece Mansion: Art Explorer" },
	{ "martian",			"Ray Bradbury's The Martian Chronicles Adventure Game" },
	{ "maze",				"The Riddle of the Maze" },
	{ "mcmillennium",		"Mission Code: Millennium" },
	{ "mediaband",			"Meet MediaBand" },
	{ "melements",			"Masters of the Elements" },
	{ "mentalmaths",		"Mental Maths Booster" },
	{ "miareading1",		"Mia's Reading Adventure: The Search for Grandma's Remedy" },
	{ "miamath",			"Mia's Math Adventure: Just in Time!" },
	{ "mickeyk",			"Mickey Mouse Kindergarten" },
	{ "mickeyp",			"Mickey Mouse Preschool" },
	{ "mickeyt",			"Mickey Mouse Toddler" },
	{ "mirage",				"Mirage" },
	{ "mmalgebra",			"Multimedia Algebra" },
	{ "mmiqtest",			"Multimedia IQ Test" },
	{ "mmmath3",			"Mission Masters Math Grade 3: Defeat Dirty D!" },
	{ "mrsquack",			"Reading with Peter Cottontail: The Story of Mrs. Quack" },
	{ "mummy",				"Mummy: Tomb of the Pharaoh" },
	{ "muppetkidsearly5",	"Muppets Kids Early Learning Series Volume 5: Sound Patterns: Phonics" },
	{ "muppetkidsthinking",	"Muppets Kids Thinking Skills" },
	{ "murderbrett",		"Who Killed Brett Penance?" },
	{ "murdermagic",		"The Magic Death" },
	{ "murdersam",			"Who Killed Sam Rupert?" },
	{ "murdertaylor",		"Who Killed Taylor French? The Case of the Undressed Reporter" },
	{ "myfirstwords",		"My First Reading & Spelling Words" },
	{ "mylk",				"Mylk" },
	{ "necrobius",			"Necrobius" },
	{ "necromancer",		"Necromancer" },
	{ "nightcafe",			"Night Café" },
	{ "nikolaiknights",		"Nikolai in Time: In the Time of the Knights" },
	{ "nikolaimystery",		"Nikolai's Mysteries: The Mystery of the Black Windows" },
	{ "nikolaipirates",		"Nikolai's Pirates" },
	{ "nikolaispace",		"Nikolai in Outer Space" },
	{ "nikolaispaceedu",	"Nikolai Space Education" },
	{ "nikolaitoys",		"NN'nN Toy Makers" },
	{ "nikolaitreats",		"Nikolai's Treats" },
	{ "nile",				"Nile: Passage to Egypt" },
	{ "nine",				"9: The Last Resort" },
	{ "noir",				"Noir: A Shadowy Thriller" },
	{ "nurseryrhymes",		"Multimedia Nursery Rhymes" },
	{ "okay2000",			"O!Kay! Best of 2000" },
	{ "okaydemo",			"O!Kay! Probier\' mal! Try out!" },
	{ "okaydownunder",		"O!Kay! Down Under" },
	{ "okaydragon",			"O!Kay! Red Dragon" },
	{ "okayfriends",		"O!Kay! Friends" },
	{ "okayhenry",			"O!Kay! Henry in Love" },
	{ "okaytruehero",		"O!Kay! A True Hero" },
	{ "operafatal",			"Opera Fatal" },
	{ "oslotg",				"Adventures with Oslo: Tools and Gadgets" },
	{ "oztma",				"Oz: The Magical Adventure" },
	{ "paws",				"P.A.W.S.: Personal Automated Wagging System" },
	{ "pbbear",				"P. B. Bear's Birthday Party" },
	{ "perdido",			"Lost in the Amazon" },
	{ "peterrabbit",		"The Adventures of Peter Rabbit and Benjamin Bunny" },
	{ "physicus",			"Physicus: Save the World with Science!" },
	{ "phonicsquest",		"Disney Phonics Quest" },
	{ "pingu1",				"Pingu: A Barrel of Fun!" },
	{ "planetarizona",		"Escape from Planet Arizona" },
	{ "playroom",			"The Playroom" },
	{ "poohac",				"Winnie the Pooh Activity Center" },
	{ "poohb",				"Winnie the Pooh Baby" },
	{ "poohk",				"Winnie the Pooh Kindergarten" },
	{ "poohp",				"Winnie the Pooh Preschool" },
	{ "pooht",				"Winnie the Pooh Toddler" },
	{ "princessfashion",	"Disney's Princess Fashion Boutique" },
	{ "pyst",				"Pyst" },
	{ "pyst2",				"Driven: The Sequel to Pyst" },
	{ "pystmake",			"The Making of Pyst" },
	{ "rainbowfish1",		"Rainbow Fish: The most beautiful fish in the ocean!" },
	{ "rainbowfish2",		"Rainbow Fish and the Whale" },
	{ "rhem1",				"Rhem" },
	{ "rhlava",				"Rescue Heroes: Lava Landslide" },
	{ "rhmeteor",			"Rescue Heroes: Meteor Madness" },
	{ "rodneyfs",			"Rodney's Funscreen" },
	{ "rodneyfs2",			"Rodney's Funscreen² Extreme: Dinky's Revenge" },
	{ "rodneyww",			"Rodney's Wonder Window" },
	{ "safecracker", 		"Safecracker" },
	{ "sajaklucky",			"Pat Sajak's Lucky Letters" },
	{ "screamingmetal",		"Screaming Metal" },
	{ "searchlearn",     	"Search & Learn Adventures" },
	{ "secretkeys",     	"Search for the Secret Keys with Mickey" },
	{ "secretpaths1",		"Secret Paths in the Forest" },
	{ "sfpd",               "SFPD Homicide Case File: The Body in the Bay" },
	{ "shellwhirl",			"Shell Whirl" },
	{ "shr1st2nd",			"Schoolhouse Rock!: 1st & 2nd Grade Essentials" },
	{ "shr3rd4th",			"Schoolhouse Rock!: 3rd & 4th Grade Essentials" },
	{ "shramerica",			"Schoolhouse Rock!: America Rock" },
	{ "shrgrammar",			"Schoolhouse Rock!: Grammar Rock" },
	{ "shrlucky",			"Schoolhouse Rock!: Lucky's Math Arcade" },
	{ "shrmath",			"Schoolhouse Rock!: Math Rock" },
	{ "shrmess",			"Schoolhouse Rock!: 1st-4th Grade Math Essentials" },
	{ "simpsonplayer",		"The Simpsons Cartoon Player"},
	{ "simpsonstudio",		"The Simpsons Cartoon Studio"},
	{ "sitfarm",	        "Sitting on the Farm"},
	{ "skeeto10",			"Skipper & Skeeto: Fun in the Park" }, // Magnus & Myggen
	{ "skippy",             "Skippy and the Curse of the Temple of Ock" },
	{ "skyborg",			"SkyBorg: Into the Vortex" },
	{ "slamdunktyping",		"Slam Dunk Typing" },
	{ "smartsteps3rd",		"Smart Steps 3rd Grade" },
	{ "snh",				"A Silly Noisy House" },
	{ "snow7han",			"Snow White and the Seven Hansels: The Fairy Tale Game" },
	{ "spacestationalpha",	"Space Station Alpha: The Encounter" },
	{ "spellingbee",		"Arc Media Spelling Bee" },
	{ "spyclub",			"Spy Club" },
	{ "spykids3d",			"Spy Kids 3-D: Game Over" },
	{ "starwarped",			"Star Warped" },
	{ "staytooned",			"Stay Tooned!" },
	{ "superspy",			"SuperSpy 1" },
	{ "supertutorgram",		"Super Tutor Grammar" },
	{ "takeru",				"Buichi Terasawa's Takeru: Letter of the Law" },
	{ "teamxtreme1",		"Operation: Weather Disaster" },
	{ "teamxtreme2",		"Operation: Eco-Nightmare" },
	{ "the7colors",			"The Seven Colors: Legend of PSY・S City" }, // English fan translation
	{ "timelapse",			"Timelapse" },
	{ "timmysafari",		"Timmy's Safari Adventure" },
	{ "tkkg2",				"A Case for TKKG 2: Deadly Chocolate" },
	{ "tkkg3",				"A Case for TKKG 3: The Mystery of the Mayan Treasure" },
	{ "tkkg4",				"A Case for TKKG 4: The Secret of Dragon Claw Manor" },
	{ "tkkg6",				"A Case for TKKG 6: The Forged Fifties" },
	{ "tkkg9",				"A Case for TKKG 9: Voodoo Magic" },
	{ "tommy",				"Pete Townshend Presents Tommy: The Interactive Adventure" },
	{ "totaldistortion",	"Total Distortion" },
	{ "traitorsgate",		"Traitors Gate" },
	{ "trekborg",			"Star Trek: Borg" },
	{ "trekklingon",		"Star Trek: Klingon" },
	{ "tweeniesrtp",		"Tweenies: Ready to Play" },
	{ "vcop",				"Virtual Cop" },
	{ "vcop1",				"Virtual Cop: Episode One: Good Cop / Bad Cop" },
	{ "vcop2",				"Virtual Cop: Episode Two: The Angel Returns" },
	{ "vnc",				"Virtual Nightclub" },
	{ "vvcyber",			"Victor Vector & Yondo: The Cyberplasm Formula" },
	{ "vvdinosaur",			"Victor Vector & Yondo: The Last Dinosaur Egg" },
	{ "vvharp",				"Victor Vector & Yondo: The Hypnotic Harp" },
	{ "vp2",				"Virtual Physics: The Eggs of Time" },
	{ "vvvampire",			"Victor Vector & Yondo: The Vampire's Coffin" },
	{ "warlock", 			"Spaceship Warlock" },
	{ "wiggles1", 			"A Day with the Wiggles" },
	{ "winnie", 			"Winnie the Witch" },
	{ "wishbone", 			"Wishbone and the Amazing Odyssey" },
	{ "wrath",				"Wrath of the Gods" },
	{ "xanthus",			"Xanthus" },
	{ "xfools",				"The X-Fools: The Spoof is Out There" },
	{ "y2lmath",			"Yearn2Learn: Master Snoopy's Math" },
	{ "y2lpeanuts",			"Yearn2Learn: Peanuts" },
	{ "y2lsnoopy",			"Yearn2Learn: Snoopy" },
	{ "ybr1",				"Yellow Brick Road" },

	// Multimedia or reference products
	{ "9worlds",			"Nine Worlds hosted by Patrick Stewart" },
	{ "aamn",				"Anatomy & Anaesthesia of the Mandibular Nerve" },
	{ "adamcmp",			"A.D.A.M. Comprehensive" },
	{ "adamess",			"A.D.A.M. Essentials" },
	{ "adamstd",			"A.D.A.M. Standard" },
	{ "adamtis",			"A.D.A.M. The Inside Story" },
	{ "alankay",			"Alan Kay CD-ROM Pack" },
	{ "alcohol101",			"Alcohol 101" },
	{ "alice2ocean",		"From Alice to Ocean: Alone Across the Outback" },
	{ "amnesty",			"Amnesty Interactive" },
	{ "aruba",				"Aruba Interactive" },
	{ "athletics",			"International Athletics" },
	{ "babylon5int",		"Babylon 5 Interactive" },
	{ "battles",			"Battles of the World" },
	{ "beatexp",			"The Beat Experience" },
	{ "bettypage",			"Betty Page: The World of a Pin-Up Queen" },
	{ "beyondcyberpunk",	"Beyond Cyberpunk! A Do-It-Yourself Guide to the Future" },
	{ "bht",				"A Brief History of Time: An Interactive Adventure" },
	{ "bioflix",			"BioFlix" },
	{ "bowie",				"JUMP: The David Bowie Interactive CD-ROM" },
	{ "bugbook",			"The Multimedia Bug Book" },
	{ "canelect",			"Exploring Canada's Electoral System" },
	{ "cdphysics",			"CD Physics for Windows" },
	{ "cezanne",			"A is for ART, C is for Cezanne" },
	{ "cezannetour",		"Paul Cézanne Art Tours" },
	{ "chuniverse",   		"The Challenge of the Universe" },
	{ "cinevolt",   		"Cinema Volta: Weird Science & Childhood Memory" },
	{ "cocktailhour",		"Cocktail Hour: A Guide to Bartending" },
	{ "comusic",			"Computer Music: An Interactive Documentary" },
	{ "cpnre",				"Canadian Practical Nurse Registration Exam Practice" },
	{ "ctrain",   			"Doing it in C++" },
	{ "dailymail100",		"Daily Mail Centenary: 100 Amazing Years" },
	{ "delphi4tutor",		"Borland Delphi 4 Tutor" },
	{ "dinos",				"Multimedia Dinosaurs" },
	{ "dynamichuman",		"The Dynamic Human: The 3D Guide to Anatomy and Physiology" },
	{ "easybass",			"Easy Bass" },
	{ "easyitalian",		"Easy Cooking Italian" },
	{ "edh",				"Executive Diet Helper" },
	{ "egypt",				"Egypt: Voyage to the Land of the Pharaohs" },
	{ "einstein",			"The Ultimate Einstein" },
	{ "espanatomy",			"Anatomy & Physiology: The Unity of Form and Function" },
	{ "exoticjapan",		"Exotic Japan: A Guide to Japanese Culture and Language" },
	{ "explorers",			"Explorers of the New World" },
	{ "flw",				"The Ultimate Frank Lloyd Wright: America's Architect" },
	{ "fractiondecimal",	"Fractions & Decimals" },
	{ "fusion",				"Harnessing the Energy of the Stars" },
	{ "futureview",			"FutureView: The 1990s and Beyond" },
	{ "ghetto",				"Stories from the Warsaw Ghetto" },
	{ "golfcd",				"The Great Golf CD: Links, Legends & Lore" },
	{ "gp2006",				"Grand Prix 2006 & Auto Directory" },
	{ "guns",				"Multimedia Guns" },
	{ "haight",			    "Haight-Ashbury in the Sixties" },
	{ "heuther",			"Understanding Pathophysiology, 3rd Edition" },
	{ "ibmcdextra",			"Sony Music CD Extra Sampler" },
	{ "iptr",				"I Photograph to Remember" },
	{ "isscommerce",		"International Space Station: Space Commercialization" },
	{ "itc",				"Internet the City: A Guided Tour Through the Internet" },
	{ "journey2life",		"The Journey to Life" },
	{ "laughingbird",		"The Laughing Bird Restaurant" },
	{ "learninternet",		"Video Professor: Learn to Use the Internet" },
	{ "learnworks2",		"Video Professor: Learn Works for Windows 95, Level 2" },
	{ "leonardo",			"Leonardo the Inventor" },
	{ "lewisclark",			"Lewis & Clark Interactive Picture CD" },
	{ "louvre",				"Le Louvre: The palace & its paintings" },
	{ "makers",				"Makers of the 20th Century" },
	{ "mediabook",			"The MediaBook CD for Director" },
	{ "moag",				"The Museum of Anything Goes" },
	{ "msa2001",		    "Middle School Advantage 2001" },
	{ "ms500nations",		"Microsoft 500 Nations" },
	{ "msdinosaurs",		"Microsoft Dinosaurs" },
	{ "msoceans",			"Microsoft Oceans" },
	{ "mswine",				"Microsoft Wine Guide" },
	{ "mysteriousegypt",	"Mysterious Egypt" },
	{ "newslinks",			"ABC NewsLinks" },
	{ "nia4",			    "News in Action 4" },
	{ "nixon",				"Nixon: Watergate" },
	{ "nmm",				"Nine Month Miracle" },
	{ "painters",			"Emile de Antonio's Painters Painting" },
	{ "paris",				"Paris: History and Splendour" },
	{ "parisvt",			"Virtual Tourism Paris" },
	{ "parliament",			"People & Parliament: A Stranger's Guide to Westminster" },
	{ "picasso",			"Picasso: the man, his works, the legend" },
	{ "pixar",				"Pixar Projector" },
	{ "planetstrass",		"Pl@net" },
	{ "potala",             "1000 Years Potala" },
	{ "princetonsat98",		"The Princeton Review: Inside the SAT '98" },
	{ "revwar",     		"Revolutionary War Picture CD" },
	{ "rodneyab",			"Rodney's Art Brain" },
	{ "saguaro",            "Saguaro & the City: Investigate the Sonoran Desert with an Interactive CD ROM" },
	{ "saillusion",     	"Scientific American Library: Illusion" },
	{ "sarahcatalog",     	"Sarah McLachlan Catalogue" },
	{ "sauniverse",     	"Scientific American Library: The Universe" },
	{ "sciencesmart",		"Science Smart" },
	{ "scrutiny",			"ScruTiny in the Great Round" },
	{ "sialmanac94",		"Sports Illustrated 1994 Multimedia Almanac" },
	{ "sk8board",			"RIDE: An Interactive Skateboarding Experience" },
	{ "supersonic",			"Supersonic: A Multimedia Guide to Modern Military Aircraft" },
	{ "survive",			"How Would You Survive?" },
	{ "take5",				"Take Five: Relaxation at Your Finger Tips" },
	{ "technik",			"Technology Interactive" },
	{ "toyota95",			"1995 Toyota Interactive" },
	{ "trekguideds9",		"Star Trek: Deep Space Nine Episode Guide" },
	{ "trekguidetng",		"Star Trek: The Next Generation Episode Guide" },
	{ "trekomni",			"Star Trek Omnipedia" },
	{ "trekpedia98",		"Star Trek Encyclopedia 1998" },
	{ "trektech",			"Star Trek: The Next Generation Interactive Technical Manual" },
	{ "truthsfictions",		"Truths & Fictions: A Journey from Documentary to Digital Photography" },
	{ "universe",			"Invisible Universe" },
	{ "unwrap",				"Unwrap the Magic: Holiday 2000 Interactive CD-ROM" }, // J.C.Penney
	{ "ushistory",			"The History of the United States for Young People" },
	{ "vote",				"Vote America: Your Field Guide to Electing a President" },
	{ "vtarot",				"Virtual Tarot" },
	{ "vusic",				"Vusic: The Screen Raver" },
	{ "warplanes", 			"Warplanes: Modern Fighting Aircraft" },
	{ "webmaster", 			"Webmaster: Fantastic Adventures in the World of the Internet" },
	{ "whales", 			"World of Whales: An Interactive Voyage of Pure Wonder" },
	{ "wildblueyonder1", 	"Wild Blue Yonder: Episode 1: 50 Years Of Gs And Jets" },
	{ "wine", 				"The Wine CD" },
	{ "woodstock25", 		"Woodstock: 25th Anniversary CD-ROM: 3 Days of Peace & Music" },
	{ "womanengineer", 		"You Can Be a Woman Engineer" },
	{ "worldnet",			"AT&T WorldNet Service E-Guide" },
	{ "wwanimals", 			"Wide World of Animals" },
	{ "xfua",				"The X-Files Unrestricted Access" },

	// Shareware and freeware
	{ "101pet",				"Dalmation Adoption" },
	{ "50ftchicken",        "Attack of the 50-foot Chicken" },
	{ "alanna",             "The Lost Island of Alanna" },
	{ "antsafire",			"Ants Afire!" },
	{ "aolstarwars",		"Star Wars: Episode III: Game, Videos & More!" },
	{ "arad",				"Animaniacs River Adventure" },
	{ "belcher",			"The Belcher" },
	{ "bigsound",			"BigSound VW Player" },
	{ "bigtimemovie",		"Big Time Movie Studios" },
	{ "bingobuds",			"Bingo Buddies" },
	{ "bob",				"Bob" },
	{ "broadwayyb",			"The 2000-2001 Broadway Series Interactive Yearbook" },
	{ "catseyeview",		"Cat's Eye View" },
	{ "childishgambino",	"Capturing Donald Glover's Motion" },
	{ "colormind",   		"ColorMind" },
	{ "crybaby",   			"Crying, Screaming Baby" },
	{ "dfireworks",			"The Digital Fireworks Stand" },
	{ "dreidel",			"DreidelLand: An Electronic Hanukah Treat" },
	{ "emigre",				"Emigre Signs of Type: Big Cheese" },
	{ "kfk",				"Kung Fu Kim" },
	{ "limit0",				"Limit 0" },
	{ "makeamug",			"Make-A-Mug" },
	{ "mathtest",			"Math Test" },
	{ "njdevils2001",		"2001 New Jersey Devils Interactive CD ROM" },
	{ "nomis",				"Nomis" },
	{ "nyknicks2000",		"NY Knicks 2000" },
	{ "nykshuffle",			"NYK Shuffle" },
	{ "nyyankeesyb",		"New York Yankees Interactive Yearbook" },
	{ "pfarrypuzzle",		"Paul Farry Puzzle" },
	{ "prangers1",			"PowerRangers Part 1" },
	{ "prangers2",			"PowerRangers Part 2" },
	{ "psych",				"Psych: An Interactive Stress Buster!" },
	{ "saspurs2001",     	"San Antonio Spurs 2001 Broadcast Screensaver" }, // Not a screensaver
	{ "saspurs2005",     	"San Antonio Spurs Internet Hot-links" }, // Not a screensaver
	{ "seinfeldondvd",		"Seinfeld on DVD" },
	{ "sensei",				"Sensei" },
	{ "simpsontrivia",		"The Simpsons Trivia" },
	{ "sonysampler",		"Sony Music Sampler" },
	{ "sorgato",			"Sylvain Sorgato's Drawings in variable color" },
	{ "thematrix",			"The Matrix: Cinemas Everywhere June 11" },
	{ "timeline",			"TimeLine Animation" },
	{ "troubleshoot101",	"Troubleshooting 101" },
	{ "twine",				"The World is Not Enough 007" },
	{ "verttice",			"DreamLight Verttice" },
	{ "wonkatrivia",		"Wonka Trivia" },
	{ "wriggle",			"Wriggle" },

	// Music videos and enhanced music CDs
	{ "avrilletgo",			"Avril Lavigne: Let Go" },
	{ "bobmambo5",			"Bob the Builder: Mambo No. 5" },
	{ "chaquico1000",		"Craig Chaquico: A Thousand Pictures" },
	{ "concentration",		"Solitudes: Natural Concentration" },
	{ "girlsaloudbox",		"Girls Aloud: The Singles Box Set" },
	{ "imesceneryfish",		"I Mother Earth: Scenery and Fish" },
	{ "princerave",			"Prince: Rave Un2 the Joy Fantastic" },
	{ "relaxation",			"Solitudes: Natural Relaxation" },
	{ "relaxplayer",		"Solitudes: Natural Relaxation Audio Player" },
	{ "royksoppam",			"Röyksopp: Melody A.M." },
	{ "sarahsurfacing",		"Sarah McLachlan: Surfacing" },
	{ "smashchillin",		"Smash Hits: Chillin\' Out Summer 2001" },
	{ "songbird",			"Solitudes: Songbird Symphony" },
	{ "stressrelief2",		"Solitudes: Natural Stress Relief II" },
	{ "tonetrakker",		"Tone Trakker" },

	// Arabic titles
	{ "abctrain",			"Alphabet Train" },
	{ "alhisab",			"هيا نتعلم الحساب والمفاهيم" },		   // Let's learn arithmetic (al-hisab) and concepts
	{ "anasheed",			"إسطوانة قطار القصص والأناشيد" },	   // Train of Stories & Songs
	{ "futsoft",			"برامج تعليمية من شركة فيوتشر سوفت" }, // Future Soft educational demos
	{ "hamamalachkal",		"تعلم مع همام الأشكال" },			   // Learn Shapes with Hamam
	{ "hamamalalwan",		"تعلم مع همام الألوان" },			   // Learn Colors with Hamam
	{ "hamamalhuruf",		"تعلم مع همام الحروف" },			   // Learn Letters with Hamam
	{ "ktaralarkam",		"قطاد الأرقام" },					   // Numbers Train
	{ "mesoftware",			"شركة الشرق الأوسط للبرمجيات" },	   // Middle East Software Company
	{ "sakhr",				"مجلة برامج صخر" },					   // Sakhr Software Catalogue

	// Catalan titles
	{ "3iadins",			"TV3 i a dins!" },
	{ "limit0inici",		"Límit 0 Inici" },

	// Czech titles
	{ "nemcina",            "Německá gramatika cvičebnice" },           // German grammar workbook

	// Danish titles
	{ "bamse1",				"Bamses allerskoreste spille-rom" },
	{ "bamse2",				"Bamse: Min egen spille-rom" },
	{ "billetrille1",		"Bille & Trille: Da fantasien slap løs" },
	{ "billetrille2",		"Bille & Trille: Helt ude i skoven" },

	// Dutch titles
	{ "beestenboel",		"Beestenboel Zoölogic" },
	{ "boeboekshaboe",		"Boeboeks: Hop hop haboe!" },
	{ "boeboekstocht",		"Boeboeks: de toch naar opa Kakadoris" },
	{ "fcdk",				"F.C. De Kampioenen: Op Zoek Naar Neroke" },
	{ "griezelbus1",		"De Griezelbus 1" },
	{ "kjoeties",			"Invasie van de Kjoeties" },
	{ "lannoo",				"Lannoo Nieuwe Media Demo" },
	{ "samson",				"Op Reis Met Samson & Gert" },

	// Finnish titles
	{ "aapelin1",			"Aapelin ABC: Hurjistunut Pölynimuri" },
	{ "kcd",				"Kompuutteri Kaikille" },
	{ "kultapossu",			"Kultapossu ja Leo Leijona: Sateenkaarivarkaat" },
	{ "petepilotti1",		"Pete Pilotti & Pontiac: Seikkailu Lapponiassa" },

	// French titles
	{ "1contre100",			"1 contre 100" },
	{ "affaires1",			"Affaires à suivre: L'Île diabolique" },
	{ "boulebill",			"Boule et Bill: Au Voleur!" },
	{ "fg25ans",			"25 Ans! Le CD-ROM de Fluide Glacial" },
	{ "forestiajr",			"Forestia Révoltozoo" },
	{ "guignols1",			"Les Guignols de l'Info ... LE JEU!" },
	{ "guignols2",			"Les Guignols de l'Info: Le cauchemar de PPD" },
	{ "lvi",				"La Vague Interactive" },
	{ "madmac",				"Mad Mac Cartoons" },
	{ "recfantome",			"Récréation fantôme" },
	{ "sethi2",				"Sethi et le sorcier inca" },
	{ "sethi3",				"Sethi et la Tribu de Neandertal" },
	{ "svmvillagina5",		"SVM Multimedia: Villagina 5" },
	{ "teddybear",			"Opération Teddy Bear" },
	{ "tomlisaindiens",		"Tom et Lisa: les Indiens" },

	// German titles
	{ "bibi2",				"Bibi Blocksberg 2: Ein verhexter Schultag" },
	{ "bibifilm",			"Bibi Blocksberg: Mein verhextes Filmstudio" },
	{ "braingames",			"Brain Games" },
	{ "cklasse",			"Mercedes-Benz C-Class Information Booth" },
	{ "flaschenfahrrad",	"Das Verkehrs-Lernspiel: Fred und das Flaschenfahrrad" },
	{ "girlspack",			"Girl's Pack!" },
	{ "globiabc",			"Globi's ABC" },
	{ "mats3",				"Mats und das rätselhafte Tier" },
	{ "max1",				"Max and the Secret Formula" },
	{ "max2",				"Max and Marie Go Shopping" },
	{ "max3",				"Max and the Haunted Castle" },
	{ "mrmore",				"Mr. More Interaktive" },
	{ "otelo",				"o.tel.o Online 01011" },
	{ "ravensburger",		"Ravensburger Interactive Demo-Sampler" },
	{ "raveshuttle",		"Rave Shuttle: The Cosmic Challenge" },
	{ "tkkgkit",			"TKKG: Identikit" },
	{ "zwergnase",			"Zwerg Nase: Ein interaktives Märchen" },

	// Italian titles
	{ "ironmask",			"The Iron Mask" },
	{ "lunes",				"I Lunes e la sfera di Lasifer" },					// Lunes & the sphere of Lasifer
	{ "magicanti",			"I Magicanti e i 3 elementi" },						// The Magicanti & the 3 elements
	{ "robidoc",			"Robi & Doc: L'isola della Scienza" },

	// Japanese games
	{ "4sight",				"four-sight" },
	{ "alexworld",			"ALeX-WORLD" },
	{ "alius",			    "The Alius: Intaractive Adventure Movie" },         // Not a typo
	{ "angelgate",			"Angel Gate" },
	{ "animaltown",			"わくわくアニマルタウン" },			  				// Waku Waku Animal Town
	{ "ankh1",				"アンク ピラミッドの謎" },
	{ "ankh2",				"アンク 2 ツタンカーメンの謎" },
	{ "ankh3",				"アンク 3" },
	{ "bem",				"妖怪人間ベム 新たなる魂の迷宮" },                  // Yokai Ningen Bemu
	{ "bemtoybox",			"妖怪人間ベム データToyBox" },                      // Bem Data Toy Box
	{ "cellofania",			"セロファニア" },
	{ "chinacrisis",		"China Crisis" },
	{ "chisanaensoka",		"小さな演奏家" },									// Little Musician (Crickets)
	{ "chuckletime",   		"チャックルタイム" },
	{ "chuteng",   			"中天" },
	{ "cutie10",   			"キューティ１０" },
	{ "dan",				"ダン" },									   		// Dan
	{ "djrom",				"The DJ-ROM: Da CD-Extra of Hip-Hop Music" },
	{ "earthtia",			"アースティアサーガ ラーサーレジェンド" },		  	// Earthtia Saga: Larthur's Legend
	{ "fantazion",			"World Engine Fantazion" },
	{ "ffa",				"ファンキー ファニー エイリアンズ" },			 	// Funky Funny Aliens
	{ "garyukeiba",			"我流競馬" },							       		// "My style horse racing"
	{ "gate1",				"the GATE I 王国「MU」への扉" },
	{ "gate2",				"the GATE II 王国「MU」への扉" },
	{ "gate3",				"the GATE III 王国「MU」への扉" },					// Gateway to the Kingdom of MU
	{ "granmarmalade",		"グラン・マーマレード・マジカル・ビレッジ" },
	{ "henachoco",			"へなちょこダービー" },						    	// HenaChoco Derby
	{ "himejijo",			"A.MAZING姫路城" },									// A.MAZING Himejijo (the HIMEJI Castle)
	{ "horrortour2",		"Zeddas: Horror Tour 2" },
	{ "horrortour3",		"ラビラーント" },							   		// Labyrinthe
	{ "incarnatia",   		"Incarnatia" },
	{ "inugumi",   			"犬組" },
	{ "ios",   				"iós" },
	{ "jyajya",				"Jya jya" },										// HyperCard with D3 movie
	{ "karuta",				"かるたでおじゃる" },								// Karuta de ojaru
	{ "katsumadojo",		"信光の勝馬道場" },
	{ "kazuyakun",			"数ヤ君" },
	{ "kenji",				"Kenji" },
	{ "kishido",			"棋士道" },									   		// Art of Shogi (Go)
	{ "lzone",				"L-ZONE" },
	{ "macaroni",			"マカロニほうれん荘 Interactive" },					// Romaji title in manual is Macaroni Hourensou
	{ "maria",				"MA-RI-A 人形館の呪い" },
	{ "marinefantasy",		"大方洋二の海中写真館 Marine Fantasy" },
	{ "mazebrew",			"MazeBrew" },
	{ "mipeterwolf",		"～Music Island Vol.1～　\"ピーターと狼\"" },
	{ "missihb",			"MISS Interactive Hard Boiled" },
	{ "momotaro",			"日本語探検シリーズ『方言ももたろう』" },			// Nihongo Tanken Shirīzu: Hōgen Momotarō
	{ "mukashibanashi",     "日本昔話" },										// Nihon Mukashi Banashi (Japanese Folk Tales)
	{ "muzukashiihon",		"難しい本を読むと眠くなる" },						// "Reading a Difficult Book Makes Me Sleepy"
	{ "nihonchiri",       	"Visual日本地理" },									// Japan Geography
	{ "niningashi",			"ににんがし" },
	{ "nonta",				"のんたくんとゆかいななかまたち" },				   	// Nonta-kun and his Wonderful Friends
	{ "novacity",			"Nova City" },
	{ "orgotto",			"Orgotto" },
	{ "osaka1",				"必修大阪弁集中講座I 2010年、標準語は大阪弁になる" }, // Hisshu Osaka-ben shuchu koza (Mandatory Osaka Dialect)
	{ "osaka2",				"必修大阪弁集中講座II 2015年、東京人の逆襲" },		// Tokyoites Strike Back
	{ "peaceland",			"PeaceLand" },
	{ "phantplanet",		"アミューズメント プラネット ファンタスマゴリア" },	// Amusement Planet Phantasmagoria
	{ "popup",				"Pop Up Computer" },
	{ "prescue",			"パラダイス レスキュ" },						  	// Paradise Rescue
	{ "pyramidint",			"Pyramid Interactive" },
	{ "racingdays",			"Racing Days" },
	{ "refixion1",			"Refixion" },
	{ "refixion2",			"Refixion II: Museum or Hospital" },
	{ "refixion3",			"Refixion III トナカイストーリー" },
	{ "renderorgan",		"RenderOrgan" },
	{ "rheingold",			"ラインの黄金" },								 	// Das Rheingold
	{ "rolypolys",			"ローリーポーリーズの七転び八起き" },
	{ "rolypolys2",			"ローリーポーリーズの世界旅行" },
	{ "sabotenman",			"The Saboten Man" },
	{ "sakin2",				"砂金II" }, 				   				    	// Sakin II
	{ "sakuratoasobo",		"さくらとあそぼ" }, 				   				// Let's Play with "SAKURA"!
	{ "schoolworld",     	"A-L: Artificial Life: School World" },
	{ "tantei",				"完全探偵マニュアル" },							 	// Perfect Detective Manual
	{ "tetsuman",			"ハイ! 鉄マン です" }, 	   					    	// Hai! Tetsuman Desu
	{ "tetsumangaiden",		"鉄マン外伝 ゲーム大王の野望" }, 				 	// Tetsuman Gaiden: Game Daiou no Yabou
	{ "tokimemotype1",		"ときめきメモリアルタイピング" },					// Tokimeki Memorial Typing
	{ "tokimemotypegs",		"ときメモGSタイピング" },							// Tokimemo GS Typing (Girl's Side)
	{ "ttw",				"Through the Window: In Search for the Lost Bag" },
	{ "twinbeeparadise",	"ツインビーPARADISE in どんぶり島" },				// TwinBee Paradise in Donburi Shima
	{ "twistynight1",		"Twisty Night #1 合わせ月の夜" },
	{ "twistynight2",		"Twisty Night #2 フェンネル" },
	{ "twistynight3",		"Twisty Night #3 いにしえびと" },
	{ "ukiuki1",			"ウキウキ釣り天国 ～幻の天狗池～" },			 	// Ukiuki tsuri tengoku (Fishing)
	{ "ukiuki2",			"ウキウキ釣り天国2 ～波止の五目釣り～" },
	{ "ukiuki3",			"ウキウキ釣り天国3 ～人魚島のボート釣り～" },
	{ "ukiukistamp",		"うきうきスタンプ" },
	{ "ukyo1",				"うきょー1" },
	{ "victorianpark",		"Victorian Park" },
	{ "void",				"VOID" },
	{ "vvs",				"Virtual Variety Show" },
	{ "wariwari",			"わりわりワールド" },								// Wari Wari World
	{ "xaxa",				"XAXA MACHINE" },
	{ "ybr2",				"イエロー・ブリック・ロードII" },
	{ "ybr3",				"Yellow Brick Road ハラペコ月と星あつめ" },
	{ "yoidon",				"よ〜いドン!" },									// Yo-i Don!
	{ "zaibatsu",			"財閥銀行" },								  		// Zaibatsu Bank

	// Japanese art and multimedia reference
	{ "a5tours",			"A5 Tours: Special Data Library" },
	{ "asylum300",			"Asylum 300" },
	{ "clockkero",			"ケロ時計" },
	{ "clocksakura",		"さくら時計" },
	{ "clocktomoyo",		"知世時計" },
	{ "curiocity",		    "キュリオシティ" },
	{ "ddoa2",				"アイドル探偵ＹＯＵ＆ＭＹ" },						// Idol Tantei (Doki Doki On-air Drama Series)
	{ "eguchi",				"江口寿史 CG MUSEUM" },								// Hisashi Eguchi
	{ "fototune",			"FotoTune Multimedia Show" },
	{ "furbydentaku",		"ファービー電卓" },								    // Furby Calculator
	{ "futarinoryori",		"ふたりの料理物語" },								// A Tale of Two Chefs
	{ "goalrush1",			"Goal Rush!!" },
	{ "goalrush2",			"Goal Rush!! 2 ～戦術分析編～" },
	{ "heididentaku1",		"ハイジ電卓１" },
	{ "heididentaku2",		"ハイジ電卓２" },
	{ "heididentaku3",		"ハイジ電卓３" },                                   // Heidi Calculators
	{ "heidimail",			"Heidi グリーティングメールカード" },               // グリーティングメールカード (Greeting Mail Card)
	{ "heidislide",			"Heidi スライドショー" },                           // Slideshow
	{ "ioshow",				"iós How To Game" },
	{ "keiri",				"経理入門" },										// Introduction to Accounting
	{ "mazebox",			"The Latest Works of MazeBox" },
	{ "mmedia11",			"Masters of Media: The Making of サクラ大戦" },
	{ "moderntimes",		"Charles Chaplin in Modern Times" },
	{ "mominoki",			"もみの木の下で ～ The Day of St.Claus" },			// Under the Fir Tree
	{ "moritaka",			"森高千里 CD-ROM 渡良瀬橋" },
	{ "oceansbelow",		"Oceans Below" },
	{ "pbdisplay",	        "PerfectBLUE DISPLAY" },
	{ "pbflash",	        "PerfectBLUE FLASH" },
	{ "pbmima",	            "PerfectBLUE MIMA" },
	{ "pbosakana",	        "PerfectBLUE OSAKANA" },
	{ "pbtoilet1",	        "PerfectBLUE TOILET1" },
	{ "pbtoilet2",	        "PerfectBLUE TOILET2" },
	{ "perfectblue",        "Perfect Blue そらいろ★ナイト" },
	{ "sakurascr",			"さくらのSCRセレクタ" },							// Sakura's SCR Selector
	{ "satodesign",			"The Art of Computer Designing: A Black and White Approach" },
	{ "satohomosexual",		"Homosexual" },
	{ "sculpt4d",			"Sculpt 4D" },
	{ "spawncollection",	"Spawn Figure Collection for Windows 95" },
	{ "ssheidi1",			"Heidi スクリーンセーバー 1" },
	{ "ssheidi2",			"Heidi スクリーンセーバー 2" },
	{ "sskero",				"ケロ Screen Saver" },
	{ "sssakura",			"さくら Screen Saver" },
	{ "ssyamazaki",			"山崎君 Screen Saver" },							// Yamazaki-kun
	{ "ssyukito",			"雪兎さん Screen Saver" },							// Yukito-san
	{ "tokon5",				"闘魂V: 長州 力" },									// Fighting Spirit V: Riki Choshu
	{ "tree",				"Onyx Tree Pro" },
	{ "tri3dtrial",			"Tri-3D-Trial" },
	{ "ukiukibgv",			"ウキウキ釣り天国 BGV" },							// Background Video? (Screen Saver)
	{ "vcb",				"Virtual Cocktail Bar 200種類のカクテルのデータベース" },
	{ "yokai",		        "真・百物語: 妖怪紳士録" },                         // Ma hyakumonogatari: Yōkai shinshiroku
	{ "yokai200",	        "水木しげるの妖怪図鑑 傑作200選 -日本編1" },        // Mizuki Shigeru no Yokai Zukan Kessaku 200-sen Nihon-hen 1
	{ "yokai400",	        "水木しげるの妖怪図鑑 傑作400選 -日本編2" },        // Mizuki Shigeru no Yokai Zukan Kessaku 400-sen Nihon-hen 2
	{ "yokaizukan",			"妖精妖怪図鑑" },                                   // Fairy Yōkai Encyclopedia
	{ "yumemirukairo",		"「夢みる廻廊」所幸則フルカラーミュージアムCD-ROM" }, // Gallery of Dreams
	{ "zuiyomail",			"ZUIYO グリーティングメールカード" },               // グリーティングメールカード (Greeting Mail Card)

	// Japanese product demos
	{ "backgrounds",		"Backgrounds for Multimedia Series" },
	{ "bakkunooni",			"VOLT-AGE バックの鬼 -侘-" },						// Back Demon (texture packs)
	{ "bebox",				"BeBox" },
	{ "businessmanager",	"琢磨 BusinessManager" },							// from Takuma Co.
	{ "calling",			"Calling" },
	{ "cnl",   				"City Net Line" },
	{ "creativeeye",		"Creative EYE" },
	{ "fontfriends",		"フォントフレンズ" },
	{ "greetingstudio",		"Greeting STUDIO" },
	{ "hikaruhana",			"光る花" },
	{ "hypercardlessons",	"HyperCard Lessons" },
	{ "hypermaterial",		"Hyper Material" },
	{ "imgimpact",     		"Images with Impact!" },
	{ "inposition",   		"INposition" },
	{ "intelligentnote",   	"インテリジェントノート" },
	{ "jointnet",       	"JOINT-net" },
	{ "koyosha",			"Koyosha CD-INSPIREシリーズ" },
	{ "kpt",				"Kai's Power Tools for Photoshop" },
	{ "macbasic",			"MacBASIC: Learning BASIC on HyperCard" },
	{ "maczaurus",			"Sharp Mac-Zaurus" },
	{ "negishihomes",		"Negishi Homes 建築見積ｿﾌﾄ" },					// Architectural Quote Software
	{ "nsxpress",			"Honda NSX Press CD-ROM" },
	{ "olnet",				"Open Library" },
	{ "picturecard",		"絵カード訓練システム" },						// Picture Card Training System
	{ "presenpack",			"Director PresenPack" },
	{ "pressit",			"PRESSiT" },
	{ "provektor2",			"Provektor II: Design & Image Library" },
	{ "provektor3",			"Provektor III: Design & Image Library" },
	{ "provektormed",		"Provektor Media" },
	{ "scripting",			"Macromedia Director Lingo Scripting Technology" },
	{ "shadeviewer",		"Shade Viewer" },
	{ "sozaijiten",			"素材辞典" },									// Datacraft Materials Dictionary (texture packs)
	{ "strata",				"Strata Studio Pro" },
	{ "toeic",				"PowerTOEIC" },
	{ "toonet11",			"TooNet11" },
	{ "transland",			"トランスランド" },
	{ "wonderompm", 		"アルダスページメーカー4.5J速習用CD-ROM" },		// CD-ROM for Quick Study of Aldus PageMaker 4.5J
	{ "wonderomcw", 		"WONDEROM クラリスワークス" },					// WONDEROM ClarisWorks ver.2

	// Polish titles
	{ "kontyngent99",		"Katalog Samochodów Kontyngent '99" },

	// Portuguese titles
	{ "almabril98",			"Almanaque Abril 1998" },
	{ "bigmax",				"Revista BigMax" },
	{ "bpapao",				"A Turma do Bicho-Papão" },
	{ "divertire",			"Revista Divertire" },
	{ "irpf2002",			"Tutorial do IRPF 2002" },
	{ "kinderkit",			"Kinder-Kit" },
	{ "lobomau",			"As Histórias do Lobo Mau" },
	{ "objetivo",			"Astrologia e Geografia Objetivo" },
	{ "ratinho",			"Programa do Ratinho" },

	// Russian titles
	{ "engl",				"English for Beginners" },
	{ "max1max2",			"Макс демонстрация" },                          // Max (Tivola) demos of the first two games
	{ "plcd",				"Подводная Лодка" },						   // Podvodnaya Lodka (Submarine) magazine
	{ "tchaik",				"Пётр Ильи́ч Чайко́вский: Жизнь и творчество" }, // Pyotr Ilyich Tchaikovsky: Life and Work
	{ "tutti",				"Волшебные истории Тутти" },				   // Tutti's Magical Stories

	// Spanish titles
	{ "123habloingles",		"1·2·3 Hablo Inglés" },
	{ "abrapalabra",		"Abrapalabra: La Magicia de Aprender a Leer" },
	{ "clasplusbee2",		"Classical Plus: Ludwig van Beethoven" },	// Planeta DeAgostini, a Spanish-Italian company based in Barcelona
	{ "deportes",			"Deporte y Musculación" },
	{ "eso",				"ESO Essentials: Student's Interactive CD-ROM" },
	{ "inventos",			"Grandes Inventos" },
	{ "pcplus64",			"PC Plus Super CD 64" },
	{ "supermente",			"Super Mente" }, // Published only in Mexico
	{ "unlimitedcl",		"Unlimited CD-ROMs Educativos" },

	// Swedish titles
	{ "alfons",				"Alfons Åberg ”Bara Överallt!”" },
	{ "backpacker2",		"Backpacker 2" },
	{ "ernie",				"Ernie" },
	{ "garygadget2",		"Bygg båtar med Mulle Meck" },              // First game listed under English
	{ "garygadget3",		"Bygg flygplan med Mulle Meck" },
	{ "garygadget4",		"Bygg hus med Mulle Meck" },
	{ "garygadget5",		"Upptäck rymden med Mulle Meck" },
	{ "jonssonligan1",		"Jönssonligan: Jakten på Mjölner" },
	{ "jonssonligan2",		"Jönssonligan går på djupet" },
	{ "pettson1",			"Pettson o Findus i snickarbon" },
	{ "pettsonjk",			"Pettson o Findus julkalender" },
	{ "pettson2",			"Pettson & Findus i trädgården" },
	{ "pettsonjs",			"Pettsons julspel" },
	{ "pettson3",			"Pettson o Findus och mucklornas värld" },
	{ "pettson4",			"Pettson & Findus Spökskrämmarmaskinen" },
	{ "polis1",				"Polis" },
	{ "polis2",				"Polis 2: Någon ljuger" },
	{ "polis3",				"Polis 3: Vargspår" },

	// Titles containing Director extras
	{ "amgpremiere",		"The American Girls Premiere" },
	{ "dcanyoncd",			"Dino CD Audio Player" },
	{ "freeallangels",		"Ash: Free All Angels Video Mixer" },
	{ "lbfamfun",			"Little Bear Family Fun" },
	{ "poliq",				"Political IQ Test" },
	{ "scissorsnstones",	"Scissors N Stones On-Line Manual" },
	{ "solmahjong",			"Solitudes Mahjong Game" },
	{ "superbowltrivia",	"Super Bowl Trivia Game" },
	{ "thinkinthingsdp",	"Dear Parents: About Thinkin' Things..." },
	{ "ultrobotkit",		"Robotoid Assembly Toolkit" },

	// DVD-ROM bonus content
	{ "planetrav",			"Planetary Traveler" },

	// Other products using VideoWorks or Director movies only
	// Examples are HyperCard, Authorware, and Microsoft Reference
	{ "encarta94",			"Microsoft Encarta '94" },
	{ "encarta95",			"Microsoft Encarta '95" },
	{ "encartaatlas2000",   "Microsoft Encarta Interactive World Atlas 2000" },
	{ "macworldexpo92",		"Macworld Expo CD Boston 1992" },
	{ "manhole",			"The Manhole" },
	{ "mazewars",			"Maze Wars+" },
	{ "mmmozart",			"Multimedia Mozart: The Dissonant Quartet" },
	{ "mmschubert",			"Multimedia Schubert: The \"Trout\" Quintet" },
	{ "osmo",				"Cosmic Osmo and the Worlds Beyond the Mackerel" },
	{ "shatter",			"Shatter by Mike Saenz" },
	{ "spelunx",			"Spelunx and the Caves of Mr. Seudo" },
	{ "stravinsky",			"Igor Stravinsky: The Rite of Spring" },

	// Magazines and periodicals
	{ "blender",   			"Blender: The Pop Culture Magazine on CD-ROM" },
	{ "blenderbest",   		"Best of Blender: The Interactive Entertainment Magazine" },
	{ "cmi",   				"Computer Music Interactive" },
	{ "gamingmegapac",		"MacUser Presents Gaming MegaPac" },
	{ "godigital",			"Go Digital Interactive Magazine" },
	{ "insidemacgames",   	"Inside Mac Games" },
	{ "interactivemagic",   "Mac Interactive Magic" },
	{ "iwave",   			"Interactive Wave" },
	{ "maccubed7",			"MacCubed Disc 7: Internet & Utilities" },
	{ "macsca",				"Mac S.C.A. Magazine" },
	{ "macweekvideo",		"MacWEEK Guide to Desktop Video" },
	{ "mieuxmieux",			"Le CD-ROM Mac Mieux-Mieux" },
	{ "mindvirus",			"Mindvirus" },
	{ "pcformat",			"PC Format" },
	{ "pcwuk",				"Personal Computer World" },
	{ "stream",				"Digital Culture Stream Magazine" },

	// Promos and catalogues
	{ "adamscholar",		"The A.D.A.M. Scholar Series" },
	{ "applestore",			"Apple Company Store" },
	{ "arcmedia",			"Arc Media Demos" },
	{ "blaster",			"Blaster Series Demo" },
	{ "bpmc",				"Byron Preiss Multimedia Catalog" },
	{ "cmc",				"Creative Multimedia Catalog" },
	{ "davidsonpp",			"Davidson Product Previews" },
	{ "davidsonps",			"Davidson Product Sampler" },
	{ "disneyint",			"Disney Interactive presents Learning & Creativity Sampler Volume I" },
	{ "disneylearning",		"Disney Interactive Learning Sampler" },
	{ "dkmm2",				"Dorling Kindersley Multimedia Sampler Disc 2" },
	{ "edmark",				"Edmark Demo" },
	{ "emme",				"E.M.M.E. Interactive: The Keys to Knowledge" },
	{ "eureka",				"Eureka Multimedia Promo" },
	{ "fppuddlebooks",		"Fisher-Price Read & Play: Puddle Books Demos" },
	{ "grolier",			"Grolier Products" },
	{ "gusbuds",			"Gus and the CyberBuds Learning Adventure Series" },
	{ "headbone",			"Headbone CD-ROM Sampler" },
	{ "hoffman",			"H+a Collection" },
	{ "ilearn",     	    "iLearn" },
	{ "imagineers",     	"The Imagineers" },
	{ "imaginopolis",   	"Microsoft Imaginopolis" },
	{ "incoming",     		"iNCOMING" },
	{ "iona",   			"Iona Software Demo CD" },
	{ "ipc",   				"About InterActive Publishing" },
	{ "jsa",				"JumpStart Advanced: How Does Your Child Learn Best?" },
	{ "jslearn",			"JumpStart Learning System" },
	{ "kidtools",			"Kid Tools Series Demo" },
	{ "learningsystem",		"The Learning System" },
	{ "msgfromapple",		"Message from Apple" },
	{ "newton",				"World of Newton" },
	{ "origin",				"Origin Systems Product Catalog" },
	{ "playskool",			"Playskool Software Experience" },
	{ "poohlearn",			"Disney Learning Winnie the Pooh Demos" },
	{ "rh",					"Rescue Heroes Demo" },
	{ "sfk",				"Science for Kids Product Demos" },
	{ "ubt",				"Under the Big Top" },
	{ "wti",				"Workstation Technologies Inc: The Digital Video Company" },

	// Promos for Non-Director titles
	{ "3datlas97",			"3D Atlas 97" },
	{ "adobedimensions",	"Professional Tips for Adobe Dimensions" },
	{ "agfa",				"AgfaType" },
	{ "aol",				"America Online" },
	{ "ataripack",			"Activision's Atari 2600 Action Pack" },
	{ "balto2",				"Balto II: Wolf Quest" },
	{ "blockbuster2",		"Blockbuster Guide to Movies & Videos, 2nd Edition" },
	{ "bobteam",			"Bob the Builder: Teamwork" },
	{ "bookshelf94",		"Microsoft Bookshelf 1994" },
	{ "c64pack",			"Activision's Commodore 64 15-Pack for Windows" },
	{ "cfdemo",   			"The ClueFinders Demo" },
	{ "cinemania94",		"Microsoft Cinemania 94" },
	{ "cinemania95",		"Microsoft Cinemania 95" },
	{ "cinemania96",		"Microsoft Cinemania 96" },
	{ "clarisworks",		"ClarisWorks" },
	{ "cpu",   				"Connectix PowerBook Utilities" },
	{ "cricketdraw",   		"CA Cricket Draw III" },
	{ "d",   				"D" },
	{ "dotsafe",   			"Dotsafe" },
	{ "earthwormjim",		"Earthworm Jim" },
	{ "exos",				"Exos PowerStick" },
	{ "explorapedia",		"Microsoft Explorapedia" },
	{ "famalbum",			"Family Album Creator" },
	{ "famdoc4",			"The Family Doctor, 4th Edition" },
	{ "freehand",			"Aldus FreeHand 2.0" },
	{ "geoquery",			"Odesta GeoQuery" },
	{ "greeneggs",			"Green Eggs and Ham" },
	{ "hollywoodhigh",		"Hollywood High" },
	{ "hyperblade",			"HyperBlade" },
	{ "ideacomm",     		"IDEAcomm Mac" },
	{ "illustrator",     	"Adobe Illustrator" },
	{ "landdesigner",		"Sierra Land Designer" },
	{ "lbt8",				"The Land Before Time: The Big Freeze" },
	{ "leopardspots",		"How the Leopard Got His Spots" },
	{ "lion",				"Lion" },
	{ "lotus123",			"Lotus 1-2-3" },
	{ "macos8",				"Mac OS 8" },
	{ "macportable",		"Your Apple Tour of the Macintosh Portable" },
	{ "mathblasterjr",		"Math Blaster Jr." },
	{ "mavisbeacon",		"Mavis Beacon Teaches Typing" },
	{ "mechwarrior2",		"MechWarrior 2" },
	{ "meetingmaker",		"Meeting Maker" },
	{ "msaccess",			"Microsoft Access" },
	{ "msarcade",			"Microsoft Arcade" },
	{ "msartgallery",		"Microsoft Art Gallery" },
	{ "msautomap",			"Microsoft Automap Road Atlas" },
	{ "msbaseball",			"Microsoft Complete Baseball" },
	{ "msbasketball",		"Microsoft Complete Basketball" },
	{ "msbob",				"Microsoft Bob" },
	{ "msbhumanbody",		"Scholastic's The Magic School Bus Explores the Human Body" },
	{ "msbsolarsystem",		"Scholastic's The Magic School Bus Explores the Solar System" },
	{ "mscomposers",		"Microsoft Illustrated Interactive Composer Series" },
	{ "msdogs",				"Microsoft Dogs" },
	{ "msexcel",			"Microsoft Excel" },
	{ "msflight",			"Microsoft Flight Simulator" },
	{ "msfonts",			"Microsoft TrueType Font Pack" },
	{ "msgolf",				"Microsoft Golf" },
	{ "msmoney",			"Microsoft Money" },
	{ "msmouse",			"The Microsoft Mouse" },
	{ "msmouseh",			"Microsoft Home Mouse" },
	{ "msmusint",			"Microsoft Musical Instruments" },
	{ "msn",				"The Microsoft Network" },
	{ "msnatkey",			"Microsoft Natural Keyboard" },
	{ "msoffice",			"Microsoft Office" },
	{ "mspowerpoint",		"Microsoft PowerPoint" },
	{ "msproject",			"Microsoft Project" },
	{ "mspublish",			"Microsoft Publisher" },
	{ "mspublishd",			"Microsoft Publisher Design Packs" },
	{ "msschedule",			"Microsoft Schedule+" },
	{ "mssndbits",			"Microsoft SoundBits" },
	{ "msword",				"Microsoft Word" },
	{ "msworks",			"Microsoft Works" },
	{ "muppets",			"Muppet Treasure Island" },
	{ "musiccentral96",		"Microsoft Music Central 96" },
	{ "musicpublisher",		"Graphic Notes Music Publisher" },
	{ "netmarket",			"CUC netMarket Demo" },
	{ "ofoto",				"Light Source Ofoto" },
	{ "orly",				"Orly's Draw-A-Story" },
	{ "pagemaker",			"Aldus PageMaker" },
	{ "pitfall",			"Pitfall: The Mayan Adventure" },
	{ "powerchess",			"Power Chess" },
	{ "princeint",			"Prince Interactive" },
	{ "pspice",				"MicroSim PSpice" },
	{ "raydream",			"Ray Dream Designer" },
	{ "readblasterjr",		"Reading Blaster Jr." },
	{ "redshift",			"RedShift: Multimedia Astronomy" },
	{ "rosettastone",		"The Rosetta Stone" },
	{ "santafe1",			"Santa Fe Mysteries: The Elk Moon Murder" },
	{ "shanghai",			"Shanghai: Great Moments" },
	{ "smashsounds1",		"Smash Sounds Volume 1" },
	{ "spycraft",			"Spycraft: The Great Game" },
	{ "system7smash",		"System 7 is a SMASH!" },
	{ "wep", 				"The Best of Microsoft Entertainment Pack" },
	{ "wfw31",				"Microsoft Windows for Workgroups 3.1" },
	{ "windows95",			"Microsoft Windows 95" },
	{ "worldatlas", 		"World Reference Atlas" },
	{ "ultrobot", 			"Isaac Asimov\'s The Ultimate Robot" },
	{ "znemesis",			"Zork Nemesis: The Forbidden Lands" },
	{ "zoombini",			"Logical Journey of the Zoombinis" },

	// Screen Savers
	{ "barbssbubbles",		"Barbie Screen Styler: Bubbles" },
	{ "barbsskisses",		"Barbie Screen Styler: Kisses" },
	{ "barbssshoes",		"Barbie Screen Styler: Shoes" },
	{ "billetrille1ss",		"Bille & Trille 1 Screen Saver" },
	{ "cinemac",			"CineMac Screen Saver Factory" },
	{ "globiss",			"Globi's Bildschirmschoner" },
	{ "lewisclarkss",		"Lewis and Clark Screen Saver" },
	{ "photos4us",			"Photos4us" },
	{ "pingufight",			"Pingu Snowball Fight" },
	{ "pingufish",			"Pingu Fish Chase" },
	{ "pinguss",			"Pingu Screen Savers" },
	{ "pingustorm",			"Pingu Snow Storm" },
	{ "pingustunt",			"Stunt Pingu" },
	{ "pingutime",			"Time for Pingu" },
	{ "ss007",				"The James Bond Screensaver" },
	{ "ss102dalmations",	"102 Dalmations Screen Saver" },
	{ "sscocacola",			"Coca-Cola Screen Saver" },
	{ "ssdietcoke",			"Diet Coke Screen Saver" },
	{ "ssgbi",				"German Bold Italic Screen Saver" },
	{ "sshercules",			"Hercules: The Legendary Journeys Screen Saver" },
	{ "sshighlander",       "Highlander: The Screen Saver" },
	{ "ssholidaymickey",	"Holiday Mickey Screen Saver" },
	{ "ssleepipes",			"The Lee Pipes Desktop Animated Feature" },
	{ "sslivepicture",		"Live Picture Screen Saver" },
	{ "ssnatureasart",		"Nature as Art" },
	{ "sspeekaboo",			"Winnie the Pooh Peek-a-Boo Screen Saver" },
	{ "ssrevwar",			"Revolutionary War Screen Saver" },

	// Press kits with Director content
	{ "bvi1997",			"Buena Vista International 1997 Promotional Interactive CD-ROM" },
	{ "bluesbros2000",		"Blues Brothers 2000 Full Promotion" },
	{ "easports2000",		"EA Sports_2000 (E3 1999)" },
	{ "hoaddams2",			"Hollywood Online: Addams Family Values" },
	{ "hoangus",			"Hollywood Online: Angus" },
	{ "hodolores",			"Hollywood Online: Dolores Claiborne" },
	{ "horobroy",			"Hollywood Online: Rob Roy: Legend of the Mist" },
	{ "hostargate",			"Hollywood Online: Stargate" },
	{ "hothenet",			"Hollywood Online: The Net" },
	{ "leepipes",			"Lee Pipes Press Kit" },
	{ "mulanpresskit",		"Mulan Multimedia Press Kit" },
	{ "stalker",			"S.T.A.L.K.E.R.: Shadow of Chernobyl" },
	{ "thesims",			"The Sims Electronic Press Kit" },
	{ "vug2005",			"Vivendi Universal Games 2005 E3 DPK" },
	{ "westwood",			"Westwood Studios Digital Press Kit 2000" },

	// Not supported
	{ "busty3",				"Busty Babes Volume III" },
	{ "busty4",				"Busty Babes Volume IV" },
	{ "digitalogue",		"Digitalogue Home Museum Series" },
	{ "dmpgallery",			"Digital Magazine for Photography: Gallery" },
	{ "eros",				"Fischer's Erotic Encyclopedia" },
	{ "gilgameshnite",		"ギルガメッシュ Night Super Deluxe CD-ROM" },
	{ "immorale",			"Immorale" },
	{ "isswim98",			"Inside Sports 1998 Swimsuit Issue" },
	{ "legs",				"Legs" },
	{ "macplaymate1",		"MacPlaymate" },
	{ "macplaymate2",		"MacPlaymate II" },
	{ "pbvv",				"Playboy's Voluptuous Vixens" },
	{ "playmate1999",		"1999 Playboy Playmate Calendar" },
	{ "sadowar",			"RSP" },
	{ "thebody",			"The Body: Five doors plus" },
	{ "thelegs",			"The Legs ～Get a LEG up～" },
	{ "venus",				"Venus Photo CD-ROM" },
	{ "vvalerie1",			"Virtual Valerie" },
	{ "vvalerie2",			"Virtual Valerie 2" },
	{ "vveronika",			"Virtual Veronika" },
	{ "vpeepshow",			"Virtual Peep Show" },

	{ 0, 0 }
};

namespace Director {

#define SUPPORT_STATUS ADGF_UNSTABLE

#define GENGAME1_(t,e,f,m,s,l,p,fl,v) 				{ { t, e, AD_ENTRY1s(f, m, s), l, p, (fl | SUPPORT_STATUS), GUIO1(GUIO_NOASPECT) }, GID_GENERIC, v }
#define GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,p,fl,v) 	{ { t, e, AD_ENTRY2s(f1, m1, s1, f2, m2, s2), l, p, (fl | SUPPORT_STATUS), GUIO1(GUIO_NOASPECT) }, GID_GENERIC, v }

#define MACGAME1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define PIPGAME1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformPippin,ADGF_MACRESFORK,v)
#define WINGAME1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define SHKGAME1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformShockwave,ADGF_NO_FLAGS,v)
#define MACDEMO1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO1(t,e,f,m,s,v) 	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformWindows,ADGF_DEMO,v)
#define MACGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define PIPGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformPippin,ADGF_MACRESFORK,v)
#define WINGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define SHKGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformShockwave,ADGF_NO_FLAGS,v)
#define MACDEMO1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformWindows,ADGF_DEMO,v)

#define MACGAME2(t,e,f1,m1,s1,f2,m2,s2,v) 	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define WINGAME2(t,e,f1,m1,s1,f2,m2,s2,v) 	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME2(t,e,f1,m1,s1,f2,m2,s2,v) 	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define MACDEMO2(t,e,f1,m1,s1,f2,m2,s2,v) 	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO2(t,e,f1,m1,s1,f2,m2,s2,v) 	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformWindows,ADGF_DEMO,v)
#define MACGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define WINGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define MACDEMO2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformWindows,ADGF_DEMO,v)

static const DirectorGameDescription gameDescriptions[] = {
	// Execute all *.lingo files in game directory
	{
		{
			"directortest",
			"",
			AD_ENTRY1("lingotests", 0),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_NO_FLAGS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_TEST,
		400
	},

	// Execute all movies in directory
	{
		{
			"directortest-all",
			"",
			AD_ENTRY1("lingotests-all", 0),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_NO_FLAGS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_TESTALL,
		400
	},

	// Original filename is "•Main Menu" for all
	MACGAME1("theapartment", "D2", "xn--Main Menu-zd0e", "fc56c179cb8c6d4938e61ee61fd0032c", 48325, 200),
	MACGAME1("theapartment", "D3", "xn--Main Menu-zd0e", "9e838fe1a6af7992d656ca325e38dee5", 47911, 300),
	MACGAME1("theapartment", "D4", "xn--Main Menu-zd0e", "ff86181f03fe6eb060f65a985ca0580d", 160612, 400),

//////////////////////////////////////////////////
//
// MacroMind VideoWorks Player 1.00 (pre-director)
//
//////////////////////////////////////////////////

	MACGAME1("bigsound", "", "BigSound VW Player", "4b42e95a6e75cf440abcfeeeee8d622f", 19456, 0),

	// Touring Engine Ver 1.00
	MACDEMO1("illustrator", "v1 Tour", "Adobe Illustrator Tour", "4d331ce05dbec4a84465ed33fa5538fa", 64948, 0),

	MACGAME2_l("madmac", "", "VW Player", "16034c0db4619552e4fe7e108cb98dae", 17070,
							 "Vieux", "3555a71c668ce58018bc0863bdc18022", 14341, Common::FR_FRA, 0),

	// Published by MacroMind. Contains some VW-style animations.
	MACGAME1("mazewars", "", "Maze Wars+2", "24874b31f1f7f0adc3e8bc1efdc155e7", 128605, 0),

	// No projector provided. Files appear to be incomplete.
	MACDEMO2("shatter", "Scenes", "TITLE", "e0e1c08c5fd90678ba550a93bc47e261", 14119,
								  "CITY", "5fcc134c1252f25a31752e4cd6307c8c", 25544, 0),

//////////////////////////////////////////////////
//
// MacroMind VideoWorks II (pre-director)
//
//////////////////////////////////////////////////

/*****************************************************************
	VideoWorks movies called from HyperCard stacks
	Movies will play by using --start-movie flag from console
	These entries use VW II Driver 1.2
*****************************************************************/

	// Original filename is FutureView™(O.L.)
	MACGAME1("futureview", "", "FutureView (O.L.)", "f2dd4c1bacdb1ad0226ac14762a2bd56", 262089, 0),
	MACDEMO1("ideacomm", "Demo", "IDEAcomm Mac Demo", "b36cb9e6e36e7cb569d9af571d2dd1bd", 21006, 0),
	MACDEMO1("osmo", "Demo", "Cosmic Osmo Demo", "eba9620282bd39ff4ba2a9190e72880b", 127941, 0),

/*****************************************************************
	VideoWorks movies built using MacroMind Touring Engine
*****************************************************************/

	// Touring Engine V2.2B12
	// Original filename is GeoQuery® Tour
	MACDEMO1("freehand", "Demo", "FreeHand 2.0 demo", "1c6bb186e709e88fdcf9279e8799eab5", 74308, 0),
	MACDEMO1("geoquery", "Demo", "GeoQuery Tour", "48476e45e1bd9d67806ebe09b959679b", 74262, 0),
	MACDEMO1("musicpublisher", "Demo", "Music Publisher Demo", "1c6bb186e709e88fdcf9279e8799eab5", 74308, 0),
	MACDEMO2("pspice", "Demo", "Tour Engine", "1c6bb186e709e88fdcf9279e8799eab5", 74308,
							   "TOUR LIST", "1efdd9c0455c4e90466ee6a6dda182d1", 22642, 0),

	// Touring Engine 3.8 © Apple Computer, Inc. & MacroMind 1985-1988
	MACGAME2("macportable", "", "Double Click Me", "341b6ae632d9e52979e478ce27ffc42c", 114679,
								"MAIN MENU", "5bfdbf8b0fc6698c9724cd7634427fe1", 30327, 0),

//////////////////////////////////////////////////
//
// MacroMind Director v1
//
//////////////////////////////////////////////////

	{
		{
			"osmo", "CD Demo",
			AD_ENTRY1s("Osmo.BW.HC", "7efaee43e298e3a3d29607300b20147a", 796297),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_CD | ADGF_DEMO | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		100	// MacroMind Player v 0.98
	},

	// Projector and movies are compiled into proprietary executable.
	// On exit, pop-up says "This Presentation was created using MacroMind Director 1.1"
	MACDEMO1_l("rosettastone", "Demo", "The Rosetta Stone", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 1379715, Common::JA_JPN, 110),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

//////////////////////////////////////////////////
//
// MacroMind Director v2
//
//////////////////////////////////////////////////

	MACGAME1_l("alice", "", "Alice", "e54ec74aeb4355b0acd46320327c1bed", 274274, Common::JA_JPN, 200),

	MACDEMO1("backgrounds", "Demo", "Backgrounds Demo", "d029fcb13fd2f0944f3c04577ad3b848", 2708196, 200),

	// Movies called from HyperCard with external MacroMind Player 2.0
	MACGAME1("beyondcyberpunk", "v1.5", "1984", "026bda630919f3692e649c00b1b52dd9", 34425, 200),

	MACDEMO1("illustrator", "v3.0 Demo", "a double click please", "cfa68a1bc49251497ebde18e5fc9c217", 194321, 200),

	MACGAME2("mindvirus", "Issue 02.94", "Projector", "cfa68a1bc49251497ebde18e5fc9c217", 271313,
										 "1", "409c1b65614c01facad7da6eb689f1c8", 1130108, 200),

	// Demos from Mac World Expo Boston 1992 Interactive Multimedia Reference CD-ROM
	MACDEMO2("msexcel", "Demo",	  "Double Click", "e54ec74aeb4355b0acd46320327c1bed", 236885,
								  "StartUp",	  "4be24cb9ca426e9ae318163f75ae55ee", 51313, 201),
	MACDEMO2("msword", "v5 Demo", "Double Click", "e54ec74aeb4355b0acd46320327c1bed", 204286,
								  "MSWD pt. 1",   "d30e1cae275e7ecfdde92df03a28b309", 249261, 201),

	// Movies called from HyperCard with external MacroMind Player 2.0
	MACGAME1("spelunx", "v1.2", "Spelunx", "3eb3598b7f6bb09de4dd31aca3683d8f", 371154, 200),

	MACGAME2("system7smash", "", "Double Click", "e54ec74aeb4355b0acd46320327c1bed", 226177,
								 "Smash", "7c11c3c07b87188cdf6260f922bb9e3c", 9287, 201),

	MACGAME1_l("tri3dtrial", "", "Tri-3D-Trial", "cfa68a1bc49251497ebde18e5fc9c217", 271223, Common::JA_JPN, 200),

	// Original file name is Spaceship Warlock™
	MACGAME1("warlock", "v1.0", "xn--Spaceship Warlock-306j", "cfa68a1bc49251497ebde18e5fc9c217", 271093, 200),
	MACGAME1("warlock", "v1.1.1", "xn--Spaceship Warlock-306j", "cfa68a1bc49251497ebde18e5fc9c217", 271107, 200),
	MACDEMO1("warlock", "v1.0 Demo", "Spaceship Warlock Demo", "cfa68a1bc49251497ebde18e5fc9c217", 271099, 200),
	MACDEMO1("warlock", "Trailer",	 "SS Warlock Movie Trailer", "cfa68a1bc49251497ebde18e5fc9c217", 273377, 200),

//////////////////////////////////////////////////
//
// MacroMind / Macromedia Director v3
//
//////////////////////////////////////////////////

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_UNSTABLE

	MACDEMO1("aamn", "Demo", "AAMN", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 354645, 301),

	// Found on ADAM The Inside Story v1.11 for Windows
	WINGAME2("adamscholar", "", "MAIN.EXE",  "de06298eb65f392f4e736a1c6b0b889c", 1152807,
								"SDEMO.DIR", "bfb9bd6de59c22f0c45da6ade0579384", 3158992, 311),

	// Original Mac filename is *デモスタート
	MACDEMO2_l("adamtis", "Demo", "Demo start",	  "1ae45c23586b41997ba52e2e7c771c4c", 1676945,
								  "step1",		  "7e17288d51f610daf84941e318404518", 393530, Common::JA_JPN, 311),
	WINDEMO1("adamtis", "Demo",	  "ADAMDEMO.EXE", "e02616ca4d7bc24cf84f9804f65831a2", 7342649, 311),

	MACDEMO1_l("adobedimensions", "Demo", "PD.Demo", "f5277c53bacd27936158dd3867e587e2", 1439492, Common::JA_JPN, 311),

	MACDEMO1("agfa", "v3.1 Demo", "Agfa CD-ROM Demo-B&W", "13ba95890bdaa1a07255c395499fe12e", 1283656, 300),

	// Original filename is アラン・ケイ
	MACDEMO1_l("alankay", "Demo", "Alan Kay", "276bee761e48a6fd709df77d5c2f60dd", 6188389, Common::JA_JPN, 311),

	MACGAME1_l("alexworld", "", "AlexWorld", "f5277c53bacd27936158dd3867e587e2", 391576, Common::JA_JPN, 300),
	WINGAME1_l("alexworld", "", "ALEX.EXE", "65d06b5fef155a2473434571aff5bc29", 369996, Common::JA_JPN, 300),

	MACGAME1("alice2ocean", "", "From Alice to Ocean", "1ae45c23586b41997ba52e2e7c771c4c", 375466, 310),

	MACGAME1("amandastories", "3.0", "AmandaStories", "1687f456d7f2bcf98e84fec6d3a03c17", 353985, 300),
	MACDEMO1("amandastories", "Sampler", "AmandaStories Sampler", "60cc4ccbab898f1f444088fb5aad90c4", 1783515, 311),

	// From Macintosh Demo Software Zenshuu CD-ROM '94 Disc 3
	// Original filename is アニマルタウンデモ版
	MACDEMO1_l("animaltown", "Demo", "Animal Town Demo Version", "f5277c53bacd27936158dd3867e587e2", 395177, Common::JA_JPN, 311),

	MACDEMO1_l("asylum300", "Demo", "ASYLUM 300 DEMO", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 1038279, Common::JA_JPN, 313),

	// Original filename is Babylon 5 Interactive/Mac
	MACGAME1("babylon5int", "", "Babylon 5 Interactive-Mac", "7f443f2e63fd497a9ad85b10dc880a91", 1262641, 313),

	MACDEMO2_l("bakkunooni", "Wabi Demo", "Browser", 	"7ba588d9fde9f714a42fec0a2c9d9655", 2835635,
										  "Main-Help-J", "2358b56196b9d9148990f5f5e9c7fb43", 8521, Common::JA_JPN, 311),

	MACGAME1("belcher", "", "The Belcher", "d0683b94f369d0d60ebd6c47d4d1ea76", 470776, 301),

	MACGAME1("beyondthewall", "", "Beyond The Wall Of Stars", "107c6a6d3cce957eaa26d427e672000c", 465523, 300),
	WINGAME1("beyondthewall", "", "WALL.EXE", "5c6862a40a48881913ee7c50d25cd984", 225253, 300),

	MACDEMO1_l("bigtimemovie", "Demo", "BIG TIME MOVIE-Studios", "f5277c53bacd27936158dd3867e587e2", 392521, Common::JA_JPN, 311),

	// Original filename is BioFlix©1993.Demo 1.0
	MACDEMO1("bioflix", "v1.0 Demo", "BioFlix 1993.Demo 1.0", "1ae45c23586b41997ba52e2e7c771c4c", 1070691, 310),

	MACGAME1("birdlife", "", "Click here to start (8mb)", "1ae45c23586b41997ba52e2e7c771c4c", 381058, 311),
	WINGAME1("birdlife", "", "BIRDLIFE.EXE", "65d06b5fef155a2473434571aff5bc29", 783483, 310),

	// Original filename is BOB©1991
	MACGAME1("bob", "", "BOB 1991", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 1209537, 300),

	WINDEMO1("bodypark", "Demo", "BODYPARK.EXE", "65d06b5fef155a2473434571aff5bc29", 1654314, 310),

	WINDEMO1("bookshelf94", "Demo", "BS94DEMO.EXE", "7c8230a804abf9353b05627a675b5ffb", 375300, 310),

	WINDEMO1("bpmc", "", "BPMC.EXE", "1998188253fc8657198e3e78efe823a8", 370291, 313),

	// Original v3.5.1 demo filename is BusinessManager.デモ
	MACDEMO1_l("businessmanager", "v3.5.1 Demo", "BusinessManager.Demo", "f5277c53bacd27936158dd3867e587e2", 2102528, Common::JA_JPN, 311),
	MACDEMO1_l("businessmanager", "Demo", "BusinessManager.Demo", "f5277c53bacd27936158dd3867e587e2", 392603, Common::JA_JPN, 311),

	MACDEMO1_l("calling", "Demo", "CallingPlayer", "276bee761e48a6fd709df77d5c2f60dd", 392676, Common::JA_JPN, 313),

	// From Sanctuary Woods Multimedia. Projectors for English, French, Spanish are included on the disc.
	WINGAME1("catcameback", "",   "TITLEE.EXE", "65d06b5fef155a2473434571aff5bc29", 369998, 310),
	WINGAME1_l("catcameback", "", "TITLES.EXE", "65d06b5fef155a2473434571aff5bc29", 369998, Common::ES_ESP, 310),
	WINGAME1_l("catcameback", "", "TITLEF.EXE", "65d06b5fef155a2473434571aff5bc29", 369998, Common::FR_FRA, 310),

	// Each movie has its own projector
	WINGAME1("cdphysics", "", "CDINTRO.EXE", "65d06b5fef155a2473434571aff5bc29", 370004, 313),

	MACDEMO1_l("cellofania", "Demo", "Cellofania.Demo", "f5277c53bacd27936158dd3867e587e2", 390226, Common::JA_JPN, 311),

	// English Mac filename is The C.H.A.O.S. Continuum™
	// Japanese Mac demo filename is CHAOS デモ and another file is called CHAOS Demo
	MACGAME1("chaos", "", "The C.H.A.O.S. Continuum", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384481, 300),
	MACDEMO1_l("chaos", "Demo", "Start CHAOS Demo", "f5277c53bacd27936158dd3867e587e2", 394939, Common::JA_JPN, 311),
	WINGAME1("chaos", "", "CHAOS.EXE", "7c8230a804abf9353b05627a675b5ffb", 375294, 300),

	// Each section is on a separate disk with its own projector
	// https://www.youtube.com/watch?v=iDr0x22zRvs
	MACGAME1("childishgambino", "", "Donald Glover - Cut 1", "1ae45c23586b41997ba52e2e7c771c4c", 827858, 310),

	// Original filename is 小さな演奏家デモ
	MACDEMO1_l("chisanaensoka", "Demo", "Chisana enso-ka Demo", "f5277c53bacd27936158dd3867e587e2", 1501224, Common::JA_JPN, 311),

	MACDEMO1_l("chuckletime", "Demo", "Chuckle Time", "f5277c53bacd27936158dd3867e587e2", 608416, Common::JA_JPN, 311),

	WINDEMO1("cinemania94", "Demo",		 "CINEOVR.EXE",	 "7c8230a804abf9353b05627a675b5ffb", 1426843, 310),
	WINDEMO1("cinemania95", "1994 Demo", "CINEDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 373209, 310),

	MACGAME1("cinevolt", "", "Cinema Volta", "2ce360c9ea2da80a2c6d1040b0ad92dd", 388167, 313),
	WINGAME1("cinevolt", "", "CINEVOLT.EXE", "65d06b5fef155a2473434571aff5bc29", 370009, 313),

	WINGAME1_l("cklasse", "", "c-klasse.exe", "39df1c7ff23ba627ddffaa5a77f83008", 376244, Common::DE_DEU, 313),

	MACDEMO1("clarisworks", "Demo", "ClarisWorks SRD Projector", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 353999, 300),

	MACDEMO1("cpu", "Demo", "CPU Demo Movie", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 533389, 300),

	MACDEMO1_l("creativeeye", "1994.02 Demo", "Creative EYE Demo", "f5277c53bacd27936158dd3867e587e2", 2355024, Common::JA_JPN, 311),
	MACDEMO1_l("creativeeye", "1994.06 Demo", "Creative EYE Demo", "276bee761e48a6fd709df77d5c2f60dd", 3344169, Common::JA_JPN, 313),

	MACDEMO1("cricketdraw", "Demo", "CA-Cricket Draw III Demo", "16759602b41cb957c8f13dba7f3f1984", 2026663, 301),

	// Original filename is キューティ１０デモ
	MACDEMO1_l("cutie10", "Demo", "Cutie 10 demo", "f5277c53bacd27936158dd3867e587e2", 390315, Common::JA_JPN, 311),

	MACGAME1("digby", "", "Start Digby's Adventures!", "7f443f2e63fd497a9ad85b10dc880a91", 383758, 313),
	WINGAME1("digby", "", "DIGBY.EXE", "65d06b5fef155a2473434571aff5bc29", 370972, 310),

	// Original filename is 恐竜サファリアドベンチャー デモ
	MACDEMO1_l("dinosafari", "Demo", "Dinosaur Safari Adventure Demo", "f5277c53bacd27936158dd3867e587e2", 394948, Common::JA_JPN, 311),

	// Demo version of Director Studio is provided (runs on 68k only). Readme instructs to run the
	// application and then open the Demo movie using the menu. However, the movie file is invisible,
	// so first you will need to copy the folder to your hard drive then modify the file properties.
	// The movie filename is 'Director Demo'.
	MACDEMO1("dirmacromind", "v3.1 Demo", "MacroMind Director 3.1.1 (SD)", "bd7b96d6c0c372e77e65ed0707aa34ee", 1191942, 311),

	MACDEMO1("donnamatrix", "Demo", "Donnamatrix Launch", "7f443f2e63fd497a9ad85b10dc880a91", 385692, 313),

	// Original filename is 東脳スタート
	MACGAME1_l("easternmind", "", "Eastern Mind Start", "276bee761e48a6fd709df77d5c2f60dd", 395037, Common::JA_JPN, 313),

	// 1994 demo for Millie's Math House, Thinkin' Things, Kid Desk
	MACGAME1_l("edmark", "", "EDMARK", "276bee761e48a6fd709df77d5c2f60dd", 392693, Common::JA_JPN, 313),

	// Demo contains Apparelizer 1.0 minigame; full game is D4
	// Found on Disc Inferno from APC magazine (Australia), Dec 1999
	WINDEMO1("elroycostume", "Demo", "elroy.exe", "9d18c6a224dd0e5be4ad03a05c74254b", 854349, 311),

	MACDEMO1("emigre", "Demo", "play cheese", "7c80091b84d4d5d48f7c773b30b10598", 990669, 310),

	MACGAME1("encarta95", "", "Encarta Projector", "7f443f2e63fd497a9ad85b10dc880a91", 385985, 313),
	WINDEMO1("encarta95", "Demo", "ENDEM95.EXE", "61d63911d437806fd473ffc31ddfc53d", 12109799, 311),

	MACDEMO1("exoticjapan", "Sampler", "Exotic Japan Sampler", "e59139ac60997f52af77d7f03275ab30", 1790832, 311),

	WINDEMO1("explorapedia", "1994 Demo", "XPLDMO6.EXE", "d61e2e1e9f9d9907005adc992a451d02", 4724919, 311),

	// All four languages on one disc. Original Mac file name is Parents’ Guide FFF
	MACGAME1("fff",   "", "Friends",      "7f443f2e63fd497a9ad85b10dc880a91", 413963, 313),
	WINGAME1("fff",   "", "FRIENDS.EXE",  "65d06b5fef155a2473434571aff5bc29", 384557, 313),
	MACGAME1_l("fff", "", "Los Amigos",   "7f443f2e63fd497a9ad85b10dc880a91", 413962, Common::ES_ESP, 313),
	MACGAME1_l("fff", "", "Les Amis",     "7f443f2e63fd497a9ad85b10dc880a91", 413962, Common::FR_FRA, 313),
	MACGAME1_l("fff", "", "Otomodachi",   "7f443f2e63fd497a9ad85b10dc880a91", 413962, Common::JA_JPN, 313),
	WINGAME1_l("fff", "", "AMIGOS.EXE",   "65d06b5fef155a2473434571aff5bc29", 384556, Common::ES_ESP, 313),
	WINGAME1_l("fff", "", "LESAMIS.EXE",  "65d06b5fef155a2473434571aff5bc29", 384554, Common::FR_FRA, 313),
	WINGAME1_l("fff", "", "OTOMODAC.EXE", "65d06b5fef155a2473434571aff5bc29", 384554, Common::JA_JPN, 313),
	MACDEMO1("fff", "Parents' Guide", "Parents' Guide FFF", "7f443f2e63fd497a9ad85b10dc880a91", 539017, 313),
	WINDEMO1("fff", "Parents' Guide", "PG_FFF.EXE", "65d06b5fef155a2473434571aff5bc29", 524393, 313),

	WINDEMO1("flw", "Demo", "FLWDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 373260, 310),

	// Original filename is 256カラーでみてください。
	MACGAME1_l("fontfriends", "Catalog", "Try 256 colors", "f5277c53bacd27936158dd3867e587e2", 1577548, Common::JA_JPN, 311),

	MACGAME1("foocastle", "", "Foo Castle", "7f443f2e63fd497a9ad85b10dc880a91", 385555, 313),
	WINGAME1("foocastle", "", "FCASTLE.EXE", "65d06b5fef155a2473434571aff5bc29", 370481, 313),

	MACGAME1_l("fototune", "", "FotoTune Multimedia show", "1ae45c23586b41997ba52e2e7c771c4c", 378993, Common::JA_JPN, 311),

	MACGAME1("freakshow", "D3", "Freak Show Projector", "bb61dd0cc8356e51fe54c1a00f979b8f", 439483, 300),

	MACGAME1("gadget", "", 	   "GADGET", 	 "7f443f2e63fd497a9ad85b10dc880a91", 384887, 313),
	MACGAME1_l("gadget", "",   "GADGET", 	 "f5277c53bacd27936158dd3867e587e2", 392906, Common::JA_JPN, 311),
	WINGAME2("gadget", "", 	   "GADGET.EXE", "2cc9e2dacb90fb130f6ee9519b66c5a8", 369009,
						   	   "GA00.MMM",	 "59c190365066ac13f9cd7721f64db85b", 324388, 310),
	FMTGAME2_l("gadget", "",   "GADGET.EXE", "2cc9e2dacb90fb130f6ee9519b66c5a8", 369009,
							   "GA00.MMM",	 "e32b3dd1a4c4e6c3899b5d2adb21d24a", 324390, Common::JA_JPN, 310),
	MACDEMO1("gadget", "Demo", "GADGET",	 "f5277c53bacd27936158dd3867e587e2", 390365, 311),
	WINDEMO1("gadget", "Demo", "GADGET.EXE", "b439d48205f27ff9431b1f1b0b841340", 684203, 311),

	// Original filename is 我流競馬ｵｰﾄﾃﾞﾓ
	MACDEMO1_l("garyukeiba", "Demo", "Garyu Keiba Auto Demo", "276bee761e48a6fd709df77d5c2f60dd", 393175, Common::JA_JPN, 313),

	MACDEMO1_l("goalrush1", "Demo", "GOAL RUSH!! DEMO", "f5277c53bacd27936158dd3867e587e2", 394984, Common::JA_JPN, 311),
	MACDEMO1_l("goalrush2", "Demo", "GOAL RUSH!! DEMO", "276bee761e48a6fd709df77d5c2f60dd", 397408, Common::JA_JPN, 313),

	// Mac also has an 8-bit color binary. Win is limited to 8-bit color in D3.
	MACGAME1("golfcd", "", "Great Golf CD (24bit)", "7f443f2e63fd497a9ad85b10dc880a91", 3633557, 313),
	WINGAME1("golfcd", "", "GOLF.EXE", "65d06b5fef155a2473434571aff5bc29", 370009, 313),

	MACDEMO1_l("granmarmalade", "Demo", "GranMarmalade", "f5277c53bacd27936158dd3867e587e2", 1077206, Common::JA_JPN, 311),

	MACGAME1("gustown", "", "GUS", "7f443f2e63fd497a9ad85b10dc880a91", 384462, 313),
	WINGAME1("gustown", "", "GUS.EXE", "65d06b5fef155a2473434571aff5bc29", 369999, 310),

	WINGAME1("hellcab", "",   "HELLCAB.EXE", "65d06b5fef155a2473434571aff5bc29", 370006, 310),
	WINGAME1_l("hellcab", "", "HELLCAB.EXE", "01f98729644d862e15d67ee08ecc302c", 370094, Common::ES_ESP, 310),
	WINGAME1_l("hellcab", "", "HELLCAB.EXE", "bacbb3b51e553de98f1db77f50450d88", 369982, Common::PT_BRA, 310),

	MACDEMO1_l("henachoco", "Trial Version", "Hena Choco Derby Demo", "f5277c53bacd27936158dd3867e587e2", 1794267, Common::JA_JPN, 311),

	MACGAME1("hhouse", "", "The Ultimate Haunted House", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384475, 313),
	WINDEMO1("hhouse", "1994 Demo", "HAUNTED.EXE", "2b3543a9131a49f665982d26513a84f8", 914491, 310),

	MACDEMO1_l("hikaruhana", "Sample Version", "HikaruHana", "1e3c3caae3ba8ab04479ebc84fab326c", 393095, Common::JA_JPN, 311),

	MACGAME1("hoaddams2", "",  "AddamsFamilyInt",				"7f443f2e63fd497a9ad85b10dc880a91", 1381040, 313),
	MACGAME1("hoangus", "",	   "Angus IPK",						"2ce360c9ea2da80a2c6d1040b0ad92dd", 2029855, 313),
	MACGAME1("hodolores", "",  "Dolores Claiborne Interactive", "7f443f2e63fd497a9ad85b10dc880a91", 1475936, 313),
	MACGAME1("hostargate", "", "Stargate Interactive",			"7f443f2e63fd497a9ad85b10dc880a91", 1394354, 313),
	MACGAME1("hothenet", "",   "The Net Interactive Kit",		"7f443f2e63fd497a9ad85b10dc880a91", 2027385, 313),
	WINGAME1("hoangus", "",	   "ANGUS.EXE",  "7c8230a804abf9353b05627a675b5ffb", 2383326, 313),
	WINGAME1("hodolores", "",  "DOLRES.EXE", "65d06b5fef155a2473434571aff5bc29", 1671516, 313),
	WINGAME1("hothenet", "",   "NET.EXE",	 "65d06b5fef155a2473434571aff5bc29", 2357523, 313),

	// Movies are played from HyperCard. Each of the 10 lessons and 3 practice examples are Director.
	MACDEMO1_l("hypercardlessons", "Demo", "Lesson1movie", "8ac6b58b68561d6227921cbfef30a02d", 62433, Common::JA_JPN, 300),

	MACDEMO1_l("hypermaterial", "Demo", "Browser_Demo", "f5277c53bacd27936158dd3867e587e2", 966309, Common::JA_JPN, 311),

	// Sanctuary Woods promos from Bird's Life, not present in the Win files.
	MACGAME1("ilearn", "", "More Fun!", "2ce360c9ea2da80a2c6d1040b0ad92dd", 14008121, 313),

	WINGAME1("imaginopolis", "1994 Demo", "MSKIDS.EXE", "2b3543a9131a49f665982d26513a84f8", 370009, 310),

	// Original filesname is IMPACT!ムービー
	MACDEMO1_l("imgimpact", "Demo", "IMPACT! Movie", "a03ae8a9bf211bcb26388b6b6da17c2b", 1806631, Common::JA_JPN, 311),

	// Original filenames are ﾌﾟﾛｼﾞｪｸﾀ and 1.ノート
	MACDEMO2_l("intelligentnote", "Demo", "Projector", "a03ae8a9bf211bcb26388b6b6da17c2b", 321006,
										  "1.Note",    "9afa1fce2f0f999e00af7d32cb8bd82d", 4946, Common::JA_JPN, 311),

	// Original filename is 犬組デモ
	MACDEMO1_l("inugumi", "Demo", "Inugumi Demo", "f5277c53bacd27936158dd3867e587e2", 2366693, Common::JA_JPN, 311),

	MACGAME1("ipc", "", "About InterActive Publishing", "ec7aaa66647e526d72cb1c1d802df48b", 3056526, 313),
	WINGAME1("ipc", "", "ABOUTIPC.EXE", "65d06b5fef155a2473434571aff5bc29", 4270544, 310),

	// Bilingual English/Spanish
	MACGAME1("iptr", "", "I Photograph to Remember", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 406002, 300),
	MACDEMO1("iptr", "Sampler", "I Photograph to RememberBIG", "a46f8441517e09088aad16decb13580d", 2632411, 311),

	// Windows version is not Director
	// Original English filename is Iron Helix™ Minimum
	MACGAME1("ironhelix", "", "Iron Helix Minimum", "1ae45c23586b41997ba52e2e7c771c4c", 1652052, 311),
	MACGAME1_l("ironhelix", "", "Iron Helix Compact", "f5277c53bacd27936158dd3867e587e2", 1596478, Common::JA_JPN, 311),
	MACDEMO1("ironhelix", "1992 Demo", "IRON HELIX DEMO", "7c80091b84d4d5d48f7c773b30b10598", 1634901, 310),
	MACDEMO1_l("ironhelix", "1993 Demo", "Iron Helix Demo (Japanese)", "1ae45c23586b41997ba52e2e7c771c4c", 378801, Common::JA_JPN, 311),
	MACDEMO1("ironhelix", "1994 Demo", "Iron Helix Demo", "7f443f2e63fd497a9ad85b10dc880a91", 2031871, 313),

	MACGAME1("jman", "", "Journeyman.16 MB", "1ae45c23586b41997ba52e2e7c771c4c", 437743, 300),
	MACDEMO1("jman", "Sneak Preview", "Journeyman Sneak Preview", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 6222889, 300),
	MACDEMO1("jman", "CD Demo", "Journeyman Demo", "424093b2bc04a1bfa4376c878f67a364", 3083188, 300),
	MACDEMO1("jman", "IMG CD Demo", "Journeyman Demo", "1ae45c23586b41997ba52e2e7c771c4c", 2880877, 311),
	MACDEMO1("jman", "Looping Demo", "Journeyman Looping Demo", "1ae45c23586b41997ba52e2e7c771c4c", 3077658, 300),
	WINGAME1("jman", "", "JMAN.EXE", "7c8230a804abf9353b05627a675b5ffb", 375282, 300),
	WINGAME1_l("jman", "", "JOURNEY.EXE", "65d06b5fef155a2473434571aff5bc29", -1, Common::JA_JPN, 300),
	WINDEMO1("jman", "Demo", "JMDEMO.EXE", "7c8230a804abf9353b05627a675b5ffb", 375305, 300),

	// Original filename is JOINT-net/DEMO
	MACDEMO1_l("jointnet", "Demo", "JOINT-net-DEMO", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 895582, Common::JA_JPN, 300),

	// HyperCard game calls movie using external MacroMind Player
	MACGAME2_l("jyajya", "", "MacroMind Player", "f5277c53bacd27936158dd3867e587e2", 390204,
							 "JyajyaInit",		 "5d96a5c42b500370663431f360af3629", 669, Common::JA_JPN, 311),

	// Original filename is 信光の勝馬道場ｵｰﾄﾃﾞﾓ
	MACDEMO1_l("katsumadojo", "Demo", "Shinko's Katsuma Dojo Auto Demo", "a1da9af48fe47cf9c7e90f83dd5ddd0f", 2138762, Common::JA_JPN, 313),

	// Original filename is 数ヤ君デモ
	MACDEMO1_l("kazuyakun", "Demo", "Kazuya-kun Demo", "276bee761e48a6fd709df77d5c2f60dd", 8631832, Common::JA_JPN, 313),

	// Series of HyperCard stacks with 22 Director movies
	MACGAME2_l("keiri", "", "Title",   "99da7ea12500740dc3aa1ee4c7408e86", 24589,
							"Title2a", "4f246b30ccbad438e09fdd7c13b97c86", 37325, Common::JA_JPN, 300),

	WINGAME1("keroppi", "", "KEROPPI.EXE", "65d06b5fef155a2473434571aff5bc29", 371272, 310),

	// Original filename is 棋士道
	MACDEMO1_l("kishido", "Demo", "Kishido", "f5277c53bacd27936158dd3867e587e2", 4026429, Common::JA_JPN, 311),

	// Original filename is KOYOSHA INSPIRE シリーズ
	MACDEMO1_l("koyosha", "Demo", "KOYOSHA INSPIRE series", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384314, Common::JA_JPN, 313),

	// Original filename is Kai's Power Tools™ Demo 1.0dj-j
	MACDEMO1_l("kpt", "Demo", "Kai's Power Tools Demo 1.0dj-j", "1ae45c23586b41997ba52e2e7c771c4c", 381400, Common::JA_JPN, 311),

	MACGAME1("kyoto", "v1.01", "Cosmology of KYOTO", "f5277c53bacd27936158dd3867e587e2", 392505, 311),
	MACDEMO1("kyoto", "Demo", "COK Overview-E", "f5277c53bacd27936158dd3867e587e2", 2140801, 311),
	MACDEMO1_l("kyoto", "Demo", "DemoStart(J)", "f5277c53bacd27936158dd3867e587e2", 441296, Common::JA_JPN, 311),

	// Full product lineup for The Learning Company (1994)
	// Windows version includes a 16-color executable
	MACGAME1("learningsystem", "Billboard", "The Learning System", "7f443f2e63fd497a9ad85b10dc880a91", 384486, 313),
	WINGAME1("learningsystem", "Billboard", "BBWIN256.EXE", "7c8230a804abf9353b05627a675b5ffb", 375297, 313),

	MACGAME1("legendsofoz", "", "OZMM", "ef9b835d26074e9e5ba10e0432404253", 1051620, 313),
	WINGAME1("legendsofoz", "", "OZMM.EXE", "236c3b91788d7d5308691ef27fe91aa0", 369250, 313),

	// Portuguese version is D4
	MACGAME1("leonardo", "", "Leonardo the Inventor", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384471, 313),
	WINGAME1("leonardo", "", "LEO.EXE", "65d06b5fef155a2473434571aff5bc29", 370000, 310),

	WINDEMO1("leopardspots", "Demo", "LEOPARD.EXE", "2b3543a9131a49f665982d26513a84f8", 1081371, 310),

	MACGAME1("lingoexpo", "", "Navigator", "53c55a79ef2c9247201c3b1873d851c6", 1082586, 400),

	MACGAME1_l("lvi", "Nº1", "LVI_8Mo", "7f443f2e63fd497a9ad85b10dc880a91", 384462, Common::FR_FRA, 310),
	WINGAME1_l("lvi", "Nº1", "LVI.EXE", "65d06b5fef155a2473434571aff5bc29", 634203, Common::FR_FRA, 310),

	MACDEMO1_l("lotus123", "Tour", "Tour of 1-2-3.v3", "1ed38b71d8d0f075483117f7fa559e7c", 367333, Common::JA_JPN, 302),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

	MACGAME1("lzone", "",   "L-ZONE", 		"f5277c53bacd27936158dd3867e587e2", 392484, 300),
	MACGAME1("lzone", "v2", "L-ZONE", 		"276bee761e48a6fd709df77d5c2f60dd", 395344, 300),
	GENGAME1_("lzone", "",	"L-ZONE",		"9f0bb7ec7720e4f680ee3aa3d22c1c9d", 384968, Common::EN_ANY, Common::kPlatformMacintoshII,ADGF_MACRESFORK, 300),
	WINGAME2("lzone", "",   "L_ZONE.EXE",	"65d06b5fef155a2473434571aff5bc29", 370009,
							"SYNER_01.MMM", "56b6f1c68e85a96bcdd01028bdec2d35", 460594, 300),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_UNSTABLE

	// This may be a hybrid of media from Director, HyperCard, and Farallon MediaTracks
	// Original filenames are MB.DemoMovie/C and MB.DemoMovie/M
	MACDEMO1_l("macbasic", "Color Demo", "MB.DemoMovie-C", "7ed88097881eaf2ae4b05c9bf7efdc7c", 170579, Common::JA_JPN, 300),
	MACDEMO1_l("macbasic", "Monochrome Demo", "MB.DemoMovie-M", "3c3f3b36eb63d8148b5a3517e3febdfc", 40132, Common::JA_JPN, 300),

	MACGAME1("macweekvideo", "", "Click Here To Get Started!", "dc99af32d1580cd6177dc77d49a103d6", 383587, 313),

	// HyperCard stack that calls a single movie using PlayAccel and MacroMind Player 3.1
	// Original HyperCard filename is EXPO CD™ Boston 1992
	// This nice looping intro movie is QTMoovs:Expo intro anim.mma
	MACGAME2("macworldexpo92", "", "MacroMind Player",	  "1ae45c23586b41997ba52e2e7c771c4c", 372993,
								   "EXPO CD Boston 1992", "4799cdcd7394a1eccb14b667a1ee2707", 71362, 310),

	// Original filename is ﾌﾟﾛｼﾞｪｸﾀ
	MACDEMO2_l("maczaurus", "Demo", "Projector", "a03ae8a9bf211bcb26388b6b6da17c2b", 309519,
									"MSI C-S",   "224006f035e5f5fc0dd0133fbc5c6b89", 142729, Common::JA_JPN, 311),

	// Original Mac filename is Maniac Sports™
	MACGAME1("maniacsports", "", "Maniac Sports", "2ce360c9ea2da80a2c6d1040b0ad92dd", 421218, 311),
	WINGAME1("maniacsports", "", "MANIAC.EXE", "65d06b5fef155a2473434571aff5bc29", 371274, 311),

	MACDEMO1_l("marinefantasy", "Demo", "MarineFantasy", "276bee761e48a6fd709df77d5c2f60dd", 395226, Common::JA_JPN, 313),

	MACGAME1("maze", "", "Maze", "c4917547b9d9fda87567a9b3544489c4", 384534, 300),

	// Selection of demos narrated by the MazeBox Tone Cruise mascot:
	// 		Pyramid Interactive, Virtual Cocktail Bar, MazeBrew, Virtual Edo Castle,
	//		Soul Gunner, Q TV, Tennoz, Kokuyo, a CD-ROM cultural course, and others
	// Original filename is 付録
	MACGAME1_l("mazebox", "Vol.1", "Appendix", "f5277c53bacd27936158dd3867e587e2", 419787, Common::JA_JPN, 311),

	// Demo runs from Aldus SuperCard with Director movies
	MACDEMO1_l("mazebrew", "Demo", "MBW", "3350d8c895d47d217d2dfa58aa95496d", 814, Common::JA_JPN, 311),
	MACGAME1_l("mazebrew", "v2.0", "MazeBrew  v.2.0", "f5277c53bacd27936158dd3867e587e2", 492213, Common::JA_JPN, 311),

	MACDEMO1("meetingmaker", "Demo", "Meeting Maker Demo", "19fe54e0b5c60405c7a88d9e4e032965", 721976, 300),

	// Original filename is ピーターと狼
	// One gameplay mode supports General MIDI
	MACDEMO1_l("mipeterwolf", "Demo", "Peter and the Wolf", "f5277c53bacd27936158dd3867e587e2", 394909, Common::JA_JPN, 311),

	MACDEMO1("mmmozart", "Sampler", "Mozart Sampler", "67fb0a6c1b3c11367b06e2cf30c9ced9", 1700540, 311),
	MACDEMO1("mmschubert", "Sampler", "Schubert Sampler", "52890d7211ae1258734c612f636da2c0", 1703468, 311),

	MACDEMO1_l("moderntimes", "Demo", "ModernTimes", "f5277c53bacd27936158dd3867e587e2", 391613, Common::JA_JPN, 311),

	// Demos from The Computer Buyer Collection Volume 1 - Sep 1995
	WINDEMO1("msarcade",	   "Demo",		"ARCADE.EXE",   "2b3543a9131a49f665982d26513a84f8", 1843614, 310),
	WINDEMO1("msartgallery",   "Demo",		"ARTGDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370002, 310),
	WINDEMO1("msbaseball",	   "1994 Demo",	"BASEBALL.EXE", "2b3543a9131a49f665982d26513a84f8", 370013, 310),
	WINDEMO1("msbasketball",   "1994 Demo",	"BASKET.EXE",   "2b3543a9131a49f665982d26513a84f8", 370014, 310),
	WINDEMO1("msbhumanbody",   "1994 Demo", "HUMAN.EXE",	"2b3543a9131a49f665982d26513a84f8", 918807, 310),
	WINDEMO1("msbsolarsystem", "1994 Demo",	"SOLAR.EXE",	"2b3543a9131a49f665982d26513a84f8", 930151, 310),
	WINDEMO1("mscomposers",	   "Demo",		"COMPDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370005, 310),
	WINDEMO1("msdinosaurs",	   "Demo",		"DINODEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370003, 310),
	WINDEMO1("msflight",	   "Demo",		"FLIGHT.EXE",   "2b3543a9131a49f665982d26513a84f8", 3485236, 310),
	WINDEMO1("msfonts",		   "Demo",		"FNTS.EXE",	  	"2b3543a9131a49f665982d26513a84f8", 1419279, 310),
	WINDEMO1("msgolf",	  "1994 Demo",		"GOLFDEMO.EXE", "febc8580c2d7d91b635f961c4f63da01", 4350031, 311),
	WINDEMO1("msmoney",	  	   "Demo",		"MONEY.EXE",	"2b3543a9131a49f665982d26513a84f8", 2510607, 310),
	WINDEMO1("msmouse",	  "1994 Demo",		"MOUSE2OH.EXE", "2b3543a9131a49f665982d26513a84f8", 370016, 310),
	WINDEMO1("msmouseh",  "1994 Demo",		"HMOUSE.EXE",   "2b3543a9131a49f665982d26513a84f8", 370013, 310),
	WINDEMO1("msmusint",	   "Demo",		"MUSIDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370003, 310),
	WINDEMO1("msnatkey",  "1994 Demo",		"QUIKLOOP.EXE", "2b3543a9131a49f665982d26513a84f8", 370016, 310),
	WINDEMO1("mspublish", "v2.0 Demo",		"PUBDEMO.EXE",  "2b3543a9131a49f665982d26513a84f8", 3184344, 310),
	WINDEMO1("mspublishd",	   "Demo",		"PUBLISH.EXE",  "2b3543a9131a49f665982d26513a84f8", 1644502, 310),
	WINDEMO1("mssndbits",	   "Demo",		"SNDBITS.EXE",  "2b3543a9131a49f665982d26513a84f8", 1476769, 310),

	MACDEMO1("msproject", "Demo", "MS Project demo", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 1060170, 300),

	MACGAME1_l("msgfromapple", "", "Message", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 395782, Common::JA_JPN, 313),

	MACGAME1("murderbrett", "", "The Environmental Surfer", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384469, 300),
	WINGAME1("murderbrett", "", "BRETTP.EXE", "65d06b5fef155a2473434571aff5bc29", 370010, 300),

	MACGAME1("murdermagic", "", "The Magic Death", "a8788e8b79dccc582b9818ec63734bed", 736754, 300),
	WINGAME1("murdermagic", "", "MAGIC.EXE", "7c8230a804abf9353b05627a675b5ffb", 375298, 300),

	// Original Mac English filename is Who Killed Sam Rupert?
	// Original Japanese demo filename is サム・ルパート殺人事件ﾃﾞﾓ
	MACGAME1("murdersam", "",		"Who Killed Sam Rupert",  "243ed9ef948de907401784d0938a4ed5", 518996, 310),
	MACDEMO1_l("murdersam", "Demo", "Sam Rupert Murder Demo", "2ce360c9ea2da80a2c6d1040b0ad92dd", 382525, Common::JA_JPN, 313),
	WINGAME1("murdersam", "1993", "RUPERT.EXE", "5c6862a40a48881913ee7c50d25cd984", 225256, 300),
	WINGAME1("murdersam", "1994", "SAM.EXE",	"65d06b5fef155a2473434571aff5bc29", 370016, 310),

	MACGAME1("murdertaylor", "", "Taylor French", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384469, 300),
	WINGAME1("murdertaylor", "", "TAYLORF.EXE", "65d06b5fef155a2473434571aff5bc29", 370010, 300),

	// Original demo filename is ﾑｽﾞｶｼｲﾎﾝｦﾖﾑﾄﾈﾑｸﾅﾙ
	MACDEMO1_l("muzukashiihon", "Demo", "Muzukashiihon", "f5277c53bacd27936158dd3867e587e2", 1058777, Common::JA_JPN, 311),
	MACDEMO1_l("muzukashiihon", "Trial Version", "ITA Choco", "f5277c53bacd27936158dd3867e587e2", 1123785, Common::JA_JPN, 311),

	MACGAME1("mylk", "", "Mylk DoubleClickMe!", "8a33471513b6896d3d13b8a9c8790d86", 356280, 300),

	MACDEMO1("necrobius", "Demo", "Necrobius (Demo)", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356865, 300),

	MACDEMO1("necromancer", "Demo", "Necromancer Launch", "7f443f2e63fd497a9ad85b10dc880a91", 385697, 313),

	// Original filename is 建築見積ｿﾌﾄ Movie
	MACDEMO1_l("negishihomes", "Demo", "Kenchiku Mitsumori Sofuto Movie", "276bee761e48a6fd709df77d5c2f60dd", 1880339, Common::JA_JPN, 313),

	MACDEMO1("newton", "Demo", "Complete Newton Demo", "7f443f2e63fd497a9ad85b10dc880a91", 383575, 313),

	WINDEMO1("nmm", "Demo", "NMMDEMO.EXE", "27f013955218ac0b57241d0b4768ad6c", 7621747, 311),

	MACDEMO1_l("nonta", "Demo", "Nonta", "f5277c53bacd27936158dd3867e587e2", 390262, Common::JA_JPN, 311),

	// Original movie filename is NOVA オープニングZ
	MACDEMO2_l("novacity", "Demo", "demo",			 "f5277c53bacd27936158dd3867e587e2", 390381,
								   "NOVA Opening Z", "1ffe4ff06bb9a2a97d76e5e20c51dcc8", 3811151, Common::JA_JPN, 311),

	MACDEMO1_l("nsxpress", "Demo", "NSX Press", "f5277c53bacd27936158dd3867e587e2", 452135, Common::JA_JPN, 311),
	MACDEMO1_l("oceansbelow", "Demo", "Oceans Below Auto-Demo", "f5277c53bacd27936158dd3867e587e2", 2680311, Common::JA_JPN, 311),

	MACDEMO1("ofoto", "Tour", "Ofoto Tour", "5cc0930b4cd0b9dfc587b241ba37bf54", 354001, 300),

	// Original projector filenames are OLﾌﾟﾛｼﾞｪｸﾀ and ﾌﾟﾛｼﾞｪｸﾀ
	// Second filename is 藤沢.ムービー
	MACDEMO1_l("olnet", "Light Demo", "OL Projector",	"f5277c53bacd27936158dd3867e587e2", 4447378, Common::JA_JPN, 311),
	MACDEMO2_l("olnet", "Net Demo",	  "Projector",		"a03ae8a9bf211bcb26388b6b6da17c2b", 439934,
									  "Fujisawa.Movie", "dbb8c3b27f5017f5fa10c3fc77da8282", 5810, Common::JA_JPN, 311),

	// Game is HyperCard based. Movies will play with --start-movie from console.
	MACGAME1("osmo", "v1.6 Floppy", "vwLogos", "7ca99dfa4b620da808266ce75cabc311", 2026, 311),

	{
		{
			"osmo", "v1.2 CD",
			AD_ENTRY1s("vwIntroOsmo", "910c6e4bf76294802e985e5b55994a73", 11374),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			(ADGF_CD|ADGF_MACRESFORK|SUPPORT_STATUS),
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		311
	},

	MACDEMO1("pagemaker", "5.0 Demo", "PageMaker 5.0 Demo", "cdb60bbb5f203e860de63df641bf5995", 1425719, 310),

	MACDEMO1_l("peaceland", "Demo", "PeaceLand", "276bee761e48a6fd709df77d5c2f60dd", 394133, Common::JA_JPN, 313),

	MACDEMO1_l("picturecard", "Demo", "Surmount", "f5277c53bacd27936158dd3867e587e2", 4407360, Common::JA_JPN, 311),

	MACDEMO1("pixar", "1993 Demo", "Pixar Projector", "1ae45c23586b41997ba52e2e7c771c4c", 2324198, 310),

	MACDEMO1("playroom", "Color Demo", "Color Playroom Demo", "b29b31f423a332e7f9e059187e62e1be", 1000734, 300),

	MACGAME2_l("presenpack", "", "Start",		 "f5277c53bacd27936158dd3867e587e2", 390255,
								 "SampleMovie1", "ad6bc606c81db01035f12e3d230d6b89", 2872942, Common::JA_JPN, 311),

	// Product is by 株式会社パークウェーブ (Parc Wave)
	// Original filename is PRESSiT.デモ
	MACDEMO1_l("pressit", "Demo", "PRESSiT.Demo", "f5277c53bacd27936158dd3867e587e2", 1209769, Common::JA_JPN, 311),

	MACDEMO1("provektor2", "Demo", "Provektor Demo", "7c80091b84d4d5d48f7c773b30b10598", 1238546, 311),
	MACDEMO1("provektor2", "Cheese Grater", "Cheese", "7c80091b84d4d5d48f7c773b30b10598", 388881, 311),
	MACDEMO1("provektor3", "Demo", "PV3_Demo", "7c80091b84d4d5d48f7c773b30b10598", 1437373, 311),
	MACDEMO1("provektormed", "Demo", "PVM_Demo", "7c80091b84d4d5d48f7c773b30b10598", 2025339, 311),

	MACDEMO1_l("pyramidint", "Demo", "PyramidInteractive", "f5277c53bacd27936158dd3867e587e2", 1591182, Common::JA_JPN, 311),

	// Original Japanese filename is レイドリームデモVer.1
	MACDEMO1("raydream", "Tour", "Ray Dream Designer Tour", "1ae45c23586b41997ba52e2e7c771c4c", 3170943, 311),
	MACDEMO1("raydream", "Gallery", "Ray Dream Gallery 3.2", "2ce360c9ea2da80a2c6d1040b0ad92dd", 6007578, 313),
	MACDEMO1_l("raydream", "Demo", "Ray Dream Demo Ver.1", "276bee761e48a6fd709df77d5c2f60dd", 395082, Common::JA_JPN, 313),

	MACDEMO1("redshift", "1993 Demo", "RedShift Demonstration", "1ae45c23586b41997ba52e2e7c771c4c", 2503732, 311),

	MACGAME1_l("refixion1", "", "REFIXION", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356245, Common::JA_JPN, 300),
	MACGAME1_l("refixion2", "", "Museum or Hospital", "1ae45c23586b41997ba52e2e7c771c4c", 375841, Common::JA_JPN, 300),
	MACGAME1_l("refixion3", "", "The Reindeer Story", "f5277c53bacd27936158dd3867e587e2", 392473, Common::JA_JPN, 300),

	// Original Mac version is Director. Later DOS port uses MADE engine (also in ScummVM).
	MACDEMO1("rodneyfs", "Demo", "Rodney's Funscreen demo", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356866, 300),

	MACGAME1("rodneyww", "", "xn--Wonder Window-8q9g", "1ae45c23586b41997ba52e2e7c771c4c", 375468, 310),
	WINGAME1("rodneyww", "", "RWW.EXE", "dac3b117db9be024ff6747b1b6c49d9c", 408259, 310),

	MACGAME1("satodesign", "Gift Disk", "Animation", "a03ae8a9bf211bcb26388b6b6da17c2b", 389109, 311),
	MACGAME1("satohomosexual", "", "SATO&NAKAZAWA", "a03ae8a9bf211bcb26388b6b6da17c2b", 736532, 311),

	MACGAME1_l("schoolworld", "Capture", "CAPTURE",			 "f5277c53bacd27936158dd3867e587e2", 1652464, Common::JA_JPN, 311),
	MACGAME1_l("schoolworld", "Breed",	 "BREED",			 "f5277c53bacd27936158dd3867e587e2", 545280, Common::JA_JPN, 311),
	MACDEMO1_l("schoolworld", "Demo",	 "SchoolWorld-DEMO", "f5277c53bacd27936158dd3867e587e2", 4046783, Common::JA_JPN, 311),
	WINGAME1_l("schoolworld", "Capture", "CAPTURE.EXE",		 "7c8230a804abf9353b05627a675b5ffb", 375279, Common::JA_JPN, 310),
	WINGAME1_l("schoolworld", "Breed",	 "BREED.EXE",		 "7c8230a804abf9353b05627a675b5ffb", 375277, Common::JA_JPN, 310),

	// Manual only. Full game is made in VB3 and contains unsupported content
	WINGAME1("scissorsnstones", "", "MANUAL.EXE", "7c8230a804abf9353b05627a675b5ffb", 2494292, 310),

	// Full game was never released
	MACDEMO1("screamingmetal", "v1.0 Demo", "Screaming Metal Demo", "0a280df213c5bf3eca241f37151e1d56", 373190, 310),
	MACDEMO1("screamingmetal", "1993 Demo", "Screaming Launch", "7f443f2e63fd497a9ad85b10dc880a91", 385883, 313),

	MACDEMO1_l("scripting", "Vol.1 Demo", "Start Here!", "f5277c53bacd27936158dd3867e587e2", 390243, Common::JA_JPN, 311),
	MACDEMO1_l("scripting", "Vol.2 Demo", "SCRIPTING", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 990261, Common::JA_JPN, 313),

	// Using Sculpt demo allows choice of English or Japanese
	MACDEMO1_l("sculpt4d", "Vol.1 Demo", "Sculpt DemoVol.1",  "1ae45c23586b41997ba52e2e7c771c4c", 816379, Common::JA_JPN, 311),
	MACDEMO1("sculpt4d",   "Vol.2 Demo", "SculptDemo2", 	  "2ce360c9ea2da80a2c6d1040b0ad92dd", 1460601, 313),
	MACDEMO1("sculpt4d",   "Vol.3 Demo", "SculptDemo Vol.3",  "f54ac20d51c496911f9144ee595ade60", 2311707, 300),
	MACDEMO1("sculpt4d",   "Vol.5 Demo", "Sculpt Demo Vol.5", "f54ac20d51c496911f9144ee595ade60", 1456565, 300),
	MACDEMO1("sculpt4d",   "Using Demo", "UsingSculpt1.0",    "2ce360c9ea2da80a2c6d1040b0ad92dd", 383636, 313),

	MACGAME1("sfk", "", "More SFK Products!", "1ae45c23586b41997ba52e2e7c771c4c", 377923, 310),

	// Found on The Cat Came Back
	WINDEMO1("sitfarm", "Demo", "MOREFUN.EXE", "65d06b5fef155a2473434571aff5bc29", 4397800, 310),

	MACGAME1("sialmanac94", "", "1994 Almanac", "c72a99a71c87ad34e416f7e7776450a8", 500154, 310),
	WINGAME1("sialmanac94", "", "SPORTSI.EXE", "990caf82b2406e3342fb93ddb7222bf5", 461040, 310),

	WINDEMO1("sk8board", "Demo", "RIDE.EXE", "65d06b5fef155a2473434571aff5bc29", 370013, 310),

	// Das Bi-Ba-Butze-Haus published by Systhema, Munich (1995) and later by Rowohlt-Systhema (1999)
	MACGAME1("snh", "",		   "A Silly Noisy House",		"9f0bb7ec7720e4f680ee3aa3d22c1c9d", 357142, 300),
	MACDEMO1("snh", "Sampler", "Silly Noisy House Sampler",	"2064fd9b1871f02d216d20e92019a7ac", 1592334, 311),
	WINGAME1("snh", "",   "SNH.EXE",   "5a6e241994f671a1ebe664fbae394217", 378901, 300),
	WINGAME1_l("snh", "", "DBBBH.EXE", "9e13813fd39da5e27627ee28894d6ec0", 738336, Common::DE_DEU, 311),

	// Game is HyperCard based. Movies will play with --start-movie from console.
	MACGAME1("spelunx", "v2.01 Color", "Spelunx", "8c4ac0488e92704a257698ee45affea5", 1208584, 313),

	WINGAME1("spyclub", "", "SPYCLUB.EXE", "65d06b5fef155a2473434571aff5bc29", -1, 300),

	// Original filename is Strata PowerPCデモ
	MACDEMO1_l("strata", "Demo", "Strata PowerPC Demo", "f5277c53bacd27936158dd3867e587e2", 3981381, Common::JA_JPN, 311),

	MACDEMO1("stravinsky", "Sampler", "Stravinsky Sampler", "283b66579162e5654fbb0ece117c9885", 2039856, 311),

	MACGAME1("supersonic", "", "Double-click me", "1ae45c23586b41997ba52e2e7c771c4c", 375446, 310),
	WINGAME1("supersonic", "", "SUPERS.EXE", "7c8230a804abf9353b05627a675b5ffb", 375290, 310),

	MACGAME1("take5", "", "Take Five", "1ae45c23586b41997ba52e2e7c771c4c", 1627245, 313),
	WINGAME1("take5", "", "TAKEFIVE.EXE", "65d06b5fef155a2473434571aff5bc29", 370000, 313),

	// Original filename is ~LEGEND OF PSY•S CITY~
	// English translation by Skye Sonomura (HomeStarRunnerTron)
	MACGAME1_l("the7colors", "", "LEGEND OF PSYS CITY", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 384001, Common::JA_JPN, 300),
	MACGAME1("the7colors", "", "T7C-R!", "d84feae6ba35340857f46c9cbd6bd1a6", 398981, 300),

	// First animation fails to run on Mac emulators
	MACGAME1("timeline", "24bit 1", "TimeLine 24bit 1", "1ae45c23586b41997ba52e2e7c771c4c", 252464, 310),
	MACGAME1("timeline", "24bit 2", "TimeLine 24bit 2", "1ae45c23586b41997ba52e2e7c771c4c", 252460, 310),

	// Original filename is 闘魂V/デモ
	MACDEMO1_l("tokon5", "Demo", "Tokon V-Demo", "f5277c53bacd27936158dd3867e587e2", 392497, Common::JA_JPN, 311),

	MACDEMO1_l("toonet11", "Demo", "TooNet11_DEMO", "f5277c53bacd27936158dd3867e587e2", 829762, Common::JA_JPN, 311),

	MACDEMO1("totaldistortion", "Demo", "TD Demo!", "1ae45c23586b41997ba52e2e7c771c4c", 381059, 311),
	MACDEMO1_l("totaldistortion", "Demo", "TD Demo", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384455, Common::JA_JPN, 313),

	MACDEMO1_l("transland", "Demo", "Trans Demo", "f5277c53bacd27936158dd3867e587e2", 2339365, Common::JA_JPN, 311),

	MACDEMO1_l("tree", "Demo", "TREE Demo", "f54ac20d51c496911f9144ee595ade60", 1104947, Common::JA_JPN, 311),

	MACDEMO1_l("ttw", "Demo", "T.T.W.Demo", "51e8b81db434a6dcae723f6b7724143d", 691332, Common::JA_JPN, 302),

	// Full version is D4
	MACDEMO2_l("ukiuki1", "Demo", "DEMO",	   "f5277c53bacd27936158dd3867e587e2", 392508,
								  "D_opening", "107b285846b271eda498870c2ea5ccf7", 1677174, Common::JA_JPN, 311),

	// Original filename is うきうきスタンプ3のおしらせ
	MACDEMO1_l("ukiukistamp", "Vol.3 Demo", "Notice of Ukiuki Stamp 3", "f5277c53bacd27936158dd3867e587e2", 392544, Common::JA_JPN, 311),

	// Original filename is うきょー1デモ版
	MACDEMO1_l("ukyo1", "Demo", "Ukyo 1 demo version", "f5277c53bacd27936158dd3867e587e2", 392773, Common::JA_JPN, 311),

	// Isaac Asimov's The Ultimate Robot CD-ROM
	WINDEMO1("ultrobot", "Demo", "ROBODEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 373521, 310),
	WINGAME1("ultrobotkit", "", "TOOLKIT.EXE", "65d06b5fef155a2473434571aff5bc29", 1858955, 310),

	MACGAME1_l("vcb", "", "Virtual Cocktail Bar", "f5277c53bacd27936158dd3867e587e2", 393702, Common::JA_JPN, 311),
	MACDEMO1_l("vcb", "Demo", "VirtualCocktailBar Exective", "f5277c53bacd27936158dd3867e587e2", 394261, Common::JA_JPN, 311),

	// Original filenames are DreamLight® Verttice™ 1.0 and DreamLight® Verttice™ 1.1
	MACGAME1("verttice", "v1.0", "DreamLight Verttice 1.0", "b57fff2bb16ad91d6e807ceeab357271", 1083249, 311),
	MACGAME1("verttice", "v1.1", "DreamLight Verttice 1.1", "1ae45c23586b41997ba52e2e7c771c4c", 1087183, 311),
	MACGAME1("verttice", "v1.1 PowerMac", "DreamLight Verttice 1.1", "1ae45c23586b41997ba52e2e7c771c4c", 1089447, 311),

	MACGAME2("vvcyber", "", "Start Game", "7f443f2e63fd497a9ad85b10dc880a91", 384846,
							"START0", 	  "6d6781e7183df66d8995285e4e3f1a50", 807, 300),
	WINGAME1("vvcyber", "", "CYBER.EXE", "65d06b5fef155a2473434571aff5bc29", 371139, 300),
	MACDEMO1("vvcyber", "Demo", "CyberPlasm", "2ce360c9ea2da80a2c6d1040b0ad92dd", 504157, 300),
	WINDEMO1("vvcyber", "Demo", "CYBER.EXE", "88f4f7406f34ec36e751a64f7c76f2c4", 639439, 300),
	MACGAME1("vvdinosaur", "", "Start Game", "d41d8cd98f00b204e9800998ecf8427e", -1, 300),
	WINGAME1("vvdinosaur", "", "DINOSAUR.EXE", "4e6303630f4dd588e730d09241cf7e76", -1, 300),
	WINGAME1("vvdinosaur", "v1.1", "DINOSAUR.EXE", "88f4f7406f34ec36e751a64f7c76f2c4", 370049, 300),
	MACGAME1("vvharp", "", "Start Adventure", "7f443f2e63fd497a9ad85b10dc880a91", 383406, 300),
	WINGAME1("vvharp", "", "HYPNOTIC.EXE", "88f4f7406f34ec36e751a64f7c76f2c4", 370272, 300),
	MACGAME1("vvvampire", "", "The Vampire's Coffin", "d41d8cd98f00b204e9800998ecf8427e", -1, 300),
	WINGAME1("vvvampire", "", "VAMPIRE.EXE", "88f4f7406f34ec36e751a64f7c76f2c4", -1, 300),

	MACGAME1_l("vvs", "", "VVS Theater-ExtraLarge", "f5277c53bacd27936158dd3867e587e2", 912907, Common::JA_JPN, 311),
	MACDEMO1_l("vvs", "Demo", "VVS Theater", "f5277c53bacd27936158dd3867e587e2", 639768, Common::JA_JPN, 311),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

	// Original AV filename is Spaceship Warlock™ AV
	WINGAME1("warlock", "",		"SSWARLCK.EXE", "65d06b5fef155a2473434571aff5bc29", 370867, 300),
	WINDEMO1("warlock", "Demo", "SSWDEMO.EXE",	"65d06b5fef155a2473434571aff5bc29", 370934, 300),
	MACGAME1("warlock", "v1.1.2 AV",  "xn--Spaceship Warlock AV-5h7l", "e043b322d17e0f2ca7f73520466a4311", 382206, 313),
	MACDEMO1("warlock", "1994 Demo",  "Spaceship Launch",			   "7f443f2e63fd497a9ad85b10dc880a91", 385872, 313),
	MACDEMO1("warlock", "AV Trailer", "SS Warlock Movie Trailer AV",   "e043b322d17e0f2ca7f73520466a4311", 384477, 313),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_UNSTABLE

	WINDEMO1("wep", "Demo", "WEP.EXE", "2b3543a9131a49f665982d26513a84f8", 1796465, 310),

	// Produced by Microsoft; designed by AdWare Inc, Los Gatos, California (1992)
	WINDEMO1("wfw31", "Demo", "WFWDEMO.EXE", "d98c3f5c1b7ea3039c47cc63d238a60d", 253540, 300),

	// Original filename is WONDEROMPM4.5J Ver.2 ｻﾝﾌﾟﾙ
	MACDEMO1_l("wonderompm", "Sample Version", "WONDEROMPM4.5J Ver.2 sample", "f5277c53bacd27936158dd3867e587e2", 392574, Common::JA_JPN, 311),

	WINGAME1("woodstock25", "",     "FESTIVAL.EXE", "65d06b5fef155a2473434571aff5bc29", 370006, 310),
	WINDEMO1("woodstock25", "Demo", "WDSTOCK.EXE",  "65d06b5fef155a2473434571aff5bc29", 2099951, 310),

	MACGAME1("wrath", "", "Wrath of the Gods", "2ce360c9ea2da80a2c6d1040b0ad92dd", 413986, 300),
	WINGAME2("wrath", "", 	  "000WRATH.EXE", "3162423a1d0885eb1eb94f557a86b258", 372970,
						  	  "SHARDCST.MMM", "22af72fba773cc5313d99c91b2e5aea9", 3432948, 300),
	WINGAME2("wrath", "", 	  "000WRATH.EXE", "3162423a1d0885eb1eb94f557a86b258", 372970,
							  "SHARDCST.MMM", "35b0a9fa9cc4ed5088d665848c5258dc", 3432878, 300),
	WINDEMO2("wrath", "Demo", "000WRATH.EXE", "3162423a1d0885eb1eb94f557a86b258", 372970,
							  "SHARDCST.MMM", "85d166abe18730d96e9d4137c66255a1", 3553330, 300),

	MACDEMO1("wriggle", "Demo", "'93 Wriggle Demo", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 353993, 300),

	MACGAME1("wti", "", "WTI Projector", "1ae45c23586b41997ba52e2e7c771c4c", 3715485, 310),

	// may be vaporware; original name is ∆ X A N T H U S ∆
	MACDEMO1("xanthus", "Demo", "X A N T H U S", "1ae45c23586b41997ba52e2e7c771c4c", 375447, 300),

	MACGAME1("y2lmath", "", "Snoopy Math", "7f443f2e63fd497a9ad85b10dc880a91", 606010, 313),
	WINGAME1("y2lmath", "", "SNPYMATH.EXE", "65d06b5fef155a2473434571aff5bc29", 413887, 313),

	// Requires installation from floppy disks
	MACGAME1("y2lpeanuts", "v1.2a Floppy", "Peanuts", "1ae45c23586b41997ba52e2e7c771c4c", 543787, 311),

	// CD-ROM language selection: German, Swedish, Dutch, Danish, English, French
	{
		{
			"y2lpeanuts", "v1.4i CD",
			AD_ENTRY1s("Peanuts", "7f443f2e63fd497a9ad85b10dc880a91", 463942),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			(ADGF_CD|ADGF_MACRESFORK|SUPPORT_STATUS),
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		313
	},

	// English Mac demos are simply quicktime files, no director
	WINDEMO1("y2lpeanuts", "QuickTime Preview", "PEANUTS.EXE", "65d06b5fef155a2473434571aff5bc29", 370017, 310),
	WINDEMO1("y2lsnoopy", "QuickTime Preview", "SNOOPY.EXE", "65d06b5fef155a2473434571aff5bc29", 370016, 310),

	// Original filename is スヌーピー Demo
	MACDEMO1_l("y2lsnoopy", "v1.2 Demo", "Snoopy Demo", "1ae45c23586b41997ba52e2e7c771c4c", 402263, Common::JA_JPN, 311),

	WINGAME1("y2lsnoopy", "", "SNOOPY.EXE", "65d06b5fef155a2473434571aff5bc29", 418576, 310),

	MACGAME1("ybr1", "",   "YBR", 		"f5277c53bacd27936158dd3867e587e2", 414498, 300),
	WINGAME2("ybr1", "",   "YBR.EXE",	"2cc9e2dacb90fb130f6ee9519b66c5a8", 369007,
						   "START.MMM",	"69012b34b3f0e6f1886133b807db4476", 2566872, 300),
	MACGAME2_l("ybr1", "", "YBR",		"f5277c53bacd27936158dd3867e587e2", 414498,
						   "START",		"ca4a6650d8f8ce04b26bcbc941bf0a86", 2417242, Common::JA_JPN, 300),
	WINGAME2_l("ybr1", "", "YBR.EXE",	"2cc9e2dacb90fb130f6ee9519b66c5a8", 369007,
						   "START.MMM",	"9e02f41270708101b1d5d04cb822a784", 2563274, Common::JA_JPN, 300),

	// Original filename is 財閥銀行
	MACDEMO1_l("zaibatsu", "Demo", "Zaibatsu Bank", "a03ae8a9bf211bcb26388b6b6da17c2b", 1830610, Common::JA_JPN, 311),

//////////////////////////////////////////////////
//
// Macromedia Director v4
//
//////////////////////////////////////////////////

	WINDEMO1("3datlas97", "Demo", "ATLAS97.EXE", "b5da314bdfd9344530a24093f2e0b566", 8300357, 404),

	MACGAME1_l("4sight", "", "four-sight", "0c7bbb4b24823e5ab871cb4c1d6f3710", 508347, Common::JA_JPN, 404),
	WINGAME1_l("4sight", "", "4_SIGHT.EXE", "26c279f80434c0a641d28cec198c783f", 740581, Common::JA_JPN, 404),

	MACGAME1("9worlds", "", "Nine Worlds", "3930940b5b4b2ae2563cc29b812855a6", 482838, 400),
	WINGAME1("9worlds", "", "9WORLDS.EXE", "9da9df906149916b340a0a8fbee5ca52", 741994, 400),
	MACGAME1_l("9worlds", "", "Neun Welten", "3930940b5b4b2ae2563cc29b812855a6", 483774, Common::DE_DEU, 400),
	WINGAME1_l("9worlds", "", "9WORLDS.EXE", "054e5af279a05ab64627ef664631fe37", 742002, Common::DE_DEU, 400),

	WINGAME1("abcpalsafety", "", "EWOLSFTY.EXE", "a998d49776a611940e872a97a5fe3d1d", 4586417, 400),

	MACGAME1_l("abrapalabra", "", "ABRAPALABRA", "bcd3c718db258701496b3c5bcb827ef2", 483774, Common::ES_ESP, 404),
	WINGAME1_l("abrapalabra", "", "PALABRA.EXE", "a24a52bdb12d61eae64b9088b25ea03b", 862425, Common::ES_ESP, 404),

	// Found on Nine Month Miracle for Mac
	MACDEMO1("adamcmp", "Demo", "Comprehensive", "17efee018a660458fae80de4364021ac", 483746, 404),
	MACDEMO1("adamess", "Demo", "Essentials",	 "17efee018a660458fae80de4364021ac", 483746, 404),
	MACDEMO1("adamstd", "Demo", "Standard",		 "17efee018a660458fae80de4364021ac", 483746, 404),

	// Found on A.D.A.M. v1.1.1 for Mac
	MACGAME1("adamscholar", "", "Run Demo!", "17efee018a660458fae80de4364021ac", 483746, 404),

	// Animated Dissection of Anatomy for Medicine
	// Created by A.D.A.M. Software, Marietta, Georgia, USA
	// Puzzle demo is found on apcmag.cd Dec 1999 disc 3, published by Australian Consolidated Press
	// PUZZLE.EXE is the only file in this demo
	// Versions 2.x are labeled 1997 Edition
	MACGAME1("adamtis", "v1.1.1",	  "Adam Player.ppc",   "17085276f3b938562330a4e8bfdc97ce", 57702, 404),
	MACDEMO1("adamtis", "Demo",		  "Inside Story Demo", "ea646eccc9a53f44ce082459d4809a06", 481482, 404),
	WINGAME1("adamtis", "v1.11",	  "ADAMPLAY.EXE",	   "81bcf05f92ebbd98034a189cde6a4936", 695721, 404),
	WINGAME1("adamtis", "v2.01",	  "ADAMPLAY.EXE",	   "803570c5edef30938a1efb0900f113e0", 695855, 404),
	WINDEMO1("adamtis", "Skull Demo", "PUZZLE.EXE",		   "d2dcc8b55382fc1807e357af5108f7ba", 1057997, 404),

	MACGAME1("alice", "", "Alice", "3b61149c922f0fd815ca29686e4f554a", 304714, 400),
	WINGAME1("alice", "", "ALICE.EXE", "c67ece9b657ee80355520ac37a25fe55", 684733, 400),

	// Developed by Collabo Software and NOVUM, distributed by XING Inc.
	// Mac projector does indeed end in .EXE
	// Win has projectors for 8-bit and 16-bit color
	MACGAME1_l("alius", "",             "ALIUS_FAT.EXE", "df355a56c186f3d6a64d99e96600f48c", 499193, Common::JA_JPN, 404),
	WINGAME1_l("alius", "8-bit Color",  "ALIUS_8.EXE",   "9db857a65199db5251a33b2121ec5984", 2426433, Common::JA_JPN, 404),
	WINGAME1_l("alius", "16-bit Color", "ALIUS_16.EXE",  "98ac4e872421263dbbde1636b1e9d0e1", 2635737, Common::JA_JPN, 404),

	MACGAME1("alphabet", "", "Alpha.ppc", "71287376e445ab9c98f0d150bb0ed175", 59444, 404),
	WINGAME1("alphabet", "", "ALPHA.EXE", "c89c8301db7ef0ebffedf435863b3ffc", 749092, 404),

	WINGAME1("amnesty", "", "AMNESTY.EXE", "39b849bbba9eaf39c92ca25e0bb36a56", 736902, 404),

	WINGAME1_l("angelgate", "",		"ANGEL.EXE", "046f0458f64b9008bc4b0dca5b895390", 746991, Common::JA_JPN, 404),
	WINDEMO2_l("angelgate", "Demo", "DEMO.EXE",	 "32640d047e9e0d9498a6654de07e8248", 746865,
									"START",	 "9261f9d13410517d9172975ea33695c2", 10354, Common::JA_JPN, 404),
	MACDEMO2_l("angelgate", "Demo", "DEMO", 	 "bcd3c718db258701496b3c5bcb827ef2", 483415,
									"START",	 "66600069c64ac7938eba0531ea1c1537", 10482, Common::JA_JPN, 404),

	WINGAME1_l("ankh1", "", "ANKH.EXE", "ca3b036aed6f38beb3ee762e171b663e", 746959, Common::JA_JPN, 404),

	// Original filename is Ants Afire!™ 1.2
	MACGAME1("antsafire", "v1.2", "Ants Afire! 1.2", "1682231de376e5465240f6e4a7952072", 292216, 403),

	MACDEMO1("aol", "v2.6 Demo", "America Online Easy", "67f572196550aedb1f9523d782022be0", 482838, 404),
	WINDEMO1("aol", "Demo", "AOL.EXE", "6fa7b1fce40c6edb7710d0550431b2df", 1426687, 404),

	MACGAME1("applestore", "", "Apple Company Store", "19b7c96659c773e73b13986d06b28c5c", 774048, 404),

	MACGAME1("arcofdoom", "", "Arc Player (4mb)", "ea553e3f3fa123ad38fa5249621e8c8b", 295426, 400),
	MACDEMO1("arcofdoom", "Demo", "ArcDemo", "cdb27c916044ae4dceb4b7326063fa03", 301925, 400),
	WINGAME1("arcofdoom", "", "ARC.EXE", "fd3e9ad004597b01656b28c348a2ae7f", 687973, 400),

	MACGAME1("artrageous", "", "Artrageous!", "17efee018a660458fae80de4364021ac", 483746, 404),
	WINGAME1("artrageous", "", "ART.EXE", "926ca15bcb7bdccc8f9b14b052d05f83", 696827, 404),

	MACGAME1("aruba", "", "ARUBA POWER PC", "d8b8e42c2d9875b47ea762ca3fd45122", 57122, 404),
	WINGAME1("aruba", "", "ARUBA.EXE", "adb2655694ddacd49513ae50f58977ea", 696671, 404),

	 // Full game is not Director
	WINDEMO1("ataripack", "Demo", "ACTDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1("athletics", "", "ATHLETICS", "17efee018a660458fae80de4364021ac", 482866, 404),
	WINGAME1("athletics", "", "PROJECT.EXE", "b804f1e4bf84c31979502329ee0f8c28", 696839, 404),

	// Both Mac and Win versions require installation to extract executable
	// Russian version appears to be identical with only assets replaced
	// Original Japanese Mac filename is バッドデイ(Power PC)
	MACGAME1("badday", "",	 "BadDay (Universal)", "b7e69c37b7355022d400c14aa97c5d54", 483781, 404),
	MACGAME1_l("badday", "", "BadDay (Power PC)",  "c5f8c31feb5c3d4596b63455c520fc46", 60352, Common::JA_JPN, 404),
	WINGAME2("badday", "",   "BAD_DAY.EXE", "4ad339db5379a860b33cbb0fa64f18e2", 742342,
							 "BADDAY.DXR",	"b4b6fa644f64555f9f7af51454c40909", 288810, 404),
	WINGAME2_l("badday", "", "BAD_DAY.EXE",	"4ad339db5379a860b33cbb0fa64f18e2", 742342,
							 "BADDAY.DXR",	"b4b6fa644f64555f9f7af51454c40909", 397994, Common::RU_RUS, 404),
	WINGAME2_l("badday", "", "BAD_DAY.EXE",	"7589f11c6411e59c0e82ec129090460f", 768773,
							 "BADDAY.DXR",	"26c3b03b18e7aa098216be73d96289b0", 549108, Common::JA_JPN, 404),

	// Original filename is みんなであそぼ　デモ
	// Kidsoft US packaging says A Bear Family Adventure featuring Playtime in the Park by Erica Dale
	MACDEMO1_l("bearfamily", "Demo", "Playtime Demo", "77f4098988d5386794d1530065f514cd", 301953, Common::JA_JPN, 400),

	MACGAME2("beatexp", "", "The Beat Experience", "17efee018a660458fae80de4364021ac", 486046,
							"MAIN.DIR",			   "988fb673e94af049b30e146c1bce3fa9", 5761764, 404),
	MACDEMO2("beatexp", "", "The Beat Experience", "17efee018a660458fae80de4364021ac", 486046,
							"MAIN.DIR",			   "b4b6fa644f64555f9f7af51454c40909", 397994, 404),
	WINGAME1("beatexp", "", "BEATEXP.EXE", "2b70ef82a850598dfaf097d0a89ca454", 3588245, 404),

	// Original filename is BeBoxへの招待
	MACDEMO1_l("bebox", "Demo", "Invitation to BeBox", "5e2eb92e059fd2aa880c537da1385aa1", 484323, Common::JA_JPN, 404),

	WINGAME1_l("beestenboel", "", "ZOOLOGIC.EXE", "348bbc6d04f4ab2b9493c764cdbea8f4", 773051, Common::NL_NLD, 404),

	// Developed and published by Vantan International, Shibuya, Tokyo
	// Original filename for game is 新たなる魂の迷宮
	// Filename for toy box is データToyBox
	MACGAME1_l("bem", "", "xn--f9jwam9iq41vctmzz3e04s", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484219, Common::JA_JPN, 404),
	MACGAME1_l("bemtoybox", "", "xn--ToyBox-hu4e9b90a", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484323, Common::JA_JPN, 404),

	MACGAME1_l("betterd", "", "Better Dead 12 megs", "17efee018a660458fae80de4364021ac", 486973, Common::JA_JPN, 404),
	WINGAME1_l("betterd", "", "BETTERD.EXE", "e484d23ce2b6750d9e7e4a7b32632f47", 696877, Common::JA_JPN, 404),

	// Demo is from covermount of PC Guide (UK) Feb 1997
	MACGAME1("bht", "",   "A Brief History Of Time 16megs", "8719de9c083aca942fc0e5c0a127b6dc", 486982, 404),
	MACGAME1_l("bht", "", "Eine kurze Geschichte der Zeit", "8719de9c083aca942fc0e5c0a127b6dc", 486982, Common::DE_DEU, 404),
	WINGAME2("bht", "", 	"BHT.EXE", 		"d2f280d5ec355b252ffdadbe19332893", 692381,
							"PLAY_BHT.DIR", "663acc406405b6fcac7e2d89230c4cc2", 8398, 404),
	WINDEMO2("bht", "Demo", "BHT.EXE",		"d2f280d5ec355b252ffdadbe19332893", 692381,
							"PLAY_BHT.DIR", "9417d6ebe716c963a4424a1611aaa2ca", 3522, 404),
	WINGAME2_l("bht", "", 	"BHT.EXE", 		"d2f280d5ec355b252ffdadbe19332893", 692381,
							"PLAY_BHT.DIR", "a11fe20066d9e84423df6c3ef4966636", 69068, Common::DE_DEU, 404),

	WINGAME1("blaster", "", "DEMO.EXE", "617725437da4d66c176a9e7011977097", 24300731, 400),

	MACGAME2("blender", "Volume 2.1", "BLENDME (POWERMAC)", "9d10bbbf1b8d527e203c6be2eac3518c", 58058,
									  "OPENING.DIR",		"f5d3c1e813ec276de53d5ff13a6bf337", 2888054, 404),
	MACGAME2("blender", "Volume 2.2", "BLENDME (POWERMAC)", "9d10bbbf1b8d527e203c6be2eac3518c", 58058,
									  "OPENING.DIR",		"9984fd46227b54b7e48a76cec2cec06b", 1991202, 404),
	WINGAME2("blender", "Volume 2.1", "BLENDME.EXE", "408fdb0f6806d93a9af0412f3704481e", 728849,
									  "OPENING.DIR", "9cc466058bb16422489ce97fe02cb44a", 2887926, 404),
	WINGAME2("blender", "Volume 2.2", "BLENDME.EXE", "408fdb0f6806d93a9af0412f3704481e", 728849,
									  "OPENING.DIR", "5df4561b730dabc240e6cdf530f78d23", 1991074, 404),

	MACGAME1("blenderbest", "", "PPC LAUNCHER", "9d10bbbf1b8d527e203c6be2eac3518c", 58058, 404),
	WINGAME1("blenderbest", "", "BLENDPC.EXE", "408fdb0f6806d93a9af0412f3704481e", 728849, 404),

	// Dutch title is Blinky Bill 1 en het verhaal van de Griezel-Grot
	// Portuguese title is A Caverna do Fantasma de Blinky Bill
	WINGAME1("blinkybill1", "",		   "BLINKY.EXE",   "0d374b4a559e505c0db63cabc2219380", 712501, 404),
	WINGAME1("blinkybill1", "Softkey", "BLINKY95.EXE", "f236295291fe54b8ca13534442ee1a8c", 713061, 404),
	WINGAME2_l("blinkybill1", "",	   "start.exe",	   "be1e65196a1d1c810d84c0084a5c1033", 717299,
									   "ghost0.dxr",   "5d79d1d50d7abc7bc7b6d72b3b4b831d", 112048, Common::NL_NLD, 404),
	WINGAME1_l("blinkybill1", "",	   "BLINKY95.EXE", "3ee51e3c9f0f7f069580ef5361fd4e3d", 717025, Common::PT_BRA, 404),

	WINDEMO1("blockbuster2", "Demo", "BB2.EXE", "132e49c93beae46c2803db11584e6315", 8447185, 404),

	WINDEMO1("bookshelf95", "Demo", "BS95DEMO.EXE", "9493e1f5e92c89de805f07e1529243d4", 2593543, 404),

	WINGAME1("bowie", "", "JUMP.EXE", "1706ba3b999d724957198c134e508127", 684317, 400),

	MACGAME1("brer", "", "Brer Rabbit", "67f572196550aedb1f9523d782022be0", 483756, 404),
	WINGAME1("brer", "", "BRER.EXE", "c69462a167f1c0676c5299414484b96b", 699943, 404),

	WINDEMO1("bugbook", "Demo", "BUGBOOK.EXE", "50db9dea4e8a1778bf55c4b96c00ea5d", 770291, 404),

	// Full game is not Director
	WINDEMO1("c64pack", "Demo", "C64DEMO.EXE", "0458e44d9ad4ae0d3a583ac4141d21ae", 1007517, 400),

	// Retail CD release from BeachWare, Inc.
	// Windows version also has CASINO2.EXE (Casino! Basic) for low performance PCs
	// Director-based AUTORUN.EXE launcher chooses between these options on Win9X
	MACGAME1("casino", "", "Casino! for PowerPC", "5bb6f4e7f9f026e2b5cf758796db3cd2", 57984, 400),
	WINGAME1("casino", "", "CASINO.EXE", "7bb58472256eb84983a7d86843c81042", 692873, 404),

	MACDEMO1("catseyeview", "Demo", "Cat's Eye View.DEMO", "33f733b2809b94c3301096902f642b6e", 289746, 402),

	MACGAME1("cbible", "", "Children\'s Bible Stories", "17efee018a660458fae80de4364021ac", 483746, 404),
	WINGAME1("cbible", "", "CBIBLE.EXE", "d408f781d32337f8a5a9b3655c7d7803", 1727225, 404),

	// Both versions require installation
	MACGAME1("cclown", "", "Color Clown", "bcea0da496deb8bf81c136a8538b9a01", 852148, 404),
	WINGAME1("cclown", "", "CCLOWN.EXE", "9bb66730af24e8a5d5cbbddfe98b33e6", 1050805, 404),
	WINDEMO1("cclown", "Help", "HCLOWN.EXE", "ed58a56a9e9e003433854a041cfb12c0", 698845, 404),

	// Original Mac filename is Paul Cézanne 8 Mb
	MACGAME1_l("cezannetour", "", "Paul Cezanne 8 Mb", "2dca4bcd28ed470676af68563bf6a63e", 484331, Common::PT_BRA, 400),
	WINGAME1_l("cezannetour", "", "CEZANNE.EXE", "1463f0b6aa7d3d20de66699c16de2f98", 688027, Common::PT_BRA, 400),

	WINDEMO2("chuniverse", "Demo", "UNIVERSE.EXE", "53f7608bfe324d1837fa03966a879470", 697235,
								   "DEFI.DXR", 	   "f23981667821bd1ead36e94b3c6d7878", 1149448, 404),

	WINDEMO1("cinemania95", "1995 Demo", "CINEDEMO.EXE", "22a3ac2d4ad33edbfe531d269fe59738", 692419, 404),

	// French speech, English text
	WINDEMO1_l("cinemania96", "Demo", "CINE_FR.EXE", "1411329e65c11a6b1ebb57fc28f79d2f", 697783, Common::FR_FRA, 404),

	MACGAME1("chaquico1000", "ECD", "1000 Pictures", "01be45e7241194dad07938e7059b88e3", 486982, 404),
	WINGAME1("chaquico1000", "ECD", "1000_PIC.EXE", "7f69b6805b6a70c75b98171370ab906f", 4110937, 404),

	// Original filename is Chine Crisis /demo
	MACDEMO1_l("chinacrisis", "Demo", "Chine Crisis -demo", "b06606b4d174b85d41b265bd366959d6", 288414, Common::JA_JPN, 402),

	WINGAME1("chopsuey", "", "CHOPSUEY.EXE", "785e26240153a028549e8a66c2e904bf", 772382, 400),

	MACGAME1("chuckaduck", "", "Chuck A Duck", "77f4098988d5386794d1530065f514cd", 304189, 400),

	// Original Mac filename is 中天スタート
	MACGAME1_l("chuteng", "", "Chu-Teng Start", "ea646eccc9a53f44ce082459d4809a06", 484351, Common::JA_JPN, 404),
	WINGAME1_l("chuteng", "", "CHUTENG.EXE", "aaef7b33829ff7b0243412c89869e011", 746971, Common::JA_JPN, 404),

	MACDEMO1("cinemac", "Sample Projector", "Sample Projector with BackDrop", "2c27791a84756be6201d281bad54f7bb", 286214, 404),

	MACGAME1("circus", "", "Circus!", "dc5a87dda7a0daf46604515f7d2cca66", 320119, 400),
	WINGAME1("circus", "", "CIRCUS.EXE", "50d81af709047f5d1310468a3cd5a248", 1503187, 400),
	PIPGAME1_l("circus", "", "Circus!", "0d69b9bb731fba3d861a5f18e1810aa5", 61739, Common::JA_JPN, 404),
	MACDEMO2("circus", "Demo", "Demo", 	   	  "dc5a87dda7a0daf46604515f7d2cca66", 308542,
							   "DemoLoop", 	  "dc5a87dda7a0daf46604515f7d2cca66", 308542, 403),
	WINDEMO2("circus", "Demo", "DEMO.EXE", 	  "360f8621637354b9231059470c71fc43", 685645,
							   "PREVIEW.EXE", "d98e36d5e525e8369458509b46587d8d", 686139, 400),

	// Product catalog - does not correspond to any single game
	// Found on the Billboard Music Guide CD (1997)
	// The icon is the only additional file that could be used for detection
	WINGAME2("cmc", "", "CATALOG.EXE", "11029bddba243a6be861367d45be5db9", 3896961,
						"CMC.ICO",	   "cecbfb6ffa9bd2b1fe27e2d571809c7f", 766, 404),

	// Original filename is CityNetLine デモ版
	MACDEMO1_l("cnl", "Demo", "CityNetLine Demo Version", "f5033f237ad1b1639fc46d01a82ac380", 286396, Common::JA_JPN, 404),

	WINDEMO2("comusic", "Sampler", "START.EXE", "fba297f096949fe11676360457a1a52f", 731053,
								   "INIT.DIR",  "349635e29a5e28f88a43f3cf48b13380", 57796, 404),

	WINDEMO1("connections", "Demo", "CONNECT.EXE", "9ee064f5c862e75cf73ba567724dc8b9", 690023, 404),

	// Rodney Alan Greenblat for Nick Games
	// Windows version from Disc Inferno from APC magazine (Australia), Dec 1999
	// Later Shockwave version is from Nickelodeon Clickamajigs
	WINGAME1("crybaby", "", "crybaby.exe", "e67c787e86a948dcac23fd0d533f53ab", 1211165, 404),

	// From Personal Computer World (UK) disc no. 4 - Dec 1996
	WINDEMO2("ctrain", "Demo", "DEMO.EXE", "d8226e09cff86cece90b52bc9eeaac7b", 1585550,
							   "01.DIR",   "63a263078c15a7352a3a6c0494e1d304", 1374398, 404),

	// Curio City (キュリオ シティ) is a quarterly series of virtual mall and entertainment CD-ROMs
	// issued by Mitsui & Co. to promote its Curio City shopping services.
	MACGAME1_l("curiocity", "Vol.1", "CURIO CITY", "8719de9c083aca942fc0e5c0a127b6dc", 502845, Common::JA_JPN, 404),
	WINGAME1_l("curiocity", "Vol.1", "CURIO.EXE", "15a14209211895887d80e650984b9e32", 747389, Common::JA_JPN, 404),

	WINDEMO1("d", "Demo", "DDEMO.EXE", "fe9a58b5b5e782aac644eb9183136694", 697001, 404),

	MACGAME1("daedalus", "", "DAEDALUS.DAT", "4eb2fab14f1b932ae9f01d8b05a411de", 69794, 400),
	MACGAME1_l("daedalus", "", "DAEDALUS.DAT", "2b9e22ee93e5d58f383ef389fa09e12b", 69794, Common::DE_DEU, 400),
	MACGAME1_l("daedalus", "", "DAEDALUS.DAT", "2b9e22ee93e5d58f383ef389fa09e12b", 69794, Common::FR_FRA, 400),

	WINDEMO2("dailymail100", "Demo", "STARTUP.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1129467,
									 "LAUNCH2.DIR", "f913a0c83847ccc9df461311a4475a77", 223086, 404),

	// Mac executable is ダン
	MACGAME1_l("dan", "", "Dan", "ea646eccc9a53f44ce082459d4809a06", 485143, Common::JA_JPN, 404),
	WINGAME1_l("dan", "", "DAN.EXE", "1c0ff839ffc63cc21ce0017b5ad807ce", 740257, Common::JA_JPN, 404),

	// Both Mac and Win versions require installation to extract executable
	// Mac version has 68k, PowerPC, and a fat binary (default) as options in the installer
	MACGAME1("darkeye", "", "The Dark Eye (Universal)", "67f572196550aedb1f9523d782022be0", 486334, 400),
	WINGAME1("darkeye", "", "DARKEYE.EXE", "6190ac8ccef3fd073e912ec5d0850f94", 742326, 400),

	WINGAME1("davidsonpp", "1995", "DPP.EXE", "36c28cd89054df395c17c024a6ad6197", 112839901, 404),

	// Original Pippin filename is ダズロイド
	MACGAME1("dazzeloids", "", "Dazzeloids", "c9c25d0d249d529680302a81c30852d0", 367320, 400),
	MACDEMO1("dazzeloids", "Demo", "Dazzleoids", "77f4098988d5386794d1530065f514cd", 301953, 400),
	PIPGAME1_l("dazzeloids", "", "Dazzeloids", "2324c2928417a696fca46535ded53e32", 68242, Common::JA_JPN, 400),
	WINGAME1("dazzeloids", "", "DAZZ.EXE", "65768d30ebe836309ad2c3779a66f3ce", 1034266, 400),

	MACGAME1_l("dcanyon", "", "Devils Canyon (16+Mb)", "97474208c44c78f26bef8b2011d341aa", 483774, Common::IT_ITA, 404),
	WINGAME2("dcanyon", "",	  "DCANYON.EXE",		   "f5033a9fd54d41d348fa97bd13f8f088", 1050728,
							  "00INTRO.DIR",		   "d0c7645593725340480e2425811d6d8f", 3644052, 404),
	WINGAME2_l("dcanyon", "", "DCANYON.EXE",		   "f5033a9fd54d41d348fa97bd13f8f088", 1050728,
							  "00intro.Dir",		   "f6ca66b328f7fbcdd2e911273d74677c", 3777126, Common::IT_ITA, 404),
	WINGAME2_l("dcanyon", "", "DCANYON.EXE",		   "85e7939a0c3041660defb80e0d530230", 744381,
							  "00INTRO.DIR",		   "3621850ac727f9cf116c41143482c16c", 4044830, Common::ZH_CNA, 404),
	WINGAME1("dcanyoncd", "", "DINO_CD.EXE",		   "5fe054ed623541a92c04f1572ecb6c5d", 3160272, 404),

	// Mac executable is Derrat Sorcerum™ v1.0.3
	MACGAME1("derratsorcerum", "", "Derrat Sorcerum v1.0.3", "a546ef2b921a9b48fd93928f1a505f22", 483762, 400),
	MACDEMO1("derratsorcerum", "Demo", "Derrat Sorcerum Demo v1.0.3", "a546ef2b921a9b48fd93928f1a505f22", 483762, 400),

	// Both Mac and Win versions require installation to extract executable
	MACGAME1("devo", "", "Smart Patrol", "01be45e7241194dad07938e7059b88e3", 478506, 400),
	WINGAME1("devo", "", "SMRTPTRL.EXE", "6030100dbff520b8763f6e98d15389d7", 741904, 400),

	MACGAME1_l("digby", "", "Start Digby's Adventures", "a8e65a2268226bd59f12ebdc58a221f3", 481482, Common::ZH_CNA, 404),
	WINGAME1_l("digby", "", "DIGBY.EXE", "adc126fbc4387e5d8e84dcd5abd33653", 684269, Common::ZH_CNA, 400),

	MACDEMO1_l("dirmacromedia", "v4.0.3J Demo", "Director 4.0 Demo", "e258089af01c8233db77039828cc83f8", 1489206, Common::JA_JPN, 403),

	MACGAME1("dkmm2", "", "DKSDMac", "8554afe42cffb4add44bf37e48e1d954", 322917, 400),
	WINGAME1("dkmm2", "", "DKSD2PC.EXE", "2ad79a3a4c30655ddf9aeb2ebfe8cb5b", 862849, 400),

	// Mac versions are D5
	// Het Geheim Van Dracula localized by Transposia
	// Dracula : Le Mystère du chateau published by Hoffmann + associates
	WINGAME1("draculassecret", "",	 "SECRET.EXE",	"79cca0ac2870f070ea5228bff152b462", 808748, 404),
	WINGAME1_l("draculassecret", "", "Dracula.exe", "033eed030a848f54a8f1671f50c616e9", 772925, Common::FR_FRA, 404),
	WINGAME1_l("draculassecret", "", "secret.exe",	"b24fbaf90985cdb79132eda2ee5b73d2", 1132985, Common::NL_NLD, 404), // original release
	WINGAME1_l("draculassecret", "", "secret.EXE",	"169e3f445e3f5489f98194e63ad14730", 763851, Common::NL_NLD, 404),

	MACGAME1("dreidel", "", "dreidel", "77f4098988d5386794d1530065f514cd", 304189, 400),

	MACGAME1_l("earthtia", "", "LATHUR'S LEGEND", "b267d7e5f42c170a4f5dbb50a0f4e064", 289818, Common::JA_JPN, 402),

	// Full game is not Director
	WINDEMO1("earthwormjim", "Demo", "EWJDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1("easternmind", "", "Eastern Mind", "78138a77207907642744d0960c14d9e5", 483746, 400),
	WINGAME1("easternmind", "", "ESTRNMND.EXE", "2597cfb5466d193b5a18fc7b0e3a3fa5", 685789, 400),

	MACGAME1("easyitalian", "", "Easy Cooking Italian", "a8e65a2268226bd59f12ebdc58a221f3", 483746, 404),
	WINGAME1("easyitalian", "", "ITALIAN.EXE", "acec057095e38421040129da764e0e16", 698291, 404),

	MACGAME1("edh", "", "Executive Diet Helper CD", "7e1e1bad51542c9a3b484b1dacdf47fc", 635872, 404),
	WINGAME1("edh", "", "EDHCD.EXE", "fdeadce56c6654312bf280eb21f36692", 9841489, 404),

	WINGAME1("einstein", "", "EINSTEIN.EXE", "5f2b54a1cbf0c62913d4f1fa07b5f3a9", 711759, 404),

	WINDEMO1("elmopreschool", "Demo", "ELMO.EXE", "655f0e18645a04108ebd78d6303afc38", 5070639, 404),

	// Demo is found on Pantsylvania CD
	MACDEMO1("elroybug", "Demo", "Elroy Goes Bugzerk Demo", "bcd3c718db258701496b3c5bcb827ef2", 498650, 404),
	WINDEMO1("elroybug", "Demo", "ELRYDEMO.EXE", "cb2d86ea52d81d12d1fe8eadfb4a118c", 2438763, 404),

	// Developed and published by Headbone Interactive, Seattle
	MACGAME1("elroycostume", "", "Elroy's Costume Closet", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483746, 404),
	WINGAME1("elroycostume", "", "ECCLOSET.EXE", "f2fb9b1c60d3d1ee2b664165f4199391", 1327420, 404),

	MACGAME1("elroypave", "", "Elroy Hits the Pavement", "17efee018a660458fae80de4364021ac", 525840, 404),
	WINGAME1("elroypave", "", "PAVEMENT.EXE", "7937f42747788b558bc32cced3d8f66b", 758491, 404),
	MACDEMO1("elroypave", "Demo", "Pavement Demo", "17efee018a660458fae80de4364021ac", 521136, 403),
	WINDEMO1("elroypave", "Demo", "PAVEDEMO.EXE", "073eb1dd818796efe9513b11a8a4bb2d", 802180, 404),

	// Separate binaries for English or French, 68K or PowerPC
	MACGAME1("emme", "", "The Keys to Knowledge PowerMac", "6d6772c4177764f6b556ba7c88f9b949", 60905, 404),
	MACGAME1_l("emme", "", "Les Secrets de la conn..Pow_Mac", "6d6772c4177764f6b556ba7c88f9b949", 60905, Common::FR_FRA, 404),
	WINGAME1("emme", "", "EMMPCENG.EXE", "b03fc5677dddb8fa85d24361a0e1e9b9", 4406907, 404),
	WINGAME1_l("emme", "", "EMMPCFRA.EXE", "b3ab1dab136dd60fca422409d8876375", 5120157, Common::FR_FRA, 404),

	WINDEMO1("encarta95", "1995 Demo", "ENCARTA.EXE", "54a60641ccd62a49891aaa8329c97f46", 12015231, 404),

	WINDEMO1("exos", "Demo", "EXOSDEMO.EXE", "e26dc25e9f03c4343375e84521dc0c7d", 4001759, 404),

	WINDEMO1("explorapedia", "1995 Demo", "XPLDEMO.EXE", "11f73ebd2da334912e717c05c33b7340", 4731995, 404),

	MACGAME1("explorers", "",	"Explorers",	"ea646eccc9a53f44ce082459d4809a06", 483774, 404),
	WINGAME2("explorers", "",	"XPLRNW.EXE",	"907c28b272eb40fad1b5f42ec841b010", 696741,
								"STARTEXP.DIR", "9493238107c896d4b44b20088d3bc12e", 19114, 404),
	WINGAME2_l("explorers", "", "XPLRNW.EXE",	"907c28b272eb40fad1b5f42ec841b010", 696741,
								"STARTEXP.DIR", "3c3ab943769c548856d7cd84a8f808ec", 11198, Common::PT_BRA, 404),

	WINDEMO1("famalbum", "Tour", "TOUR.EXE", "fbc562a9945b17d9a353ccebddd2ff67", 1962659, 404),

	WINDEMO1("famdoc4", "1995 Demo", "BUBBA.EXE", "40e115073d00b7b763ff63b49e0ff798", 9322307, 404),
	WINDEMO1("famdoc4", "1996 Demo", "FAMDOC4.EXE", "cd004ff93ca55c4a5f04e4ec20db5d80", 13804287, 404),

	MACDEMO1_l("fantazion", "Demo", "Demo-16M", "77f4098988d5386794d1530065f514cd", 303309, Common::JA_JPN, 400),

	WINGAME1("fct", "",		  "FELIX.EXE",	  "6475efb8f19537e6753ba898daaf8c8d", 694477, 400),
	WINGAME1("fctplayer", "", "PLAYER.EXE",	  "194c9d45a603a1a131c39ac43b54d8aa", 834551, 404),
	WINGAME1("fctexport", "", "TRANSFMR.EXE", "ca58379b982a714d975358421fe4be50", 1542693, 400),

	WINGAME1("flw", "", "FLW.EXE", "7d02787f74f2adfc0c66f34646380c0e", 720683, 400),

	MACGAME1_l("ffa", "", "FFA-8M", "411051c134236a9ead0d0d1837aafb5e", 290682, Common::JA_JPN, 402),
	PIPGAME1_l("ffa", "", "FFA", "2618a85198d0180e3eae9162f81aafed", 60921, Common::JA_JPN, 404),

	//Fred en de Flessenfiets (Demo)
	WINDEMO1_l("flaschenfahrrad", "Demo", "FREDDEMO.EXE", "f5fa2d95970e8eb85761e95d755883d2", 812075, Common::NL_NLD, 400),

	// Willy, der Zauberfisch : ein Meer voll Überraschungen!
	// Originally published by Tivola, Hamburg (1997)
	// De vis die kon wensen localized by Bombilla, Amsterdam
	MACGAME1_l("fishwish", "", "Willy, der Zauberfisch", "ab2bda961c62f9deb2c1ba297d0a1ea9", 501815, Common::DE_DEU, 404),
	WINGAME1_l("fishwish", "", "WENSVIS.EXE", "50004a80942bafec52bbde5c09674bf9", 696993, Common::NL_NLD, 404),

	MACGAME1("fpbaxter", "", "bigplayer", "07710cabdfcf6d9fba4205dce062399c", 642443, 404),
	WINGAME2("fpbaxter", "", "START.EXE",  "560c84484a76412254325caa953deeae", 698957,
							 "STARTW.DIR", "515c16244e84c2e2c2ef8a4e84c59e43", 29216, 404),

	MACDEMO1("fppirates", "Preview v1.0", "Pirates Preview (Power Mac)", "ccf864a8dc6e9d0d26eb73b4683e634b", 63532, 404),

	// Collection of demos for the Puddle Books series
	MACGAME1("fppuddlebooks", "", "Puddle Books Demo", "07710cabdfcf6d9fba4205dce062399c", 644707, 404),
	WINGAME2("fppuddlebooks", "", "START.EXE", "c988e54a65cc107345f113a601bc47f7", 696731,
								  "START.DIR", "d66ca8450f52c8632e9c24e193c47bec", 9030, 404),

	MACGAME1("fpyolanda", "", "bigplayer", "07710cabdfcf6d9fba4205dce062399c", 642443, 404),
	WINGAME2("fpyolanda", "", "START.EXE", "560c84484a76412254325caa953deeae", 698957,
							  "YP1.DIR",   "86dca2337cbbd2612fc92bd5d0805d85", 4509574, 404),

	// Portuguese version is from cover disc of Revista Big Max #10
	MACDEMO1("frankenstein", "Demo", "Frankenstein (PowerMac)", "db9f5fce2025aa6c1f8755af849fd49b", 61234, 400),
	WINDEMO1("frankenstein", "Demo", "FRNKDEMO.EXE", "ed00aa67138b715a8bee6f41756852c5", 7365699, 400),
	MACGAME1("frankenstein", "",   	 "Frankenstein", "01be45e7241194dad07938e7059b88e3", 483771, 403),
	WINGAME1("frankenstein", "",   	 "FRANKIE.EXE",	 "a9a4e3a07f3ecda7e59215aabb844532", 2229509, 404),
	WINGAME1_l("frankenstein", "", 	 "FRANKIE.EXE",	 "98beeaa18c58708b0ce82de320e3bdf7", 2196911, Common::DE_DEU, 404),
	WINGAME1_l("frankenstein", "", 	 "FRANKIE.EXE",	 "1e4e424f5c6c78f68080e973fc4493a0", 2386679, Common::PT_BRA, 404),

	MACDEMO1("frankrw", "Demo", "Franklin's Reading World Demo", "b66a5580d7b10e365241932e941b1dda", 483746, 404),
	WINDEMO2("frankrw", "Demo", "TITLE.EXE", "37a5db8af81ed3ab09e96ff0eaf95ee1", 696855,
								"TITLE.DXR", "69ce66337b1781a654131ef854231996", 2371220, 404),

	MACGAME1("freakshow", "D4", "FreakShow Projector", "dc5a87dda7a0daf46604515f7d2cca66", 300644, 400),
	WINGAME1("freakshow", "", "FREAKS.EXE", "b2e1c5abc0e3c31ddd2089a55a27a0a5", 695893, 400),

	MACDEMO1("fsky", "Demo", "A Field Trip to the Sky", "a1bb13f9e6b70ec5a5ed1ad350b5fecc", 498505, 400),

	// Original filename is ・ふたりの料理物語
	MACDEMO1_l("futarinoryori", "Demo", "A Tale of Two Chefs", "22815cf659b911c4e07d0015cac5d98f", 301937, Common::JA_JPN, 400),

	WINGAME1_l("fuzzyfloppybee", "", "APEDORO.EXE", "317dfcb883a6dd59129606adcd3ffdcb", 696827, Common::IT_ITA, 404),

	MACGAME2_l("gate1", "", "THE_GATE",		"8ea9e9a699c61edddffd79ddd0c994d7", 290654,
							"start.Dxr",	"f4f0efc5c519b3ebd63c6d3f8e343967", 5622, Common::JA_JPN, 402),
	MACGAME2_l("gate2", "", "THE_GATE",		"8ea9e9a699c61edddffd79ddd0c994d7", 290654,
							"start.Dxr",	"27456dc17d056a822d5c8a3c046dc0d2", 5618, Common::JA_JPN, 402),
	MACGAME2_l("gate3", "", "THE_GATE",		"33f733b2809b94c3301096902f642b6e", 290654,
							"start.Dxr",	"662bb0fe055817639198f4b9851496de", 5636, Common::JA_JPN, 402),
	WINGAME1_l("gate1", "", "THE_GATE.EXE", "dd0bb1a07ad5b5d4489ac8f54e6ada2e", 712014, Common::JA_JPN, 402),
	WINGAME1_l("gate2", "", "THE_GATE.EXE", "0818b5c0ced885b5ebcef1bfd9523405", 711962, Common::JA_JPN, 402),
	WINGAME1_l("gate3", "", "THE_GATE.EXE", "48f4e49459ad83330521457642875406", 712003, Common::JA_JPN, 402),

	// Original German Mac filename is Mäusejagd
	// Original multilingual Mac filename is Gröna Musikmössen
	// International release plays in English, Danish, Finnish, Swedish, Norwegian
	MACGAME1("ggmd", "", "Grona Musikmossen",			"8c50fe295dd0e2e523d430e8d6fba448", 483791, 404),
	MACGAME1_l("ggmd", "", "Mausejagd",		 			"ea646eccc9a53f44ce082459d4809a06", 483746, Common::DE_DEU, 404),
	MACGAME1_l("ggmd", "", "Help! Muizen in 't hotel!", "e6833f1ce3b022f0128e4c80a55bcd46", 285538, Common::NL_NLD, 404),
	WINGAME1("ggmd", "",   "KMDGM.EXE",		 			"c45bac8f730cae2e2a174dbc14deff7b", 690021, 404),
	WINGAME1_l("ggmd", "", "MAUSJAGD.EXE",	 			"04d63d66464bce6356f9d70d83487838", 1302352, Common::DE_DEU, 404),
	WINGAME1_l("ggmd", "", "MUIZEN.EXE",	 			"97f8977dae92d12cc8f9c7deff5e8f8d", 1483435, Common::NL_NLD, 404),
	MACGAME1("ggmdmaze", "", "Mouse Maze",	 			"17efee018a660458fae80de4364021ac", 482866, 404),
	WINGAME1("ggmdmaze", "", "MOUSMAZE.EXE", 			"c306a1b1065c2ffe0ce2bfc0d58c52b4", 1690622, 404),
	MACGAME1_l("ggmdpics", "", "Gallery",	 			"ea646eccc9a53f44ce082459d4809a06", 483746, Common::DE_DEU, 404),
	MACGAME1_l("ggmdpics", "", "Galerij",	 			"ea646eccc9a53f44ce082459d4809a06", 483774, Common::NL_NLD, 404),
	WINGAME1_l("ggmdpics", "", "GALLERY.EXE",			"c476512cadbbcffc6af5cfee8670f8f7", 5099674, Common::DE_DEU, 404),
	WINGAME1_l("ggmdpics", "", "GALERIJ.EXE",			"c476512cadbbcffc6af5cfee8670f8f7", 5099674, Common::NL_NLD, 404),
	MACGAME1("ggmdsuper", "", "SuperGame",	 			"17efee018a660458fae80de4364021ac", 482866, 404),
	MACGAME1_l("ggmdsuper", "", "Super Spel",	 		"17efee018a660458fae80de4364021ac", 482866, Common::NL_NLD, 404),
	WINGAME1("ggmdsuper", "", "SUPRGAME.EXE",			"5da9f151d28659d83cb381ceca7493f1", 740518, 404),
	WINGAME1_l("ggmdsuper", "", "SUPER.EXE",			"5da9f151d28659d83cb381ceca7493f1", 740518, Common::NL_NLD, 404),

	MACGAME1("gigglecity", "",	   "Infinity City",		 "e6833f1ce3b022f0128e4c80a55bcd46", 285538, 404),
	WINGAME1("gigglecity", "",	   "INFINITY.EXE",		 "07b919509db761c7910f5677216b588d", 3228770, 404),
	MACDEMO1("gigglecity", "Demo", "Infinity City Demo", "2d1fb07ef7ec0f4dad1a279989fa8f57", 304124, 404),
	WINDEMO1("gigglecity", "Demo", "ICDEMO.EXE",		 "f8eb3a346a02193cec8bc14497b73a8f", 802018, 404),

	// Demo is found on Pantsylvania CD
	MACGAME1("gigglefarm", "",	   "AlphaBonk Farm PowerMac", "bcd3c718db258701496b3c5bcb827ef2", 502333, 404),
	MACDEMO1("gigglefarm", "Demo", "AlphaBonk Farm Demo",	  "bcd3c718db258701496b3c5bcb827ef2", 502333, 404),
	WINGAME1("gigglefarm", "",	   "ALPHBNK.EXE", "9720ed078d3318e7dc51f1480e1280f0", 740982, 404),
	WINDEMO1("gigglefarm", "Demo", "ABFDEMO.EXE", "6ccff5b1e2541065b66ce6b33b2ade9f", 8517847, 404),

	MACGAME1("gigglevania", "", "Pantsylvania", "d9082ba24e164f376ffb3090c43fa997", 304149, 404),
	WINGAME1("gigglevania", "", "PANTS.EXE",	"1b10e3c6f6a47971802fe835642130ce", 697317, 404),

	MACGAME1("godigital", "Vol.1 No.1",	"Go Digital vol.1 no.1", "dc5a87dda7a0daf46604515f7d2cca66", 291322, 403),
	MACGAME1("godigital", "Vol.1 No.2", "Go Digital vol 1 # 2",  "97474208c44c78f26bef8b2011d341aa", 482838, 404),
	MACGAME1("godigital", "Vol.2 No.1", "GoDigital3",			 "e6833f1ce3b022f0128e4c80a55bcd46", 284630, 404),
	WINGAME1("godigital", "Vol.1 No.1",	"GODIGIT.EXE", "8183e02291e69b19c9b1b149a8036ffd", 34247559, 404),
	WINGAME1("godigital", "Vol.1 No.2", "GODIGIT.EXE", "7ce7407982b9c3abfab010432a0b9b96", 703515, 404),
	WINGAME1("godigital", "Vol.2 No.1", "GODIG3.EXE",  "601b468f1e0e22319b7abd5c0d1787e7", 889427, 404),

	MACDEMO1("goldilocks", "Sampler", "Goldilocks Gamebook Sampler", "cbce20666bfe47a9533331c6be1e6039", 285523, 403),
	WINDEMO1("goldilocks", "Sampler", "GOLDILKS.EXE", "46b6ed6299db88ac1eab54aab4be91d7", 1894363, 403),

	WINGAME1("gordak", "", "GordakCD.exe", "d3dcd15712e8ac16cb88d86af9cd64bf", 737262, 404),

	MACDEMO2_l("greetingstudio", "Demo", "Click Me",   "17efee018a660458fae80de4364021ac", 484351,
								 		 "MAIN.DIR",   "f5f8e6c76bb0659fc80fa2c1c263afa9", 3016176, Common::JA_JPN, 404),
	WINDEMO1_l("greetingstudio", "Demo", "SHOWME.EXE", "711b37028bca19093720fcb281c08b4d", 754977, Common::JA_JPN, 404),

	MACDEMO1("grolier", "Catalog", "Grolier Products", "f5033f237ad1b1639fc46d01a82ac380", 283274, 404),

	MACGAME1_l("guignols1", "", "LE JEU ! 12Mo", "e07d16e7d0986ef7acf3a5e302ed905e", 484331, Common::FR_FRA, 404),
	WINGAME1_l("guignols1", "", "ELM.EXE", "b04c8494176cbc3b2080bf1630ae1748", 697216, Common::FR_FRA, 404),

	MACDEMO1("gundam0079", "Demo", "Gundam Demo", "01be45e7241194dad07938e7059b88e3", 483376, 400), // full game is D5

	MACGAME1("guns", "", "Multimedia Guns", "01be45e7241194dad07938e7059b88e3", 486927, 404),
	WINGAME1("guns", "", "GUNS.EXE", "43342caa10c6dc46f983787da1b625b7", 1636235, 404),

	MACGAME1("gusbuds", "",		"MMV Product Demos for PowerMac", "692f6732b6d7deaa00c9b3df57bb30ce", 60324, 404),
	MACDEMO1("guscarn", "Demo", "Carnival Demo 4 you",			  "67f572196550aedb1f9523d782022be0", 481482, 404),
	MACDEMO1("gusolis", "Demo", "Cyberopolis DEMO",				  "77f4098988d5386794d1530065f514cd", 304217, 400),
	MACGAME1("guspark", "",		"Gus goes to CyberStone Park",	  "ccfbfc1a0ac231db40a250babaa6ad7c", 285538, 404),
	MACDEMO1("gustown", "Demo", "Gus Goes To CyberTown DEMO",	  "77f4098988d5386794d1530065f514cd", 304217, 400),
	//Guus in Cyberstad (demo)
	WINDEMO1_l("gustown", "Demo", "GUUS.EXE",	  "775eb4d8a78916b10e7531eebc758dd2", 8319869, Common::NL_NLD, 404),
	WINGAME1("gusbuds", "",		"MMVDEMOS.EXE", "71d4ad9e9dc92a81561476d4d9813492", 692037, 404),
	WINGAME1("guspark", "",		"CYBSTONE.EXE", "ac22c7568c90ab4af7396148521f446e", 707439, 400),
	WINGAME1_l("guspark", "",	"CYBSTONE.EXE", "dc0be57ab8e9f9b54de24ac41b1b4854", 703913, Common::PT_BRA, 404),

	// Disc 1 is called Haight, Disc 2 is called Ashbury. You can start either one.
	// Mac partition contains three mini-games that can be launched directly from Finder
	// Original Mac game filenames are Tune ◊ In, Turn ◊ On, Drop ◊ Out
	// Demos are found on CD-ROM La Revista Nº6 (Spain) from Zinco Multimedia
	MACGAME1("haight", "Haight",   "Haight-Ashbury in the Sixties", "c9c25d0d249d529680302a81c30852d0", 493066, 404),
	MACDEMO1("haight", "Demo",     "Haight-Ashbury Short",          "c9c25d0d249d529680302a81c30852d0", 539498, 404),
	MACGAME1("haight", "Tune In",  "Tune In",                       "c9c25d0d249d529680302a81c30852d0", 493066, 404),
	MACGAME1("haight", "Turn On",  "Turn On",                       "c9c25d0d249d529680302a81c30852d0", 493066, 404),
	MACGAME1("haight", "Drop Out", "Drop Out",                      "c9c25d0d249d529680302a81c30852d0", 539498, 404),
	WINGAME1("haight", "Haight",   "HAIGHT.EXE",                    "f309096bd3eb9f45283d7218bb8f1c88", 821499, 404),
	WINDEMO1("haight", "Demo",     "HAROCK.EXE",                    "cd0ffd0e7612cd60aadaf42a7b4f480c", 821041, 404),

	// Different releases of hamsterland1 allow choice of language on the opening screen
	// English is always available, along with one alternate language
	// Dutch version was localized by Pride Kids Interactive of Ede, Netherlands
	MACGAME2_l("hamsterland1", "", "Hamsterland", "bcd3c718db258701496b3c5bcb827ef2", 483774,
								   "AIRDK",		  "f74f18a9d454db63465dac151a6b5706", 8425728, Common::DA_DAN, 400),
	MACGAME2_l("hamsterland1", "", "Hamsterland", "bcd3c718db258701496b3c5bcb827ef2", 483774,
								   "AIRSW",		  "ccf7c642796c5aeb9fee4c663bdd02d9", 7588992, Common::SE_SWE, 400),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "2bb6e93d9aab502f46dbf163d51eb785", 785327,
								   "AIRDK",		  "ad98bbbd724e31a8a125e284a74d0241", 8425546, Common::DA_DAN, 400),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "a0d2cfdf10ec14c00338329277bc8acc", 727653,
								   "AIRSP",		  "9b5b82d488b96b2fcf5e78ec8769e29a", 8432260, Common::ES_ESP, 400),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "11669580c1f85b8caa4cd02373e7c947", 785221,
								   "AIRNL",		  "369dbec85b84239ea1ee10d647723243", 8426154, Common::NL_NLD, 404),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "2bb6e93d9aab502f46dbf163d51eb785", 785327,
								   "AIRSW",		  "410efb55564b8eb2042eea61d0f8025b", 7588828, Common::SE_SWE, 400),

	// Original Mac filename is La Máquina del Tiempo
	MACGAME1_l("hamsterland2", "", "La Maquina del Tiempo", "2c7d0c0d55cbe3f622c7d68cedb671e0", 483774, Common::ES_ESP, 400),
	WINGAME1_l("hamsterland2", "", "HL2SP.EXE", "8dd22b8bde300c9fb5b66808905300f7", 875665, Common::ES_ESP, 400),
	MACGAME1("hamsterland2", "", "The Time Machine", "2c7d0c0d55cbe3f622c7d68cedb671e0", 483774, 400),
	WINGAME1("hamsterland2", "", "HL2EN.EXE", "4c812a63165c1f50242e879aae62718d", 859681, 400),

	// Sampler is found on AlphaBonk Farm and probably elsewhere
	MACGAME1("headbone", "Sampler", "Headbone CD-ROM Sampler", "5bbb193a8785c70abe2a4d86b99e1536", 304126, 404),
	WINGAME2("headbone", "Sampler", "SAMPLER.EXE",  "b083372f35bfaa97f68cfa7f9bb5222e", 2132572,
									"DemoMain.dxr", "d16606eadccdb21f654f4b4264fc996a", 2711628, 404),

	WINGAME1("hhouse", "",			"HHOUSE.EXE",  "e798a08ba6057705af028673f7a9a2ef", 3181345, 400),
	WINDEMO1("hhouse", "1995 Demo", "HAUNTED.EXE", "5b7e970d8b8dec473e31cc6815c03bf6", 1166813, 404),

	// Found on Uki Uki 3 CD
	// Original movie filename is デモ
	MACDEMO2_l("himejijo", "Demo", "Macromedia Player", "de889febf08007ca7ac501a952cfba6f", 457275,
								   "Demo",				"88c318f3e821b4a76f8ff67bb97c002f", 6736268, Common::JA_JPN, 400),

	WINGAME1("hkbigfun", "", "KITTY.EXE", "42e600e8a917de593f4048428ec8d8b8", 703689, 404),

	MACGAME1("horobroy", "", "Rob Roy", "01be45e7241194dad07938e7059b88e3", 483382, 404),
	WINGAME1("horobroy", "", "ROBROY.EXE", "65d06b5fef155a2473434571aff5bc29", 2047746, 400),

	MACGAME1("horrortour1", "",	  "ZEDDAS(7M)", "da0da5d543b237051975ad70bec129f4", 483443, 404),
	WINGAME1("horrortour1", "",	  "ZEDDAS.EXE", "d3ce91f305dd0f4d2f5e9ff6d4e41a3b", 741818, 404),
	WINGAME2_l("horrortour1", "", "HORROR.EXE", "b16ecf8ebc02142c742b8a9acc935d52", 752425,
								  "HORROR.DAT", "42f0450d970a95f0dd47727988996ce9", 450, Common::ZH_TWN, 404),

	MACGAME1_l("horrortour1", "", "HorrorTour(7M)", "b7e69c37b7355022d400c14aa97c5d54", 483443, Common::JA_JPN, 404),
	WINGAME1_l("horrortour1", "", "HORROR.EXE", "b16ecf8ebc02142c742b8a9acc935d52", 752425, Common::JA_JPN, 404),
	MACGAME1_l("horrortour2", "", "ZEDDAS PowerPC", "da7d3f1d85bdb99518b586c40d2a673e", 60013, Common::JA_JPN, 400),
	WINGAME1_l("horrortour2", "", "HT2.EXE", "499d8545ee2325b18d3f09fb2c0fc26e", 698029, Common::JA_JPN, 400),

	WINDEMO1("hyperblade", "Demo", "HYPER.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400), // full game is not Director

	WINGAME1("id4p1", "iD4 Mission Disk 1 - Alien Supreme Commander", "SUPREME.EXE", "629eb9a5d991a2dbe380804e8c37043a", 1664965, 400),
	WINGAME1("id4p2", "iD4 Mission Disk 2 - Alien Science Officer", "SCIENCE.EXE", "812a4b81b70e61e547c14dbbd507b402", 1766499, 400),
	WINGAME1("id4p3", "iD4 Mission Disk 3 - Warrior Alien", "WARRIOR.EXE", "387245092ce0583c6fd0c54000b1502a", 1751593, 400),
	WINGAME1("id4p4", "iD4 Mission Disk 4 - Alien Navigator", "NAV.EXE", "29de2d1fd34029b3c97ce852a7fc665e", 1834037, 400),
	WINGAME1("id4p5", "iD4 Mission Disk 5 - Captain Steve Hiller", "STEVE.EXE", "14f19b724dd6361e4bf3cfddbac87d3f", 1797301, 400),
	WINGAME1("id4p6", "iD4 Mission Disk 6 - Dave's Computer", "DAVE.EXE", "237f9db2ea9a38fa6f7292974539f494", 1774167, 400),
	WINGAME1("id4p7", "iD4 Mission Disk 7 - President Whitmore", "PREZ.EXE", "e7d03a6d749d65dbcea7171ec4627e9c", 1666293, 400),
	WINGAME1("id4p8", "iD4 Mission Disk 8 - Alien Attack Fighter", "ALIEN_F.EXE", "ee2eb92900d515ed7872c57f3b89a408", 1754975, 400),
	WINGAME1("id4p9", "iD4 Mission Disk 9 - FA-18 Fighter Jet", "F18.EXE", "7a0292909a5103c89297c40cce1d836c", 1691893, 400),
	WINGAME1("id4p10", "iD4 Mission Disk 10 - Alien Bomber", "BOMBER.EXE", "17758a9f425f7f3e7a926951e6c770f4", 1844189, 400),
	WINGAME1("id4p11", "iD4 Mission Disk 11 - Area 51", "AREA51.EXE", "78be40f9c7e8e1770c388cc16a522aaf", 1776077, 400),

	MACDEMO1("imagineers", "Portfolio", "The Imagineers Demo", "f00c61f30719f8ed5f64ddff2e3c7268", 482302, 404),

	WINGAME1("imaginopolis", "1995 Demo", "MSKIDS.EXE", "f99d634a7880364990da8564010b95e2", 3394725, 400),

	MACGAME1("imesceneryfish", "ECD", "Scenery and Fish", "e60d4b832a771b0064a703938f82dfb3", 2804, 404),
	WINGAME2("imesceneryfish", "ECD", "runme.exe",		  "47b17c219097afb877fd9bc15455e4d4", 738415,
									  "main.dir",		  "0b20d6b771b4f5fd50e823c3773aecdd", 3526788, 404),

	// Play as either Shirley (disc 1) or Dolan (disc 2)
	MACGAME2("improv", "Shirley", "IMPROV (PowerPC)", "096e0aacbc1670c80a354c3c49b3fabe", 60324,
								  "INTRO.DIR",		  "62695e977e1a29647e630f70349a3690", 2926976, 400),
	MACGAME2("improv", "Dolan",   "IMPROV (PowerPC)", "096e0aacbc1670c80a354c3c49b3fabe", 60324,
								  "INTRO.DIR",		  "dd667e45e402729581c70f278140f3a5", 3400832, 400),
	WINGAME2("improv", "Shirley", "IMPROV.EXE",	   	  "097276acd3caee9bc79b85af79278643", 730079,
								  "INTRO.DIR",		  "37f2d3c0b6f805e7a0f3a3ea62f8297c", 44532, 400),
	WINGAME2("improv", "Dolan",   "IMPROV.EXE",	   	  "097276acd3caee9bc79b85af79278643", 730079,
								  "INTRO.DIR",		  "075c3c7bd7c059280ca86c6b906bf97b", 46366, 400),

	// Non-interactive preview of Dark Eye and Smart Patrol from the Bad Day CD
	WINGAME1("incoming", "Preview", "INCOMING.EXE", "7c40db466105d08a53bb41023abdaa6a", 743550, 404),

	MACGAME1("insidemacgames", "Volume 1", "IMG CD-ROM", "2e2becf3549673a8107c0d2028a08fc1", 353787, 400),

	// Also launches three other projectors on disc, including some D3 and D5
	MACGAME1("interactivemagic", "", "Mac Interactive Magic", "337c94c66b435e075a2d7f94b3cffc49", 483746, 404),

	// Original filename is チュートリアル
	MACDEMO1_l("inposition", "Tutorial", "Tutorial", "77f4098988d5386794d1530065f514cd", 305533, Common::JA_JPN, 400),

	// Original Mac filename is Grandes Inventos™
	MACGAME1_l("inventos", "", "Grandes Inventos", "bcd3c718db258701496b3c5bcb827ef2", 483774, Common::ES_ESP, 404),
	WINGAME1_l("inventos", "", "INVENTOS.EXE", "667c71ae2c24cae2e7e4e82b52d5a7bc", 750295, Common::ES_ESP, 404),

	// Demos and product catalog from Iona Software, Ltd.
	MACDEMO1("iona", "'96", "IONA DEMO", "547fefcd6bda748214be2068a7bcdead", 292216, 404),
	WINDEMO2("iona", "'96", "DEMO.EXE", "95a3aeb1017546da820a8d3c95d3c4e4", 1946711,
							"MAIN.DIR", "71eacbde48a94043390d7dab58b8bb52", 1812168, 404),

	WINGAME1_l("ios", "",	 "IOS.EXE", "2b8edd5af0f79d84542c57754b7fbf61", 1004833, Common::JA_JPN, 404),
	WINGAME1_l("ioshow", "", "HOW.EXE", "a526a724f26e266b17815b4f7f7ae079", 1863309, Common::JA_JPN, 404),

	MACGAME1("isis", "", "ISIS", "dedfabf9ee7bf5aab003bdab4137bca6", 777886, 400),
	WINGAME1("isis", "", "ISIS.EXE", "59c1cb960199dd3f041262ab5271bb23", 14747213, 400),
	MACGAME1_l("isis", "", "ISIS", "dedfabf9ee7bf5aab003bdab4137bca6", 780610, Common::DE_DEU, 400),
	WINGAME1_l("isis", "", "ISIS.EXE", "d7f7e89495ac22c75b3fc04c09675b6e", 16750643, Common::DE_DEU, 400),

	MACGAME1("iwave", "Issue 1", "!", "ae7178ba5dd9dcd15fb7a27cd99089b2", 484389, 400),
	WINGAME1("iwave", "Issue 1", "IWAVE.EXE", "67aa1f75dc23e071e5325be04e9738a6", 690955, 400),

	// Note: There are four versions of the binary included on the disc.
	// French version was distributed by Ubi Soft
	// English versions 2.00 and 2.0.1 were distibuted by Discis and DreamCatcher, respectively
	// Horses of Asva demo is found on Czech Super Hry III CD from Future Media International
	MACGAME2("jewels1", "v2.00",         "Jewels 11 Meg",   "339c89a148c4ff2c5c815c62ac006325", 483922,
										 "NAVLOAD.Dxr",     "862688a820a7494f8a9edd196e04b5bf", 420, 404),
	MACGAME2_l("jewels1", "",		     "Jewels 11 Meg",   "339c89a148c4ff2c5c815c62ac006325", 483922,
										 "NAVLOAD.Dxr",     "711211bf062c3cab48ce90870900bc3b", 471, Common::FR_FRA, 404),
	MACDEMO1("jewels1", "Demo",		     "Two-Minute Demo", "01be45e7241194dad07938e7059b88e3", 483746, 404),
	WINGAME2("jewels1", "v2.0.1",        "JEWELS.EXE",      "bb6d81471d166088260090472c6c3a87", 800395,
										 "NAVLOAD.DXR",     "ff8446121236a1cbfb1fe431fea5bc09", 405042, 404),
	WINDEMO1("jewels1", "Horses Demo",   "HORSE.EXE",		"03bbe56c80fcbca3939ba08407d99f76", 847689, 400),
	WINDEMO2("jewels1", "Demo",		     "JEWELS.EXE",      "abcc448c035e88d4edb4a29034fd1e34", 869983,
										 "PUZZ_01.DXR",     "ea75491b1be5352de158c310fcf7baf5", 267074, 400),
	WINDEMO2("jewels1", "Nightsky Demo", "DEMO.EXE",        "ebee52d3c4280674c600177df5b09da0", 800403,
										 "NAVLOAD.DXR",     "1f4466ba91364dd7223264b86dd5402c", 403980, 404),
	WINDEMO2_l("jewels1", "Demo",        "DEMO.EXE",		"ebee52d3c4280674c600177df5b09da0", 800403,
										 "NAVLOAD.DXR",     "1f4466ba91364dd7223264b86dd5402c", 403980, Common::FR_FRA, 404),

	// Original filename is JMP Turbo™
	MACGAME1("jman", "Turbo!", "JMP Turbo", "cc3321069072b90f091f220bba16e4d4", -1, 400),
	MACGAME1("jman", "Making Of", "The Journey", "cc3321069072b90f091f220bba16e4d4", -1, 400),
	MACDEMO1("jman", "Director's Cut Demo", "Journeyman - Director's Cut", "01be45e7241194dad07938e7059b88e3", 484284, 400),

	// Original filename is Buried in Time™ PowerPC; also contains 68k binary
	MACGAME1("jman2", "", "Buried in Time PowerPC", "71287376e445ab9c98f0d150bb0ed175", 80334, 400),
	MACGAME1_l("jman2", "", "Buried in Time PowerPC", "71287376e445ab9c98f0d150bb0ed175", 86324, Common::DE_DEU, 400),
	MACDEMO1("jman2", "Demo", "Buried in Time Demo", "1ae45c23586b41997ba52e2e7c771c4c", 437743, 400),
	MACDEMO1("jman2", "06/22/94 Demo", "Buried in Time Demo", "cdb27c916044ae4dceb4b7326063fa03", 328895, 400),
	MACDEMO1("jman2", "Final Demo", "Buried in Time Demo", "cc3321069072b90f091f220bba16e4d4", 292731, 400),
	MACDEMO1("jman2", "Gallery", "BIT Gallery", "01be45e7241194dad07938e7059b88e3", 484284, 400),
	MACDEMO1("jman2", "Overview", "BIT Overview", "01be45e7241194dad07938e7059b88e3", 484284, 400),

	MACGAME1("jmmd", "", "Just Me & My Dad", "ea646eccc9a53f44ce082459d4809a06", 486966, 400),

	// Bilingual English & Spanish
	MACGAME1("journey2life", "", "The Journey to Life", "bcd3c718db258701496b3c5bcb827ef2", 483774, 404),
	WINGAME1("journey2life", "", "LIFE.EXE", "b23041f4f5cce3d15ef985bbd513030a", 756297, 404),

	// Original Taiwan release is called 塔克拉玛干—敦煌传奇 (Taklamakan: Dunhuang Chuanqi)
	MACGAME1("karma", "", "Karma", "ea646eccc9a53f44ce082459d4809a06", 485535, 400),
	WINGAME1("karma", "", "KARMA.EXE", "e830af6b5dfca4964184e7d61039e120", 697047, 400),
	WINGAME1_l("karma", "", "DH.EXE", "f917ac9c649bff9eaf538ae69432a145", 690991, Common::ZH_TWN, 400),

	// Original Mac filename is かるた
	MACDEMO1_l("karuta", "Demo", "Karuta",		 "78138a77207907642744d0960c14d9e5", 484567, Common::JA_JPN, 404),
	WINDEMO2_l("karuta", "Demo", "S.EXE",		 "aa3900a47af9c2b5f066fbbff43dd1f3", 746989,
								 "OPENING4.DIR", "89beafaa3b41f1c533d13fb378d5eebf", 3995204, Common::JA_JPN, 404),

	MACDEMO1_l("kenji", "Demo", "KENJI", "4577dd3eadc467a986ab172d90871b22", 502033, Common::JA_JPN, 404),

	WINGAME1("kfk", "", "KFK.EXE", "75a9f8838cd654701afdd50e68cf5736", 2696447, 404),

	WINGAME1("kidtools", "", "DEMO.EXE", "da65c64d0821c0d689f8a3ead9301a2a", 15606953, 400),

	// Original Mac filename is Kinder-Kit™
	MACGAME1_l("kinderkit", "", "Kinder-Kit", "bcd3c718db258701496b3c5bcb827ef2", 483774, Common::PT_BRA, 404),
	WINGAME1_l("kinderkit", "", "KKIT.EXE", "a24a52bdb12d61eae64b9088b25ea03b", 862425, Common::PT_BRA, 404),

	MACGAME1("kyoto", "v2.0", "Cosmology of KYOTO", "8719de9c083aca942fc0e5c0a127b6dc", 484370, 400),
	WINGAME1("kyoto", "", "PLAY_E.EXE", "84cc8880f8c46b4da121b4c9f184418a", 691269, 400),
	MACGAME1_l("kyoto", "v2.0", "Cosmology of KYOTO", "8719de9c083aca942fc0e5c0a127b6dc", 484445, Common::JA_JPN, 400),
	WINGAME2_l("kyoto", "", "PLAY.EXE", 	"865b1b59e32e51a6670b9105ac8501ec", 741137,
							"OPENING1.DXR", "b96015c8c138c6626b10fffaed28efea", 679328, Common::JA_JPN, 400),

	MACGAME1("laughingbird", "", "The Laughing Bird Restaurant", "547553eca48ebc089e893ba1905c2b74", 673138, 404),

	WINGAME1_l("leonardo", "", "LEO.EXE", "0be0b03b89bb4aba716a974c3ccc3950", 692347, Common::PT_BRA, 404),

	WINDEMO1("letters", "Demo", "LETTERS.EXE", "ed0636bab94b299d96552e4c71bc82a1", 3875399, 404),

	// full game is DOS only, not Director
	MACDEMO1("lion", "Demo", "Lion Demo", "01be45e7241194dad07938e7059b88e3", 484284, 400),

	WINGAME1_l("lobomau", "", "LOBO.EXE", "162d4d1aaf42b6e8d7dfc520e5de2bed", 201828999, Common::PT_BRA, 400),

	MACGAME1("louiscatorze", "", "Louis Catorze", "2c7d0c0d55cbe3f622c7d68cedb671e0", 486954, 400),
	WINGAME1("louiscatorze", "", "LOUIS.EXE", "21610856ba0f75598624edd58291600b", 719433, 400),

	MACGAME1("louvre", "", "Louvre 5 Mo", "a685f1809706f42bff5f3ee94f606065", 483774, 404),
	WINGAME1("louvre", "", "LOUVRE.EXE", "f575ed4b37c05ab4249f9d6d3c3d7e17", 698829, 404),

	// Win/Mac versions are D3
	PIPGAME1_l("lzone", "", "L-ZONE", "07c3095bd36e5aed00ba12f17f761070", 60352, Common::JA_JPN, 400),

	MACDEMO1("macos8", "Tour", "Mac OS 8 Tour", "2332900b20b0d33e0617e5e7505923e8", 776072, 404),

	// Mac filenames contain n° instead of no
	MACGAME1_l("macsca", "Numéro 12", "Version Director no12", "7093a24634992bf9d23ff31ae1dea424", 284048, Common::FR_FRA, 404),

	WINDEMO1("madpup", "Demo 1", "MAD.EXE", "c135c843d7313da01272f061d2ab64b1", 4725743, 404),
	WINDEMO1("madpup", "Demo 2", "MADPUP2.EXE", "a399589a31c26a01663c00a265ac3640", 696857, 404),
	WINDEMO1("madtg", "1996 Demo", "MADTG.EXE", "f53afbe0ae5126fa04adce4952a84b7f", 5867859, 404),

	MACGAME1("majestic", "", "Majestic", "01be45e7241194dad07938e7059b88e3", 483774, 400),
	WINGAME1("majestic", "", "MAJESTIC.EXE", "624267f70253e5327981003a6fc0aeba", 23437631, 400),

	// Original filename is Make•A•Mug™ V1.0
	MACGAME1("makeamug", "", "Make-A-Mug V1.0", "4f8bb7ad0cbcec1815538ba15a899061", 304279, 400),

	MACGAME1("makers", "", "Makers of the 20th Century", "da0da5d543b237051975ad70bec129f4", 482866, 404),
	WINGAME1("makers", "", "MAKERS.EXE", "d879d7b40dd9f2eb59a2fbae5bc62306", 690883, 404),

	MACDEMO1_l("manhole", "Masterpiece Edition Demo", "The Manhole DEMO", "583a2d78dfcc184f2fbabfd3187322c1", 301861, Common::JA_JPN, 400),

	MACGAME1("mastermansion", "", "Masterpiece Mansion", "bdd793ba61c4333dfeaf976d6adc38fe", 285533, 404),
	WINGAME1("mastermansion", "", "MANSION.EXE", "b397657fec77654afc589000612de963", 84700821, 404),
	WINDEMO1("mastermansion", "Demo", "MANSION.EXE", "be88c599759d0c8d6bdc1d2719ca769a", 17866669, 404),
	MACGAME1("mastermansionex", "", "Art Explorer", "9e9696433d18629b88714089034c086b", 285509, 404),
	WINGAME1("mastermansionex", "", "EXPLORER.EXE", "7a335c6571e359b56453edb78e6fdc53", 36685767, 404),

	MACGAME1("martian", "", "The Martian Chronicles PPC CD", "db9b7f11aea52a294d2986a94a184000", 60328, 400),
	WINGAME1("martian", "", "MC.EXE", "ee6267d276a18e8bfd6f0e4ecd07ba36", 1764151, 400),

	MACDEMO1("mathblasterjr", "Preview v1.0c", "Math Blaster Jr. Power MAC", "602e61f10c158183218405dd30a09b3f", 60324, 404),

	MACGAME1("mathtest", "", "mathtest (mac)", "cdb27c916044ae4dceb4b7326063fa03", 301925, 400),

	MACDEMO1_l("max1", "Demo", "Max en de geheime... DEMO", "a2f5930615493c2358b2ad07e731c475", 502790, Common::NL_NLD, 404),
	MACDEMO1_l("max2", "Demo", "Max en Merel... DEMO", "a2f5930615493c2358b2ad07e731c475", 502790, Common::NL_NLD, 404),
	WINDEMO1_l("max1", "Demo", "MAX1DMA.EXE", "b35d311e2982849c08379f2d74519d58", 752991, Common::NL_NLD, 404),

	// Max und das Schloßgespenst (original) published by Tivola (1996)
	// Max en het gele-sokjes-spook published by Uitgeverij Bombilla, Amsterdam (1996)
	// Max et le château hanté published by E.M.M.E., Boulogne, Paris (2001)
	// Макс и привидения из замка localized by New Media Generation (NMG), Yakimanka, Moscow (1997)
	// English and usually German are always selectable languages during gameplay
	// Original Mac German filename is Max und das Schloßgespenst
	// Original Mac French filename is Max et le château hanté
	MACGAME1_l("max3", "", "Max und das Schlossgespenst",  "dd5bb78cb7db5c8fa7b87ddf3136b337", 504078, Common::DE_DEU, 404),
	MACGAME1_l("max3", "", "Max et le chateau hante",      "504e7e5b53a02dbebd3d19bf9a9b73d9", 504078, Common::FR_FRA, 404),
	MACGAME1_l("max3", "", "Max en het gele-sokjes-spook", "a2f5930615493c2358b2ad07e731c475", 502790, Common::NL_NLD, 404),
	WINGAME1_l("max3", "", "MAX3.EXE",     "aba98fa8042bb9f87dedf00be1d19de2", 702881, Common::DE_DEU, 404),
	WINGAME1_l("max3", "", "M3_START.EXE", "99cc0c88814c402d8de01e8980582d65", 702863, Common::FR_FRA, 404),

	WINDEMO1("mcmillennium", "Demo", "MILLDEMO.EXE", "b6027f900ae90ed59de3d22e68d2bfed", 3630918, 404),

	// Full game is not Director
	WINDEMO1("mechwarrior2", "Demo", "MW2DEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	// Original file name is Meet MediaBand™
	MACGAME2("mediaband", "v1.0", "xn--Meet MediaBand-yk6h", "17efee018a660458fae80de4364021ac", 483774,
								  "title", "88e717a623bc2690d84a1246e512eaff", 2646636, 404),
	MACGAME2("mediaband", "v1.1", "xn--Meet MediaBand-yk6h", "17efee018a660458fae80de4364021ac", 483774,
								  "title", "14a64b7999d909a23df7842cec65458c", 2752392, 404),
	WINGAME1("mediaband", "v1.1", "MEDIABND.EXE", "0cfb9b4762e33ab56d656a0eb146a048", 717921, 404),

	// Projector is 4.0 Demo from Lingo Workshop
	MACDEMO1("mediabook", "Sampler", "MediaBook Sampler 16Mb", "78138a77207907642744d0960c14d9e5", 510450, 400),
	MACDEMO1("mediabook", "ToolBox Sampler", "ToolBox Sampler", "da61a96a720dbd5f987d86e9eb4b7a09", 302000, 400),

	MACGAME1("mirage", "", "Mirage", "0c7bbb4b24823e5ab871cb4c1d6f3710", 486954, 400),
	WINGAME1("mirage", "", "MIRAGE.EXE", "2291ea234c14f1ccb8f2e67ae09bbfa3", 696867, 400),
	MACGAME1("mirage", "Making Of", "The Making of Mirage", "78138a77207907642744d0960c14d9e5", 486982, 400),
	WINGAME1("mirage", "Making Of", "MAKINGOF.EXE", "2458926212e5589c013b7e7c28b9bee0", 698407, 400),

	MACGAME1("mmiqtest", "", "Multimedia IQ Test", "7fd44b6dffa0ea0402eaed4c3769b39b", 285566, 404),
	WINGAME1("mmiqtest", "", "IQTEST.EXE", "2a788332a4d3af3e5c5f9fe230e6c89f", 740528, 404),

	MACGAME1("moag", "", "MacMoag", "46697df7ffee90bf7cd4c0cec4c54c28", 494808, 404),
	WINGAME1("moag", "", "WINMOAG.EXE", "3483a0e7c65996c4edce7f8c0c3c43e3", 726173, 404),

	// Original filename is もみの木の下で.予告編
	MACDEMO1_l("mominoki", "Demo", "Mominoki no shita de.Trailer", "0666ae690e459d3d0d91800ebd94de46", 290654, Common::JA_JPN, 402),

	MACGAME1_l("moritaka", "", "WATARASE-BASHI", "c761bfe3a0865ca0f43cb5556230ed5b", 107527, Common::JA_JPN, 404),
	PIPGAME1_l("moritaka", "", "Pippin Projector", "b708dcf9cdc19e6e186000ad93e41997", 73705, Common::JA_JPN, 404),

	// Created by Fritsch & Friends MediaGroup, Babelsberg, Germany
	// Found on In´side MULTIMEDIA: Das Computermagazin mit CD-ROM 07/96 by Tronic Media World, Hesse, Germany
	WINGAME1_l("mrmore", "", "MRMORE.EXE", "8273050f0eccbd62542225bc92fc6ad3", 689995, Common::DE_DEU, 404),

	// Both versions require installation to extract executables
	MACGAME1("mrsquack", "", "Reading with Peter Cottontail", "97474208c44c78f26bef8b2011d341aa", 483708, 404),
	WINGAME1("mrsquack", "", "QUACK.EXE", "5f80de56cd9c653721b451b752189264", 763381, 404),

	// Demos from Microsoft Exposition CD
	WINDEMO1("ms500nations",   "Demo",			  "500NAT.EXE",	  "d74e6aa33e11561a38eb82dd52b91613", 2284149, 404),
	WINDEMO1("msaccess",	   "Windows 95 Demo", "ACDEMO.EXE",	  "ea5d410e9d0e3f2160d1d43364a8ae24", 1979227, 404),
	WINDEMO1("msautomap",	   "Demo",			  "MARA.EXE",	  "b7850776d9e103e4ad4c2de6b4237226", 8317329, 400),
	WINDEMO1("msbaseball",	   "1995 Demo",		  "COMPBASE.EXE", "9b46c1cb673ff60b97a5468cc9cf833c", 4602907, 404),
	WINDEMO1("msbasketball",   "1995 Demo",		  "COMPBASK.EXE", "a600b567ae40200f94b1cb5d32f7fce6", 5280287, 404),
	WINDEMO1("msbob",		   "Demo",			  "BOBDEMO.EXE",  "e975ae22434e98a910549e8a160a08a3", 3083061, 400),
	WINDEMO1("msbhumanbody",   "1995 Demo",		  "HUMAN.EXE",	  "c88694c3fe8da8b6fc86b9bd4214e568", 1153901, 404),
	WINDEMO1("msbsolarsystem", "1995 Demo",		  "SOLAR.EXE",	  "0b4ee6125ef4c2dbe32854f69e2240d0", 1176537, 404),
	WINDEMO1("msdogs",		   "Demo",			  "DOGSDEMO.EXE", "0735a8ad4b4e09b6575afbe301946260", 4490505, 404),
	WINDEMO1("msexcel",		   "Demo",			  "EXDEMO.EXE",	  "3971666400faf88a1d0b91b93122bdc8", 2514951, 404),
	WINDEMO1("msgolf",		   "1995 Demo",		  "GOLFDEMO.EXE", "3cf38257dcbd44ff89a2e0deba601428", 3687453, 404),
	WINDEMO1("msmouse",		   "1995 Demo",		  "MOUSE2OH.EXE", "fe9401c1a9bf87ca9b246cae7ddace19", 4278473, 400),
	WINDEMO1("msmouseh",	   "1995 Demo",		  "HMOUSE.EXE",	  "53f18ec3c4984be4b36b67322df662c8", 3560439, 400),
	WINDEMO1("msnatkey",	   "1995 Demo",		  "KEYBDDEM.EXE", "ab38b5fb4c2c5f8cb61a55bde3328c78", 8368681, 400),
	WINDEMO1("msoceans",	   "Demo",			  "OCNSDEMO.EXE", "1086dc080877b260479a322830652e34", 4771371, 404),

	// Earlier Win demo is text only. Multimedia demo created by The HyperMedia Group of Emeryville, CA
	MACDEMO1("msoffice", "v4.2 Demo", "Microsoft Office 4.2 Complete", "22815cf659b911c4e07d0015cac5d98f", 304189, 400),
	WINDEMO1("msoffice", "Windows 95 Demo", "OFC95DEM.EXE", "3a3b86311ea93318c00e615910c9b9af", 2278071, 404),
	WINDEMO1("msoffice", "HyperMedia Demo", "OFFICE.EXE",	"6d3a440ed39ea166bc709941d1ac4d1e", 2259121, 404),
	WINDEMO2("mspowerpoint",		"Demo", "PPDEMO.EXE",	"8c49e85fe392cc16bfaaa4e4f5f3b38f", 2382163,
											"PPMENU.DIR",	"9af214d29ea0db2bc1cda9263b7adade", 1802184, 404),
	WINDEMO1("msproject",			"Demo",	"PROJDEMO.EXE", "01d88edc91499189f59467d32a0c27b2", 692401, 404),
	WINDEMO1("mspublish",	   "1995 Demo",	"PUBDEMO.EXE",  "6803a5c6453a680538e7fc15507be0bd", 2760365, 400),
	WINDEMO1("msschedule",			"Demo", "SCDEMO.EXE",	"3490bdb0957fed1ef43b09f774720ce2", 2595817, 404),
	WINDEMO1("mswine",				"Demo", "WINEDEMO.EXE",	"c84dcde32949946851630de98c6c9aa7", 2048505, 404),
	WINDEMO1("msword",	 "Windows 95 Demo", "WDDEMO.EXE",	"978b912f4d83feefbc2a72e19bf63539", 2408327, 404),
	WINDEMO1("msworks",				"Demo", "WORKS.EXE", 	"2f28c708b365ab1b7f8ae511bf515a33", 5021281, 400),

	// Original filename is 日本昔話
	MACDEMO1_l("mukashibanashi", "Demo", "Nihon Mukashi Banashi", "8ea9e9a699c61edddffd79ddd0c994d7", 290654, Common::JA_JPN, 402),

	// Both Mac and Win versions require installation to extract executable and some data files
	MACGAME1("mummy", "", "MUMMY", "01be45e7241194dad07938e7059b88e3", 503560, 400),
	WINGAME1("mummy", "", "MUMMY.EXE", "2ebe3a4ef8c128db46794333d4b61c36", 2939630, 400),

	 // Full game is not Director
	WINDEMO1("muppets", "Demo", "MUPPETS.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1_l("murdertaylor", "", "Taylor French", "dc839fb9e2f8e6bfc4f4f995c57df495", 291683, Common::DE_DEU, 400),
	WINGAME1_l("murdertaylor", "", "TF.EXE", "d7a97fbe1daf2bc5fdecee2725c297cd", 952741, Common::DE_DEU, 400),
	WINGAME1_l("murdertaylor", "", "JOURNA.EXE", "e6504ba65562c9950806c0dd395e3adb", 688299, Common::KO_KOR, 400),

	WINDEMO1("musiccentral96", "Demo", "MC96DEMO.EXE", "6b30dbea5949e64edd66427290b0fd8c", 690031, 404),

	WINGAME1("mylk", "", "mylk.exe", "032b0860a694ece5f64f37cfe1ebdfa0", 904859, 400),

	MACGAME1("mysteriousegypt", "",   "Mysterious Egypt",		   "32cb3a881f2d47a7e525370b198b2c5c", 483746, 404),
	MACGAME1_l("mysteriousegypt", "", "Matka muinaiseen Egyptiin", "17efee018a660458fae80de4364021ac", 483774, Common::FI_FIN, 404),
	WINGAME1_l("mysteriousegypt", "", "EGYPTI.EXE",				   "8bdf5baaa1fd82daf59fe0a96d356530", 1295295, Common::FI_FIN, 404),
	MACDEMO1_l("mysteriousegypt", "Demo", "Egypti demo", "337c94c66b435e075a2d7f94b3cffc49", 483746, Common::FI_FIN, 404),
	WINDEMO1_l("mysteriousegypt", "Demo", "EGYPTI.EXE",	 "2e8cba31e473bd1567476f57d6aeb4d6", 5574413, Common::FI_FIN, 404),

	// Windows demo is from PC Gamer (US) demo disc #10 - Sep 1995
	MACGAME1("necrobius", "", "NCROBIUS.PPC", "ab6ba48edb4a93ca034c63905f615865", 605874, 400),
	WINGAME1("necrobius", "", "N_BIUS.EXE", "d82ac6034122e1314157931f9df613f9", 692919, 400),
	WINDEMO1("necrobius", "Demo", "N_BIUS.EXE", "d17330706956c2fda3ee482b39b0609f", 705049, 400),

	WINDEMO1("newslinks", "Demo", "NEWS.EXE", "22900fa6922d71b1f880aa3cc0bbad1a", 16526563, 404),

	// Published by Corel CD Home. Later released as Nikolai's Knights.
	WINGAME1("nikolaiknights", "Corel", "KNIGHTS.EXE", "5ab667a256a0c334e9adca78564dbc5d", 740436, 404),

	// Later released as Nikolai's Toys
	// Original Mac filename is NN’nN Toy Makers™
	MACGAME1("nikolaitoys", "", "NN\'nN Toy Makers", "2c7d0c0d55cbe3f622c7d68cedb671e0", 487026, 404),
	WINGAME1("nikolaitoys", "", "NNN_TOYS.EXE", "22147e4c6311f670f72d43f8b793169e", 3206640, 404),

	MACDEMO1("nightsky", "Sampler", "Night Sky Interactive Sampler", "cbce20666bfe47a9533331c6be1e6039", 285525, 400),
	WINDEMO1("nightsky", "Sampler", "NIGHTSKY.EXE", "68f1fe67a5881fd47b08e905401d174c", 4300149, 404),

	// Original filename is Visual日本地理DEMO
	MACDEMO1_l("nihonchiri", "Demo", "Visual Nihon Chiri DEMO", "8b138db44d4421cc7294a9dc792ccf1b", 306940, Common::JA_JPN, 402),

	MACGAME1("nile", "", "Nile Passage to Egypt", "9765ad17bce6a2b40dd7f48377e82436", 512990, 400),
	WINGAME1("nile", "", "NILE.EXE", "9b00cbba14f0a2e0445784ebacf62c78", 2846777, 400),

	// Full game is D5
	WINDEMO1("nine", "Demo", "NINEDEMO.EXE", "d7596e7f6e8bc7c95d4217ff431a2f02", 711181, 404),

	// Demo executable name is ににんがしデモ
	// Full version executable name is ににんがし
	// There are also projectors to play audio in 11kHz or for systems with 4MB RAM
	MACGAME1_l("niningashi", "",	 "Niningashi",		"0666ae690e459d3d0d91800ebd94de46", 290682, Common::JA_JPN, 402),
	MACDEMO1_l("niningashi", "Demo", "Niningashi Demo", "0666ae690e459d3d0d91800ebd94de46", 290682, Common::JA_JPN, 402),
	WINDEMO2_l("niningashi", "Demo", "S.EXE",			"0c8a24a885123f20992c0c74d8c5062c", 768683,
									 "MAIN.DXR",		"8af3de22d679eb4e192429ca682bb974", 1119286, Common::JA_JPN, 404),

	WINDEMO1("nixon", "Demo", "NIXON.EXE", "ca89b860bb28aed3a699478a7f411ee5", 3193595, 404),

	// Pregnancy demo is from ADAM v1.1.1 for Mac
	MACGAME1("nmm", "",		"Adam Player.ppc", "df028c9e22b2dec8f7ffeee28ca7b991", 57726, 404),
	MACDEMO1("nmm", "Demo", "NMM Demo",		   "17efee018a660458fae80de4364021ac", 481482, 404),

	WINDEMO1("noir", "Demo", "NOIRDEMO.EXE", "a9690aa58c6da36b7a6bf88fd4c81ffc", 10949309, 404),

	// Original filename is Nomis™ PPC
	MACGAME1("nomis", "", "Nomis PPC", "6dd87d48277cf2cd886e5168266ce4bf", 58051, 403),

	MACDEMO1("nurseryrhymes", "Sampler", "Nursery Rhymes Sampler", "cbce20666bfe47a9533331c6be1e6039", 285529, 400),
	WINDEMO1("nurseryrhymes", "Sampler", "NURSERY.EXE", "c7cca77d8c1c88e8003db72abb05da0a", 4518423, 404),

	WINGAME1("operafatal", "",	 "OPERA.EXE",   "2b9da5566698a1f4b453e1a27e00ad29", 697739, 400),
	MACGAME2("operafatal", "",	 "OPERA FATAL", "f5033f237ad1b1639fc46d01a82ac380", 285566,
								 "SPRINT.Dxr",  "3e86f01eeac5fa3349c5177378997a7f", 694912, 400),
	MACGAME2_l("operafatal", "", "OPERA FATAL",	"f5033f237ad1b1639fc46d01a82ac380", 285566,
								 "SPRINT.Dxr",	"3eb6f5568c9ced258059e2cfd30751c5", 479616, Common::IT_ITA, 400),

	MACDEMO1("orgotto", "Demo", "ORGOTTO", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484351, 404),
	WINDEMO1("orgotto", "Demo", "ORGOTTO.EXE", "f9272ef143c610ebd4dcb8301aa9b678", 760137, 404),

	// Found on PC Gamer (US) demo discs #1,3,4,6
	// V10 found on Czech Super Hry III (FMI)
	WINGAME1("origin", "V6",  "CATALOG.EXE", "31ccde4688ffea57022b05d467bad4ed", 8844619, 400),
	WINGAME1("origin", "V7",  "CAT_WOG.EXE", "4753368b2fd973e18b5917b1f43bb29b", 9337013, 400),
	WINGAME1("origin", "V8",  "CATALOG.EXE", "e6fe968cbe2b51ea423af58216c78392", 9509999, 400),
	WINGAME1("origin", "V10", "CATALOG.EXE", "7cff9d0feac9240a93dbd442f556e6d5", 9509767, 400),
	WINGAME1("origin", "V11", "CATALOG.EXE", "c117a85d635a2b4469a141f7f051b0a8", 10347633, 400),

	WINGAME1_l("osaka1", "",	 "OSAKA.EXE", "c0479277618ab17bd9c79b5da66ab435", 1491097, Common::JA_JPN, 400),
	WINDEMO2_l("osaka1", "Demo", "DEMO.EXE",  "763f360a098cf3bec7cbdc5685b1e4a3", 1193483,
								 "START.DIR", "83190aa4c2db873334d36bac329ec670", 825036, Common::JA_JPN, 404),
	MACDEMO2_l("osaka1", "Demo", "DEMO",	  "5a012e69fec2369ad2e8d73c42d928f3", 1096269,
								 "START.DIR", "8b82c58788768cfa88115217de4e8995", 825192, Common::JA_JPN, 404),

	MACGAME1("oslotg", "", "OSLO\'s T&G", "ef59432e7b24df951cb7096cfd45d168", 307427, 400),
	WINGAME1("oslotg", "", "OSLOTG.EXE", "c4be18eb4f16e3e21df22d0703866900", 995939, 400),

	WINGAME1("painters", "", "PAINTERS.EXE", "3cba94b585493ef5f22d0d650b6eb7fd", 895727, 404),
	MACGAME1("painters", "", "Painters Painting", "0a81aee4106eec4ffc0cc564a7c15a23", 288774, 404),

	// Full version is bilingual. Demo is French only.
	// Demo found on EMME Keys to Knowledge sampler CD
	MACGAME1("paris", "",		"PARIS History & Splendour", "1c2e5371b835680e7c1ca8bcea008bef", 482838, 404),
	MACDEMO1_l("paris", "Demo", "DEMO PARIS INFO LINK-EMME", "1c2e5371b835680e7c1ca8bcea008bef", 482838, Common::FR_FRA, 404),
	WINGAME1("paris", "",		"PARISPC.EXE",	"efff9526abac439e895005efb07499cb", 234012595, 404),
	WINDEMO1_l("paris", "Demo", "DPARISPC.EXE", "875af2a4007c6ec11939ca0cc1f380d5", 719579, Common::FR_FRA, 404),

	// All four languages found on Apple Europe Edition CD
	MACGAME1("parisvt",	  "", "Virtual Tourism PARIS (E)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, 404),
	MACGAME1_l("parisvt", "", "Virtual Tourism PARIS (D)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::DE_DEU, 404),
	MACGAME1_l("parisvt", "", "Virtual Tourism PARIS (F)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::FR_FRA, 404),
	MACGAME1_l("parisvt", "", "Virtual Tourism PARIS (I)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::IT_ITA, 404),

	MACGAME1("paws", "", "Start the Dog!", "af8fad5423f5416fe7743198e3909294", 325317, 404),
	MACDEMO1("paws", "Making of", "The Making of P.A.W.S", "a55b1e9e9d04a2234189a6bcfbe69e4c", 295404, 404),
	WINGAME1("paws", "", "STARTDOG.EXE", "5c9a56c88b4bb8732377f93f62a885a4", 818961, 404),
	WINDEMO1("paws", "Making of", "MAKEPAWS.EXE", "559f4c728a348c18b96cddaf102e3413", 874293, 404),

	WINDEMO1("pbbear", "Sampler", "PBBEAR.EXE", "dc58e6e06807f4a4a4cc278f8748659f", 696807, 404),

	MACGAME1_l("petepilotti1", "",	   "Seikkailu Lapponiassa", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::FI_FIN, 404),
	MACDEMO1_l("petepilotti1", "Demo", "Pete Pilotin esittely", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483746, Common::FI_FIN, 404),
	WINGAME1_l("petepilotti1", "",	   "PETE.EXE",	   "4d4637a93653ece18e7d1238cc52a111", 1295281, Common::FI_FIN, 404),
	WINDEMO1_l("petepilotti1", "Demo", "PETEDEMO.EXE", "fd8a1586ac3e8e95746b31e0c9daf767", 8772665, Common::FI_FIN, 404),

	// Mac version requires hard drive installation
	// Choice of American or British English by selecting Language = 0 or 1 in PETER.INI
	MACGAME1("peterrabbit", "", "Peter Rabbit (PowerMac)", "fd5cf6efd07077a06519145fc3700e63", 62616, 404),

	// These tile puzzles are identical except for the image
	MACGAME1("pfarrypuzzle", "Flower", "Flower Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 304196, 400),
	MACGAME1("pfarrypuzzle", "Iris", "Iris Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 304196, 400),
	MACGAME1("pfarrypuzzle", "Lighthouse", "Lighthouse Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 304196, 400),
	MACGAME1("pfarrypuzzle", "Old Camera", "Old Camera Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 304196, 400),
	MACGAME1("pfarrypuzzle", "Sunflower", "Sunflower Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 304196, 400),

	MACGAME1_l("phantplanet", "", "phantasmagoria_PPC", "602e61f10c158183218405dd30a09b3f", 60352, Common::JA_JPN, 400),
	WINGAME1_l("phantplanet", "", "PHANTAS.EXE", "c2dd62dd0f9488ae8102970553eff170", 690449, Common::JA_JPN, 400),

	MACDEMO1("photos4us", "Demo", "Photos4us", "2c27791a84756be6201d281bad54f7bb", 351560, 404),

	// Full game is not Director
	WINDEMO1("pitfall", "Demo", "PITDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1("planetarizona", "", "Planet Arizona", "0c7bbb4b24823e5ab871cb4c1d6f3710", 488433, 400),
	WINGAME1("planetarizona", "", "ARIZONA.EXE", "a23462ec87eff973d2cdb2ddfd4a59fa", 698651, 400),

	MACGAME1("playskool", "", "goHIGmem PPC", "a6043fbba9186296faf8a2b82e5e4182", 64506, 404),
	WINGAME2("playskool", "", "SAMPLER.EXE",  "20ffd50fc265f5e90398b771071e9732", 696951,
							  "START.DIR",	  "b0d7dc2b2f45654c97dd4dd8ed7e25f3", 21469988, 404),

	// Distributed with Vote America demo
	WINGAME1("poliq", "", "POLIQ.EXE", "064decf4d538e2dcdc8ccbbbb857ff7e", 1376591, 404),

	MACGAME1_l("popup", "", "POP UP COMPUTER", "c1c73a286e7fdb439c8d49c79a2d9997", 318305, Common::JA_JPN, 400),
	WINGAME1_l("popup", "", "POPUP.EXE", "f47f7663a75120eca6c9e91025d51786", 65216494, Common::JA_JPN, 400),

	// Laser Publishing of Berkeley, California (1995)
	// Plays in English, Simplified Chinese, Tibetan
	// Alternate titles are 布达拉宫 and ཕོ་བྲང་པོ་ཏ་ལ་
	WINGAME1("potala", "", "POTALA.EXE", "2d5780d54e3c26281ef4aadef7d004b8", 35710089, 400),

	MACGAME1("prangers1", "", "Power Rangers", "13fe5212d9fc599e34b1260dc09970be", 303281, 400),
	MACGAME1("prangers2", "", "PR Part 2", "0ecc4b4483d638bfb727cc5472b2fde3", 303281, 400),

	// original file name is Paradise*Rescue
	MACGAME1_l("prescue", "", "ParadiseRescue", "bcd3c718db258701496b3c5bcb827ef2", 502965, Common::JA_JPN, 404),
	WINGAME1_l("prescue", "", "P_RESCUE.EXE", "c66e73719aff15a2ba4f33cf2e21581a", 813265, Common::JA_JPN, 404),

	MACDEMO1("princeint", "Demo", "Mac_Int2", "dc5a87dda7a0daf46604515f7d2cca66", 289980, 403),
	WINDEMO1("princeint", "Demo", "PRINC2.EXE", "86fa884d22484ffa46407a2aa1ece297", 4758501, 400),

	// original file name is psych™
	MACGAME1("psych", "v1.0.5", "psych", "85dfccc89072ba781bc90783998c3937", 284622, 403),
	MACGAME1("psych", "v2.0.1", "psych", "1e0f16853ec1652a51ade41823405440", 406450, 403),

	MACDEMO1_l("racingdays", "Demo", "Racing Days World", "fbe75e9140b23cf5bb2f5fd6f7ce8e88", 482059, Common::JA_JPN, 404),

	MACDEMO1("readblasterjr", "Preview v1.0c", "Reading Blaster Jr. Power Mac", "49aa41e6b624e64e8e48850faa882cc8", 63532, 404),

	MACDEMO1("redshift", "1994 Demo", "RSDEMO.MAC", "4f7ff33ce95ed9f42befdae4f9b6b690", 292244, 403),

	MACGAME1_l("renderorgan", "", "RenderOrgan", "0c7bbb4b24823e5ab871cb4c1d6f3710", 505374, Common::JA_JPN, 404),
	WINGAME1_l("renderorgan", "", "743.EXE", "7a59a30b6b2db921f6d354cd74faf09a", 697963, Common::JA_JPN, 404),

	// Original filename is ラインの黄金CD
	MACDEMO1_l("rheingold", "Demo", "Das Rheingold CD", "b7e69c37b7355022d400c14aa97c5d54", 484351, Common::JA_JPN, 404),

	// Developed by Masahiro Fukuda & Co, published by Mizuki of Kashiba, Nara, Japan (1995)
	// Auto Mode plays game as a non-interactive movie
	WINGAME1_l("sabotenman", "",          "SABOTEN.EXE",  "30721602cb11d8764c5f0d9999ebe04d", 753725, Common::JA_JPN, 404),
	WINGAME1_l("sabotenman", "Auto Mode", "AUTOMODE.EXE", "67388a4076d1ba021dc7aa551798754e", 754423, Common::JA_JPN, 404),

	// Found on Sakhr Arabic Grammar v1.1
	// Product catalogue for Sakhr Software Co., Heliopolis, Egypt
	WINGAME1_l("sakhr", "", "MMDEMO.EXE", "0e5436b4daa9e787abb2692bb5ca5454", 740524, Common::AR_ARB, 404),

	MACGAME1_l("sakin2", "", "STARTCD", "67f572196550aedb1f9523d782022be0", 484351, Common::JA_JPN, 404),
	WINGAME1_l("sakin2", "", "STARTCD.EXE", "0c8a44b04aa6e8f1483b05f6b567fa3c", 749233, Common::JA_JPN, 404),

	// Full game is not Director
	WINDEMO1("santafe1", "Demo", "ELKMOON.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1("sciencesmart", "", "Science Smart", "e020c33ab426b167647fed5e7aea6659", 295454, 403),
	WINGAME1("sciencesmart", "", "SCIENCE.EXE", "23e748085b255870650ae18b15dd986b", 759951, 404),

	MACGAME1("scrutiny", "", "ScruTiny in the Great Round", "f5c99f14046b52844b2e9bd0575f1eed", 494142, 404),
	WINGAME1("scrutiny", "", "SCRUTINY.EXE", "05dd9dfaf51383c242f61e990575fa34", 724885, 404),

	WINDEMO1("searchlearn", "Demo", "SEARCH.EXE", "a563a1a244faf97137b47a3c0ee82176", 8088823, 404),

	MACGAME1("sensei", "", "Sensei", "6ab7bac3d8fe6bcf4da81750d7ca286c", 284630, 404),

	MACGAME1("sfpd", "v1.00", "Body in the Bay", "01be45e7241194dad07938e7059b88e3", 483774, 404),

	// Product was published by 夢本舗株式会社 (Yumehonpo)
	MACDEMO1_l("shadeviewer", "Operation Manual", "Manual", "8b138db44d4421cc7294a9dc792ccf1b", 502913, Common::JA_JPN, 404),

	// Full game is not Director
	WINDEMO1("shanghai", "Demo", "SHGMDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	WINDEMO1("shramerica", "Demo", "SHRAMER.EXE", "b50e77a25088cfe1cb88ee2dc4d3a9c9", 1335269, 404),
	WINDEMO1("shrgrammar", "Demo", "SHRGRAM.EXE", "c3ee0462fe5935cf1eabfbdecfe33f03", 698575, 404),
	WINDEMO1("shrmath", "Demo", "SHRMATH.EXE", "bc3ec272680e0e57f76032a2a8e196eb", 690109, 404),

	// Player app is a standalone player for cartoons created in Studio
	// Demo is found on apcmag.cd Dec 1999 disc 3, published by Australian Consolidated Press
	MACGAME1("simpsonstudio", "",	  "Simpsons Cartoon Studio", "cd98745b01c43b49b223ecb1543cb3b1", 317514, 403),
	MACGAME1("simpsonplayer", "",	  "Simpsons Cartoon Player", "f18e1cf6fb9fea099aae580c2057e551", 502040, 403),
	WINGAME1("simpsonstudio", "",	  "SIMPSONS.EXE", "358af28ffe3fa515a9b9a03149483cb1", 3368957, 404),
	WINDEMO1("simpsonstudio", "Demo", "SIMPDEMO.EXE", "bcd332d5061ec00b103c1529b4095a49", 901047, 404),
	WINGAME1("simpsonplayer", "",	  "SPLAYER.EXE",  "8966c096c5718316fddc7b238dd9df94", 884843, 404),

	// Win version is D5
	MACGAME1("simpsontrivia", "v3.1", "Simpsons Trivia 3.1", "db9b7f11aea52a294d2986a94a184000", 58354, 403),

	// Windows demo is from PC Gamer (US) demo disc #11 - Oct 1995
	MACGAME1("skyborg", "", "SkyBorg 1.0", "bcd3c718db258701496b3c5bcb827ef2", 486954, 404),
	WINGAME1("skyborg", "", "BORG.EXE", "855f305ba8ae70d5e5a53a9085b83d5b", 1887499, 404),
	WINDEMO1("skyborg", "Demo", "SKYBORG.EXE", "a2c76a72f703012808ab241c0e189694", 22368545, 404),

	WINDEMO1("smashsounds1", "Demo", "SMASH.EXE", "cc9f6f623ef61d2ac364eb41f65957ed", 2076581, 404),

	MACGAME1("sorgato", "", "SORGATO\'S VARIABLE COLOR", "4011dd51c0eed1b5cf1fbf55360a7f60", 304189, 400),

	// Original filename is 素材辞典『体験版』ブラウザ
	MACDEMO1_l("sozaijiten", "Vol. 1 (Stone) Trial Version", "Sozaijiten (Trial Version) Browser", "d1ef4c4efcc587aea2a84a70d9eb778a", 297377, Common::JA_JPN, 402),

	MACGAME1("spacestationalpha", "", "The Encounter 16+MB", "e019f541a05887922e2ee19bcff5bb25", 483774, 404),

	// Full game is not Director
	WINDEMO1("spycraft", "Demo", "SPYCRAFT.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1("sscocacola", "", "Coca-Cola Animations", "6e86a061950bc3987ce2ddf531bfde34", 295426, 403),
	MACGAME1("ssdietcoke", "", "DietCoke Animations", "6e86a061950bc3987ce2ddf531bfde34", 295426, 403),
	MACGAME1("sslivepicture", "", "Live Picture Screen Saver", "4502263d183dd9dae0e3c3505fdf8ae1", 555539, 404),

	MACGAME1("stream", "Volume 1", "Stream_1", "cdb27c916044ae4dceb4b7326063fa03", 304217, 400),
	WINGAME1("stream", "Volume 1", "STREAM_1.EXE", "147c76b43a5ec051381c238488f722d5", 690979, 400),

	// From Super Sunday: An Interactive History Volume 2
	MACGAME1("superbowltrivia", "", "SB Trivia Game", "4979678478db83693217cf295f53572c", 544413, 404),

	WINGAME1_l("supermente", "", "superm.exe", "57181623661742fcad179aa387b75a29", 742640, Common::RU_RUS, 404),

	MACGAME1("superspy", "", "ssi english", "ccf864a8dc6e9d0d26eb73b4683e634b", 60324, 400),
	MACGAME1_l("superspy", "", "SSI (Power Mac)", "5f036ea61efdcc5e30074a404dbf4d80", 61030, Common::DE_DEU, 400),
	MACGAME1_l("superspy", "", "ssi hebrew", "49aa41e6b624e64e8e48850faa882cc8", 60324, Common::HE_ISR, 400),
	MACGAME1_l("superspy", "", "SSI", "8f6a07fe6aa88428dd73557e1cd53d06", 58058, Common::IT_ITA, 400),
	WINGAME1("superspy", "", "ssie.exe", "1f256591c24a3bef0875aee737114057", 2181003, 400),
	WINGAME1_l("superspy", "", "Ssi.exe", "88272b3e24689c3986f4f4aa8c50e1f7", 2307489, Common::DE_DEU, 400),
	WINGAME1_l("superspy", "", "ssih.exe", "f016f23131189b2b65669f5258538fb5", 2261091, Common::HE_ISR, 400),
	WINGAME1_l("superspy", "", "SSI.EXE", "890c17a442dd3d96ab331f96d8c1eed8", 3648017, Common::IT_ITA, 400),

	// Mac executable is How Would You Survive?
	MACGAME1("survive", "", "How Would You Survive", "01be45e7241194dad07938e7059b88e3", 501316, 404),
	WINGAME1("survive", "", "SURVIVE.EXE", "6d798bb5d6d90cc4bae30510a87eff3c", 703155, 404),

	MACGAME1_l("svmvillagina5", "", "Villagina 5 -8Mo", "08876be0a21938f382038f8d12d5e5d9", 483423, Common::FR_FRA, 404),
	WINGAME1_l("svmvillagina5", "", "VILLAGE.EXE", "fd8420e5fc9dcca6f7ddcb3d17bec5c0", 743945, Common::FR_FRA, 404),

	WINGAME1("teamxtreme1", "", "XTREME.EXE", "45ab80997efedec388ff5200722e673c", 690123, 400),
	WINGAME1("teamxtreme2", "", "TX2.EXE", "50c80bd2add25e574494838772973beb", 2585471, 400),

	// Mac full executable name is ハイ！鉄マンです
	// Mac demo executable name is デモ
	MACGAME1_l("tetsuman", "", 	   "Tetsuman",		"bcd3c718db258701496b3c5bcb827ef2", 484323, Common::JA_JPN, 404),
	MACDEMO2_l("tetsuman", "Demo", "Demo",			"bcd3c718db258701496b3c5bcb827ef2", 484323,
								   "LOGO",			"eca1db6f65dbd3213dbddf121adb3db2", 1050164, Common::JA_JPN, 404),
	WINGAME1_l("tetsuman", "", 	   "TETUMAN.EXE", 	"460a27915f96f1aeb50b271722637a60", 746847, Common::JA_JPN, 404),
	WINDEMO2_l("tetsuman", "Demo", "DEMO.EXE", 		"460a27915f96f1aeb50b271722637a60", 746847,
								   "SHARED.DIR", 	"1a294eaa8f725a54aa00e5ec6d3560a9", 1656378, Common::JA_JPN, 404),

	// Pippin disc contains Pippin + Mac executables
	// On Win/Mac disc, the original Mac executable name is 鉄マン外伝
	// Mac demo executable name is デモ
	MACGAME1_l("tetsumangaiden", "",	 "Tetsuman Gaiden", "ea646eccc9a53f44ce082459d4809a06", 484323, Common::JA_JPN, 404),
	MACDEMO2_l("tetsumangaiden", "Demo", "Demo",			"0cbcb147543278d3f719fc31a3e6def6", 1097597,
										 "LOGO",			"e656c2676aa805ae95c40dbd3ac3cd61", 1049760, Common::JA_JPN, 404),
	PIPGAME1_l("tetsumangaiden", "",	 "GAIDEN.Pippin",	"2618a85198d0180e3eae9162f81aafed", 61059, Common::JA_JPN, 404),
	WINGAME1_l("tetsumangaiden", "",	 "GAIDEN.EXE",		"e0176c2683e3f3cac971e976bafb8fee", 747105, Common::JA_JPN, 404),
	WINDEMO2_l("tetsumangaiden", "Demo", "S.EXE",			"6e8d348333574dad57d316b780bc5f35", 747195,
										 "LOGO", 			"82d44fb57e72e6243b55634379a74f6c", 1051768, Common::JA_JPN, 404),

	// Mac version is not Director
	WINGAME1("thinkinthingsdp", "", "PARENTS.EXE", "4e82061a925caa16320c52b38aeb68c5", 1160899, 400),

	WINDEMO1("timelapse", "Demo", "TLOVIEW.EXE", "6cd9f5644c8aa66ce60a23ee02762eab", 75131959, 404),

	MACDEMO1_l("toeic", "Demo", "TOEIC", "77f4098988d5386794d1530065f514cd", 301937, Common::JA_JPN, 400),

	WINDEMO1("tommy", "Demo", "TOMMY.EXE", "ee4a543d88cbeaf3372ea25068720642", 696897, 404),

	// Full version is available on Tone Tales from Tomorrow Too from Ntone (CD9)
	WINDEMO1("tonetrakker", "Demo", "TTSTART.EXE", "7ab8fc552f890fe827ccd60679032527", 697017, 404),

	// Mac executable name is TD MAC/PPC
	MACGAME1("totaldistortion", "", "TD MACPPC", "17efee018a660458fae80de4364021ac", 486074, 404),
	WINGAME1("totaldistortion", "", "TOTAL_DN.EXE", "461b407c321e80487ae4882056310f9f", 700747, 404),

	MACGAME1("toyota95", "", "Toyota 95", "01be45e7241194dad07938e7059b88e3", 486985, 404),

	MACGAME1("trekborg", "", "Picard Dossier", "e1dc28c1dd8409c2d2e0d5d269df5ffc", 520069, 400),
	WINGAME1("trekborg", "", "OMNIBORG.EXE", "1580ebad7599fb6c18815e244b0bfda3", 811363, 400),

	MACGAME1("trekguideds9", "v1.0", "Omnipedia DS9 Episodes", "1c2e5371b835680e7c1ca8bcea008bef", 505317, 400),
	WINGAME1("trekguideds9", "v1.0", "OMNI_DS9.EXE", "0058390ff77e527c7bb413081004c304", 805517, 400),

	MACGAME1("trekguidetng", "v1.1", "TNG Episodes", "1c2e5371b835680e7c1ca8bcea008bef", 520149, 400),
	WINGAME1("trekguidetng", "v1.1", "OMNI_TNG.EXE", "0049d72e2d5869408fc33860ec4b5c1f", 794201, 400),

	MACGAME1("trekklingon", "", "Klingon Language Lab", "b797956eb3a4dabcc15bfadf6fc66591", 481482, 400),
	WINGAME1("trekklingon", "", "TREK_WIN.EXE", "204417e63c0a2df18cf42d780b97ed58", 1425763, 400),

	MACGAME1("trekomni", "v1.00", "Omnipedia", "b7e69c37b7355022d400c14aa97c5d54", 516791, 400),
	MACGAME1("trekomni", "v1.1.2 Upgrade", "Omnipedia 2", "b7e69c37b7355022d400c14aa97c5d54", 613253, 400),
	WINGAME1("trekomni", "Premier Edition", "ST_OMNI.EXE", "1a648d47632561f10a98782f1dde5738", 811827, 400),
	WINGAME1("trekomni", "v1.1.2 Upgrade", "ST_OMNI2.EXE", "1d60aad73cc9c69776a878aa59e65230", 809781, 400),

	MACGAME1("trektech", "", "STNG Technical Manual (PowerPC)", "a9bd9f3a82fcde6e4d151868e256aec7", 525946, 400),
	MACDEMO1("trektech", "Demo", "TrekForMac", "68ed73866232194a9a5609040dc1f242", 289952, 403),
	WINGAME1("trektech", "", "NCC1701D.EXE", "02aec408cee26413a096aec9b1cb1878", 720249, 400),

	// Bilingual English/Spanish
	MACGAME1("truthsfictions", "", "Truths & Fictions", "4577dd3eadc467a986ab172d90871b22", 534968, 404),

	// Original filenames are 合わせ月の夜 (disc 1), フェンネル (disc 2), いにしえびと (disc 3)
	MACGAME1_l("twistynight1", "", "Moonlit Night", "8ea9e9a699c61edddffd79ddd0c994d7", 290682, Common::JA_JPN, 402),
	MACGAME1_l("twistynight2", "", "Fennel", "8ea9e9a699c61edddffd79ddd0c994d7", 290682, Common::JA_JPN, 402),
	MACGAME1_l("twistynight3", "", "Young Man", "8ea9e9a699c61edddffd79ddd0c994d7", 290682, Common::JA_JPN, 402),

	// Demos from Big Top Productions: Felix the Cat, Hello Kitty, Keroppi & The Groove Thing
	WINGAME1("ubt", "", "BTDEMO.EXE", "dbe72b7dc91c72db5b4597857aecf5c6", 696813, 404),

	// YOBI.EXE is a projector for lower performance systems
	WINGAME1_l("ukiuki1", "", 	  "TENNGU.EXE", "f0bbb9938a7cb899b6fc93ef7f3e8150", 747145, Common::JA_JPN, 404),
	WINDEMO2_l("ukiuki1", "Demo", "S.EXE",		"09430e02b3540e623d0b400792958901", 747145,
								  "LOGO.DIR",	"b6d341c63fbea25898fc310981413c28", 1053528, Common::JA_JPN, 404),
	WINGAME1("ukiukibgv", "",	  "BGV",		"4dc07ac998272bb4027a9979f5b6c3b6", 1097649, 404),
	{
		{
			"ukiuki1", "CD Demo",
			// Original filename is 幻の天狗池
			AD_ENTRY1s("Maboroshi no tengu-chi", "792a89586ed20c4662b51c2bfd43be80", 1102407),
			Common::JA_JPN,
			Common::kPlatformMacintosh,
			ADGF_CD | ADGF_DEMO | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		404
	},

	// Original Mac demo filename is デモ
	// Original Mac full game filename is 波止の五目釣り
	// Windows demos on Uki Uki 3 sample disc are hidden in MOVIE/BMP
	// All of the Windows demo projectors use the S.EXE filename
	MACGAME1_l("ukiuki2", "",	  "Hashi no gomoku-dzuri", "bcd3c718db258701496b3c5bcb827ef2", 488946, Common::JA_JPN, 404),
	MACDEMO2_l("ukiuki2", "Demo", "Demo",  				   "5ef06a50a335ec0a9a0f9017057ccfe9", 1097469,
								  "START", 				   "c1eaf606b97d1fb5a55214485d330aa9", 9228, Common::JA_JPN, 404),
	WINDEMO2_l("ukiuki2", "Demo", "S.EXE",  			   "5ef06a50a335ec0a9a0f9017057ccfe9", 1097469,
								  "OPENING",			   "c1eaf606b97d1fb5a55214485d330aa9", 9228, Common::JA_JPN, 404),

	// Demo is D5
	// Original filename is 人魚島のボート釣り
	MACGAME1_l("ukiuki3", "", "Ningyo shima no boto-dzuri", "bcd3c718db258701496b3c5bcb827ef2", 488038, Common::JA_JPN, 404),

	MACGAME1("universe", "", "Invisible Universe", "78138a77207907642744d0960c14d9e5", 596766, 404),
	WINGAME2("universe", "", "UNIVERSE.EXE", "77ddb6ca4c45b78cc501868afa55e166", 700157,
							 "STARTUP.DIR",	 "f66999c161fd9bac1f70be4635abfcc2", 24958, 404),

	WINGAME1("ushistory", "", "HISTORY.EXE", "0ca49c80588dd50f985d5aa6192b973e", 703629, 404),

	// Original Mac fllenames begin with Virtual Cop™
	MACDEMO1("vcop", "Demo", "Virtual Cop IPK", "ea646eccc9a53f44ce082459d4809a06", 482838, 404),
	MACGAME1("vcop1", "", "Virtual Cop (8MB)", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483774, 404),
	MACGAME1("vcop2", "", "Cop II, The Angel Returns", "0c7bbb4b24823e5ab871cb4c1d6f3710", 482838, 404),
	WINGAME1("vcop1", "", "VCOP.EXE", "dfa4c8709ed83f2ac79aeecf9b2d1f95", 697427, 404),
	WINGAME1("vcop2", "", "VCOP2.EXE", "9683bc8aeb2d47f2e38908bac65fd9bd", 723653, 404),

	// Original filename is DreamLight® Verttice™ 2.0
	MACGAME1("verttice", "v2.0", "DreamLight Verttice 2.0", "b7e69c37b7355022d400c14aa97c5d54", 512047, 404),

	MACDEMO1_l("victorianpark", "Demo", "Victorian Park DEMO", "0d5f13d9321d36c23b63f229460928b4", 483443, Common::JA_JPN, 404),

	WINDEMO1("vote", "Demo", "VOTEDEMO.EXE", "4b8c50c375c348e2d46086e1cccdd407", 7679955, 404),

	MACGAME1("vnc", "", "VNC", "0c7bbb4b24823e5ab871cb4c1d6f3710", 486116, 404),
	WINGAME1("vnc", "", "VNC.EXE", "40ba00213a10164eb6e01847108f9b21", 1086869, 404),
	WINGAME1("vnc", "Beta", "VNC.EXE", "e6f284971c09f19e3277aa8ebcf58cbd", 726643, 404),

	WINDEMO1("vtarot", "Demo", "VTAROT.EXE", "06bf4ef6c25c6590949f57ea3b043abd", 693261, 404),

	// Original Mac filename is VUSIC™ The Screen Raver™
	MACDEMO1("vusic", "Demo", "VUSIC The Screen Raver", "5bbb193a8785c70abe2a4d86b99e1536", 283291, 403),
	WINDEMO1("vusic", "Demo", "VUSIC.EXE", "ff2c0a776d5f0c9aa5bc115d3b36676b", 693375, 400),

	WINGAME2_l("warlock", "", "START.EXE",	  "04e0887e76ee58b86ace1d89bf816d9f", 694159,
							  "SSWARLCK.DIR", "aa3d2d8d69746d2b0f312427649cd98f", 608862, Common::JA_JPN, 400),

	// Original Mac filename is わりわりワールド_デモ
	MACDEMO1_l("wariwari", "Demo", "Wari Wari World Demo", "f808a9f231b77617fa559cf9d2da66c1", 502975, Common::JA_JPN, 400),
	WINDEMO2_l("wariwari", "Demo", "S.EXE",				   "56faebd9531821fe9be95515c43f7fcc", 744019,
								   "WADEMO.DXR",		   "cf6453b97f7e1cb1fb19ecb59bbb9caf", 6213026, Common::JA_JPN, 404),

	MACDEMO1("warplanes", "Demo", "Warplanes Demo", "4f7ff33ce95ed9f42befdae4f9b6b690", 292244, 403),

	MACGAME1("whales", "", "World Of Whales", "da0da5d543b237051975ad70bec129f4", 483774, 404),

	MACGAME1("wildblueyonder1", "", "Wild Blue Yonder 1", "dc5a87dda7a0daf46604515f7d2cca66", 292244, 403),

	WINDEMO1("windows95", "Demo", "W95DEMO.EXE", "508a025373f0e8f6ae514578cf97c281", 24814094, 404),

	//Heksenspul met Hennie de heks en de kat Helmer
	WINGAME1_l("winnie", "", "HENNIE.EXE", "25b6c57704b8a2913cfa5d7f30adbc9a", 967339, Common::NL_NLD, 400),

	MACDEMO1_l("wonderomcw", "Demo", "WONDEROM_CW", "549afa25835bcd35daff0f399e54149e", 290726, Common::JA_JPN, 402),

	WINDEMO1("worldatlas", "Sampler", "ATLAS.EXE", "dc58e6e06807f4a4a4cc278f8748659f", 696807, 404),

	WINDEMO1("wwanimals", "Demo", "ANIMALS.EXE", "25fee176193d52cf7cbc2b604bfcbf8c", 6961631, 404),

	MACGAME1_l("xaxa", "", "XAXA MACHINE", "ff0b7a4b925c7345785c372d618d0967", 343233, Common::JA_JPN, 400),

	MACGAME1_l("ybr2", "", "YBR2", "b797956eb3a4dabcc15bfadf6fc66591", 504153, Common::JA_JPN, 400),
	WINGAME1_l("ybr2", "", "YBR2.EXE", "dbe273c1df60305be98a1a582ddd2c3b", 860579, Common::JA_JPN, 400),
	WINDEMO1_l("ybr2", "Demo", "YBR2DEMO.EXE", "25ecc053e02a0ef537d34d615119c814", 900973, Common::JA_JPN, 400),

	// Original Mac filename is よーいドンDEMO
	MACDEMO1_l("yoidon", "Demo", "Yo-i Don DEMO", "3a0c62a46f36157434c4204e50f22886", 305032, Common::JA_JPN, 403),
	WINDEMO2_l("yoidon", "Demo", "S.EXE",		  "9448daa2ccbc2c3707df48323327feb0", 747007,
								 "START.DXR",	  "651764cd9add9cc56022dc499b2aca92", 9803044, Common::JA_JPN, 404),

	// Original Mac filename is 真・百物語
	MACGAME1_l("yokai", "", "xn--vek138qttcmsa439e", "17efee018a660458fae80de4364021ac", 556245, Common::JA_JPN, 404),
	WINGAME1_l("yokai", "", "YOUKAI.EXE", "d223c4b2174baf83bc33357a94077fea", 740279, Common::JA_JPN, 404),

	// Published by Nikkei and Sakura Notes of Minato City, Tokyo (1996)
	// Windows disc contains a projector SWAP.EXE that loads the program using virtual memory
	// Four different Mac projectors for various memory and monitor configurations
	// Original Mac filename is 17インチ1670万色(要10Ｍ）
	MACGAME1_l("yumemirukairo", "", "xn--171670(10-hv4htktuj831avm1hqewau034bqra", "8b138db44d4421cc7294a9dc792ccf1b", 505178, Common::JA_JPN, 400),
	WINGAME1_l("yumemirukairo", "", "YUMEMIRU.EXE", "a6573719b2f3c3fbc6b7ad6a7bb191c0", 866281, Common::JA_JPN, 404),

	// Full game is supported in ZVision engine
	WINDEMO1("znemesis", "Demo", "ZORKDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	WINDEMO1("zoombini", "Demo", "_ZOOMDAT.EXE", "d573b80bb932f50cbe69395b158e9f47", 696927, 404),
	WINDEMO1("zoombini", "Demo", "ZOOMBINI.EXE", "e68b82276dc4f89a292c7d60d97983fe", 4632551, 404),

//////////////////////////////////////////////////
//
// Macromedia Director v5
//
//////////////////////////////////////////////////

	WINGAME1_l("a5tours", "", "A5TOURS.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410246, Common::JA_JPN, 501),

	// Run Windows installer (ASENNA.EXE) on Win9X extract 32-bit executable
	MACGAME1_l("aapelin1", "", "Aapelin ABC, 7-9 v", "231d3041df162be4a0ddd36a74eb03b6", 719261, Common::FI_FIN, 501),
	WINGAME1_l("aapelin1", "", "Aapeli32.exe", "3460ad87d2ba57104e2810a77b53c220", 1396675, Common::FI_FIN, 500),

	// GT Publishing, New York, ABCD-ROM series (1997)
	WINGAME1("abclunch", "", "ABC95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1421779, 501),

	// Installers for both platforms also use Director
	MACGAME1("alcohol101", "", "Let\'s Party", "2d2ac01320f4c2dce8e156cda5c73fe8", 719289, 501),
	WINGAME2("alcohol101", "", "START95.EXE",  "1a7acbba10a7246ba58c1d53fc7203f5", 1411661,
							   "INTRO.DXR",	   "de5b5bbc9cc4659b3a6464efffd22fb9", 903418, 501),

	WINDEMO1_l("almabril98", "Demo", "DEMO AA98 START.EXE", "3460ad87d2ba57104e2810a77b53c220", 4180353, Common::PT_BRA, 500),

	WINGAME1("amber", "", "amber_jb.exe", "1a7acbba10a7246ba58c1d53fc7203f5", -1, 500),

	// Original file names are ' ANKH2 ' and ' ANKH3 '
	MACGAME1_l("ankh2", "", "ANKH2", "779a44f65837ded641cc3fbbebe5ace1", 721432, Common::JA_JPN, 501),
	MACGAME1_l("ankh3", "", "ANKH3", "f715a3036c1b54ab1121e90388948018", 720456, Common::JA_JPN, 501),

	WINGAME1("arad", "", "arad95nt.exe", "3460ad87d2ba57104e2810a77b53c220", 2623135, 500),

	// Available here: http://web.archive.org/web/20080412010505/http://www.beachware.com/download/
	// Each shareware title plays 1 of 2 arcade games until unlocked with registration code
	// All games are also available and unlocked on the retail BeachWare Arcade Classics CD
	MACGAME1("arcadeboing", "",	"Classic Arcade Boing!", "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME2("arcadeairattack", "", "shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Bomber.Dxr",	"e2409782f6bfa16862fba0437c9cdf3d", 3443518, 501),
	WINGAME2("arcadeboing", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Astro.Dxr",	"4378f9b78697520087e603856f0f2246", 1379858, 501),
	WINGAME2("arcadehockey", "",	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Bumper.Dxr",	"696e88ec6cf6fd9a5c5422f91dd8608a", 681780, 501),
	WINGAME2("arcadelander", "",	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Moon.Dxr",		"66102dd187a016df492c0657beeef3cc", 2008328, 501),
	WINGAME2("arcadesubs", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Caverns.Dxr",	"57bf22de8a2f1822e9259d4a3d8e3f5a", 3188250, 501),

	MACGAME1("arcmedia", "", "MAC.EXE", 	"231d3041df162be4a0ddd36a74eb03b6", 716997, 501),
	WINGAME2("arcmedia", "", "WIN95.EXE", 	"1a7acbba10a7246ba58c1d53fc7203f5", 1411325,
							 "000MAIN.DXR", "0fb364d9201b3b652f575282abb6ea16", 311662, 501),

	WINGAME1("babesintoyland", "", "BABESIN.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411231, 501),

	// Installer is also Director
	WINGAME1_l("backpacker2", "", "bp2new.exe", "842014a812b454620f64b860fd7211f0", 940821, Common::NB_NOR, 501),
	WINGAME1_l("backpacker2", "", "bp2new.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1418983, Common::SE_SWE, 501),

	// Based on the Australian TV children's TV series
	// Swedish released in association with Lattjo Lajban (1998)
	// Brazilian version was released on CD Expert Kids nº 19 (1999)
	WINGAME1("bananasfun", "",   "BIP32.EXE",      "1a7acbba10a7246ba58c1d53fc7203f5", 1410665, 501),
	MACGAME1_l("bananasfun", "", "It's Fun Time!", "07f19d8ae16dd1ffab68540c78fa0b8b", 719743, Common::PT_BRA, 501),
	MACGAME1_l("bananasfun", "", "It’s Fun Time!", "231d3041df162be4a0ddd36a74eb03b6", 719743, Common::SE_SWE, 501),

	WINGAME1("barbssbubbles", "Screensaver", "BUBBLES.EXE", "77c85ac62fdb5a5f1ed40209ca88f78e", 1117695, 501),
	WINGAME1("barbsskisses", "Screensaver", "KISSES.EXE", "77c85ac62fdb5a5f1ed40209ca88f78e", 1145437, 501),
	WINGAME1("barbssshoes", "Screensaver", "SHOES.EXE", "77c85ac62fdb5a5f1ed40209ca88f78e", 1380835, 501),

	MACGAME1("battles", "", "BATTLES OF THE WORLD", "06ed90580400cd9e263525f84c8075fd", 705701, 500),
	WINGAME1("battles", "", "BT_INT32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1400693, 500),

	WINGAME1_l("bigmax", "nº10", "BIG32.EXE", "3460ad87d2ba57104e2810a77b53c220", 4539109, Common::PT_BRA, 500),

	MACGAME1("blender", "Volume 2.5", "Blender (PPC)", "f102e699371fd85eaf57606a1c0b1adc", 94329, 501),
	MACGAME1("blender", "Volume 3.1", "Blender (PPC)", "013ce52c2d8fa0f004fe6d1118448a58", 108119, 501),
	WINGAME2("blender", "Volume 2.5", "BLENDME.EXE",   "2e62abdad839e42068afdcd0644d7dcf", 949909,
									  "OPENING.DIR",   "45cb69d7174a3f93d54e9a5ee1fb9f3b", 2274768, 500),
	WINGAME1("blender", "Volume 3.1", "LNCHR_32.EXE",  "1a7acbba10a7246ba58c1d53fc7203f5", 1421431, 501),

	// Designed by In Chair Viewing (ICV)
	// Binaries provided for Win3.1, Win95, WinNT
	WINGAME1("bluesbros2000", "Windows 95", "Blues95.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410935, 501),
	WINGAME1("bluesbros2000", "Windows NT", "BluesNT.exe", "842014a812b454620f64b860fd7211f0", 932773, 501),

	MACGAME1("bvi1997", "", "BVI", "c148f66ae3511fb88733102aa27efe7e", 718353, 501),
	WINGAME1("bvi1997", "", "BVI95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 9097249, 501),

	// Bilingual English and French
	MACGAME1("canelect", "", "Elect", "6e7e31d05709e1d38d63f4df6a59eec0", 719289, 501),
	WINGAME1("canelect", "", "ELECT_95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1479345, 501),

	// Available here: http://web.archive.org/web/20080412010505/http://www.beachware.com/download/
	// Each shareware title plays one of several casino games until unlocked with registration code
	// The games are also available and unlocked on various retail CDs from BeachWare
	WINGAME2("casinoblackjack", "",	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Black.Dxr",	"c934d66f73149927ce9842ac3b6a6219", 433022, 501),
	WINGAME2("casinokeno", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Keno.Dxr",		"229860fdf77f1d92da7ca23535393597", 314064, 501),
	WINGAME2("casinopoker", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Draw.Dxr",		"56f8b8fa6324b2abc16eafa8aa6ba403", 489404, 501),
	WINGAME2("casinoslots", "", 	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Quarters.Dxr",	"4b91f3fa860cd4de3b0aa167f3afdff3", 527618, 501),

	MACGAME1("cassandra", "", "The Cassandra Galleries", "231d3041df162be4a0ddd36a74eb03b6", 718353, 501),
	WINGAME1("cassandra", "", "GOWIN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 2083273, 501),

	MACGAME1("cezanne", "", "CEZANNE", "8e171256e4811dc976720da230634d87", 705689, 500),
	WINGAME1("cezanne", "", "CEZWIN95.EXE", "3460ad87d2ba57104e2810a77b53c220", 2763107, 500),

	// Series includes Schubert, Tchaikovsky, Mozart, Vivaldi and probably more
	WINGAME1_l("clasplusbee2", "", "BEE2_95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1694421, Common::ES_ESP, 501),

	// Clocks from Let's Play with Sakura CD
	// Windows versions are D6
	// Original filenames follow the entries on each line
	MACGAME1_l("clockkero", "",	  "Kero Tokei",	  "65063397536553c4f6ff2a6c07194bf7", 1602707, Common::JA_JPN, 500), // ケロ時計
	MACGAME1_l("clocksakura", "", "Sakura Tokei", "65063397536553c4f6ff2a6c07194bf7", 1602709, Common::JA_JPN, 500), // さくら時計
	MACGAME1_l("clocktomoyo", "", "Tomoyo Tokei", "65063397536553c4f6ff2a6c07194bf7", 1602707, Common::JA_JPN, 500), // 知世時計

	// Installer uses Director and Authorware
	// Developed by Arome, distributed by Global Star Software
	WINGAME1("cocktailhour", "", "COCKT32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411465, 501),

	MACGAME1("colormind", "v1.5", "ColorMind 1.5", "37faaf693259d7a4fa031f4a2edf3098", 126087, 501),

	MACGAME1_l("crusader", "", "Croisades", "6e7e31d05709e1d38d63f4df6a59eec0", 718381, Common::FR_FRA, 501),
	WINGAME1("crusader", "", "CRUSAD95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427, 501),
	WINGAME1_l("crusader", "", "KREUZZ95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427, Common::DE_DEU, 501),
	WINGAME1_l("crusader", "", "CROISA95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427, Common::FR_FRA, 501),

	WINGAME2("davidsonps", "v1.0", "DPS32.EXE",	  "3460ad87d2ba57104e2810a77b53c220", 1401517,
								   "DPSHOT.DXR",  "d980c9272bc723c57238a31790b71f11", 1354686, 500),
	WINGAME1("davidsonps", "v2.0", "DPS2032.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1425025, 501),
	{
		{
			"davidsonps", "CD",
			AD_ENTRY2s("DPS32.EXE",	 "3460ad87d2ba57104e2810a77b53c220", 1401517,
					   "DPSHOT.DXR", "08b944be3cccdbbe3646fce08f2780f0", 1357970),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_CD | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		500
	},

	// Mini-game from Star Warped can also be launched separately
	MACGAME1("deathstar", "Minigame", "Death Star Destructo", "11aea1c6868839f53cc6312df724364f", 108091, 501),
	WINGAME1("deathstar", "Minigame", "DSD32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 2758841, 501),

	// Windows executables for Win 3.1 and 95; Mac executables for 68k, PPC, and Fat binary
	MACGAME1("dimensionq", "", "Dimension Q", "c148f66ae3511fb88733102aa27efe7e", 719313, 501),
	WINGAME1("dimensionq", "", "DIMENQ95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1416041, 501),
	MACDEMO1("dimensionq", "Trailer", "Dimension Q Trailer", "08d6f6e39fbd8388faf57f602acaebcc", 705702, 500),
	WINDEMO1("dimensionq", "Trailer", "DIMQ95.EXE", "3460ad87d2ba57104e2810a77b53c220", 6877089, 500),

	MACGAME1("dinos", "", "Dinos", "231d3041df162be4a0ddd36a74eb03b6", 718285, 500),
	WINGAME1("dinos", "", "DINO98.EXE", "3460ad87d2ba57104e2810a77b53c220", 1393813, 500),

	MACGAME1_l("djrom", "", "DJ-ROM", "4a3fc901992d82fa2197da9da1be6992", 107828, Common::JA_JPN, 501),
	WINGAME1_l("djrom", "", "DJROM.exe", "38b75ecdedf662326fe4931a68ae60cd", 1823050, Common::JA_JPN, 501),

	// Het Geheim van Dracula, Win versions on same discs are D4
	MACGAME1_l("draculassecret", "", "Dracula.PPC", "65f0701cced8f5c64813e1e0353f0510", 108119, Common::FR_FRA, 501),
	MACGAME1_l("draculassecret", "", "Het geheim", "a4df1e62980bf13fb87cc2598ca72c9e", 95653, Common::NL_NLD, 500),

	// Win version on same discs is D6
	MACGAME1("dynamichuman", "v2.0", "Dynamic Human 2.0", "bfd348abd981acae64c13d5e5e4d9540", 718353, 501),

	MACGAME1("easybass", "", "Bass", 		"231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME2("easybass", "", "WIN95.EXE", 	"1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
							 "322MAIN.DXR", "5f66f50a682be582b7b88444945b45df", 1007992, 501),

	MACGAME1("edmark", "", "Edmark Demo", "d0f3aedb1f7c46853243b6a560440dd7", 705613, 500),
	WINGAME2("edmark", "", "DEMO.EXE", 	  "2e62abdad839e42068afdcd0644d7dcf", 917547,
						   "MAININT",	  "1e995592236894b843c3853906bbee1d", 2935876, 500),

	// Original Mac filename is 江口寿史
	MACGAME1_l("eguchi", "", "Hisashi Eguchi", "552992fb31c736ca67ffd403096596d6", 719909, Common::JA_JPN, 501),
	WINGAME1_l("eguchi", "", "EGU32.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410078, Common::JA_JPN, 501),

	WINGAME1_l("ernie", "", "Ernie.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1417481, Common::SE_SWE, 500),
	WINDEMO1_l("ernie", "Demo", "ERNIE.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1417371, Common::SE_SWE, 500),

	// Developed by Brilliant Interactive Ideas, published by Brainstorm
	MACGAME1("flipper", "", "Flipper!",	  "6e7e31d05709e1d38d63f4df6a59eec0", 718381, 501),
	WINGAME1("flipper", "", "FLIP32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1398201, 500),

	MACGAME1("frankac", "", "Franklin's Activity Center", "06ed90580400cd9e263525f84c8075fd", 705701, 500),
	WINGAME2("frankac", "",	  "NAVIGATE.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917643,
							  "NAVIGATE.DXR", "01549a16ecc542ead343bb2ed8ebf604", 3303124, 500),
	WINGAME2_l("frankac", "", "NAVIGATE.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917643,
							  "NAVIGATE.DXR", "edeb8f86c0579a44f8163a135a30dd90", 4062902, Common::PT_BRA, 500),

	MACDEMO1("franklm", "Demo", "Franklin Learns Math Info", "f637b7b88b82c0772082f84a0b2cf628", 705673, 500),
	WINDEMO1("franklm", "Demo", "FLMINFO.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1119725, 500),

	PIPGAME1("gadget", "", "GADGET", "d7e907d3933869f055ae59774c87f501", 111000, 501),

	MACGAME1("gadgetpaf", "",	"GADGET -Past as Future- (Disc1)", "3b96e0a903130cf68e6f8362bb4d096c", 178907, 501),
	MACGAME1_l("gadgetpaf", "", "GADGET -Past as Future- (Disc1)", "4b2213a9fb04f390ec074c54b916370d", 113425, Common::JA_JPN, 501),
	WINGAME2("gadgetpaf", "",	"GADGET.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411507,
								"TEXT_E.Cxt", "5f14330705974a22deb9a12cd8ae6e79", 691046, 501),
	WINGAME2_l("gadgetpaf", "", "GADGET.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411507,
								"TEXT_E.Cxt", "056ab5419f65fab51fa50c28ad360e76", 561824, Common::ES_ESP, 501),

	MACGAME1("gamingmegapac", "", "Gaming MegaPac", "b861188374e80b1184e7f96dcab4fc9b", 719261, 501),

	// Creators make heads to be used in the full games
	MACGAME1("getaheadmath", "",	"Math Heads (PPC)",	  "b6618c98b209ba70ed7ae7e85e7306ef", 107473, 501),
	MACGAME1("getaheadstrat", "",	"Strategy Heads",	  "f5d1590da086b496507871f12382e973", 719456, 501),
	WINGAME1("getaheadmath", "",	"MATHHD32.EXE",		  "6860e78189ba90c10a46c31d8069fc5f", 1412189, 501),
	WINGAME1("getaheadstrat", "",	"STRATEGY.EXE",		  "3fbb58682d34ce5ec8b774064725b172", 1412265, 501),
	MACGAME1("getaheadmathcr", "",	"Math Heads Creator", "f5d1590da086b496507871f12382e973", 719289, 501),
	MACGAME1("getaheadstratcr", "",	"Creator",			  "f5d1590da086b496507871f12382e973", 719271, 501),
	WINGAME1("getaheadmathcr", "",	"CREATE32.EXE",		  "3fbb58682d34ce5ec8b774064725b172", 1410627, 501),
	WINGAME1("getaheadstratcr", "",	"CREATOR.EXE",		  "3fbb58682d34ce5ec8b774064725b172", 1412265, 501),

	MACGAME1("ghetto", "", "Ghetto 8MB", "35dbf55e70f69e00ca016e3663379970", 704793, 500),
	WINGAME1("ghetto", "", "GHETTO.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917597, 500),

	MACGAME1("giggletour", "", "World Tour", "35dbf55e70f69e00ca016e3663379970", 705681, 500),
	WINGAME1("giggletour", "", "WRLDTR32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1393973, 500),
	MACDEMO1("giggletour", "Trailer", "World Tour Trailer", "08d6f6e39fbd8388faf57f602acaebcc", 705673, 500),
	WINDEMO1("giggletour", "Trailer", "WRLD95.EXE", "3460ad87d2ba57104e2810a77b53c220", 4262595, 500),

	// Green Eggs and Hamulator mini-game
	// Demo for a Living Books game that is supported in MOHAWK engine
	// Found on Disc Inferno from APC magazine (Australia), Dec 1999
	WINDEMO1("greeneggs", "Demo", "seuss95.exe", "3460ad87d2ba57104e2810a77b53c220", 2555603, 500),

	// Demo is from the covermount of Joystick (France) N°77 Dec 1996 (CD-ROM Collection N°19)
	MACGAME1_l("guignols2", "", "Le Cauchemar de PPD", "f3817a8eca9efb143a23b76525dedfa9", 718381, Common::FR_FRA, 501),
	WINGAME1_l("guignols2", "", "CPPD.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1465338, Common::FR_FRA, 501),
	WINDEMO1_l("guignols2", "Demo", "GUIGNOLS.EXE", "2e62abdad839e42068afdcd0644d7dcf", 971988, Common::FR_FRA, 501),

	MACGAME2("gundam0079", "", 	 "Gundam0079",	   "4c38a51a21a1ad231f218c4786ff771d", 107211,
								 "MENU.CST",	   "d4de2296fc46f76cc249b0a1d01e7003", 3580645, 501),
	MACGAME2_l("gundam0079", "", "GUNDAM0079",	   "4c38a51a21a1ad231f218c4786ff771d", 107211,
								 "MENU.Cxt",	   "730d60b0f5fbc925a01b04319c50e59d", 2862062, Common::JA_JPN, 501),
	WINGAME1("gundam0079", "", 	 "Gundam0079.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1411761, 501),

	MACGAME1("gussshc", "", "Write On", "9e9309ff1b58f6b56a440893e9723bd6", 705585, 500),
	WINGAME1("gussshc", "", "SCHOOL.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917645, 500),

	// Sourced from Dimension Q disc
	MACGAME1("headbone", "Sampler 2", "Sampler 2",	 "35dbf55e70f69e00ca016e3663379970", 705671, 500),
	WINGAME2("headbone", "Sampler 2", "SAMPLER.EXE", "c3c38bd3907ca7e13220b74bd0317a6c", 1019877,
									  "DEMOS.DXR",	 "d8c086a6879d092b409110f9bf5b93de", 3016920, 500),

	// Hoffman + Associates previews. Found on Nikolai in Outer Space.
	WINGAME1("hoffman", "", "HARUNNER.EXE", "3460ad87d2ba57104e2810a77b53c220", 1458773, 500),

	// Later Win demo found on Math Heads CD
	MACDEMO1("hollywoodhigh", "Demo", "Hollywood Hot Shot", "3ecbe87870ab4b0c0acb10a9e22eb561", 705674, 500),
	WINDEMO1("hollywoodhigh", "Demo", "HOTSHOT.EXE", "2e62abdad839e42068afdcd0644d7dcf", 9949661, 500),
	WINDEMO1("hollywoodhigh", "Demo", "HOTSHOT.EXE", "5b056b97e60209a45665e27ff39d8010", 10066133, 501),

	// Win version must be installed in 32-bit Windows to extract executable
	WINGAME1_l("horrortour3", "", "HT3.exe", "3460ad87d2ba57104e2810a77b53c220", 5128359, Common::JA_JPN, 500),
	MACGAME1_l("horrortour3", "", "HT3", "b545372e9f6e9351d4119af9258d8de0", 108736, Common::JA_JPN, 500),

	// Distributed with IBM Aptiva PCs
	WINGAME2("ibmcdextra", "", "SAMPLER.EXE", "2e62abdad839e42068afdcd0644d7dcf", 929109,
							   "SAMPMM.DIR",  "0a17bfdfbd2413932af9d1578419b4e3", 4642820, 500),

	// Installers for both platforms also use Director
	MACGAME1_l("incarnatia", "", "incarnatia_PowerMac", "2e7d373f75c014be20cfb04c5cd65dae", 108736, Common::JA_JPN, 501),
	WINGAME1_l("incarnatia", "", "incarnatia_Win.exe", "38b75ecdedf662326fe4931a68ae60cd", 1414152, Common::JA_JPN, 501),

	// Australian Broadcasting Corporation (ABC) has made this available for free download
	// https://www.abc.net.au/science/ingenious/patch.htm
	MACGAME1("ingenious", "",   "Ingenious",   "f5d1590da086b496507871f12382e973", 754833, 501),
	WINGAME1("ingenious", "",   "INGW95.EXE",  "3460ad87d2ba57104e2810a77b53c220", 1398293, 500),
	MACGAME1("ingenioused", "", "EdRes",       "f5d1590da086b496507871f12382e973", 754807, 501),
	WINGAME1("ingenioused", "", "EDRES95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1417113, 501),

	// Later releases are titled "I Spy School Days"
	// Bilingual Spanish/English release by Star E-Media of Orange County, California
	MACGAME1("ispy", "",	  "Play I Spy",	 "6e7e31d05709e1d38d63f4df6a59eec0", 719289, 501),
	MACGAME1("ispy", "Star",  "I Spy",		 "6e7e31d05709e1d38d63f4df6a59eec0", 719338, 501),
	MACGAME1_l("ispy", "",	  "Veo, Veo",	 "83bbffe673e902df8fa3e99067f73cb0", 704745, Common::ES_ESP, 500),
	WINGAME1("ispy", "",	  "Ispy95.exe",	 "1a7acbba10a7246ba58c1d53fc7203f5", 1443421, 501),
	WINGAME1_l("ispy", "",	  "veo-veo.exe", "3460ad87d2ba57104e2810a77b53c220", 1433357, Common::ES_ESP, 500),
	WINGAME1_l("ispy", "",	  "Ispy95.exe",	 "1a7acbba10a7246ba58c1d53fc7203f5", 1437966, Common::RU_RUS, 501),

	// Original filename is Internet The City™
	MACGAME1("itc", "", "Internet The City", "4ab012350c6e1c39eda772e33df30cea", 719289, 501),

	// Later released as Jewels II: The Ultimate Challenge
	MACDEMO1("jewels2", "Demo", "Jewels II", "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME1("jewels2", "", "JewsII95.exe", "3460ad87d2ba57104e2810a77b53c220", 1454223, 500),

	MACGAME1("jslearn", "1997 D5 Demo", "JumpStart Previews", "231d3041df162be4a0ddd36a74eb03b6", 718745, 501),
	WINGAME1("jslearn", "1997 D5 Demo", "PREV32A.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411155, 501),

	MACGAME1("maccubed7", "", "Let's Go! Internet & Utilities", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705613, 500),

	// Original Mac Pre-K filename contains non-printable character
	// Full games do not use Director except for Progress Report utilities
	MACDEMO1("madcc12", "Demo",	"Madeline 1st & 2nd Grade Demo", "32c629eab7202d758c52c758493f1847", 719261, 501),
	MACDEMO1("madccpk", "Demo", "Madeline Pre-K Demo", "32c629eab7202d758c52c758493f1847", 719261, 501),
	WINDEMO1("madcc12", "Demo",		 "MAD12.EXE",  "842014a812b454620f64b860fd7211f0", 932335, 501),
	WINDEMO1("madcc12", "Slideshow", "SLIDES.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1192485, 501),
	WINDEMO1("madccpk", "Demo",		 "MADPK.EXE",  "842014a812b454620f64b860fd7211f0", 932303, 501),

	WINGAME1_l("maria", "", "MARIA1.EXE", "3460ad87d2ba57104e2810a77b53c220", 6727617, Common::JA_JPN, 500),

	MACDEMO1("mavisbeacon", "v5.0 Demo", "Mavis 5 Demo 12_12", "35dbf55e70f69e00ca016e3663379970", 703409, 500),

	// Original Mac filename is Demonstraciä
	// Found on Russian Max 3 CD from NRG
	MACGAME1_l("max1max2", "Demo", "Demonstracia", "06ed90580400cd9e263525f84c8075fd", 705673, Common::RU_RUS, 500),

	// On hybrid CD with Joystick (France) covermount
	// Original filenames use N° instead of No
	MACGAME1_l("mieuxmieux", "N°16", "CD Mieux-Mieux No16", "227fcce08de8028e2201f5f4eb3b3cc3", 720132, Common::FR_FRA, 501),

	WINGAME1_l("missihb", "", "MISS95.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410206, Common::JA_JPN, 501),

	WINGAME1("mmalgebra", "", "mmalgbra.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1887007, 501),

	// Apple Masters of Media #011
	MACGAME1_l("mmedia11", "", "Making of SAKURA", "bef2a1951fe8853c36f7313940040cb6", 717656, Common::JA_JPN, 501),

	MACGAME1("mmmath3", "", "Mission Masters Math 3", "ec6fba1c2d0fd9dbe987f4336cb08e2b", 718381, 501),
	WINGAME1("mmmath3", "", "INTRO323.EXE", "d82e8bf2e13128be8b1c2a6afe536308", 1415493, 501),

	WINGAME1("msn", "Preview", "MSNPREV8.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 5215403, 501),

	WINGAME2("muppetkidsearly5", "",   "bright32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 2159587,
									   "sndpats.dir",  "5d1c7b91fcb9cfc0ea438bb09b968df1", 1369944, 501),
	WINGAME2("muppetkidsthinking", "", "bright32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 2159587,
									   "thinkskl.dir", "8a6267e64700117ee7ebaab48316741d", 1504798, 501),

	MACGAME1_l("murderbrett", "", "Brad, le surfeur", "227fcce08de8028e2201f5f4eb3b3cc3", 720160, Common::FR_FRA, 500),
	WINGAME1_l("murderbrett", "", "BRAD.EXE", "e1c3cb4df694b887f3708f9ebb72302f", 934342, Common::FR_FRA, 500),

	// Found on PC World (Czechia) Sept 2003
	WINGAME2_l("nemcina", "", "START_32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1710313,
							  "CVIC.DXR",     "8f12d20e12dddc2fc3207e1f4e571d17", 23223862, Common::CZ_CZE, 500),

	// All original Mac filenames end with ™
	// Nikolai in Outer Space did not get a Mac release
	MACGAME1("nikolaiknights", "v2.0", "Nikolai\'s Knights",   "c43bfadda9be111e461dc0b735430ad3", 720690, 501),
	MACGAME1("nikolaimystery", "",     "Nikolai\'s Mysteries", "c43bfadda9be111e461dc0b735430ad3", 719241, 501),
	MACGAME1("nikolaipirates", "",     "Nikolai\'s Pirates",   "c43bfadda9be111e461dc0b735430ad3", 719289, 501),
	WINGAME1("nikolaiknights", "v2.0", "KNIGHT95.EXE",         "1a7acbba10a7246ba58c1d53fc7203f5", 1410541, 501),
	WINGAME1("nikolaipirates", "",     "PIRATE95.EXE",         "3460ad87d2ba57104e2810a77b53c220", 1394017, 500),
	WINGAME1("nikolaispace", "",       "0_LAUNCH.EXE",         "3460ad87d2ba57104e2810a77b53c220", 1394291, 501),

	// spaceedu module can also be launched externally
	WINGAME1("nikolaispaceedu", "", "spaceedu.exe", "3460ad87d2ba57104e2810a77b53c220", 1394307, 500),

	// Both versions require installation to extract executable
	MACGAME1("nine", "", "The Last Resort", "957d819f99e30d54f68824ebe3d5d4ae", 730760, 500),
	WINGAME1("nine", "", "nine_95.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1555823, 501),

	WINGAME1("noir", "", "NOIR.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1020879, 500),

	WINDEMO1("orly", "Demo", "_ORLYDEM.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917641, 500),

	MACDEMO1_l("osaka2", "Demo", "OSAKA2",	   "2e75b0d7a218c71d5dd00a27eb755f00", 719012, Common::JA_JPN, 501),
	WINDEMO1_l("osaka2", "Demo", "OSAKA2.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410110, Common::JA_JPN, 501),

	WINGAME1("parliament", "", "GUIDE.EXE", "2e62abdad839e42068afdcd0644d7dcf", 918871, 500),

	// Screen savers from Perfect Blue (requires installation)
	MACGAME1("pbdisplay", "",   "Display",      "687fa112eefc7ff11ed97ab0dce67401", 806915, 501),
	MACGAME1("pbflash", "",     "Flash",        "687fa112eefc7ff11ed97ab0dce67401", 806913, 501),
	MACGAME1("pbmima", "",      "MIMA",         "687fa112eefc7ff11ed97ab0dce67401", 806912, 501),
	MACGAME1("pbosakana", "",   "OSAKANA",      "687fa112eefc7ff11ed97ab0dce67401", 806915, 501),
	MACGAME1_l("pbtoilet1", "", "Toilet1",      "687fa112eefc7ff11ed97ab0dce67401", 806915, Common::JA_JPN, 501),
	MACGAME1_l("pbtoilet2", "", "Toilet2",      "687fa112eefc7ff11ed97ab0dce67401", 806915, Common::JA_JPN, 501),
	WINGAME1("pbdisplay", "",   "INSTALL1.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2339226, 501),
	WINGAME1("pbflash", "",     "INSTALL2.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2181972, 501),
	WINGAME1("pbmima", "",      "INSTALL6.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1517124, 501),
	WINGAME1("pbosakana", "",   "INSTALL3.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1665350, 501),
	WINGAME1_l("pbtoilet1", "", "INSTALL4.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2878548, Common::JA_JPN, 501),
	WINGAME1_l("pbtoilet2", "", "INSTALL5.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2836264, Common::JA_JPN, 501),

	// Also calls external files such as pdf, html, midi
	WINGAME2("pcwuk", "Disc no.4", "FILE.EXE",	   "842014a812b454620f64b860fd7211f0", 968431,
								   "INTPCW12.DXR", "85c81b0cf75a2576568026c7b55d5f17", 254794, 501),

	// Initial language selection for Portuguese, Spanish or English
	// Mac executable to be renamed from Perdido na Amazônia
	MACGAME1("perdido", "", "Perdido na Amazonia", "ddaaf48a4becb8fec47508ecd38b9c12", 717025, 501),
	WINGAME1("perdido", "", "AMAZW95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1413431, 501),

	// Original Mac filename is そらいろナイト
	MACGAME1_l("perfectblue", "", "xn--n8j6b4gra9i6ima", "687fa112eefc7ff11ed97ab0dce67401", 718381, Common::JA_JPN, 501),
	WINGAME1_l("perfectblue", "", "PERFECTB.EXE", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1420772, Common::JA_JPN, 501),

	WINGAME1_l("pettson1", "", "PETT32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1430755, Common::SE_SWE, 501),

	WINDEMO1("picasso", "Demo", "PICASS32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1413437, 500),

	// Later releases are D6
	// Multi3 disc from Zeta Multimedia (Barcelona) contains Brazil/Catalan/Spanish
	MACGAME1("pingu1", "",		"Pingu CD-ROM", "35dbf55e70f69e00ca016e3663379970", 705701, 500),
	WINGAME2("pingu1", "1282A", "PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "2e604dfd80ce4189dc0162dbe47ca7e2", 478854, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "e56af5ddd0750b8ec04cb4ea3d707066", 489234, Common::CA_ESP, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "2b0c09c2aab5064afd0006fc33579d52", 482580, Common::ES_ESP, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "3c4192601421a1eee08bb6b8f0c33b84", 481270, Common::PT_BRA, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"Pintitle.dxr", "7244d4a9cca1ef8d665b11639233a7d6", 524602, Common::SE_SWE, 500),

	// Included with Pingu 1. Contains no text nor speech.
	// Mac version uses a different projector for each screen saver
	WINGAME1("pinguss", "GSP",	"PINGU_SS.EXE", "2e62abdad839e42068afdcd0644d7dcf", 918527, 500),
	WINGAME1("pinguss", "Zeta", "Pingu_ss.exe", "2e62abdad839e42068afdcd0644d7dcf", 918549, 500),
	MACGAME1("pingufish",  "Screen Saver", " PINGU - Fish Chase",	  "35dbf55e70f69e00ca016e3663379970", 799260, 500),
	MACGAME1("pingufight", "Screen Saver", " PINGU - Snowball Fight", "35dbf55e70f69e00ca016e3663379970", 799260, 500),
	MACGAME1("pingustorm", "Screen Saver", " PINGU - Snow Storm",	  "35dbf55e70f69e00ca016e3663379970", 799260, 500),
	MACGAME1("pingustunt", "Screen Saver", " PINGU - Stunt Pingu",	  "35dbf55e70f69e00ca016e3663379970", 799260, 500),
	MACGAME1("pingutime",  "Screen Saver", " PINGU - Time for Pingu", "35dbf55e70f69e00ca016e3663379970", 799282, 500),

	// Found on Sierra On-Line's MasterCook Cooking Light v4.0 (1996)
	// There are no Mac demos on this disc
	WINDEMO1("powerchess", "Demo", "PCHESW95.EXE", "3460ad87d2ba57104e2810a77b53c220", 1400353, 500),

	WINGAME1("princetonsat98", "", "sat98_32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1446775, 501),

	// "Making of Pyst" parody video is from X-Fools
	MACGAME1("pyst", "", "PYST", "8a99f02ecc7f918d85be99a0cd718107", 7015, 501),
	WINGAME1("pyst", "", "PYST32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411439, 501),
	WINGAME1("pystmake", "", "PYST32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1464563, 501),

	// Full game was not released. Windows previews differ on Star Warped and X-Fools discs.
	MACDEMO1("pyst2", "Preview", "Driven Preview", "8a093239a2bbfd73269bc70f873c69b8", 108091, 501),
	WINDEMO1("pyst2", "Preview", "DRIVEN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1464207, 501), // star warped
	WINDEMO1("pyst2", "Preview", "DRIVEN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1464241, 501), // x-fools

	MACGAME1_l("ravensburger", "", "Ravensburger Demo", "aaebd553081fa7382390dc8366623035", 720369, Common::DE_DEU, 501),
	WINGAME2_l("ravensburger", "", "START.EXE",			"65ef7246e9ab04aff59fb734e9551727", 1076085,
								   "SPIELBAR.DXR",		"869c9c88894c73510341c7ce63b9be36", 495092, Common::DE_DEU, 501),

	MACGAME1_l("raveshuttle", "", "Rave Shuttle", "7b0837f93c5de519acdf1feea2a4ccf2", 705673, Common::DE_DEU, 500),
	WINGAME1_l("raveshuttle", "", "RAVES.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1000911, Common::DE_DEU, 500),

	// Released only in Japan by Interlink of Minato City, Tokyo (1997)
	// Games play fully in English with Japanese credits only
	MACGAME1("rodneyab", "",  "ArtBrain",	  "4023a53e495618c3edb90531e09dc2d0", 720449, 501),
	WINGAME1("rodneyab", "",  "ARTBRAIN.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410136, 501),
	MACGAME1("rodneyfs2", "", "FunScreen2",	  "4023a53e495618c3edb90531e09dc2d0", 719253, 501),
	WINGAME1("rodneyfs2", "", "FSCREEN2.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1412242, 501),

	MACGAME1_l("rolypolys", "", 	 "ROLY_PPC", 	 "7f6e753dda02c8aca539b21e1d3a0108", 127326, Common::JA_JPN, 501),
	MACDEMO1_l("rolypolys2", "Demo", "CatchUp!", 	 "1da813df08575abf9f94ec1151852005", 738510, Common::JA_JPN, 501),
	WINGAME1_l("rolypolys", "", 	 "KOTOWZ32.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1411360, Common::JA_JPN, 501),
	WINDEMO2_l("rolypolys2", "Demo", "DEMO32.EXE", 	 "38b75ecdedf662326fe4931a68ae60cd", 1411230,
									 "DEMO.DXR", 	 "eef8ef25462ea82637af5ab730d3c684", 10075784, Common::JA_JPN, 501),

	WINGAME1("safecracker", "", "sc_eng.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1415977, 501),

	// Published by the University of Arizona and the Environmental Education Exchange
	MACGAME1("saguaro", "", "SCInstall", "ec6fba1c2d0fd9dbe987f4336cb08e2b", 719261, 501),
	WINGAME1("saguaro", "", "SCWIN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1417616, 501),

	// Use 32-bit Windows executable in SUPPORT/WIN_95
	MACGAME1("saillusion", "", "Illusion", "3f3285490a1764d200c9a82041bf4937", 719289, 501),
	MACGAME1_l("saillusion", "", "Illusion", "06ed90580400cd9e263525f84c8075fd", 705673, Common::DE_DEU, 500),
	WINGAME1("saillusion", "", "ILLUSION.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411175, 501),
	WINGAME1_l("saillusion", "", "Illusion.exe", "1c1fa9c5797b8d2cdc04ad283d9e41d7", 1412949, Common::DE_DEU, 501),

	// Catalogue is found on Surfacing ECD
	// Windows version calls catalogue from ECD main menu
	MACGAME1("sarahcatalog", "",	  "Cat player",		 "b861188374e80b1184e7f96dcab4fc9b", 718353, 501),
	MACGAME1("sarahsurfacing", "ECD", "surf ecd Player", "06ed90580400cd9e263525f84c8075fd", 704765, 501),
	WINGAME1("sarahsurfacing", "ECD", "RUNME32.EXE",	 "3460ad87d2ba57104e2810a77b53c220", 1462645, 501),

	MACGAME1("sauniverse", "", "UNIVPPC", "f488a0465587e739b67e53d224449b9a", 94329, 500),
	WINGAME1("sauniverse", "", "UNIV32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1468873, 501),

	MACGAME1("secretpaths1", "", "Secret Paths in the Forest", "4f0fb528e9c495fd2822ad400178e7a8", 717027, 501),
	WINGAME1("secretpaths1", "", "Secret Paths in the Forest.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1425465, 501),

	// From SHR Math Essentials Disc 2
	MACDEMO1("shr1st2nd", "Demo", "Grades 1 & 2 Essentials Demo", "9f75f1febafbb9224db5e45f39bf21a6", 719289, 501),
	MACDEMO1("shr3rd4th", "Demo", "SHR 3_4 Demo", "231d3041df162be4a0ddd36a74eb03b6", 716997, 501),
	WINDEMO1("shr1st2nd", "Demo", "SHR12.EXE", "842014a812b454620f64b860fd7211f0", 932325, 501),
	WINDEMO1("shr3rd4th", "Demo", "SHR34.EXE", "842014a812b454620f64b860fd7211f0", 932323, 501),

	// From SHR Math Essentials Disc 1
	MACGAME1("shrmath", "", "SHR Math Rock", "6e7e31d05709e1d38d63f4df6a59eec0", 728723, 501),
	MACGAME1("shrmath", "Parents and Teachers Corner", "Parents & Teachers Corner", "2d2ac01320f4c2dce8e156cda5c73fe8", 719261, 501),
	MACGAME1("shrmath", "Print Activities", "Print Activities", "4f2c70510b4cbedf758cf9958d218e6e", 705673, 500),
	WINGAME1("shrmath", "", "SHRM_W95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 4056173, 501),
	WINGAME1("shrmath", "Parents and Teachers Corner", "CORNER95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1413323, 501),
	WINGAME1("shrmath", "Print Activities", "PRINTPAK.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917721, 500),

	WINDEMO1("shrmess", "Demo", "SHRMESS.EXE", "842014a812b454620f64b860fd7211f0", 932319, 501),

	// Created by Tony Clemens, Desktop Wizard (1997)
	WINGAME1("simpsontrivia", "v3.1", "Simpsons Trivia.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 2355677, 501),

	// Developed by Mary Boies Software, published by Creative Wonders
	// Windows version also found in Middle School Advantage 2001 bundle
	MACGAME1("slamdunktyping", "",     "Slam Dunk Typing", "5683c6b3956a3bca7fb5fc5bbb237984", 719201, 501),
	WINGAME1("slamdunktyping", "",     "SDT95.EXE",        "1a7acbba10a7246ba58c1d53fc7203f5", 1840781, 501),
	WINDEMO1("slamdunktyping", "Demo", "SDTDEMO.EXE",      "842014a812b454620f64b860fd7211f0", 932727, 501),
	WINDEMO1("slamdunktyping", "Demo", "SLAMDUNK.EXE",     "1a7acbba10a7246ba58c1d53fc7203f5", 3143069, 501),
	MACDEMO1("slamdunktyping", "Demo", "Mac Slam Dunk",    "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),

	// Polish version is from the covermount of CyberMycha 07/2002
	WINGAME1_l("snow7han", "", "Snw7han.exe", "65ef7246e9ab04aff59fb734e9551727", 941245, Common::PL_POL, 501),

	// Original filename is 僐儗僋僔儑儞.exe
	WINGAME1_l("spawncollection", "", "Spawn32.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2768388, Common::JA_JPN, 501),

	MACGAME1("spellingbee", "", "SPELLING",	   "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME2("spellingbee", "", "WIN95.EXE",   "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								"136MAIN.DXR", "b46fe5ee3a0903bb763121059cee2c06", 679554, 501),

	// Windows provides 640x480 and 800x600 movies; Mac provides 640x480 and 832x624 movies
	// Created by Unis Multimedia, Hollywood, California (1996) using CinéMac 1.2.2c
	// The low- and hi-res movies have the same filenames, so there can be only one installed at a time
	MACGAME1("sshighlander", "v1.10e", "Highlander Screen Saver", "6b91ac61174d6a07bea6a8820a1fe172", 802522, 500),
	WINGAME1("sshighlander", "", "Highlander Screen Saver.exe", "3460ad87d2ba57104e2810a77b53c220", 1976229, 500),

	// Screen savers found on Let's Play with "Sakura" activity CD
	// Windows versions on same disc are D6
	// Original filenames follow the entries on each line
	MACGAME1_l("sskero", "",	 "Kero",		 "65063397536553c4f6ff2a6c07194bf7", 1608622, Common::JA_JPN, 500), // ケロ
	MACGAME1_l("sssakura", "",	 "Sakura",		 "65063397536553c4f6ff2a6c07194bf7", 1608788, Common::JA_JPN, 500), // さくら
	MACGAME1_l("ssyamazaki", "", "Yamazaki-kun", "65063397536553c4f6ff2a6c07194bf7", 3693218, Common::JA_JPN, 500), // 山崎君
	MACGAME1_l("ssyukito", "",	 "Yukito-san",	 "65063397536553c4f6ff2a6c07194bf7", 4867440, Common::JA_JPN, 500), // 雪兎さん

	// Found on Revolutionary War Picture CD from Holiday Digital Pictures
	MACGAME1("ssrevwar", "", "Revolutionary War Screen Saver", "43234754a346ed7ac25b581f6d106866", 218094, 500),

	// Mac version requires installation
	// Preview is from X-Fools disc
	MACGAME1("starwarped", "", "Star Warped", "d2531c0b8c0553be7c7cd5f6c6a07b78", 108091, 501),
	WINGAME1("starwarped", "", "STARW32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1863971, 501),
	WINDEMO1("starwarped", "Preview", "EWOK32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411571, 501),

	MACGAME1("staytooned", "", "Power Mac Stay Tooned!", "d692140f81aaf86096538f66d6477404", 94301, 500),
	WINGAME2("staytooned", "", "START32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1394421,
							   "PROJECT.DXR", "6490c4706e8b72b61c01a7eb1a39a96c", 2828130, 500),

	MACGAME2("takeru",   "Chapter 1", "Takeru",		  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu.Dxr",	  "2c0e5edc98e83efd468d9927395d809a", 3024360, 501),
	MACGAME2("takeru",   "Chapter 2", "Takeru2",	  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu2.Dxr",	  "59fc8473757d5f05b92bd38622771cb9", 3052200, 501),
	MACGAME2_l("takeru", "Chapter 1", "Takeru",		  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu.Dxr",	  "bc2f80a2535d06afeff8c5faf369d7c4", 3014370, Common::DE_DEU, 501),
	MACGAME2_l("takeru", "Chapter 2", "Takeru2",	  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu2.Dxr",	  "98f7ef959aa84c3b14fa8a2bd741fcf2", 3080880, Common::DE_DEU, 501),
	WINGAME2_l("takeru", "Chapter 1", "TAKERU32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411857,
									  "A_FIRST.DXR",  "6d6ed808178aa818746f24ab5de13e99", 10236, Common::DE_DEU, 501),
	WINGAME2_l("takeru", "Chapter 2", "TAK_2_32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411337,
									  "A_SECOND.DXR", "2b3b43f4c2239bcf49a5ffd7ca4bd57f", 9712, Common::DE_DEU, 501),
	WINGAME2("takeru", 	 "Chapter 1", "TAKERU32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411857,
						 			  "A_FIRST.DXR",  "a974472966857faa6039140ccd125a48", 10230, 501),
	WINGAME2("takeru",	 "Chapter 2", "TAK_2_32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411337,
									  "A_SECOND.DXR", "c2d0c64659f18d1c53ad48371125d6a0", 9706, 501),
	WINDEMO1("takeru", 	 "Demo",	  "TAKERU32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1395275, 500),

	// Original Mac filename is 完全探偵ﾏﾆｭｱﾙ.ppc
	MACGAME1_l("tantei", "", "Tantei.ppc", "2e8327655bfb5602e0ec40792949925f", 108736, Common::JA_JPN, 501),
	WINGAME1_l("tantei", "", "TANTEI.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410270, Common::JA_JPN, 501),

	MACGAME1_l("teddybear", "", "Teddy Bear", "f117b8395c4859d11b9c02c741e22cea", 704793, Common::FR_FRA, 500),
	WINGAME1_l("teddybear", "", "BEAR95.EXE", "3460ad87d2ba57104e2810a77b53c220", 1394051, Common::FR_FRA, 500),

	MACGAME1("troubleshoot101", "Basic", "Troubleshooting 101 IA", "62e979424add2428daa835610fb83864", 719261, 501),
	MACGAME1("troubleshoot101", "Music", "Troubleshooting 101 IA w MUSIC", "222fbd020a3910ef748724945145771c", 719261, 501),

	// Original filename is ﾂｲﾝﾋﾞｰPARADISE in どんぶり島.exe
	WINGAME1_l("twinbeeparadise", "", "TwinBee PARADISE in Donburi Shima.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1410246, Common::JA_JPN, 501),

	WINDEMO2_l("ukiuki3", "Demo", "S.EXE",	  "f7bf3d09655f30ba327810f010150004", 1035432,
								  "LOGO.DIR", "7cd32d690ffaaf21c75ccfb9507a712d", 1052642, Common::JA_JPN, 501),
	{
		{
			"ukiuki3", "CD Demo",
			// Original filename is 幻の天狗池.EXE
			AD_ENTRY1s("BOAT95.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410860),
			Common::JA_JPN,
			Common::kPlatformWindows,
			ADGF_DEMO | ADGF_CD | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		501
	},

	MACGAME1("vp2", "", "VPhys2", "cb91232ecece0045461d236d5914c03d", 719261, 500),
	MACDEMO1("vp2", "Demo", "VP2Demo", "cb91232ecece0045461d236d5914c03d", 719261, 500),
	WINGAME1("vp2", "", "VPHYS2.EXE", "c3c38bd3907ca7e13220b74bd0317a6c", 1021347, 500),
	WINDEMO1("vp2", "Demo", "VP2DEMO.EXE", "c3c38bd3907ca7e13220b74bd0317a6c", 1021353, 500),

	MACGAME1("wine", "", "double-click me!", "231d3041df162be4a0ddd36a74eb03b6", 719289, 501),
	WINGAME2("wine", "", "WIN95.EXE", 		 "1a7acbba10a7246ba58c1d53fc7203f5", 1411337,
						 "160MAIN.DXR", 	 "23dbb4744121b077d331b01123709519", 592640, 501),

	// Both Mac and Windows require HD install
	MACGAME1("wishbone", "", "Odyssey", "15a4144726d15488814dab951ec7c3ff", 94329, 500),
	WINGAME1("wishbone", "", "ODYSSEY.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1026617, 500),

	MACGAME1("womanengineer", "", "PowerPC", "6710977cfafc46ebe050897e01719f89", 105855, 501),
	WINGAME1("womanengineer", "", "ENG32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1823493, 501),

	// Original Mac filenames are ハラペコ
	MACGAME1_l("ybr3", "", "Harapeco", "0dab15dae11b5458512beb4ac85cafc1", 113641, Common::JA_JPN, 501),
	WINGAME1_l("ybr3", "", "YBRH.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410805, Common::JA_JPN, 500),
	MACGAME1_l("ybr3", "Single", "Harapeco", "4ab012350c6e1c39eda772e33df30cea", 723903, Common::JA_JPN, 500),
	WINGAME1_l("ybr3", "Single", "YBRSingl.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410799, Common::JA_JPN, 500),

	// Developed by Kodansha Co. of Bunkyo, Tokyo
	// Original Mac filename is 妖怪図鑑1
	MACGAME1_l("yokai200", "", "xn--1-we0by4fq4jlr4e", "5b6db61d580e40b903a7f0797b0bdad7", 719012, Common::JA_JPN, 501),
	WINGAME1_l("yokai200", "", "YOUKAI1.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1411170, Common::JA_JPN, 501),

//////////////////////////////////////////////////
//
// Macromedia Director v6
//
//////////////////////////////////////////////////

	// Disney's 101 Dalmations
	WINGAME1("101pet", "", "101pet.exe", "d62438566e44826960fc16c5c23dbe43", 1862441, 650),

	MACGAME1("10plus2", "", "10plus2 PPC", "22e2e91bed55f087b739983679e4a0ff", 114739, 600),
	WINGAME2("10plus2", "", "START95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1508485,
							"START.Dir",   "b9f7a692dce72c30e54325c4a957e582", 9290, 600),

	WINGAME1("1stcdtoddler", "", "_dkilbbt.exe", "d62438566e44826960fc16c5c23dbe43", 2012554, 650),

	WINGAME1_l("3iadins", "", "TVC.EXE", "d62438566e44826960fc16c5c23dbe43", 1777420, Common::CA_ESP, 650),

	// Created by NOVA Online for PBS / WGBH Boston
	// Companion app for NOVA episode "Special Effects: Titanic and Beyond"
	// Original PBS Airdate: November 3, 1998
	// https://www.pbs.org/wgbh/nova/specialfx2/
	// Win9X version found on apcmag.cd Dec 1999 disc 3, published by Australian Consolidated Press
	MACGAME1("50ftchicken", "",		   "NOVA_Chicken", "7b83483a881626b278258c109c1bd3b4", 1030370, 602),
	WINGAME1("50ftchicken", "Win 9X",  "NOVAchi9.exe", "a593079aecf5bd938ce75264cac24b2d", 1637982, 600),
	WINGAME1("50ftchicken", "Win 3.x", "NOVAchi3.exe", "b0f3841f6e8005e519445b22de37749b", 1259932, 600),
	SHKGAME1("50ftchicken", "",		   "chicken.dcr",  "55fa0c9afa4ee4102b50258544fc28d4", 442575, 600),

	// Published by Future Soft of Nasr City, Cairo
	WINGAME1_l("abctrain", "", "abc.exe", "a593079aecf5bd938ce75264cac24b2d", 2091687, Common::AR_ARB, 600),

	// Mini-game from X-Fools can also be launched separately
	WINGAME1("abductthis", "", "ABDUCT32.EXE", "a593079aecf5bd938ce75264cac24b2d", 3644633, 600),

	MACGAME1("afiles", "", "The A-Files", 	"63e8b9f6744efefbb8a004a2b76e2b1d", 118530, 602),
	WINGAME2("afiles", "", "Projector.exe", "4c850adf7c36a9a3dea64c880eaf25c0", 1515545,
						   "intro.dir", 	"8030f92799c85ab5a6fd1c23f4ce6734", 396047, 602),

	// Cherry Coke Presents a Myst clone
	MACGAME1("alanna", "", "Alanna", "05c94e6fcb102f9fa795e354c956b28e", 1029257, 600),

	MACGAME1("amertailmb", "", "An American Tail MB", "41fa2186d635be3094403c75b5f44d4b", 115647, 600),
	WINGAME1("amertailmb", "", "Amer32.exe", "518a98696fe1122e08410b0f157f21bf", 2075235, 602),

	// Full game is not Director; no Director content on Disc 2
	MACDEMO1("amgpremiere", "Advanced Tutorial", "Advanced Tutorial", "ddfa76b82cb37f6349b55f13ff5b034a", 1026901, 600),
	MACDEMO1("amgpremiere", "Beginning Tutorial", "Beginning Tutorial", "ddfa76b82cb37f6349b55f13ff5b034a", 1026901, 600),
	MACDEMO1("amgpremiere", "Director's Guide", "Director's Guide", "ddfa76b82cb37f6349b55f13ff5b034a", 1026901, 600),
	WINDEMO1("amgpremiere", "Advanced Tutorial", "ADVTUTOR.EXE", "a593079aecf5bd938ce75264cac24b2d", 3019357, 600),
	WINDEMO1("amgpremiere", "Beginning Tutorial", "BEGTUTOR.EXE", "a593079aecf5bd938ce75264cac24b2d", 2078039, 600),
	WINDEMO1("amgpremiere", "Director's Guide", "DIRGUIDE.EXE", "a593079aecf5bd938ce75264cac24b2d", 2070484, 600),

	// Fun Pack is on the Party Time CD
	WINGAME1("bananaspack", "", "_Fun_Pack.exe", "a593079aecf5bd938ce75264cac24b2d", 1508656, 600),
	WINGAME1("bananasparty", "", "_Party_Time.exe", "a593079aecf5bd938ce75264cac24b2d", 1508811, 600),

	WINGAME2("barbnail", "", "LAUNCH.EXE", "518a98696fe1122e08410b0f157f21bf", 1758656,
							 "intro.dxr",  "8732eb742a8bbfd6de5c55b22e41317b", 2549490, 602),

	// Part of box set with music CD and photo book
	MACGAME1("bettypage", "", "Betty", "be947e969e358cc77e6a96ee42bab3f1", 1031674, 601),
	WINGAME1("bettypage", "", "betty.exe", "a593079aecf5bd938ce75264cac24b2d", 1510046, 600),

	WINGAME1_l("bigmax", "nº20", "BIG32.EXE", "518a98696fe1122e08410b0f157f21bf", 7313980, Common::PT_BRA, 602),

	// From Soleau Software, New York, a member of the Association of Shareware Professionals (ASP)
	WINGAME1("bingobuds", "v1.1", "BINGO.EXE", "b0f3841f6e8005e519445b22de37749b", 4373364, 600),

	MACGAME1("casperact", "", "Casper Activity Center", "904cb6465321d8e1d12d2a5a29612050", 1029165, 600),
	WINGAME1("casperact", "", "CASPER32.EXE", "a593079aecf5bd938ce75264cac24b2d", 1819279, 600),

	MACGAME1("catshats", "", "Cats and Hats", "cc27aab06406e53f53bcf7efd154ac1c", 1033985, 602),
	WINGAME1("catshats", "", "HEXEN32.EXE", "be5ee23851ba95ce0b790e50f75f7e2e", 1661593, 602),

	// Developed by Real World Multimedia, Wiltshire, England (1997)
	// Distributed in Germany by Funware, Hamburg
	MACGAME2("ceremony", "",   "Ceremony PPC", 	"d001d6e8615e35edc03465683f56e84d", 115675,
							   "00startCD.dir", "f40c38467c0ad3fca7d3626b134c13b3", 15503, 600),
	MACGAME2_l("ceremony", "", "Ceremony PPC",  "d001d6e8615e35edc03465683f56e84d", 115675,
							   "00startCD.dir", "39d2e56f6a29bdf0f38888489f99d60c", 15507, Common::DE_DEU, 600),
	WINGAME2("ceremony", "",   "ceremony.exe",  "a593079aecf5bd938ce75264cac24b2d", 1700809,
							   "00startCD.dir", "f40c38467c0ad3fca7d3626b134c13b3", 15503, 600),
	WINGAME2_l("ceremony", "", "ceremony.exe",  "a593079aecf5bd938ce75264cac24b2d", 1700809,
							   "00startCD.dir", "39d2e56f6a29bdf0f38888489f99d60c", 15507, Common::DE_DEU, 600),

	// General preview for ClueFinders series. Does not correspond to a specific game.
	WINGAME1("cfdemo", "", "CFDemo.exe", "d62438566e44826960fc16c5c23dbe43", 11941853, 650),

	// Full game can be unlocked with registration key
	// Developed by LittleFingers Software, Redding, Connecticut
	// Later Mac OS X version is D10
	// https://web.archive.org/*/http://littlefingers.com/
	MACGAME1("checkersvillage", "Classic OS", "Checkers Village", "a593079aecf5bd938ce75264cac24b2d", 3871783, 600),
	WINGAME1("checkersvillage", "", "Checkers Village.exe", "a593079aecf5bd938ce75264cac24b2d", 3871783, 600),

	// Clocks from Let's Play with Sakura CD
	// Mac versions are D5
	// Original filenames follow the entries on each line
	WINGAME1_l("clockkero", "",	  "Kero Tokei.exe",	  "45871c12eb944f09f50ee742113a1e2d", 2770370, Common::JA_JPN, 650), // ケロ時計.exe
	WINGAME1_l("clocksakura", "", "Sakura Tokei.exe", "45871c12eb944f09f50ee742113a1e2d", 2754593, Common::JA_JPN, 650), // さくら時計.exe
	WINGAME1_l("clocktomoyo", "", "Tomoyo Tokei.exe", "45871c12eb944f09f50ee742113a1e2d", 3184823, Common::JA_JPN, 650), // 知世時計.exe

	MACGAME1("concentration", "ECD", "Natural",	   "f987dae6f5cdd01875c886a491591e72", 1031658, 650),
	WINGAME2("concentration", "ECD", "win95.exe",  "d62438566e44826960fc16c5c23dbe43", 1703271,
									 "stub32.dxr", "c835559b5556665bc755350ec9bd8244", 47639, 650),

	MACGAME1_l("crusader2000", "", "Lancer Croisades", "398eb2cdf121feb490097c6323d52267", 1031745, Common::FR_FRA, 650),
	WINGAME1_l("crusader2000", "", "Croisade.exe", "d62438566e44826960fc16c5c23dbe43", 1546312, Common::FR_FRA, 650),

	// Doki Doki On-air Drama Series acts as a companion to a series of radio broadcasts
	// It includes the audio episodes alongside sketches, interviews, and mini-games
	// Original filenames are as follows:
	// Vol.2 - アイドル探偵ＹＯＵ＆ＭＹ
	MACGAME1_l("ddoa2", "Vol.2", "Idol Tantei You & My", "baed611e800d4619b66bbb28db3df1c7", 1033523, Common::JA_JPN, 601),

	WINGAME1("delphi4tutor", "", "Del4Tutor.exe", "ece1c7a090010965890840102978e693", 3125198, 601),

	WINGAME1("dfireworks", "Ver.98", "Firewk32.exe", "ece1c7a090010965890840102978e693", 1513130, 601),

	// Plays movies and launches 5 demos. Only the MSN preview uses Director
	// Other engines include MediaStation ASB and Bill Appleton's DreamFactory
	MACGAME1("disneyint", "", "DIeduSLVppc", "0096dc69d72faeb63ec7dbbb96899fac", 113411, 600),
	WINGAME1("disneyint", "", "DIEdu32.exe", "a593079aecf5bd938ce75264cac24b2d", 1510321, 600),

	// Mac version on same discs is D5
	WINGAME1("dynamichuman", "v2.0", "DH2.EXE", "d62438566e44826960fc16c5c23dbe43", 1718624, 650),

	// Published by Birchtree Interactive, Tillson, Ontario (1998)
	// There are four demos described here:
	// https://web.archive.org/web/20000623024147/http://www.eddieandminx.com/demo.htm
	// Map demo found on Disc Inferno from APC magazine (Australia), Dec 1999
	WINDEMO1("eddieminx", "Map Demo", "mapgame.exe", "518a98696fe1122e08410b0f157f21bf", 5876875, 602),

	MACGAME1("egypt", "", "Egypt", "0944b962ebb00f4b5d5149d220f8449b", 114142, 702),

	WINDEMO1_l("engl", "Demo", "ENGL.EXE", "a593079aecf5bd938ce75264cac24b2d", 13304811, Common::RU_RUS, 600),

	MACGAME1("espanatomy", "", "Anatomy & Physiology ESP", "e3a044ab01f96d6645bc315628c2b00f", 118396, 602),
	WINGAME1("espanatomy", "", "Anatomy & Physiology ESP.exe", "625deae5e42f9453c5e4ccf7d322f048", 1526924, 602),

	WINGAME1("forestia", "", "FORESTIA.EXE", "9ba84c313bc116ffa08029aad52cd2e8", 1859350, 601),
	WINGAME1_l("forestia", "", "Forestia.exe", "5e123b0ddb0f1193e1f840c50f24e382", 1521194, Common::FI_FIN, 650),
	MACGAME1_l("forestia", "", "FORESTIA", "3c0d928e84acac2ee6739a4360e70fc6", 1032662, Common::FR_FRA, 602),

	// Later releases are D8
	WINGAME1_l("forestiajr", "", "Forestia Junior.exe", "5e123b0ddb0f1193e1f840c50f24e382", 1553190, Common::FR_FRA, 650),

	MACDEMO1("fpcastle2", "Crocodile Kitchen Demo", "Castle Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINGAME1("fpcastle2", "", "CASTLE32.EX_", "518a98696fe1122e08410b0f157f21bf", 1563605, 602),
	WINDEMO1("fpcastle2", "Crocodile Kitchen Demo", "CASDEM95.EXE", "518a98696fe1122e08410b0f157f21bf", 1512624, 602),

	MACDEMO1("fpcon", "Crane Demo", "FP Construction Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1031726, 600),
	WINDEMO1("fpcon", "Crane Demo", "CONDEM95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1508205, 600),

	MACDEMO1("fpdollhouse", "Dress Up Demo", "FP Dollhouse Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1031658, 602),
	WINDEMO1("fpdollhouse", "Dress Up Demo", "DHDEMO95.EXE", "518a98696fe1122e08410b0f157f21bf", 1512578, 602),

	MACGAME1("fpgarage", "", "Big Action Garage", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032662, 602),
	WINGAME2("fpgarage", "", "GARAGE.EXE", "518a98696fe1122e08410b0f157f21bf", 1512853,
							 "START.DXR",  "f69996bd5a1dea3971c7647e86b4ee30", 190436, 602),

	MACDEMO1("fpreadyt", "ABC Fun Demo",	  "FP Toddler Demo",	  "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINDEMO1("fpreadyt", "ABC Fun Demo",	  "TODDEM95.EXE",		  "518a98696fe1122e08410b0f157f21bf", 1512576, 602),
	MACDEMO1("fpreadyk", "Toy Shop Demo",	  "FP Kindergarten Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINDEMO1("fpreadyk", "Toy Shop Demo",	  "KGDEMO95.EXE",		  "518a98696fe1122e08410b0f157f21bf", 1512576, 602),
	WINDEMO1("fpready1", "Acorn Arcade Demo", "FIRST95.EXE",		  "985a5cdb61904b2229043af3f0e4dd60", 1498587, 602),

	MACDEMO1("fpwestern", "Wacky Wanted Posters Demo", "Western Town Demo", "ade290061bd8f78051a8e872a889855c", 1031646, 601),
	WINDEMO1("fpwestern", "Wacky Wanted Posters Demo", "WEST95.EXE", "518a98696fe1122e08410b0f157f21bf", 1512580, 602),

	MACGAME1("fpxmas", "", "Christmas", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINGAME1("fpxmas", "", "XFUN32.EXE", "518a98696fe1122e08410b0f157f21bf", 1566416, 602),

	MACGAME1("fusion", "", "Start FUSION Mac", "3849d7cd0cdbe4f46333879cbed56492", 1029165, 600),
	WINGAME1("fusion", "", "FUSION.exe", "518a98696fe1122e08410b0f157f21bf", 1513751, 602),

	// Contains previews for educational and religious products for children and adults
	// Miscellaneous section contains an art package and an encyclopedia on pregnancy and birth
	WINGAME1_l("futsoft", "", "fs_demo.exe", "a593079aecf5bd938ce75264cac24b2d", 2091687, Common::AR_ARB, 600),

	MACGAME1_l("garage", "", "Garage",	   "e5ed4533b25be47b708bb1245550cb2c", 118818, Common::JA_JPN, 650),
	WINGAME2("garage", "",	 "Garage.exe", "0e43a5130e1964231fa25472108ca522", 1516264,
							 "open.swf",   "9c6eb1fb21dfcd3ddff4c153c88a53b7", 96640, 650),
	WINGAME2_l("garage", "", "Garage.exe", "0e43a5130e1964231fa25472108ca522", 1516264,
							 "open.swf",   "d01cf5e6eb157859466f846ccb30a081", 178668, Common::JA_JPN, 650),

	// Miel Monteur - Miel Bouwt Auto's! localized by Transposia
	// Dutch Mac demo is found in the Flipper & Lopaka compilation
	WINGAME1_l("garygadget1", "",	  "Willy32.exe",	   "d62438566e44826960fc16c5c23dbe43", 1518423, Common::DE_DEU, 650),
	WINDEMO1_l("garygadget1", "Demo", "miel.exe",          "518a98696fe1122e08410b0f157f21bf", 1512519, Common::NL_NLD, 602),
	MACDEMO1_l("garygadget1", "Demo", "Miel Monteur demo", "329aab81c0d74c5d3f31ddad26bcc639", 1029165, Common::NL_NLD, 600),

	// Dutch Windows version on same disc is D8
	MACGAME1_l("garygadget2", "", "Schiffe bauen mit Willy", "1eb3e6dd864a8a9bf5fbd63ea2bc8ebc", 1032634, Common::DE_DEU, 602),
	MACGAME2_l("garygadget2", "", "Game",                    "1d9149b9745e35ef93ed4cdf08ec3af7", 1030361,
								  "StartCD.dxr",             "07c672f1c05c4c12ac6abbb371a0ee1f", 24053, Common::NL_NLD, 600),
	WINGAME1_l("garygadget2", "", "Willy2.exe",				 "d62438566e44826960fc16c5c23dbe43", 1507905, Common::DE_DEU, 650),

	WINDEMO1("generations", "v4.2 Demo", "GEN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 15646702, 600),

	// Gigglebone Gang games (Beestenbende) were published in Belgium and the Netherlands by Zwijsen CD-ROMs
	// https://nationaalarchiefeducatievegames.nl/archief?filter=Headbone%20Interactive
	WINDEMO2_l("gigglecity", "Demo", "WIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1700151,
									 "INTRO.DXR", "514a17949a7e30d2ed616c3954dadb7a", 3254498, Common::NL_NLD, 600),
	WINDEMO2_l("gigglefarm", "Demo", "WIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1700151,
									 "INTRO.DXR", "c6e4a53180109b3bf4a156910aa042aa", 1070088, Common::NL_NLD, 600),

	// Language selection at start for High German / Swiss German
	MACGAME1_l("globiabc", "", "Globi's ABC Power PC", "0bc838e9350c4749e2d10523d620a2ad", 117356, Common::DE_DEU, 650),
	WINGAME1_l("globiabc", "", "GLOBI32.EXE", "d62438566e44826960fc16c5c23dbe43", 1711195, Common::DE_DEU, 650),

	// Windows screen saver is in BILDNT directory
	MACGAME1_l("globiss", "", "Globi's Bildschirmschoner", "512aa445bccb66babe48419237422745", 1150767, Common::DE_DEU, 650),
	WINGAME1_l("globiss", "", "GLOBISAZ.EXE", "6e893e1d588f51d9d6202410a38a73a6", 9857917, Common::DE_DEU, 650),

	// Published by A-Star Interactive (Singapore)
	WINGAME1("grammarplaytime2", "", "H_32.exe", "a593079aecf5bd938ce75264cac24b2d", 2234889, 600),

	WINGAME1_l("griezelbus1", "", "BUS95.EXE", "518a98696fe1122e08410b0f157f21bf", 1748606, Common::NL_NLD, 602),

	WINGAME1("hamletmurder", "", "PMHamlet.exe", "a593079aecf5bd938ce75264cac24b2d", 1873557, 600),

	// Based on the original I Spy CD-ROM, now with dozens of new challenges
	// Flemish Edition (c) 2000, Standaard Uitgeverij, Antwerp
	// Dutch Edition (c) 2000, Halloween Educational Software, Amsterdam
	// Mac installer creates an invisible projector file
	MACGAME1("ispyschool", "",	 "Play I Spy School Days", "fa259c68cd2594e863524ca7d18db67a", 116034, 650),
	MACGAME2_l("ispyschool", "", "Speel ik zie, ik zie",   "904cb6465321d8e1d12d2a5a29612050", 1029165,
								 "ISPYMAIN.DXR",		   "d46cbab557f938b88660e77c4fe64b5a", 7136056, Common::NL_BEL, 600),
	MACGAME2_l("ispyschool", "", "Speel ik zie, ik zie",   "904cb6465321d8e1d12d2a5a29612050", 1029165,
								 "ISPYMAIN.DXR",		   "e152e96487decca8ddc8ab16de55366e", 7156892, Common::NL_NLD, 600),
	WINGAME1("ispyschool", "",	 "Ispy.exe",			   "d62438566e44826960fc16c5c23dbe43", 1580375, 650),
	WINGAME1_l("ispyschool", "", "Ikzie32.exe",			   "a593079aecf5bd938ce75264cac24b2d", 1989859, Common::NL_BEL, 600),
	WINGAME1_l("ispyschool", "", "Ikzie32.exe",			   "a593079aecf5bd938ce75264cac24b2d", 1989785, Common::NL_NLD, 600),

	WINGAME1("js123", "", "JSNUMS.EXE", "f78f95afb7457fd465be3691a3932b15", 1532801, 602),

	MACGAME1("jsabc", "", "JumpStart LG ABCs", "833281980d0b2e2ffdf900a0e818f5d8", 116032, 602),
	WINGAME1("jsabc", "", "JSLG_ABC.exe", "518a98696fe1122e08410b0f157f21bf", 1588391, 602),

	MACGAME1("jslearn", "1997 D6 Demo", "JumpStart Previews", "9d08e05121dedcc5ee4c2a9495b78747", 987498, 600),
	MACGAME1("jslearn", "1998 Demo", "JumpStart Previews", "9d08e05121dedcc5ee4c2a9495b78747", 987818, 602),
	MACGAME1("jslearn", "1999 Demo", "JumpStart Previews", "fa259c68cd2594e863524ca7d18db67a", 115488, 602),
	WINGAME1("jslearn", "1997 D6 Demo", "PREV32A.EXE", "a593079aecf5bd938ce75264cac24b2d", 1509011, 600),
	WINGAME1("jslearn", "1998 Demo", "PREV32A.EXE", "518a98696fe1122e08410b0f157f21bf", 1513371, 602),
	WINGAME1("jslearn", "1999 Demo", "PREV32A.EXE", "518a98696fe1122e08410b0f157f21bf", 1601517, 602),

	MACGAME1("jsmusic", "", "JumpStart Music", "63e8b9f6744efefbb8a004a2b76e2b1d", 116032, 602),
	WINGAME1("jsmusic", "", "MUSIC.EXE", "f78f95afb7457fd465be3691a3932b15", 1532043, 602),

	MACGAME1("jsspanish", "", "JumpStart Spanish", "55d01cca925752c170ac1e9c01d1f87e", 1031646, 601),
	WINGAME1("jsspanish", "", "JSSPAN.EXE", "ece1c7a090010965890840102978e693", 1511580, 601),

	WINGAME1("jumpaheadss2000at", "", "ATEST.EXE", "a593079aecf5bd938ce75264cac24b2d", 1508221, 600),
	WINGAME1("jumpaheadss2000wb", "", "WORKBOOK.EXE", "a593079aecf5bd938ce75264cac24b2d", 1731863, 600),

	WINGAME1_l("kcd", "K15 2001", "V_Fi.exe", "518a98696fe1122e08410b0f157f21bf", 1704035, Common::FI_FIN, 602),

	WINGAME1("kingandi", "", "King&I.exe", "518a98696fe1122e08410b0f157f21bf", 1967220, 602),

	WINGAME2_l("kontyngent99", "", "START.EXE", "d62438566e44826960fc16c5c23dbe43", 1513041,
								   "MAIN.DXR",	"98b4f7339e1f8f6628035e6317f78912", 21043440, Common::PL_POL, 650),

	// Published by Future Soft of Nasr City, Cairo
	WINGAME1_l("ktaralarkam", "", "123.exe", "a593079aecf5bd938ce75264cac24b2d", 2748951, Common::AR_ARB, 600),

	WINGAME1_l("kultapossu", "", "POSSU_95.EXE", "518a98696fe1122e08410b0f157f21bf", 1531081, Common::FI_FIN, 602),

	WINDEMO1("landdesigner", "Demo", "CLD_DEMO.EXE", "518a98696fe1122e08410b0f157f21bf", 22576635, 602),

	WINGAME1("learninternet", "", "VIDPROF.EXE", "b0f3841f6e8005e519445b22de37749b", 2674733, 600),
	WINGAME1("learnworks2", "v4.0", "Vidprof.exe", "b0f3841f6e8005e519445b22de37749b", 2854401, 600),

	// Pre-rendered CG animated adventure based on the popular comedy manga
	// Developed by Future Pirates, published by Toshiba EMI
	MACGAME1_l("macaroni", "", "Macaroni.PowerMac", "be7faef1b5c713e2d13a693eb6e1f5c9", 180281, Common::JA_JPN, 404),

	WINDEMO1("madtg", "1998 Demo", "MTGDSLID.EXE", "b0f3841f6e8005e519445b22de37749b", 1317661, 600),

	// Masters of the Elements - English and German (from lotharsm)
	// Original Dutch game Meesters van Macht released in 1997
	// Released in Germany as "Meister Zufall und die Herrscher der Elemente"
	// Developed by IJsfontein, published by Tivola
	// File version of MVM.EXE is 6.0.2.32
	// The game disc is a hybrid CD-ROM containing both the Windows and the Macintosh release.
	MACGAME2("melements", "",	"check.dxr", 			  "f48ce7700bbf5f00a03373397b491a87", 898334,
								"Masters of the Elements", 0, 1034962, 602),
	MACGAME2_l("melements", "", "check.dxr",			  "bd320cbd150d4d54fec798ce0222bc63", 575554,
								"Meister Zufall",		  "398eb2cdf121feb490097c6323d52267", 1034962, Common::DE_DEU, 602),
	WINGAME2("melements", "",	"CHECK.DXR",			  "c31ee30eebd24a8cf31691fc9926daa4", 901820,
								"MVM.EXE",				  0, 2565921, 602),
	WINGAME2_l("melements", "", "CHECK.DXR",			  "d1cd0ed95b0e30597e0089bf3e5caf0f", 575414,
								"MVM.EXE",				  "518a98696fe1122e08410b0f157f21bf", 1512503, Common::DE_DEU, 602),

	MACGAME1("mulanpresskit", "", "Disney's Mulan", "d16e0af2a86b6b04a8f9c86205c0d3d2", 1031738, 601),
	WINGAME1("mulanpresskit", "", "MULAN.EXE", "ece1c7a090010965890840102978e693", 1828679, 601),

	MACGAME1("netmarket", "", "netMarket", "ade290061bd8f78051a8e872a889855c", 1030738, 600),
	WINGAME1("netmarket", "", "NETMKT32.EXE", "3cb7a28198b9b8acd58d6d0e74272531", 1514399, 600),

	// Study guide from The Daily Telegraph
	// Mac executable filename does indeed end in .exe
	MACGAME1("nia4", "", "nia4.exe", "ee2cca33b022bed087aa3911f9ec78b1", 1032689, 650),
	WINGAME1("nia4", "", "nia4w95.exe", "d62438566e44826960fc16c5c23dbe43", 1711499, 650),

	// Original Mac filename is Nikolai's Treats™
	MACGAME1("nikolaitreats", "", "Nikolai's Treats", "ce0a3a5891a35b2dd2ab706e8e376baa", 1032717, 650),

	// Mac executable is originally Café
	// Choice of French or English gameplay at start
	MACGAME1("nightcafe", "", "Cafe", "e8fd8a7b24520e47344c2d9768a2479f", 1029193, 600),
	WINGAME1("nightcafe", "", "Cafe95.exe", "a593079aecf5bd938ce75264cac24b2d", 1701222, 600),

	// Found on NY Knicks CDK from CDKNet LLC, Garden City, New York
	// Extremely annoying, play with sound off
	WINGAME2("nykshuffle", "", "KNICKS.EXE",  "d62438566e44826960fc16c5c23dbe43", 4229955,
							   "CDKPLAY.KXE", "a3b34c0871dc2fd51eec5559b68f709d", 4, 650),

	// Designed and produced by C-Squared Studios, Caldwell, New Jersey (1998)
	MACGAME1("nyyankeesyb", "", "start-ppc",	 "fa259c68cd2594e863524ca7d18db67a", 115115, 650),
	WINGAME2("nyyankeesyb", "", "START95.EXE",	 "d62438566e44826960fc16c5c23dbe43", 1544371,
								"tradition.dxr", "05bc2cd75e7bd414d735d2fc91835989", 1206863, 650),

	// Found on covermount of CD-ROM Today (Brazil) Volume 4 Número 16
	// Only a 16-bit executable is provided
	WINGAME1_l("objetivo", "", "OBETIVO.EXE", "b0f3841f6e8005e519445b22de37749b", 11660888, Common::PT_BRA, 600),

	// O!Kay is a monthly magazine for German students in grades 1 to 4 to learn English.
	// If ordered, every three months a CD-ROM is included with unique educational games.
	// The "Try out" demos most likely also required paid subscriptions.
	MACGAME1_l("okaydemo", "", 		"O!Kay!  Demo",	"a40c77fb7f0033d5a9c1c8d526244729", 1036504, Common::DE_DEU, 650),
	WINGAME2_l("okaydemo", "", 		"START32.EXE", 	"1b8d78ddca650041b8997cac7af3184b", 2027288,
									"TITEL.DXR",	"ade368a04615f440386c74f0266dc7f7", 216938, Common::DE_DEU, 650),
	MACGAME2_l("okaydownunder", "", "Start",	   	"136e1ab1d4d13168964afb699bda13aa", 1034240,
									"Titel.dxr",   	"48e1ee3d905895ef775761a60cefe056", 1505702, Common::DE_DEU, 650),
	WINGAME1_l("okaydownunder", "", "Ok49932.exe", 	"1b8d78ddca650041b8997cac7af3184b", 1890546, Common::DE_DEU, 650),
	MACGAME2_l("okaydragon", "",	"Start",	   	"3cef8710f4eddbe16fa186b198833ace", 1034014,
									"Titel.dxr",   	"8f4430db871ea50643037a16274fb6e4", 858265, Common::DE_DEU, 650),
	WINGAME1_l("okaydragon", "", 	"Ok29932.exe", 	"1b8d78ddca650041b8997cac7af3184b", 2109486, Common::DE_DEU, 650),
	MACGAME2_l("okayfriends", "",	"Start",	   	"136e1ab1d4d13168964afb699bda13aa", 1034240,
									"Titel.dxr",   	"d390b52b55266630faf7d9697c271605", 1857650, Common::DE_DEU, 650),
	WINGAME1_l("okayfriends", "",	"Ok10032.exe", 	"d62438566e44826960fc16c5c23dbe43", 2278721, Common::DE_DEU, 650),
	MACGAME2_l("okayhenry", "",		"Start",	   	"136e1ab1d4d13168964afb699bda13aa", 1034204,
									"titel.dxr",   	"db3b00a35d78d6065ee36c7f60558fe6", 698410, Common::DE_DEU, 650),
	WINGAME1_l("okayhenry", "",		"Ok19932.exe", 	"1b8d78ddca650041b8997cac7af3184b", 2009104, Common::DE_DEU, 650),
	MACGAME2_l("okaytruehero", "",	"Start",	   	"136e1ab1d4d13168964afb699bda13aa", 1034240,
									"Titel.dxr",   	"e8b13e9e34dcfbdd4481f7f0b8209903", 1134260, Common::DE_DEU, 650),
	WINGAME1_l("okaytruehero", "",	"ok39932.exe", 	"1b8d78ddca650041b8997cac7af3184b", 1883584, Common::DE_DEU, 650),

	WINGAME2_l("pettson2", "", "START32.EXE", "518a98696fe1122e08410b0f157f21bf", 1723219,
							   "START.DXR",	  "18d333b1b9b02d76b35a07252046d295", 37384, Common::SE_SWE, 602),
	// German version is D7
	MACGAME1_l("pettsonjk", "", "Starta kalendern",		 "98f39f06e78cc7d3e20b498d30f737b6", 1029165, Common::SE_SWE, 600),
	MACGAME1_l("pettsonjk", "", "Pesosen joulukalenteri", "3aaab7a6b2cbcc767f839bd6d8d3dd26", 1032582, Common::FI_FIN, 602),
	WINGAME1_l("pettsonjk", "", "PETWIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1702396, Common::SE_SWE, 600),
	WINGAME1_l("pettsonjk", "", "PETWIN95.EXE", "518a98696fe1122e08410b0f157f21bf", 1738188, Common::FI_FIN, 602),

	// Global Software Products catalogue # 1282B (1999) and 1282C (Favourites, 2006)
	WINGAME2("pingu1", "1282B", "PINGU.EXE",	"d62438566e44826960fc16c5c23dbe43", 1570152,
								"BBCLOGO.DXR",	"0af3596b90ae5ee1fcd14c4a84d72c5f", 1516128, 650),
	WINGAME2("pingu1", "1282C", "Pingu.exe",	"d62438566e44826960fc16c5c23dbe43", 1999206,
								"Pintitle.dxr", "e02ebaad2b4c28914b9fe0fedd740a53", 498532, 650),

	WINGAME1_l("plcd", "Nº11 1998", "submarine.exe", "a593079aecf5bd938ce75264cac24b2d", 1700379, Common::RU_RUS, 600),
	WINGAME2_l("plcd", "Nº12 1998", "Start.exe",	 "d62438566e44826960fc16c5c23dbe43", 1919710,
									"Mainmenu.dxr",	 "23c87266e4b249d6cb25c09c50ae0666", 10447472, Common::RU_RUS, 650),

	// DVD-ROM content from Planetary Traveler movie
	WINGAME1("planetrav", "", "PCDVD.EXE", "a593079aecf5bd938ce75264cac24b2d", 2345815, 600),

	// Projectors on the installation disc for Swedish, Norwegian, Danish, Finnish
	MACGAME1_l("polis1", "", "KRIPOS", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::NB_NOR, 650),
	MACGAME1_l("polis1", "", "STRISSER", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::DA_DAN, 650),
	MACGAME1_l("polis1", "", "POLIS", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::SE_SWE, 650),
	MACGAME1_l("polis1", "", "POLIISI", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::FI_FIN, 650),
	WINGAME1_l("polis1", "", "Kripos.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::NB_NOR, 650),
	WINGAME1_l("polis1", "", "Strisser.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::DA_DAN, 650),
	WINGAME1_l("polis1", "", "Polis.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::SE_SWE, 650),
	WINGAME1_l("polis1", "", "Poliisi.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::FI_FIN, 650),

	MACGAME1("poohlearn", "", "Learning Demos", "83b232d2d02d9238e481019eb93e7194", 2766, 650),
	WINGAME1("poohlearn", "", "demos.exe", "d62438566e44826960fc16c5c23dbe43", 2313191, 650),

	// Mac demo is from Disney Interactive Learning Sampler CD
	// Mac installer uses Director 7.0.2
	MACDEMO1("poohp", "D6 Demo", "PSchool.Mac", "e0eb86f93a9fba6ea6c4141eed29d923", 116023, 650),
	WINDEMO1("poohp", "D6 Demo", "PSchool.exe", "d62438566e44826960fc16c5c23dbe43", 1501560, 650),

	// American Revolutionary War
	MACGAME2("revwar", "", "BEGIN",	   	   "2806e0d1bac713be5677a62b425d3c98", 1030361,
						   "mainmenu.dxr", "9343ddc8818f99929eeb1067b8329707", 5592862, 650),
	WINGAME2("revwar", "", "BEGIN.exe",	   "d62438566e44826960fc16c5c23dbe43", 1514063,
						   "mainmenu.dxr", "1b6c62ffd84ac53fce242a8f0a4cc337", 5839626, 650),

	//Edison: Bio-Mania
	WINGAME2_l("robidoc", "", "start.exe", "518a98696fe1122e08410b0f157f21bf", 1518949,
			"Bio.exe", "55180c6a904d1b35c6ae60cab1f84949", 188408, Common::NL_NLD, 600),

	// Found on Let's Play with "Sakura"
	// This directly runs the screen savers available on the CD
	// Original filename is さくらのscrセレクタ
	MACGAME1_l("sakurascr", "", "Sakura\'s scr selector", "65063397536553c4f6ff2a6c07194bf7", 1822055, Common::JA_JPN, 602),

	// Original filenames are さくらとあそぼ
	MACGAME1_l("sakuratoasobo", "", "Let\'s Play with Sakura", "8d83064402198a909b0abcebc6b46d2b", 118198, Common::JA_JPN, 602),
	WINGAME1_l("sakuratoasobo", "", "Let\'s Play with Sakura.exe", "45871c12eb944f09f50ee742113a1e2d", 1982850, Common::JA_JPN, 650),

	WINGAME2_l("samson", "", "start.exe", "a593079aecf5bd938ce75264cac24b2d", 1919963,
								"GOSCHOT.DXR", "045e8b0091317831da84596f807779cd", 161404, Common::NL_NLD, 600),

	MACGAME1("shrlucky", "", "Arcade", "dab7a517b0877454d1e16c40c9b5a9be", 1029193, 600),
	WINGAME1("shrlucky", "", "ARCWIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 7304861, 600),

	WINGAME1("ss007", "", "007.exe", "d62438566e44826960fc16c5c23dbe43", 4971852, 650),

	MACGAME1("ssgbi", "", "GBI Screen Saver", "9c9907925c1bf80a71ae27f423925725", 1130762, 601),

	MACGAME1("ssleepipes", "", "pipes",		"dc48a185cfddce0d48a199fd25e328ac", 94195, 650),
	WINGAME1("ssleepipes", "", "pipes.exe", "a593079aecf5bd938ce75264cac24b2d", 1545446, 600),

	// Screen savers found on Let's Play with "Sakura" activity CD
	// Mac versions are D5
	WINGAME1_l("sskero", "",	 "Kero.exe",	 "45871c12eb944f09f50ee742113a1e2d", 1730497, Common::JA_JPN, 650),
	WINGAME1_l("sssakura", "",	 "Sakura.exe",	 "45871c12eb944f09f50ee742113a1e2d", 1736349, Common::JA_JPN, 650),
	WINGAME1_l("ssyamazaki", "", "Yamazaki.exe", "45871c12eb944f09f50ee742113a1e2d", 3854052, Common::JA_JPN, 650),
	WINGAME1_l("ssyukito", "",	 "Yukito.exe",	 "45871c12eb944f09f50ee742113a1e2d", 5003908, Common::JA_JPN, 650),

	// Mac version is D5
	WINGAME1("ssrevwar", "", "Revwar.exe", "d62438566e44826960fc16c5c23dbe43", 21088827, 650),

	// Developed by Accurate Research, Inc. of Sunnyvale, California (1998)
	// Part of the Super Tutor series sold through Homeworkhelp.com
	// Found in the Middle School Advantage 2001 bundle and High Achiever Grammar from PC Treasures
	WINGAME1("supertutorgram", "v1.0", "GRAMMAR.EXE", "a593079aecf5bd938ce75264cac24b2d", 1853673, 600),

	WINDEMO1_l("tchaik", "Demo", "TCHAIK.EXE", "a593079aecf5bd938ce75264cac24b2d", 15780729, Common::RU_RUS, 600),

	WINGAME1("technik", "", "Techni00.exe", "1b8d78ddca650041b8997cac7af3184b", 1615559, 650),

	WINGAME1("thesims", "", "maxis.exe", "d62438566e44826960fc16c5c23dbe43", 1915533, 650),

	//Dutch numbering is different from German originals
	//Een zaak voor TKKG 2: dodelijke chocolade (bilingual NL/EN)
	WINGAME1_l("tkkg2", "", "Tkkg2_95.exe", "518a98696fe1122e08410b0f157f21bf", 1705034, Common::NL_NLD, 602),
	//Een zaak voor TKKG 1: De schat van de Maya's (bilingual NL/EN) (Demo)
	WINDEMO2_l("tkkg3", "Demo", "start.exe", "e7bccfe54354d08a9d2d0e181f66406b", 1289732,
			"DEMO_00.dxr", "1ea80b7d22a6db7ce669a988812f0d64", 2488656, Common::NL_NLD, 602),
	//Een zaak voor TKKG 5: het raadsel van villa Drakenklauw (bilingual NL/EN)
	WINGAME1_l("tkkg4", "", "tkkg4_95.exe", "518a98696fe1122e08410b0f157f21bf", 1513570, Common::NL_NLD, 602),
	MACGAME1("tkkg6", "", "TKKG-Start", "dd58f1859ddab9bf15867a510cf7bfe4", 1034014, 650),
	WINGAME1("tkkg6", "", "Tkkg6_32.exe", "d62438566e44826960fc16c5c23dbe43", 1594089, 650),

	WINGAME1("traitorsgate", "", "TRG001.EXE", "b762d2cc3f7db2a6446135917fe92496", 2072959, 650),

	MACGAME1("trekpedia98", "", "Ency98 Player", "b0b0e36586489ca6070d20feeff52fa5", 1091806, 600),
	WINGAME1("trekpedia98", "", "ENCY98.EXE", "35f1550747fcf691283b0f2486144e2b", 1707566, 600),

	// Overview of Tutti's Magical Stories series
	WINGAME1_l("tutti", "", "TUTTI.EXE", "a593079aecf5bd938ce75264cac24b2d", 14715583, Common::RU_RUS, 600),

	// Promotional item produced by Chester Square, London
	WINGAME1("twine", "", "bond.exe", "d62438566e44826960fc16c5c23dbe43", 14288637, 650),

	WINGAME1("void", "", "VOID.exe", "1154a54e6fb77f82e9091a9adc37a4cb", 1701070, 602),

	// CD check projector uses Win95 GUI mockup to ask your drive speed then launch game
	WINGAME1("wiggles1", "", "WIGGLES.EXE", "d62438566e44826960fc16c5c23dbe43", 1862279, 650),

	// Found on Disc Inferno from APC magazine (Australia), Dec 1999
	MACGAME1("wonkatrivia", "v1.0", "wonkatriviaPPC.prj", "c2f8ae6c5a7b8f9aab5597f7de517443", 113731, 650),

	WINGAME1("worldnet", "", "EGUIDE95.EXE", "518a98696fe1122e08410b0f157f21bf", 2876414, 602),

	WINGAME1("xfools", "", "XFOOLS32.EXE", "a593079aecf5bd938ce75264cac24b2d", 2115343, 600),
	MACDEMO1("xfools", "Preview", "The X-Fools Preview", "41fa2186d635be3094403c75b5f44d4b", 115647, 600),
	WINDEMO1("xfools", "Preview", "XMAN32.EXE", "a593079aecf5bd938ce75264cac24b2d", 1701371, 600),

	// Disc 2 has no director content
	WINGAME1("xfua", "", "X-FILES.EXE", "518a98696fe1122e08410b0f157f21bf", 1719387, 602),

	// Original Mac filename is 妖怪図鑑2
	MACGAME1_l("yokai400", "", "xn--2-we0by4fq4jlr4e", "d14bf1f7a413df29a04b8fbc7a0fe81f", 1033551, Common::JA_JPN, 601),
	WINGAME1_l("yokai400", "", "YOUKAI2.EXE", "3703e9ea28aed0c647b73a1b49a51d65", 1512615, Common::JA_JPN, 601),

//////////////////////////////////////////////////
//
// Macromedia Director v7
//
//////////////////////////////////////////////////

	MACGAME2_l("affaires1", "", "Start Me", "0944b962ebb00f4b5d5149d220f8449b", 125495,
								"Main - 7.dxr", "4fa7c071ea2e934eaf9d6f4ef3205ecf", 13068189, Common::FR_FRA, 702),
	WINGAME2_l("affaires1", "", "StartMe.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1819926,
								"Main - 7.dxr", "ad34b9d4987fc84c238f0e88b174fbc9", 13068061, Common::FR_FRA, 702),

	WINDEMO1("artus1", "Demo", "artus.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2595828, 702),

	MACGAME1("atvrally", "", "atvmac", "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("atvrally", "", "ATVwin.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1815336, 702),

	MACGAME1("badmilk", "", "badmilk", "0944b962ebb00f4b5d5149d220f8449b", 111478, 702),
	WINGAME1("badmilk", "", "badmilk.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2682776, 702),

	WINDEMO2("basilbaker", "Preview", "Start.exe",	  "c1a2e8b7e41fa204009324a9c7db1030", 2615108,
									  "Mission1.dxr", "ddf7a5d922d1d99c9debc72f7ab3f247", 1979501, 700),

	WINGAME1("bbbighelpers", "", "BigHelpers.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2843894, 702),

	// Later releases are D8
	WINGAME1_l("beautyorbeast", "", "Beauty or the Beast.exe", "02b0d114c93b598c737b1c627178195c", 2190754, Common::RU_RUS, 702),

	MACGAME1_l("bellini3", "", "Bellinis bikini",	   "0944b962ebb00f4b5d5149d220f8449b", 114321, Common::DA_DAN, 702),
	MACGAME1_l("bellini3", "", "Bellinin bikinit",	   "0944b962ebb00f4b5d5149d220f8449b", 114321, Common::FI_FIN, 702),
	WINGAME1_l("bellini3", "", "Bellinis bikini.exe",  "7c18c9a6af2694156bf09ed195c1ab09", 2596204, Common::DA_DAN, 702),
	WINGAME1_l("bellini3", "", "Bellinin bikinit.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2596204, Common::FI_FIN, 702),

	MACGAME1_l("bibi2", "", "Spielstart",  "0944b962ebb00f4b5d5149d220f8449b", 117347, Common::DE_DEU, 702),
	WINGAME2_l("bibi2", "", "Start.exe",   "7c18c9a6af2694156bf09ed195c1ab09", 1820386,
							"SPIELST.DXR", "24139a522420d2c6e3f4d0aa502f5936", 2250124, Common::DE_DEU, 702),

	// Finnish title is Ville & Lilli: Mielikuvitus vauhdissa
	// Developer website calls this Double Trouble: Crazy Cool Kindergarten,
	// although we don't know if it was actually released in English
	// https://web.archive.org/web/20060208235831/http://billetrille.savannah.dk/dtpages.php3?page_id=8&lang=english

	MACGAME1_l("billetrille1", "",	   "VilleLilli",		 "0944b962ebb00f4b5d5149d220f8449b", 112758, Common::FI_FIN, 702),
	WINDEMO1_l("billetrille1", "Demo", "VilleLilliDemo.exe", "18e31b6357c42300bb6947a6af7b8a69", 5150588, Common::FI_FIN, 702),

	// Bonus content on retail CD releases. No text or dialogue is used.
	WINGAME1("billetrille1ss", "", "screensaverDT1.exe", "18e31b6357c42300bb6947a6af7b8a69", 3261985, 702),

	//Blinky Bill Peuter
	WINGAME1_l("blinkyps", "", "PS.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173560, Common::NL_NLD, 702),

	WINGAME2("blinkyk1", "", "K1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173598,
			"home.dxr", "a5bf0926474b9d6100d5eb0a02c59e7c", 2414060, 702),
	//Blinky Bill Kleuter
	WINGAME2_l("blinkyk1", "", "K1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173598,
			"home.dxr", "dd7f95732848801b0d5a7e784db68962", 2381576, Common::NL_NLD, 702),

	//Blinky Bill Lezertje
	WINGAME1_l("blinkyy1", "", "Y1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173554, Common::NL_NLD, 702),

	// Found on Windows Spielehits für Kinder by Compedia / Xtend New Media of Scheidegg, Bavaria
	WINGAME1_l("braingames", "", "invent.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2648430, Common::DE_DEU, 702),

	WINGAME1("buzz1", "", "DBLY1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2201114, 702),

	// Bilingual English and French
	MACGAME1("cpnre", "", "ASI-SEI",	 "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("cpnre", "", "ASI-SEI.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2595714, 702),

	// Mac version calls installers as D7 apps to copy demos to HDD
	// Win version calls D7 apps to open links to Disney web pages
	MACGAME1("disneylearning", "", "SAMPLER.MAC", "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("disneylearning", "", "SAMPLER.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 1816154, 702),

	// Covermount for Revista Divertire (Brazil)
	// Launches installer for non-Director game (Nanico)
	WINGAME1_l("divertire", "Número 5", "divertire.exe", "c1a2e8b7e41fa204009324a9c7db1030", 4653626, Common::PT_BRA, 702),

	// Found as Enhanced CD content on WOW 2000 Christian Rock compilation
	WINDEMO1("dotsafe", "Demo", "DOTSAFE.EXE", "c1a2e8b7e41fa204009324a9c7db1030", 19795672, 700),

	WINGAME2("easports2000", "", "PC.EXE", 	  "c1a2e8b7e41fa204009324a9c7db1030", 2212134,
								 "INTRO.DXR", "209cd844f714140413eb58c3a69db454", 5179191, 700),

	// Shockwave movie found on the CD Especial from Pc Pro magazine Nº1 (2000) published by Larpress, Madrid
	SHKGAME1_l("encartaatlas2000", "Demo", "PT_EWIA.dcr", "659daa595626c56635519af2c18e2ad1", 2612035, Common::ES_ESP, 700),

	MACGAME1("erdisaster", "", "ER Disaster Strikes Start", "0944b962ebb00f4b5d5149d220f8449b", 114890, 702),
	WINGAME1("erdisaster", "", "ER Disaster Strikes.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2682526, 702),

	MACGAME1_l("fg25ans", "", "FG25Ans", "dec72b4b6f8e97f1ea24361794bf0bdf", 114301, Common::FR_FRA, 702),
	WINGAME1_l("fg25ans", "", "FG25Ans.exe", "88d4c24f6d4b78a73ce5b07693eddbc8", 2412706, Common::FR_FRA, 702),

	// Found on デスクトップマスコット ファービー (Desktop Mascot Furby)
	WINGAME1_l("furbydentaku", "", "xn--.exe-fk4colma72ab4209fos3h", "1799677b9d869c8dc577d931e229ee3b", 3002842, Common::JA_JPN, 702),

	//Miel Monteur - Miel Bouwt Auto's!
	WINGAME2_l("garygadget1", "", "Start.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2933829,
			"Monteur.cnt", "7038be89eb5c49b51927bf76d8fd0b8a", 2490, Common::NL_NLD, 700),

	// Found on アクティブマスコット・ハイジ (Heidi Desktop Mascot) software from Inner Brain, Shinjuku, Tokyo
	// Installers for the screen savers and other applications also use Director
	// Original calculator filenames are ハイジ電卓１.exe, ハイジ電卓２.exe, ハイジ電卓３.exe
	WINGAME1_l("heididentaku1", "", "xn--.exe-uk4cqevgp14zyi5ggs7i", "1799677b9d869c8dc577d931e229ee3b", 3232268, Common::JA_JPN, 702),
	WINGAME1_l("heididentaku2", "", "xn--.exe-uk4cqevgp14zyi5gqs7i", "1799677b9d869c8dc577d931e229ee3b", 2947676, Common::JA_JPN, 702),
	WINGAME1_l("heididentaku3", "", "xn--.exe-uk4cqevgp14zyi5g0s7i", "1799677b9d869c8dc577d931e229ee3b", 2988876, Common::JA_JPN, 702),
	WINGAME1_l("heidimail", "",  "HeidiML.exe", "1799677b9d869c8dc577d931e229ee3b", 2662490, Common::JA_JPN, 702),
	WINGAME1_l("heidislide", "", "Slide.exe",   "1799677b9d869c8dc577d931e229ee3b", 7934640, Common::JA_JPN, 702),

	MACGAME1_l("ironmask", "", "THE IRON MASK", "0944b962ebb00f4b5d5149d220f8449b", 112786, Common::IT_ITA, 702),
	WINGAME1_l("ironmask", "", "TIM.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2916546, Common::IT_ITA, 702),

	// Polish demo is found on magazine covermount of CyberMycha - Oct 2000
	// Zobacz i Znajdź: Tajemnice Domu Strachów (Polish title), localized by Optimus Pascal Multimedia of Bielsko-Biała
	WINDEMO2_l("ispyspooky", "Demo", "start.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2211414,
									 "salon.dxr", "28600924c9b6c087004a1adc39ca2254", 663694, Common::PL_POL, 700),

	MACGAME1("isscommerce", "", "Mac-Start", "fa52f0136cde568a46249ce74f01a324", 107126, 700),
	WINGAME1("isscommerce", "", "PC-Start.exe", "c1a2e8b7e41fa204009324a9c7db1030", 6878037, 700),

	MACGAME1("jewels1", "", "Jewels of the Oracle", "fa52f0136cde568a46249ce74f01a324", -1, 700),
	WINGAME1("jewels1", "", "Jewels.exe", "c1a2e8b7e41fa204009324a9c7db1030", -1, 700),

	// All of the installers also use Director
	// Mac filename is Starta Jönssonligan
	MACGAME1_l("jonssonligan1", "", "Starta Jonssonligan", "0944b962ebb00f4b5d5149d220f8449b", 113750, Common::SE_SWE, 702),
	WINGAME1_l("jonssonligan1", "", "xn--Jnssonligan.exe-zya4t",					"7c18c9a6af2694156bf09ed195c1ab09", 2432602, Common::SE_SWE, 702),
	WINGAME1_l("jonssonligan2", "", "xn--Jnssonligan gr p djupet.exe-83ad70c4mnae", "6213518ca81bb9e7397b408a8f38703d", 3374107, Common::SE_SWE, 702),

	// Plays QuickTime movie then opens webpage (still works in 2021)
	WINGAME2("jsa", "Demo", "Projector.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2289485,
							"jslogo.jpg",    "fd78f0ab06eb3894d38c11a75e13d008", 25016, 702),

	// Extra activities on Little Bear Thinking Adventures
	MACGAME1("lbfamfun", "", "Little Bear Family Fun", "0944b962ebb00f4b5d5149d220f8449b", 112758, 702),
	WINGAME1("lbfamfun", "", "Little Bear Family Fun.exe", "7c18c9a6af2694156bf09ed195c1ab09", 4214763, 702),

	WINDEMO1("lbkinder", "Demo", "LBKinder.exe", "7c18c9a6af2694156bf09ed195c1ab09", 6486618, 702),
	WINDEMO1("lbpre", "Demo", "LBPre.exe", "7c18c9a6af2694156bf09ed195c1ab09", 5944146, 702),

	MACGAME1("lbtpreschool", "", "LBT Preschool Adv", "fa52f0136cde568a46249ce74f01a324", 111391, 700),
	WINGAME1("lbtpreschool", "", "Lbt.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2450962, 700),

	MACGAME2("leepipes", "", "Press Kit",	  "0944b962ebb00f4b5d5149d220f8449b", 111450,
							 "ss_fs.dxr",	  "deddb2749bdfde8648e51fc9e18ae3db", 6451729, 702),
	WINGAME2("leepipes", "", "Press Kit.exe", "c1a2e8b7e41fa204009324a9c7db1030", 7448796,
							 "ss_fs.dxr",	  "b5f34c9b5222b64bda16b9c71bc14d62", 6451601, 700),

	//Mia Muis Op Zoek naar Oma Mimi's Medicijn (CD1)
	WINGAME1("miareading1", "", "Mia.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2595806, 702),

	// Mac demo is from Disney Interactive Learning Sampler CD
	// Installer also uses Director 7.0.2
	WINDEMO1("mickeyp", "D7 Demo", "MickeyP.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2044554, 702),
	MACDEMO1("mickeyt", "D7 Demo", "MickeyT.mac", "0944b962ebb00f4b5d5149d220f8449b", 111478, 702),
	WINDEMO1("mickeyt", "D7 Demo", "MickeyT.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1880445, 702),

	// Launcher for third party products included in MSA bundle from Softkey
	// Also includes single page ads with links to defunct sales pages for other Advantage bundles
	// Encore Software's budget release is v2.0
	WINGAME1("msa2001", "v2.0", "Middle School Advantage.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2691484, 702),

	MACGAME1("myfirstwords", "", "My First Reading Words Start", "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("myfirstwords", "", "MFRWORDS.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 3918368, 702),

	WINGAME2("nyknicks2000", "", "KNICKS.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2834311,
								 "Garden.dxr", "fe309424e95c3f0435c8f8a6e9a7883f", 322042, 700),

	// Found on German Silly Noisy House CD
	WINGAME1_l("otelo", "Demo", "PEARL.EXE", "c1a2e8b7e41fa204009324a9c7db1030", 8036549, Common::DE_DEU, 702),

	MACGAME1("oztma", "", "Start Oz", "0944b962ebb00f4b5d5149d220f8449b", 115200, 702),
	WINGAME1("oztma", "", "Oz - TMA.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2621536, 702),

	// Cover disc from Spanish PC Plus magazine. May simply load HTML pages from disc.
	WINGAME1_l("pcplus64", "Cover Disc", "cd.exe", "7c18c9a6af2694156bf09ed195c1ab09", 5014518, Common::ES_ESP, 702),

	MACGAME1_l("pettsonjk", "", "Findus3", "0944b962ebb00f4b5d5149d220f8449b", 115401, Common::DE_DEU, 702),
	WINGAME1_l("pettsonjk", "", "FINDUS3.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 6268578, Common::DE_DEU, 702),

	MACGAME1_l("pettsonjs", "", "Julpettson", "0944b962ebb00f4b5d5149d220f8449b", 115004, Common::SE_SWE, 702),
	WINGAME1_l("pettsonjs", "", "Julstart.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2610931, Common::SE_SWE, 702),

	MACGAME1_l("physicus", "", "Physikus", "5d3f89e052320f8ce140451c730e232b", 114645, Common::FR_FRA, 702),

	WINDEMO1("planetstrass", "Demo", "Planet.exe", "88d4c24f6d4b78a73ce5b07693eddbc8", 15434606, 702),

	MACGAME1_l("polis2", "", "POLIS 2", "fa52f0136cde568a46249ce74f01a324", 110730, Common::SE_SWE, 700),
	MACGAME1_l("polis2", "", "Kripos 2", "fa52f0136cde568a46249ce74f01a324", 111690, Common::NB_NOR, 700),
	WINGAME1_l("polis2", "", "Polis 2.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2678147, Common::SE_SWE, 700),
	WINGAME1_l("polis2", "", "Kripos2m.exe", "f790bb1816a6f89567d6f5671b751bf5", 3461770, Common::NB_NOR, 700),

	MACGAME1("poohac", "", "Pooh Activity Center", "0944b962ebb00f4b5d5149d220f8449b", 122576, 702),
	WINGAME1("poohac", "", "PoohAC.exe", "e40161ef4d2dceb372ee7113adf821aa", 1818138, 702),

	WINGAME1("princerave", "", "The_Artist.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2596022, 702),

	WINGAME1_l("princessfashion", "", "Disney.exe", "7c18c9a6af2694156bf09ed195c1ab09", 172782, Common::ES_ESP, 702),

	MACGAME1_l("rainbowfish1", "", "REGENBOOG", "dec72b4b6f8e97f1ea24361794bf0bdf", 116715, Common::NL_NLD, 702),
	WINGAME1_l("rainbowfish1", "", "Regenboog.exe", "88d4c24f6d4b78a73ce5b07693eddbc8", 1820762, Common::NL_NLD, 702),

	MACGAME1("rainbowfish2", "", "Rainbow Fish and the Whale", "dec72b4b6f8e97f1ea24361794bf0bdf", 116715, 702),
	MACGAME1_l("rainbowfish2", "", "Wal", "dec72b4b6f8e97f1ea24361794bf0bdf", 116715, Common::DE_DEU, 702),
	WINGAME1("rainbowfish2", "", "Rainbow2.exe", "06f5ec786e7f2e94e36571f651810fb4", 1817774, 702),
	WINGAME1_l("rainbowfish2", "", "Arcobaleno.exe", "06f5ec786e7f2e94e36571f651810fb4", 1817774, Common::IT_ITA, 702),
	WINGAME1_l("rainbowfish2", "", "wal.exe", "06f5ec786e7f2e94e36571f651810fb4", 1817774, Common::DE_DEU, 702),

	WINGAME1("relaxation", "ECD",  "solitude.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 1807680, 702),
	MACGAME1("relaxplayer", "ECD", "Relax",		   "0944b962ebb00f4b5d5149d220f8449b", 112738, 702),

	MACGAME1("smartsteps3rd", "", "Smart Steps 3rd Grade", "0944b962ebb00f4b5d5149d220f8449b", 116042, 702),
	WINGAME1("smartsteps3rd", "", "Smart Steps 3rd Grade.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1820192, 702),

	// Found on Solitudes Enhanced CDs
	// 1999 version is on Natural Relaxation
	// 2001 version is on Songbird Symphony, Stress Relief 2 and others
	MACGAME1("solmahjong", "1999 version", "Mahjong",	  "0944b962ebb00f4b5d5149d220f8449b", 113714, 702),
	MACGAME1("solmahjong", "2001 version", "Mahjong",	  "0944b962ebb00f4b5d5149d220f8449b", 112758, 702),
	WINGAME1("solmahjong", "1999 version", "Mahjong.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 2757472, 702),
	WINGAME1("solmahjong", "2001 version", "Mahjong.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 2832712, 702),

	WINGAME1("ssheidi1", "", "_heidi01.exe", "91823501d9b3f9b9ced814101312fd11", 5985066, 701),
	WINGAME1("ssheidi2", "", "_heidi02.exe", "91823501d9b3f9b9ced814101312fd11", 7783641, 701),

	// Produced by Davis-Panzer Merchandising; developed by Unis Multimedia, Hollywood, California (1999)
	MACGAME1("sshercules", "", "Hercules Screen Saver", "fa52f0136cde568a46249ce74f01a324", 259047, 700),
	WINGAME1("sshercules", "", "Herc Screen Saver.exe", "7c18c9a6af2694156bf09ed195c1ab09", 47066937, 702),

	// http://web.archive.org/web/20080412010505/http://www.beachware.com/download/
	MACGAME1("ssmorphclock", "", "MorphClock", "fa52f0136cde568a46249ce74f01a324", 189234, 700),
	WINGAME1("ssmorphclock", "", "Morph Clock.exe", "c1a2e8b7e41fa204009324a9c7db1030", 3800619, 700),

	// Screen Saver found on Solitudes Natural Relaxation ECD
	MACGAME1("ssnatureasart", "", "Nature As Art", "0944b962ebb00f4b5d5149d220f8449b", 199990, 702),
	WINGAME1("ssnatureasart", "", "Nature As Art.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 3246939, 702),

	// Copies provided in The Daily Mirror
	WINGAME2("thematrix", "", "Presentation.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2212124,
							  "intro.dir",        "ebe2cac80218c4933ecc609cd8ef27cc", 10368479, 700),

	MACGAME1_l("tkkgkit", "", "Phantombild Start", "0944b962ebb00f4b5d5149d220f8449b", 115754, Common::DE_DEU, 702),
	WINGAME1_l("tkkgkit", "", "Phantombild Start.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1820554, Common::DE_DEU, 702),

	MACGAME1_l("tomlisaindiens", "", "Tom en Lisa", "19f92df0c7cb7a17b02ed5c73b1ee4c1", 33105, Common::NL_NLD, 702),
	WINGAME1_l("tomlisaindiens", "", "TOM ET LISA.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 783498, Common::NL_NLD, 702),

	// Original filename is DreamLight® Verttice™ 3.0
	MACGAME1("verttice", "v3.0", "DreamLight Verttice 3.0", "0944b962ebb00f4b5d5149d220f8449b", 123353, 702),
	WINGAME1("verttice", "v3.0", "DreamLight Verttice 30.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 3010200, 702),

	MACGAME1("webmaster", "", "Webmaster", "0944b962ebb00f4b5d5149d220f8449b", 128297, 702),
	WINGAME1("webmaster", "", "Webmaster.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1820594, 702),

	// Found on アクティブマスコット・ハイジ (Heidi Desktop Mascot)
	// Create cards using ZUIYO's new characters Popee and Beast
	WINGAME1_l("zuiyomail", "", "MAIL2.exe", "1799677b9d869c8dc577d931e229ee3b", 2662488, Common::JA_JPN, 702),

//////////////////////////////////////////////////
//
// Macromedia Director v8
//
//////////////////////////////////////////////////

	// Original filenames are 1·2·3 Hablo Inglés.exe
	WINGAME2_l("123habloingles", "#1 El Viaje",		   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "f396a24506e44c07f301fc371a194890", 5183390, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#2 Las Profesiones", "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "b2cbc3d929eabf2104092c9085e3f799", 2033834, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#3 La Ciudad",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "aa90009810ae0f8dc6c18127e43ee653", 2636966, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#4 La Familia",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "fc150a2006ce5a275c91a973a9bb0620", 3023360, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#5 El Colegio",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "4068c7be2497cbfe5c817079f07f6448", 2850986, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#6 La Casa",		   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "f353c62bcec28a4fc46111186bd87d75", 5346849, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#7 Los Animales",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "ee91ed26714dff37f12338fe7f335c10", 3657617, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#8 La Granja",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "72fd0dd40798d7441908024509708e38", 2657540, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#9 Al Aire Libre",   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "073d9db7afc78e771c5f326a1005bb16", 4816002, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#10 El Parque",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "8cfaf779033cc9e2d894c4d79359c5f6", 4180556, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#11 Los Alimentos",  "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "4bafa0401749466dff3d6125d9161844", 2677780, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#12 Las Vacaciones", "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "9196f3ea7eac1b7f35c29977cbe2ab6e", 2522054, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#13 Diccionario",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "282a153f108019fc8cdd19c9d973db1f", 2389614, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#14 Karaoke",		   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "d9c5fa53e38e683465174740bd1a771d", 2789550, Common::ES_ESP, 851),

	MACGAME1_l("alfons", "", "Alfons", "08c9ea94f6469e71ae0c71987bbf6323", 199733, Common::SE_SWE, 851),
	WINGAME1_l("alfons", "", "Alfons.exe", "02913e7deeab4ece4ae44ad521082d4e", 2166668, Common::SE_SWE, 851),

	// Developed by Almajarra المجرة
	WINGAME2_l("alhisab", "", "Start.exe",	  "c163f36141579ee374f7b4b2bddee95a", 2117096,
							  "Preintro.dxr", "5fb6543cc57d53fac26d975922c18e48", 11170, Common::AR_ARB, 850),

	// Published by Future Soft of Nasr City, Cairo
	WINGAME1_l("anasheed", "", "Anasheed.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 3595486, Common::AR_ARB, 800),

	MACGAME2("avrilletgo", "ECD", "Projector",	   "4ea5fc09f79eee6dded94dc40f303779", 194863,
								  "movie.dxr",	   "6d0c0712fdd32cf1de489b4c152b2460", 50908119, 800),
	WINGAME2("avrilletgo", "ECD", "Projector.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 56830,
								  "movie.dxr",	   "b8dc39b080e4892913c2d302fec39567", 50907991, 800),

	MACDEMO1("balto2", "Trailer", "MacBolto", "08c9ea94f6469e71ae0c71987bbf6323", 155737, 850),
	WINDEMO1("balto2", "Trailer", "Balto.exe", "c163f36141579ee374f7b4b2bddee95a", 2309044, 850),

	MACGAME1_l("bamse1", "", "Spillerom", "a44511b8ff0e46b4f9c85dd1cb58d458", 199093, Common::DA_DAN, 851),
	MACGAME1_l("bamse2", "", "Bamses egen", "a44511b8ff0e46b4f9c85dd1cb58d458", 157079, Common::DA_DAN, 851),
	WINGAME1_l("bamse1", "", "spillerom.exe", "0c81c84ca4966313ad27d47daba44537", 2158320, Common::DA_DAN, 851),
	WINGAME1_l("bamse2", "", "Bamsesegen.exe", "0c81c84ca4966313ad27d47daba44537", 2158340, Common::DA_DAN, 851),

	MACGAME1("barbrapunzel", "", "Rapunzel", "08c9ea94f6469e71ae0c71987bbf6323", 213604, 850),
	MACDEMO1("barbrapunzel", "Trailer", "Trailer", "08c9ea94f6469e71ae0c71987bbf6323", 155737, 850),
	WINGAME1("barbrapunzel", "", "Rapunzel.exe", "c163f36141579ee374f7b4b2bddee95a", 2116696, 850),
	WINDEMO2("barbrapunzel", "Trailer", "Trailer.exe", "c163f36141579ee374f7b4b2bddee95a", 2303378,
										"Trailer.mov", "c23add499f206fb3f8e088cf315c2783", 17393683, 850),

	MACGAME1_l("bibifilm", "", "Filmstudio", "3ba983d2dd8c94d882c0de01ab920c43", 1249397, Common::DE_DEU, 850),
	WINGAME1_l("bibifilm", "", "Filmstudio_start.exe", "c163f36141579ee374f7b4b2bddee95a", 148898, Common::DE_DEU, 850),

	// Finnish title is Ville & Lilli: Ihan Pihalla
	// Developer website calls this Double Trouble: Wacky Woods,
	// although we don't know if it was actually released in English
	// https://web.archive.org/web/20060208235824/http://billetrille.savannah.dk/dtpages.php3?page_id=208&lang=english
	MACDEMO1_l("billetrille2", "Demo", "VilleLilli2Demo", "4ea5fc09f79eee6dded94dc40f303779", 196171, Common::FI_FIN, 800),

	WINGAME2("bobmambo5", "ECD", "START.EXE", "e24d4bab978b1a5c2326d2c56cf4d781", 6980680,
								 "MAMBO.MOV", "990db0c7187621250dfca0a55996538e", 39868175, 800),

	WINGAME1_l("boeboekshaboe", "", "Arcade.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2389026, Common::NL_NLD, 800),
	WINDEMO1_l("boeboekstocht", "Demo", "Boeboeks.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 58054, Common::NL_NLD, 800),

	MACGAME1("broadwayyb", "", "Startmac",	   "4ea5fc09f79eee6dded94dc40f303779", 196199, 800),
	WINGAME1("broadwayyb", "", "YEARBOOK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2256212, 800),

	MACGAME1("cmi", "CM38/10/01", "CMi_38_Mac", "f065c75691d28120e9f630448c3b1b71", 1225735, 800),
	WINGAME1("cmi", "CM38/10/01", "CMi_38_Win.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2514361, 800),

	// Distributed by Océano Multimedia (Colombia) of Cota, Cundinamarca (2000)
	WINGAME2_l("deportes", "", "start.exe",    "c163f36141579ee374f7b4b2bddee95a", 2383840,
							   "Deportes.dxr", "2330cc03f17c2aa4a4a10e76bc774fe8", 3985672, Common::ES_ESP, 850),

	MACGAME1("dispix2and3", "", "2nd and 3rd Grade", "a44511b8ff0e46b4f9c85dd1cb58d458", 220552, 851),
	WINGAME1("dispix2and3", "", "2nd and 3rd Grade.exe", "68835b24dd317fbc96e4a8c53892a361", 2630239, 851),

	WINGAME1("eureka", "", "Promo.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 17971868, 800),

	WINGAME2_l("fcdk", "", "Start.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 511933,
			"boma.dir", "484a5f57cde0ce4f035be6be933ede34", 10561442, Common::NL_NLD, 800),

	// De drie werelden van Flipper & Lopaka published by Transposia of Ghent, Flanders
	MACGAME2("flipper1", "",   "Flipper",	  "305030a32728843d9e953b8e0f53a149", 6129,
							   "Splash.dxr",  "e2e9db4d52497b66d30b67257ac0b9f3", 3227343, 800),
	MACGAME2_l("flipper1", "", "Flipper",	  "305030a32728843d9e953b8e0f53a149", 6129,
							   "Splash.dxr",  "690080bb870fa4f9dd92665dd05a6e75", 3403943, Common::FR_FRA, 800),
	MACGAME2_l("flipper1", "", "Flipper",	  "26342893ab4fceffc6c6efaa81718780", 6165,
							   "Splash.dxr",  "5430500b5660bd30ec9fd72784233560", 3521553, Common::NL_NLD, 800),
	WINGAME2_l("flipper1", "", "Flipper.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 57196,
							   "Splash.dxr",  "2cb70c1101fc967f6b134fd1237d40a7", 3403815, Common::FR_FRA, 800),
	WINGAME2_l("flipper1", "", "Flipper.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 57196,
							   "Splash.dxr",  "34027bf8975bced3a92ea6a1d41ccf21", 3521425, Common::NL_NLD, 800),

	MACGAME1_l("flipper2", "", "Secrets", "039fd480c0ba5b06a88c233f79bbabbe", 8429, Common::NL_NLD, 850),
	WINGAME1_l("flipper2", "", "Secrets.exe", "c163f36141579ee374f7b4b2bddee95a", 57184, Common::NL_NLD, 850),

	MACGAME1_l("forestiajr", "", "Forestia Aufstand im Zoo", "75e71e2abbe6cf6e79a62be76cc05d06", 157104, Common::DE_DEU, 850),
	WINGAME1_l("forestiajr", "", "Forestia Aufstand im Zoo.exe", "14a1ca568d9188926eb70827f42ac856", 2166796, Common::DE_DEU, 851),

	MACGAME1("fpairport", "", "Discovery Airport", "08c9ea94f6469e71ae0c71987bbf6323", 206619, 851),
	WINGAME1("fpairport", "", "Discovery Airport.exe", "0c81c84ca4966313ad27d47daba44537", 2156986, 851),

	WINGAME1("fractiondecimal", "", "Fd.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4775506, 800),

	// Found as mini-game on Chillin Out ECD from Smash Hits magazine
	WINGAME1("freeallangels", "", "FREE ALL ANGELS.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2248678, 800),

	MACGAME1("garfieldmadcats", "", "Mad About Cats", "4ea5fc09f79eee6dded94dc40f303779", 194891, 800),
	WINGAME1("garfieldmadcats", "", "Garfield Start.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2695719, 800),

	// Mac version on same disc is D6
	WINGAME1_l("garygadget2", "", "okki.exe", "0c81c84ca4966313ad27d47daba44537", 2513593, Common::NL_NLD, 851),

	// Flugzeuge bauen mit Willy Werkel localized by Terzio Verlag, Munich (2001)
	WINGAME1_l("garygadget3", "", "WillyFlug.exe", "70a7b053c1a60617d3baace061fcba54", 9158814, Common::DE_DEU, 800),

	// Mac installers also use Director
	MACGAME2_l("garygadget4", "", "MulleHus",	  "a44511b8ff0e46b4f9c85dd1cb58d458", 157051,
								  "01.dxr",	 	  "a443d3493ad279d26ce08814d8636d97", 44658, Common::FI_FIN, 851),
	MACGAME2_l("garygadget4", "", "MulleHus",	  "a44511b8ff0e46b4f9c85dd1cb58d458", 157051,
								  "01.dxr",	 	  "bc776ee31fa7e4426d128ef8bceb4cc1", 44846, Common::SE_SWE, 851),
	WINGAME1_l("garygadget4", "", "MulleHus.exe", "0c81c84ca4966313ad27d47daba44537", 3760882, Common::SE_SWE, 851),
	WINGAME1_l("garygadget4", "", "MulleHus.exe", "0c81c84ca4966313ad27d47daba44537", 3793560, Common::FI_FIN, 851),

	// Mac OS X and Windows versions are D9
	MACGAME1_l("garygadget5", "Classic OS", "Miel5 OS9", "789536da81694518f494945bb161ace9", 234210, Common::NL_NLD, 851),

	// Mac version on CD02 is D10
	WINGAME1("girlsaloudbox", "CD02 No Good Advice", 		"Clickme.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2911148, 800),
	MACGAME1("girlsaloudbox", "CD03 Life Got Cold",  		"Enhanced",	   "08c9ea94f6469e71ae0c71987bbf6323", 190678, 850),
	WINGAME2("girlsaloudbox", "CD03 Life Got Cold",  		"Start.exe",   "c163f36141579ee374f7b4b2bddee95a", 2117284,
													 		"ECD.dxr",	   "7d8cb42d6784efca5dda28e879423f84", 14581925, 850),
	MACGAME1("girlsaloudbox", "CD05 The Show",		 		"Enhanced",	   "08c9ea94f6469e71ae0c71987bbf6323", 186904, 850),
	WINGAME2("girlsaloudbox", "CD05 The Show",		 		"Start.exe",   "c163f36141579ee374f7b4b2bddee95a", 2117284,
													 		"ECD.dxr",	   "4517e9e28fcec6762e8155765221d9e8", 3446870, 850),
	WINGAME2("girlsaloudbox", "CD13 Something Kinda Ooooh", "Start.exe",   "c163f36141579ee374f7b4b2bddee95a", 2117284,
													 		"ECD.dxr",	   "27e4760a954f90285f80331ed5036426", 4236916, 850),

	MACGAME1_l("girlspack", "", "Das Girl's Pack", "4ea5fc09f79eee6dded94dc40f303779", 214488, Common::DE_DEU, 800),
	WINGAME2_l("girlspack", "", "Projector.exe",   "e24d4bab978b1a5c2326d2c56cf4d781", 2251176,
								"picture.cxt",	   "e69c284d644c4f446b2ec4d876f94f17", 568440, Common::DE_DEU, 800),

	// Early Education Series from Ariss Computer Inc. of Beirut
	WINGAME1_l("hamamalachkal", "", "SHAPE.EXE",  "c163f36141579ee374f7b4b2bddee95a", 3784670, Common::AR_ARB, 850),
	WINGAME1_l("hamamalalwan", "",  "COLOR.EXE",  "c163f36141579ee374f7b4b2bddee95a", 3786748, Common::AR_ARB, 850),
	WINGAME1_l("hamamalhuruf", "",	"LETTER.EXE", "c163f36141579ee374f7b4b2bddee95a", 3797680, Common::AR_ARB, 850),

	// Mac OS X executable is D9
	MACGAME1("heuther", "Classic OS", "HuetherOS9", "789536da81694518f494945bb161ace9", 178551, 851),

	WINGAME1_l("irpf2002", "", "Tutorial do IRPF2002.exe", "c163f36141579ee374f7b4b2bddee95a", 3197116, Common::PT_BRA, 850),

	MACGAME1("kellyparade", "", "Kelly Club Pet Parade", "08c9ea94f6469e71ae0c71987bbf6323", 155765, 851),
	WINGAME1("kellyparade", "", "Kelly Club Pet Parade.exe", "c163f36141579ee374f7b4b2bddee95a", 2116952, 851),

	WINGAME1("kidsmathsquest", "", "Ekmquest.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4775408, 800),

	// Vlaams Centrum voor Agro- en Visserijmarketing is a government agency that promotes agricultural products
	// The CD-ROM offers the opportunity to work on healthy food, more specifically on fruit and vegetables
	// Additional activities are offered for parents, teachers and management
	MACGAME1_l("kjoeties", "", "Kjoeties",	   "3df301ad7614245a6ab1fb5d9ae6e474", 213295, Common::NL_NLD, 800),
	WINGAME1_l("kjoeties", "", "Kjoeties.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2281118, Common::NL_NLD, 800),

	// From Dutch Pettson 1 v3.0 disc
	// Static screen with 2 http links (one to local html files) and a mailto link
	// Original Mac and Win filenames are Méér speel-en leerplezier!
	MACGAME1_l("lannoo", "", "Meer speel-en leerplezier!", "08c9ea94f6469e71ae0c71987bbf6323", 155737, Common::NL_NLD, 850),
	WINGAME1_l("lannoo", "", "Meer speel-en leerplezier!.exe", "c163f36141579ee374f7b4b2bddee95a", 2564520, Common::NL_NLD, 850),

	// Movie preview. Mac file system simply links to QuickTime movie.
	WINDEMO1("lbt8", "Preview", "lbt.exe", "c163f36141579ee374f7b4b2bddee95a", 2210752, 850),

	MACGAME2("lewisclark", "", "Begin",		   "08c9ea94f6469e71ae0c71987bbf6323", 155737,
							   "mainmenu.dxr", "31bd20f92460376a62f3b652dd9a5ec8", 3828023, 850),
	WINGAME2("lewisclark", "", "Begin.exe",	   "c163f36141579ee374f7b4b2bddee95a", 2837534,
							   "mainmenu.dxr", "744f296ef21e07252253bf499e6e5e68", 3831200, 850),

	MACGAME1("lewisclarkss", "", "Lewis and Clark Screen Saver", "b1bf6ceb4afd79814f93ee1d866f9a29", 243455, 850),
	WINGAME1("lewisclarkss", "", "Lewis and Clark Screen Saver.exe", "c163f36141579ee374f7b4b2bddee95a", 29172512, 850),

	// Plays school instructional videos, loads PDF documents, installs D10 game
	WINGAME1_l("limit0inici", "", "limit0_inici.exe", "0c81c84ca4966313ad27d47daba44537", 723194, Common::CA_ESP, 851),

	WINGAME1_l("lunes", "", "Lunes.exe", "9482a4a5f6ae02470ce1863808120f6e", 2258509, Common::IT_ITA, 851),

	// Advertainment film from Ferrero (chocolates)
	WINGAME1_l("magicanti", "", "Magicanti.exe", "0c81c84ca4966313ad27d47daba44537", 2158202, Common::IT_ITA, 851),

	MACDEMO1("mickeyk", "D8 Demo",	 "MickeyK",		 "4ea5fc09f79eee6dded94dc40f303779", 197114, 800),
	WINDEMO1("mickeyk", "D8 Demo",	 "MickeyK.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2532440, 800),
	MACDEMO1("mickeyp", "D8 Demo",	 "MickeyP",		 "4ea5fc09f79eee6dded94dc40f303779", 198055, 800),
	WINDEMO1("mickeyp", "D8 Demo",	 "MICKEYP.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2542920, 800),
	MACDEMO1("mickeyt", "D8 Demo",	 "MickeyT",		 "4ea5fc09f79eee6dded94dc40f303779", 197788, 800),
	WINDEMO1("mickeyt", "D8 Demo",	 "MickeyT.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2277079, 800),
	MACDEMO1("mickeyk", "Slideshow", "sMickeyK.mac", "4ea5fc09f79eee6dded94dc40f303779", 197086, 800),
	WINDEMO1("mickeyk", "Slideshow", "sMickeyK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4847376, 800),
	MACDEMO1("mickeyp", "Slideshow", "sMickeyP.mac", "4ea5fc09f79eee6dded94dc40f303779", 198027, 800),
	WINDEMO1("mickeyp", "Slideshow", "sMickeyP.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4518947, 800),
	WINDEMO1("mickeyt", "Slideshow", "sMickeyT.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4290004, 800),

	// Published by Fujitsu BSC, Minato City, Tokyo
	MACGAME1_l("momotaro", "", "MOMOTARO", "2e860522900a5342e52e5ce51bcad9dd", 195098, Common::JA_JPN, 800),
	WINGAME1_l("momotaro", "", "MOMOTARO.EXE", "a60f99447824a8ef70799dd7596b8945", 4011752, Common::JA_JPN, 800),

	// Produced and developed by New Tier Inc., Scottsdale, Arizona
	WINGAME1("njdevils2001", "", "NJDevils.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 45455403, 800),

	MACGAME2_l("okay2000", "", "Start",	   "8c1b4ddb1adff89deaba119f7cf8df7b", 195159,
							 "TITEL.DXR",  "6190d0e21cb88e9f37afce89b41aa8ff", 1187527, Common::DE_DEU, 800),
	WINGAME1_l("okay2000", "", "Ok0032.exe", "70a7b053c1a60617d3baace061fcba54", 3565692, Common::DE_DEU, 800),

	MACGAME1_l("operafatal", "Classic OS", "Opera Classic", "78e78f91a6e42ece5a585c3a3dc81de3", 172200, Common::DE_DEU, 800),

	WINGAME1("pcformat", "PCF132 CD 02/02", "PCF132.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4722596, 800),

	// Mac OS X installer runs the game in Classic environment
	MACGAME1_l("pettson1", "v3.0", "Spelen",	   "a44511b8ff0e46b4f9c85dd1cb58d458", 158043, Common::NL_NLD, 851),
	WINGAME1_l("pettson1", "v3.0", "Spelen.exe",   "568c6f849ff7f2104636a99f151a6cd6", 3249822, Common::NL_NLD, 851),

	//Pettson & Findus in de tuin (Libelle)
	WINGAME1_l("pettson2", "", "pettstart.exe",   "518a98696fe1122e08410b0f157f21bf", 1534912, Common::NL_NLD, 851),
	MACGAME1_l("pettson2", "", "Spelen",	   "124ee629902a66fe1fb20b18ae4a1788", 3924112, Common::NL_NLD, 851),

	MACGAME1_l("pettson3", "",	   "Pettson3",	   "4ea5fc09f79eee6dded94dc40f303779", 211841, Common::SE_SWE, 800),
	WINGAME1_l("pettson3", "",	   "Pettson3.exe", "1c753fb8361ba617ae6142fcdd12d3d5", 2443868, Common::SE_SWE, 800),

	WINDEMO1("phonicsquest", "Demo", "Phonics Quest Demo.exe", "0c81c84ca4966313ad27d47daba44537", 2202074, 851),

	WINGAME2_l("plcd", "Nº4 2001", "Start.exe",		  "e24d4bab978b1a5c2326d2c56cf4d781", 2247370,
								   "PL_2001_#04.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 3842928, Common::RU_RUS, 800),

	WINGAME2_l("polis3", "", "launcher.exe", "0c81c84ca4966313ad27d47daba44537", 2860282,
							 "polis3.dxr",	 "1a391250c502a1f55da5a4d0438b493d", 3533782, Common::ES_ESP, 851),

	WINGAME1("poohb", "", "POOHBABY.EXE",  		 "e24d4bab978b1a5c2326d2c56cf4d781", 2290422, 800),
	MACGAME1("poohp", "", "PoohP.Mac",	   		 "4ea5fc09f79eee6dded94dc40f303779", 197191,  800),
	WINGAME1("poohp", "", "PoohP.exe",	   		 "e24d4bab978b1a5c2326d2c56cf4d781", 2692574, 800),
	WINGAME1("pooht", "", "PoohT.exe",	   		 "e24d4bab978b1a5c2326d2c56cf4d781", 2690898, 800),
	MACDEMO1("poohk", "D8 Demo", "PoohK",	   	 "4ea5fc09f79eee6dded94dc40f303779", 196535, 800),
	WINDEMO1("poohk", "D8 Demo", "PoohK.exe", 	 "e24d4bab978b1a5c2326d2c56cf4d781", 2688206, 800),
	MACDEMO1("poohp", "D8 Demo", "PoohP", 		 "4ea5fc09f79eee6dded94dc40f303779", 197191, 800),
	WINDEMO1("poohp", "D8 Demo", "PoohP.exe", 	 "e24d4bab978b1a5c2326d2c56cf4d781", 2692738, 800),
	MACDEMO1("pooht", "D8 Demo", "PoohT",		 "4ea5fc09f79eee6dded94dc40f303779", 197191, 800),
	WINDEMO1("pooht", "D8 Demo", "PoohT.exe", 	 "e24d4bab978b1a5c2326d2c56cf4d781", 2691062, 800),
	MACDEMO1("poohk", "Slideshow", "sPoohK.mac", "4ea5fc09f79eee6dded94dc40f303779", 196507, 800),
	WINDEMO1("poohk", "Slideshow", "sPoohK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 3933055, 800),
	WINDEMO1("poohk", "Slideshow", "PoohKD.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5985988, 800),
	WINDEMO1("poohp", "Slideshow", "sPoohP.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4080558, 800),
	WINDEMO1("poohp", "Slideshow", "PoohPD.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 6362184, 800),
	WINDEMO1("pooht", "Slideshow", "PoohTD.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5596394, 800),

	WINGAME1_l("ratinho", "", "ratinho.exe", "c163f36141579ee374f7b4b2bddee95a", 2119876, Common::PT_BRA, 850),

	//Speeltijd met spookjes
	WINGAME2_l("recfantome", "", "Speel.exe", "2942c9272bb0f41e53f5d103af16195c", 3443389,
			"fantome.ico", "d357185c51154ed60bb05aea3689dc60", 2238, Common::NL_NLD, 800),

	// Playable demo for Meteor Madness and Tremor Trouble
	MACGAME1("rh", "", "RHDemo", "08c9ea94f6469e71ae0c71987bbf6323", 155737, 850),
	WINGAME1("rh", "", "RHDemo.exe", "c163f36141579ee374f7b4b2bddee95a", 2250046, 850),

	WINDEMO1("rhem1", "Demo", "RhemDemo.exe", "70a7b053c1a60617d3baace061fcba54", 3061118, 800),

	MACGAME1("rhlava", "", "RH Lava Landslide", "08c9ea94f6469e71ae0c71987bbf6323", 161151, 850),
	WINGAME1("rhlava", "", "RH Lava Landslide.exe", "c163f36141579ee374f7b4b2bddee95a", 2116280, 850),
	MACGAME1("rhmeteor", "", "RH Meteor Madness", "4ea5fc09f79eee6dded94dc40f303779", 199688, 800),
	WINGAME1("rhmeteor", "", "RescueHeroes.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2248192, 800),

	MACGAME2("royksoppam", "Bonus disc", "Projector", "a44511b8ff0e46b4f9c85dd1cb58d458", 155743,
										 "MAIN.dxr",  "b03dfbaac4bf75198d724048e4fdad80", 3236242, 851),

	// Produced and developed by New Tier Inc., Scottsdale, Arizona
	WINGAME1("saspurs2001", "", "Spurs.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5924396, 800),
	WINGAME1("saspurs2005", "", "Spurs.exe", "98e75b2c5561f9be40aa745f35f22244", 5508840, 800),

	MACDEMO1("secretkeys", "Demo", "Secret Keys Demo", "a44511b8ff0e46b4f9c85dd1cb58d458", 155771, 851),
	WINDEMO1("secretkeys", "Demo", "Secret Keys Demo.exe", "0c81c84ca4966313ad27d47daba44537", 2200706, 851),

	// Mac OS X executables are D9
	MACGAME1_l("sethi2", "Classic OS", "Sethi Incas",  "41e7d3bf50e4085c35eba322aa63b238", 161027, Common::FR_FRA, 851),
	MACGAME1_l("sethi3", "Classic OS", "Start Me OS9", "789536da81694518f494945bb161ace9", 179887, Common::DE_DEU, 851),
	WINGAME1_l("sethi2", "", "Sethi_Incas.exe", "0c81c84ca4966313ad27d47daba44537", 2158774, Common::FR_FRA, 851),

	WINGAME1_l("skeeto10", "", "mm7main.exe", "0c81c84ca4966313ad27d47daba44537", 12051446, Common::DA_DAN, 851),

	// Dutch demos found on Flipper & Lopaka compilation
	MACGAME1_l("skippy", "",     "Skippy",      "4ea5fc09f79eee6dded94dc40f303779", 197127, Common::NL_NLD, 800),
	MACDEMO1_l("skippy", "Demo", "Skippy Demo", "4ea5fc09f79eee6dded94dc40f303779", 197127, Common::NL_NLD, 800),

	// Loads two external Flash games and one external Director game
	WINGAME1("smashchillin", "ECD", "Smash.exe", "c163f36141579ee374f7b4b2bddee95a", 2152147, 850),

	MACGAME2("songbird", "ECD", "Solitudes",			 "08c9ea94f6469e71ae0c71987bbf6323", 157045,
								"Songbird Symphony.CDQ", "8383a2142c38600d464847409b76db5a", 5925, 850),
	WINGAME1("songbird", "ECD", "solitudes.exe",		 "c163f36141579ee374f7b4b2bddee95a", 2118995, 850),

	MACGAME2("stressrelief2", "ECD", "Solitudes",					 "08c9ea94f6469e71ae0c71987bbf6323", 157045,
									 "Natural Stress Relief II.CDQ", "18256d220db28ca68c8907d5ac590190", 12912, 850),

	WINGAME1("spykids3d", "", "Spy Kids 3D.exe", "c163f36141579ee374f7b4b2bddee95a", 1314722, 850),

	// Found on JCPenney Unwrap the Magic (2000)
	MACGAME1("ss102dalmations", "", "102 Dalmations",	 "7bcc1b0cae920a784384bfcf7de895bf", 327494, 800),
	WINGAME1("ss102dalmations", "",	"102dalmatians.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2918994, 800),
	MACGAME1("sspeekaboo", "",		"Peek-a-boo Pooh",	 "7bcc1b0cae920a784384bfcf7de895bf", 327735, 800),
	WINGAME1("sspeekaboo", "",		"pooh.exe",			 "e24d4bab978b1a5c2326d2c56cf4d781", 2485973, 800),
	MACGAME1("ssholidaymickey", "",	"Holiday Mickey",	 "7bcc1b0cae920a784384bfcf7de895bf", 327494, 800),
	WINGAME1("ssholidaymickey", "",	"mickey.exe",		 "e24d4bab978b1a5c2326d2c56cf4d781", 3200102, 800),

	MACGAME1("tkkg9", "", "TKKG-Start", "2c64a568bd26944452957a53af85b067", 197423, 800),
	WINGAME1("tkkg9", "", "TKKG 9.exe", "70a7b053c1a60617d3baace061fcba54", 2329244, 800),

	// Original Mac filename is ときメモタイピング
	MACGAME1_l("tokimemotype1", "", "Tokimemo Typing", "80b8d1697b18f6f2d8a2813a594cead2", 255114, Common::JA_JPN, 851),
	WINGAME1_l("tokimemotype1", "", "tkmktype.exe",	"d5069f2a24854aa78f8fbd01462ba37c", 2160344, Common::JA_JPN, 851),

	WINGAME1("tweeniesrtp", "", "BBC Tweenies Tour.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5435024, 800),

	WINGAME1_l("unlimitedcl", "", "CD-ROMs Educativos.exe", "0c81c84ca4966313ad27d47daba44537", 2366839, Common::ES_ESP, 851),

	MACGAME2("unwrap", "", "Start Here", "4ea5fc09f79eee6dded94dc40f303779", 194863,
						   "unwrap.dxr", "4016e7c9c9782eb8533d68aa96898066", 50599511, 800),
	WINGAME2("unwrap", "", "Start.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 3631198,
						   "unwrap.dxr", "69dd7f79e76af5b0eab89d5ae589f836", 50599487, 800),

	MACGAME1("vug2005", "", "VUGames.osx", "a171b7a952d1ac68ae3cd419d6dfc674", 262042, 850),
	WINGAME1("vug2005", "", "VUG_2005.exe", "c163f36141579ee374f7b4b2bddee95a", 2823410, 850),

	MACGAME1("westwood", "", "WW DPK", "4ea5fc09f79eee6dded94dc40f303779", 194863, 800),
	WINGAME1("westwood", "", "WW_DPK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2351418, 800),

	// Original Mac filename is 妖精妖怪図鑑
	MACGAME1_l("yokaizukan", "", "xn--lcs34da058ddt2bxt3a", "dd3c8aeb1d2847c77db701ad49ad8186", 163060, Common::JA_JPN, 850),
	WINGAME1_l("yokaizukan", "", "xn--.exe-ul4gs3la685khv6dnj8b", "b541b4e21a7284bef5180907f72d5702", 2118234, Common::JA_JPN, 850),

	MACGAME1_l("zwergnase", "", "Zwergnase", "afc6a14573e21d1de9d0c7fbb1ceb874", 181398, Common::DE_DEU, 851),
	WINGAME1_l("zwergnase", "", "ZWERGNASE.EXE", "0c81c84ca4966313ad27d47daba44537", 2383258, Common::DE_DEU, 851),

//////////////////////////////////////////////////
//
// Macromedia Director MX (v9)
//
//////////////////////////////////////////////////

	WINDEMO1("barbpauper", "Demo", "PPDemo.exe", "dde8ac96c47b16cb802a38feb1f1df19", 2519617, 900),

	WINGAME1_l("barbswanlake", "", "SwanLake.exe", "310659620631c126edb6943af1f83e38", 4096651, Common::FR_FRA, 900),
	WINDEMO1("barbswanlake", "Demo", "SwanLake.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2385166, 900),

	WINGAME1_l("bpapao", "", "bpapao.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 4829907, Common::PT_BRA, 900),

	WINGAME1("bobcastle", "", "Bob's Castle Adventure.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 887534, 900),
	WINDEMO2("bobteam", "Trailer", "trailer.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 142794,
								   "trailer.mov", "798658eb3bdb3bb967384350f428854b", 4141897, 900),

	// There is an OS X installer, but the game itself runs in Classic environment (up to OS 10.4)
	MACGAME1_l("boulebill", "", "Boule et Bill Au voleur !!!", "9ba96b315646d5f62be9ab5597d2e0d7", 176370, Common::FR_FRA, 901),
	WINGAME1_l("boulebill", "", "Au voleur!.exe", "4b89dba499aefda5201eef3d27963d01", 2186312, Common::FR_FRA, 900),

	WINGAME2_l("eso", "", "START.EXE",	"c612aa43e7ef55aa4fd2e1085fb1ef7a", 3752491,
						  "ESO_D1.DXR", "6d39a8ef9a8060e21616f23872c581b6", 2075636, Common::ES_ESP, 900),

	// Häuser bauen mit Willy Werkel localized by Terzio Verlag, Munich (2003)
	WINGAME1_l("garygadget4", "", "WILLYHAU.EXE", "e1cb27c285fc19a989f152b785b0f375", 137056, Common::DE_DEU, 900),

	// Mac Classic OS version is D8
	// German Mac OS X version is D10. Classic OS is not supported.
	// Raumschiffe bauen mit Willy Werkel published by Terzio, Munich (2005)
	MACGAME1_l("garygadget5", "OS X", "Miel5 OSX",           "d483e955df901222145267d2ad729ea2", 284016, Common::NL_NLD, 900),
	WINGAME1_l("garygadget5", "",     "WillyRaumschiff.exe", "6b9dc16e1d307150bfec28729b59a523", 2185322, Common::DE_DEU, 900),
	WINGAME1_l("garygadget5", "",     "Miel5.exe",           "7202313e2b177197b62e84dcf24d1292", 4253422, Common::NL_NLD, 900),

	MACGAME2("gp2006", "", "CLICK ME",	"d483e955df901222145267d2ad729ea2", 233800,
						   "Intro.cxt", "c7d1f703b3cfa4d134f601d17f8563a1", 673544, 900),
	WINGAME1("gp2006", "", "CLICK_ME.EXE", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2182372, 900),

	// Language selection in German, English, French
	// Use Mac OS X executable in osx folder on disc
	MACGAME1("heidi", "", "Heidi", "d483e955df901222145267d2ad729ea2", 267460, 900),
	WINGAME1("heidi", "", "Heidi.exe", "25d73085a5735a3badecf8cf1945ffc3", 95418, 900),

	// Classic OS executable is D8
	MACGAME1("heuther", "OS X", "HuetherOSX", "d483e955df901222145267d2ad729ea2", 228355, 900),
	WINGAME1("heuther", "", "Huether.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 3353374, 900),

	// Original Mac filename is Mats und das rätselhafte Tier
	// Mac version must be installed. Additional OS X installer runs the game Classic environment.
	MACGAME1_l("mats3", "", "Mats und das ratselhafte Tier", "9ba96b315646d5f62be9ab5597d2e0d7", 176978, Common::DE_DEU, 901),
	WINGAME1_l("mats3", "", "Mats3.exe", "4b89dba499aefda5201eef3d27963d01", 2187308, Common::DE_DEU, 900),

	MACGAME1_l("operafatal", "OS X", "Opera OSX", "3ab7133c17cd4f175e5cb14c6750766e", 222001, Common::DE_DEU, 900),
	WINGAME1_l("operafatal", "", "Opera.exe", "05e89a3d53d270cac3b53e0a6f9352f5", 2747652, Common::DE_DEU, 900),

	// Original filenames are Spökmaskinen (OS X) and Spökmaskinen.exe
	MACGAME1_l("pettson4", "", "Spokmaskinen (OS X)", "d483e955df901222145267d2ad729ea2", 284153, Common::SE_SWE, 900),
	WINGAME1_l("pettson4", "", "Spokmaskinen.exe", "627d23c658a36a3b6d0053a6dcda1a37", 2330628, Common::SE_SWE, 900),

	WINGAME1("sajaklucky", "Deluxe", "LuckyLettersDeluxe.exe", "001d65a360a61861118f3cfa92c68ef3", 14018695, 900),

	// Classic Mac OS and Windows executables are D8
	MACGAME1_l("sethi2", "OS X", "Sethi Incas",	 "d483e955df901222145267d2ad729ea2", 233556, Common::FR_FRA, 900),
	MACGAME1_l("sethi3", "OS X", "Start Me OSX", "d483e955df901222145267d2ad729ea2", 229696, Common::DE_DEU, 900),
	WINGAME2_l("sethi3", "", "StartMe.exe", 	 "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2186964,
							 "StartMe.dxr", 	 "55248d9db7aa326eb740b2532ba83252", 15584, Common::DE_DEU, 900),

	WINGAME1("stalker", "Press Kit", "Stalker.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 55314588, 900),

	// Most likely this is ES_MEX. Find more examples to justify a new language code.
	WINGAME1_l("timmysafari", "", "safari.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2891613, Common::ES_ESP, 900),

//////////////////////////////////////////////////
//
// Macromedia Director MX 2004 (v10)
//
//////////////////////////////////////////////////

	WINGAME2_l("1contre100", "", "start.exe", "00541c08177b6d55a3df893bcfccc843", 2764454,
								 "main.dxr",  "c2bf555f6209e51a1c8cce29c8e6534f", 43315121, Common::FR_FRA, 1010),

	// Found on AOL 9.0 promo CD
	// Game description is based on desktop shortcut after installation
	WINGAME1("aolstarwars", "", "STARWARS.EXE", "bcf64185ce848b7b70858d62945f48a8", 25472412, 1010),

	MACGAME1("babarcoins", "", "Mac.osx", 		"a171b7a952d1ac68ae3cd419d6dfc674", 309249, 1010),
	WINGAME2("babarcoins", "", "Start.exe",		"b198e9bf56c679747e4fd0972d5ba7b7", 2659300,
							   "ba-01_A01.dxr", "cb38821091082aeb097e88551b791e05", 9946435, 1010),

	// See notes in D6 entry
	MACGAME1("checkersvillage", "OS X", "village.osx", "f991fbe24bc002a215fda2c58fbb572f", 5880680, 1010),

	// German Win version is D9
	// Installer & deinstaller also use Director
	MACGAME1_l("garygadget5", "", "WillyRaumschiff OSX", "b7181d7af306a3d336e5cc70cc77c641", 318788, Common::DE_DEU, 1010),

	// CDs 03-05 are D8 for Mac and Windows
	// CD02 and CD13 are D8 for Windows and D10 for Mac
	// Several discs contain mini-games using Flash Player (v6,v7,v8)
	MACGAME1("girlsaloudbox", "CD02 No Good Advice",			  		"OSX",		  		   "666bfa2ee1ae12443ce06f5dd142502b", 331558, 1000),
	MACGAME1("girlsaloudbox", "CD06 Love Machine (Classic)",			"ECD.classic", 		   "670b37815e4e3f61b7af77cc676a791c", 259405, 1000),
	MACGAME1("girlsaloudbox", "CD06 Love Machine (OS X)",				"ECD.osx",	  		   "666bfa2ee1ae12443ce06f5dd142502b", 309243, 1000),
	WINGAME2("girlsaloudbox", "CD06 Love Machine",				  		"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 8376442,
																		"GirlsAloud.mov",	   "1b689c2002aa2397fde706f197aa11d1", 47282498, 1000),
	MACGAME1("girlsaloudbox", "CD07 I'll Stand By You (Classic)",		"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 260404, 1000),
	MACGAME1("girlsaloudbox", "CD07 I'll Stand By You (OS X)",			"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 310246, 1000),
	WINGAME2("girlsaloudbox", "CD07 I'll Stand By You",				  	"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 8830599,
																		"Stand Final.mov",	   "823208f98b99ba3a4987e3085dfd624f", 44262711, 1000),
	MACGAME1("girlsaloudbox", "CD08 Wake Me Up (Classic)",				"ECD.classic", 		   "670b37815e4e3f61b7af77cc676a791c", 258001, 1000),
	MACGAME1("girlsaloudbox", "CD08 Wake Me Up (OS X)",					"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 307842, 1000),
	WINGAME2("girlsaloudbox", "CD08 Wake Me Up",				  		"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 7455567,
																		"Girls AloudWake.mov", "a70ba1e1e16cbf213a6155485533495e", 52371605, 1000),
	MACGAME1("girlsaloudbox", "CD09 Long Hot Summer (Classic)",			"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 205687, 1000),
	MACGAME1("girlsaloudbox", "CD09 Long Hot Summer (OS X)",			"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 311946, 1000),
	WINGAME2("girlsaloudbox", "CD09 Long Hot Summer",					"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 9316487,
																		"SUMMER.DAT",		   "a56b212624c0a1742f6b579581c8384e", 118528, 1000),
	MACGAME1("girlsaloudbox", "CD10 Biology (Classic)",					"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 205856, 1000),
	MACGAME1("girlsaloudbox", "CD10 Biology (OS X)",					"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 312115, 1000),
	WINGAME2("girlsaloudbox", "CD10 Biology",				  			"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 9348193,
																		"Biology.mp3",		   "3039a3d35b819e15c806b8e1c8d108f3", 904581, 1000),
	MACGAME1("girlsaloudbox", "CD11 See the Day (Classic)",				"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 189904, 1000),
	MACGAME1("girlsaloudbox", "CD11 See the Day (OS X)",				"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 296163, 1000),
	WINGAME2("girlsaloudbox", "CD11 See the Day",				  		"START.EXE",		   "827e5af88f4c096652a1523dc28c9bf4", 7006606,
																		"TRACK.MP3",		   "7cc9e0f7e9257442490650f4cb747339", 4881282, 1000),
	MACGAME1("girlsaloudbox", "CD12 Whole Lotta History (Classic)",		"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 190669, 1000),
	MACGAME1("girlsaloudbox", "CD12 Whole Lotta History (OS X)",		"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 296928, 1000),
	WINGAME2("girlsaloudbox", "CD12 Whole Lotta History",				"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 8680437,
																		"GIRLS ALOUD.mov",	   "0897d41deb1a044243238bb692933226", 58160086, 1000),
	MACGAME1("girlsaloudbox", "CD13 Something Kinda Ooooh (Classic)", 	"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 191649, 1000),
	MACGAME1("girlsaloudbox", "CD13 Something Kinda Ooooh (OS X)",	  	"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 297908, 1000),
	MACGAME1("girlsaloudbox", "CD14 I Think We're Alone Now (Classic)",	"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 248015, 1000),
	MACGAME1("girlsaloudbox", "CD14 I Think We're Alone Now (OS X)",	"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 297853, 1000),
	WINGAME2("girlsaloudbox", "CD14 I Think We're Alone Now",	  		"START.EXE",		   "827e5af88f4c096652a1523dc28c9bf4", 5480254,
																		"girls.mov",		   "055c7cdf5708c24861e8e9d856e7a4b3", 58248141, 1000),
	MACGAME1("girlsaloudbox", "CD15 Walk This Way (Classic)", 			"ECD.classic", 		   "670b37815e4e3f61b7af77cc676a791c", 242326, 1000),
	MACGAME1("girlsaloudbox", "CD15 Walk This Way (OS X)",	  			"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 292174, 1000),
	WINGAME2("girlsaloudbox", "CD15 Walk This Way",						"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 5405872,
																		"walk.mov",			   "546eb2b6de937674e47d20ad406e4ad3", 49937425, 1000),
	MACGAME1("girlsaloudbox", "CD16 Sexy! No No No ... (Classic)",		"ECD.classic", 		   "670b37815e4e3f61b7af77cc676a791c", 257648, 1000),
	MACGAME1("girlsaloudbox", "CD16 Sexy! No No No ... (OS X)",	  		"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 307486, 1000),
	WINGAME2("girlsaloudbox", "CD16 Sexy! No No No ...",	  	  		"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 7730270,
																		"Girls.mov",		   "9148a343290835d87dc297bb10d13c78", 52424731, 1000),
	MACGAME1("girlsaloudbox", "CD17 Call the Shots (Classic)", 			"ECD.classic", 		   "670b37815e4e3f61b7af77cc676a791c", 256127, 1000),
	MACGAME1("girlsaloudbox", "CD17 Call the Shots (OS X)",	  			"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 305965, 1000),
	WINGAME2("girlsaloudbox", "CD17 Call the Shots", 			  		"START.EXE", 		   "827e5af88f4c096652a1523dc28c9bf4", 6006160,
													 					"Girls.mov",		   "b16ea946f4e3096eb2485345fe8899c9", 59580337, 1000),
	MACGAME1("girlsaloudbox", "CD18 Can't Speak French (Classic)", 		"ECD.classic", 		   "670b37815e4e3f61b7af77cc676a791c", 258680, 1000),
	MACGAME1("girlsaloudbox", "CD18 Can't Speak French (OS X)",	  		"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 308520, 1000),
	WINGAME2("girlsaloudbox", "CD18 Can't Speak French", 		  		"START.EXE", 		   "827e5af88f4c096652a1523dc28c9bf4", 8080898,
													 					"french.mov",		   "b64f3b5aaa44dcd3037f01d4f687e072", 53929555, 1000),

	WINGAME2("jsworldp", "",		 "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627915,
									 "LevelData.utd",		"093b8127750b4762ede83231b3085a46", 81284, 1000),
	WINGAME2("jsworldk", "",		 "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd",		"961040b538e8e70affbc54d152de9207", 756700, 1000),
	WINGAME2("jsworld1", "v1.0.4.0", "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd", 	  	"b87a40b62d5f239f6424203bbb35cc4c", 767880, 1000),
	WINGAME2("jsworld1", "v1.0.7.0", "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd", 	  	"04e96ad6119b400c861c188a50d846df", 767904, 1000),
	WINGAME2("jsworld1t", "",	   	 "TeacherPanel.exe",	"bcf64185ce848b7b70858d62945f48a8", 3142911,
									 "TeacherHub.dcr",		"d6b0f959196e656d50c1f6cbf16e1041", 270405, 1000),
	WINGAME2("jsworld2", "",	   	 "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd",		"5b504423963c8c6a09713f8ba96e100f", 976888, 1000),
	WINGAME2("jsworld2t", "",	   	 "TeacherPanel.exe",	"bcf64185ce848b7b70858d62945f48a8", 3142911,
									 "TeacherHub.dcr",		"95a9c2e05fac3181cafc22da932dae2a", 270371, 1000),

	// Original filename is Límit 0.exe
	// Requires installation from D8 app limit0inici
	// Selection of Spanish, Catalan, English at start
	WINGAME1("limit0", "", "Limit 0.exe", "827e5af88f4c096652a1523dc28c9bf4", 4664824, 1000),

	// Found on Bonjour تعليم الفرنسية
	// Software catalogue for Middle East Software Company of Giza, Egypt
	WINGAME1_l("mesoftware", "", "MES.exe", "bcf64185ce848b7b70858d62945f48a8", 3560318, Common::AR_ARB, 1010),

	MACGAME1("miamath", "OS X", "MiaOSX", "666bfa2ee1ae12443ce06f5dd142502b", 53741, 1000),
	WINGAME1("miamath", "", "MiaMath.exe", "0c25e89b5084b272f0eab7827b6e411a", 2671820, 1000),

	// Found on AOL 9.0 trial CD
	WINGAME1("seinfeldondvd", "", "SEINFELD.EXE", "827e5af88f4c096652a1523dc28c9bf4", 3572626, 1000),

	// Time-limited shareware release from BeachWare Inc. Unlock full game with registration code.
	// http://web.archive.org/web/20140629224457/http://www.beachware.com/download/ShellWhirl/ShellWhirl.dmg
	// http://web.archive.org/web/20070207233900/http://www.beachware.com/download/ShellWhirl/ShellWhirlSetup.exe
	MACGAME1("shellwhirl", "", "Shell Whirl", "a171b7a952d1ac68ae3cd419d6dfc674", 313545, 1010),
	WINGAME1("shellwhirl", "", "Shell Whirl.exe", "bcf64185ce848b7b70858d62945f48a8", 3779090, 1010),

	WINDEMO1_l("tokimemotypegs", "Demo", "tkmkgstype.exe", "1d1646000633ab994404ac38fb350553", 2716404, Common::JA_JPN, 1000),

//////////////////////////////////////////////////
//
// Adobe Director v11
//
//////////////////////////////////////////////////

	WINGAME1("mentalmaths", "", "Mental Maths.exe", "b162d633891f0ab2e2fc6ba6164df337", 5017068, 1100),


// Not supported

	MACGAME1("busty3", 		  "", 	   	 "Busty III Slide Viewer", "1682231de376e5465240f6e4a7952072", 289980, 400),
	MACGAME1("busty4", 		  "", 	   	 "Busty 4",	  	 		   "d35d3bb2e79e008e6bd9af62d099344f", 483746, 404),
	WINGAME1("busty3", 		  "", 	   	 "BUSTY3.EXE",			   "07c20a266c2fd9d35960a7ce413cfedf", 4293647, 400),
	WINGAME1("busty4", 		  "",		 "BUSTY4.EXE",	 		   "09d32c60f12c76c6d1d0f3d2d5593e44", 1569431, 404),
	MACDEMO2_l("digitalogue", "Preview", "PREVIEW",   	 		   "f5277c53bacd27936158dd3867e587e2", 392506,
									   	 "preview-1",		 	   "71f28684bafe3195685cf8b7a6c674d9", 1294330, Common::JA_JPN, 311),
	MACGAME1_l("dmpgallery",  "Vol.1",   "Gallery vol.1",		   "a03ae8a9bf211bcb26388b6b6da17c2b", 7522802, Common::JA_JPN, 311),
	MACGAME1_l("dmpgallery",  "Vol.2",   "Gallery vol.2",		   "f5277c53bacd27936158dd3867e587e2", 1941814, Common::JA_JPN, 311),
	MACGAME1_l("dmpgallery",  "Vol.3",   "Gallery vol.3",		   "f5277c53bacd27936158dd3867e587e2", 2913247, Common::JA_JPN, 311),

	// Original Mac filename is Fischer's Erotic Encyclopœdia
	MACGAME1("eros", "", "Fischer's Erotic Encyclopedia", "0c7bbb4b24823e5ab871cb4c1d6f3710", 486982, 404),
	WINGAME1("eros", "", "EROS.EXE", "714d53f8cfbb6a8bb22e535978af6278", 690595, 404),

	// Original filename is ギルガメSDガイ
	MACDEMO1_l("gilgameshnite", "Demo", "Gilgamesh SD Guide", "f5277c53bacd27936158dd3867e587e2", 1173668, Common::JA_JPN, 311),

	// Original filename is ﾍﾙﾑﾄ･ﾆｭｰﾄﾝ & 石田えり
	MACDEMO1_l("immorale", "Demo", "Helmut Newton & Eri Ishida", "f5277c53bacd27936158dd3867e587e2", 390241, Common::JA_JPN, 311),
	MACGAME1("isswim98", "",	   "Inside Sports Swimsuit 98",	 "4577dd3eadc467a986ab172d90871b22", 304156, 404),
	WINGAME1("isswim98", "",	   "ISSWIM98.EXE",				 "24de9da2e30d07ba98d2fd6259afd16c", 753801, 404),
	MACDEMO1_l("legs", "Demo",	   "LEGS Vol.1",				 "f5277c53bacd27936158dd3867e587e2", 548017, Common::JA_JPN, 311),

	// Touring Engine Ver 1.00. Original filename is MacPlaymate™
	MACGAME1("macplaymate1", "",  "MacPlaymate",	 "4bdad2173d739dcaca1241afe88c7aef", 33851, 0),
	MACGAME1("macplaymate2", "",  "MacPlaymate II",	 "cfa68a1bc49251497ebde18e5fc9c217", 822229, 200),
	MACGAME1("pbvv", "",		  "Playboy",		 "f26885badb07dcf3a79defda517d4ddb", 1032662, 602),
	WINGAME1("pbvv", "",		  "PBVV95.EXE",		 "a593079aecf5bd938ce75264cac24b2d", 1700279, 600),
	MACGAME1("playmate1999", "",  "Playboy PowerPC", "63e8b9f6744efefbb8a004a2b76e2b1d", 116023, 650),
	WINGAME1("playmate1999", "",  "PB95.exe",		 "d62438566e44826960fc16c5c23dbe43", 1710252, 650),
	WINGAME1("sadowar", "v1.1",	  "RSP.EXE",		 "3460ad87d2ba57104e2810a77b53c220", 1393989, 500),
	MACDEMO2_l("thebody", "Demo", "DEMO", 			 "bcd3c718db258701496b3c5bcb827ef2", 484323,
								  "START.DIR",		 "beeb32cacc5108838a8b5c6850275b86", 7342, Common::JA_JPN, 404),
	WINDEMO2_l("thebody", "Demo", "DEMO.EXE",		 "763f360a098cf3bec7cbdc5685b1e4a3", 1193483,
								  "START.DIR",		 "dd60f73a3c0590754b07e0cee4ec2921", 7206, Common::JA_JPN, 404),
	WINDEMO2_l("thelegs", "8-bit Color Demo",  "S.EXE",		  "c3c38bd3907ca7e13220b74bd0317a6c", 1013279,
											   "START8.DIR",  "ed4bfebf096a195ae68db0fe7ba999cc", 4812, Common::JA_JPN, 500),
	WINDEMO2_l("thelegs", "16-bit Color Demo", "S.EXE",		  "1c654e09938e5a27f694e694aca13833", 1387193,
											   "START16.DIR", "1b42803d81028c827022eb08e00616b0", 4942, Common::JA_JPN, 500),

	// Original filename is ビーナスの美女のデモ
	MACDEMO1("venus", 	  "Demo", "Venus no Bijo Demo", "1ae45c23586b41997ba52e2e7c771c4c", 3333366, 310),
	MACGAME1("vvalerie1", "",	  "VV",				  	"d830c8fa306d1bd501fbedf1cf9dd57a", 707445, 310),
	MACGAME1("vvalerie2", "",	  "VV2", 				"98229e39001a22ec1cfeb8f124c28483", 307427, 400),
	WINGAME1("vvalerie2", "",	  "VALERIE2.EXE",		"e11ef9aad93815eaacfad6fa6a427c6b", 686367, 400),
	MACGAME1("vveronika", "",	  "Veronika",			"43e89a8298b7dc638e2d6939fadc5234", 94329, 500),
	MACDEMO1("vpeepshow", "Demo", "Virtual PeepShow",	"f5277c53bacd27936158dd3867e587e2", 425489, 311),

	{ AD_TABLE_END_MARKER, GID_GENERIC, 0 }

};

} // End of namespace Director

#endif
