/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitWriter;

class UnitWriterLaTeX
extends UnitWriter {
    public UnitWriterLaTeX(UnitExpr unitExpr) {
        super(unitExpr);
    }

    @Override
    public String write() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        try {
            stringBuilder.append("\\si{");
            if (this.ue.getLogFactor() != 0.0) {
                this.writeNumber(stringBuilder, Math.pow(10.0, this.ue.getLogFactor()));
            }
            for (OneUnit oneUnit : this.ue) {
                double d = oneUnit.getExponent();
                if (d == 1.0) {
                    if (!bl) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(oneUnit.unitString(Syntax.LATEX));
                } else if (d < 0.0) {
                    stringBuilder.append("\\per ").append(oneUnit.unitString(Syntax.LATEX));
                    if (d != -1.0) {
                        stringBuilder.append("^{");
                        this.writeNumber(stringBuilder, -d);
                        stringBuilder.append('}');
                    }
                } else {
                    if (!bl) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(oneUnit.unitString(Syntax.LATEX));
                    stringBuilder.append("^{");
                    this.writeNumber(stringBuilder, d);
                    stringBuilder.append("}");
                }
                bl = false;
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        catch (UnitParserException unitParserException) {
            throw new AssertionError((Object)("units system failed to recognise built-in syntax LATEX: " + unitParserException));
        }
    }

    void writeNumber(StringBuilder stringBuilder, double d) {
        this.writeNumber(stringBuilder, d, false, false, false, false);
    }
}

