//============================================================================
//  The contents of this file are covered by the Viskores license. See
//  LICENSE.txt for details.
//
//  By contributing to this file, all contributors agree to the Developer
//  Certificate of Origin Version 1.1 (DCO 1.1) as stated in DCO.txt.
//============================================================================

//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by FunctionInterfaceDetailPre.h.in

#ifndef viskores_internal_FunctionInterfaceDetailPre_h
#define viskores_internal_FunctionInterfaceDetailPre_h

#if !defined(viskores_internal_FunctionInterface_h) && !defined(VISKORES_TEST_HEADER_BUILD)
#error FunctionInterfaceDetailPre.h must be included from FunctionInterface.h
#endif

#include <viskores/List.h>
#include <viskores/Types.h>
#include <viskores/internal/IndexTag.h>

#include <type_traits>

#define VISKORES_MAX_FUNCTION_PARAMETERS 20


namespace viskores
{
namespace internal
{

/// This struct is used internally by FunctionInterface to store the return
/// value of a function. There is a special implementation for a return type of
/// void, which stores nothing.
///
template <typename T>
struct FunctionInterfaceReturnContainer
{
  T Value;
  static constexpr bool VALID = true;
};

template <>
struct FunctionInterfaceReturnContainer<void>
{
  // Nothing to store for void return.
  static constexpr bool VALID = false;
};

namespace detail
{

//============================================================================

// This templated class contains the state of parameters. If you get a compiler
// error stating that this class is not specialized, that probably means that
// you are using FunctionInterface with an unsupported number of arguments.
template <typename FunctionSignature>
struct ParameterContainer;

// clang-format off

template <typename R>
struct ParameterContainer<R()>
{
};

template <typename R,
          typename P1>
struct ParameterContainer<R(P1)>
{
  P1 Parameter1;
};

template <typename R,
          typename P1,
          typename P2>
struct ParameterContainer<R(P1, P2)>
{
  P1 Parameter1;
  P2 Parameter2;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3>
struct ParameterContainer<R(P1, P2, P3)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4>
struct ParameterContainer<R(P1, P2, P3, P4)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5>
struct ParameterContainer<R(P1, P2, P3, P4, P5)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
  P18 Parameter18;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
  P18 Parameter18;
  P19 Parameter19;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19,
          typename P20>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
  P18 Parameter18;
  P19 Parameter19;
  P20 Parameter20;
};

// clang-format on

//============================================================================
template <typename>
struct FunctionSigInfo;
template <typename R, typename... ArgTypes>
struct FunctionSigInfo<R(ArgTypes...)>
{
  static constexpr std::size_t Arity = sizeof...(ArgTypes);
  using ArityType = std::integral_constant<int, static_cast<int>(Arity)>;

  using ResultType = R;
  using Components = viskores::List<R, ArgTypes...>;
  using Parameters = viskores::List<ArgTypes...>;
};

template <int, typename>
struct AtType;
template <int Index, typename R, typename... ArgTypes>
struct AtType<Index, R(ArgTypes...)>
{
  using type = viskores::ListAt<viskores::List<R, ArgTypes...>, Index>;
};

//============================================================================

// clang-format off

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<1>)
  -> decltype(parameters.Parameter1) const&
{
  return parameters.Parameter1;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<2>)
  -> decltype(parameters.Parameter2) const&
{
  return parameters.Parameter2;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<3>)
  -> decltype(parameters.Parameter3) const&
{
  return parameters.Parameter3;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<4>)
  -> decltype(parameters.Parameter4) const&
{
  return parameters.Parameter4;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<5>)
  -> decltype(parameters.Parameter5) const&
{
  return parameters.Parameter5;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<6>)
  -> decltype(parameters.Parameter6) const&
{
  return parameters.Parameter6;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<7>)
  -> decltype(parameters.Parameter7) const&
{
  return parameters.Parameter7;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<8>)
  -> decltype(parameters.Parameter8) const&
{
  return parameters.Parameter8;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<9>)
  -> decltype(parameters.Parameter9) const&
{
  return parameters.Parameter9;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<10>)
  -> decltype(parameters.Parameter10) const&
{
  return parameters.Parameter10;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<11>)
  -> decltype(parameters.Parameter11) const&
{
  return parameters.Parameter11;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<12>)
  -> decltype(parameters.Parameter12) const&
{
  return parameters.Parameter12;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<13>)
  -> decltype(parameters.Parameter13) const&
{
  return parameters.Parameter13;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<14>)
  -> decltype(parameters.Parameter14) const&
{
  return parameters.Parameter14;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<15>)
  -> decltype(parameters.Parameter15) const&
{
  return parameters.Parameter15;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<16>)
  -> decltype(parameters.Parameter16) const&
{
  return parameters.Parameter16;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<17>)
  -> decltype(parameters.Parameter17) const&
{
  return parameters.Parameter17;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<18>)
  -> decltype(parameters.Parameter18) const&
{
  return parameters.Parameter18;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<19>)
  -> decltype(parameters.Parameter19) const&
{
  return parameters.Parameter19;
}
VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VISKORES_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 viskores::internal::IndexTag<20>)
  -> decltype(parameters.Parameter20) const&
{
  return parameters.Parameter20;
}

// clang-format on

//============================================================================

template <typename OriginalSignature, typename Transform>
struct FunctionInterfaceStaticTransformType;

// clang-format off

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR()>& originalParameters)
{
  (void)transform;
  (void)originalParameters;
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, viskores::internal::IndexTag<14>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, viskores::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, viskores::internal::IndexTag<15>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, viskores::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, viskores::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, viskores::internal::IndexTag<16>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16,
          typename OriginalP17>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16, OriginalP17)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, viskores::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, viskores::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, viskores::internal::IndexTag<16>()),
    transform(originalParameters.Parameter17, viskores::internal::IndexTag<17>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16,
          typename OriginalP17,
          typename OriginalP18>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16, OriginalP17, OriginalP18)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, viskores::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, viskores::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, viskores::internal::IndexTag<16>()),
    transform(originalParameters.Parameter17, viskores::internal::IndexTag<17>()),
    transform(originalParameters.Parameter18, viskores::internal::IndexTag<18>())
  };
}

VISKORES_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16,
          typename OriginalP17,
          typename OriginalP18,
          typename OriginalP19>
VISKORES_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16, OriginalP17, OriginalP18, OriginalP19)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, viskores::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, viskores::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, viskores::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, viskores::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, viskores::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, viskores::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, viskores::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, viskores::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, viskores::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, viskores::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, viskores::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, viskores::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, viskores::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, viskores::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, viskores::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, viskores::internal::IndexTag<16>()),
    transform(originalParameters.Parameter17, viskores::internal::IndexTag<17>()),
    transform(originalParameters.Parameter18, viskores::internal::IndexTag<18>()),
    transform(originalParameters.Parameter19, viskores::internal::IndexTag<19>())
  };
}

// clang-format on

} // namespace detail
}
} // namespace viskores::internal

#endif //viskores_internal_FunctionInterfaceDetailPre_h
