/*******************************************************************************
 *
 *	Font metric data for Symbol
 *
 *	Copyright 2001 Ian Pilcher
 *
 *
 *	See dlls/wineps/data/COPYRIGHTS for font copyright information.
 *
 */

#include "psdrv.h"
#include "data/agl.h"


/*
 *  Glyph metrics
 */

static const AFMMETRICS metrics[188] =
{
    {  32, 0xf020,  250, GN_space },
    {  33, 0xf021,  333, GN_exclam },
    {  34, 0xf022,  713, GN_universal },
    {  35, 0xf023,  500, GN_numbersign },
    {  36, 0xf024,  549, GN_existential },
    {  37, 0xf025,  833, GN_percent },
    {  38, 0xf026,  778, GN_ampersand },
    {  39, 0xf027,  439, GN_suchthat },
    {  40, 0xf028,  333, GN_parenleft },
    {  41, 0xf029,  333, GN_parenright },
    {  42, 0xf02a,  500, GN_asteriskmath },
    {  43, 0xf02b,  549, GN_plus },
    {  44, 0xf02c,  250, GN_comma },
    {  45, 0xf02d,  549, GN_minus },
    {  46, 0xf02e,  250, GN_period },
    {  47, 0xf02f,  278, GN_slash },
    {  48, 0xf030,  500, GN_zero },
    {  49, 0xf031,  500, GN_one },
    {  50, 0xf032,  500, GN_two },
    {  51, 0xf033,  500, GN_three },
    {  52, 0xf034,  500, GN_four },
    {  53, 0xf035,  500, GN_five },
    {  54, 0xf036,  500, GN_six },
    {  55, 0xf037,  500, GN_seven },
    {  56, 0xf038,  500, GN_eight },
    {  57, 0xf039,  500, GN_nine },
    {  58, 0xf03a,  278, GN_colon },
    {  59, 0xf03b,  278, GN_semicolon },
    {  60, 0xf03c,  549, GN_less },
    {  61, 0xf03d,  549, GN_equal },
    {  62, 0xf03e,  549, GN_greater },
    {  63, 0xf03f,  444, GN_question },
    {  64, 0xf040,  549, GN_congruent },
    {  65, 0xf041,  722, GN_Alpha },
    {  66, 0xf042,  667, GN_Beta },
    {  67, 0xf043,  722, GN_Chi },
    {  68, 0xf044,  612, GN_Delta },
    {  69, 0xf045,  611, GN_Epsilon },
    {  70, 0xf046,  763, GN_Phi },
    {  71, 0xf047,  603, GN_Gamma },
    {  72, 0xf048,  722, GN_Eta },
    {  73, 0xf049,  333, GN_Iota },
    {  74, 0xf04a,  631, GN_theta1 },
    {  75, 0xf04b,  722, GN_Kappa },
    {  76, 0xf04c,  686, GN_Lambda },
    {  77, 0xf04d,  889, GN_Mu },
    {  78, 0xf04e,  722, GN_Nu },
    {  79, 0xf04f,  722, GN_Omicron },
    {  80, 0xf050,  768, GN_Pi },
    {  81, 0xf051,  741, GN_Theta },
    {  82, 0xf052,  556, GN_Rho },
    {  83, 0xf053,  592, GN_Sigma },
    {  84, 0xf054,  611, GN_Tau },
    {  85, 0xf055,  690, GN_Upsilon },
    {  86, 0xf056,  439, GN_sigma1 },
    {  87, 0xf057,  768, GN_Omega },
    {  88, 0xf058,  645, GN_Xi },
    {  89, 0xf059,  795, GN_Psi },
    {  90, 0xf05a,  611, GN_Zeta },
    {  91, 0xf05b,  333, GN_bracketleft },
    {  92, 0xf05c,  863, GN_therefore },
    {  93, 0xf05d,  333, GN_bracketright },
    {  94, 0xf05e,  658, GN_perpendicular },
    {  95, 0xf05f,  500, GN_underscore },
    {  96, 0xf060,  500, GN_radicalex },
    {  97, 0xf061,  631, GN_alpha },
    {  98, 0xf062,  549, GN_beta },
    {  99, 0xf063,  549, GN_chi },
    { 100, 0xf064,  494, GN_delta },
    { 101, 0xf065,  439, GN_epsilon },
    { 102, 0xf066,  521, GN_phi },
    { 103, 0xf067,  411, GN_gamma },
    { 104, 0xf068,  603, GN_eta },
    { 105, 0xf069,  329, GN_iota },
    { 106, 0xf06a,  603, GN_phi1 },
    { 107, 0xf06b,  549, GN_kappa },
    { 108, 0xf06c,  549, GN_lambda },
    { 109, 0xf06d,  576, GN_mu },
    { 110, 0xf06e,  521, GN_nu },
    { 111, 0xf06f,  549, GN_omicron },
    { 112, 0xf070,  549, GN_pi },
    { 113, 0xf071,  521, GN_theta },
    { 114, 0xf072,  549, GN_rho },
    { 115, 0xf073,  603, GN_sigma },
    { 116, 0xf074,  439, GN_tau },
    { 117, 0xf075,  576, GN_upsilon },
    { 118, 0xf076,  713, GN_omega1 },
    { 119, 0xf077,  686, GN_omega },
    { 120, 0xf078,  493, GN_xi },
    { 121, 0xf079,  686, GN_psi },
    { 122, 0xf07a,  494, GN_zeta },
    { 123, 0xf07b,  480, GN_braceleft },
    { 124, 0xf07c,  200, GN_bar },
    { 125, 0xf07d,  480, GN_braceright },
    { 126, 0xf07e,  549, GN_similar },
    { 161, 0xf0a1,  620, GN_Upsilon1 },
    { 162, 0xf0a2,  247, GN_minute },
    { 163, 0xf0a3,  549, GN_lessequal },
    { 164, 0xf0a4,  167, GN_fraction },
    { 165, 0xf0a5,  713, GN_infinity },
    { 166, 0xf0a6,  500, GN_florin },
    { 167, 0xf0a7,  753, GN_club },
    { 168, 0xf0a8,  753, GN_diamond },
    { 169, 0xf0a9,  753, GN_heart },
    { 170, 0xf0aa,  753, GN_spade },
    { 171, 0xf0ab, 1042, GN_arrowboth },
    { 172, 0xf0ac,  987, GN_arrowleft },
    { 173, 0xf0ad,  603, GN_arrowup },
    { 174, 0xf0ae,  987, GN_arrowright },
    { 175, 0xf0af,  603, GN_arrowdown },
    { 176, 0xf0b0,  400, GN_degree },
    { 177, 0xf0b1,  549, GN_plusminus },
    { 178, 0xf0b2,  411, GN_second },
    { 179, 0xf0b3,  549, GN_greaterequal },
    { 180, 0xf0b4,  549, GN_multiply },
    { 181, 0xf0b5,  713, GN_proportional },
    { 182, 0xf0b6,  494, GN_partialdiff },
    { 183, 0xf0b7,  460, GN_bullet },
    { 184, 0xf0b8,  549, GN_divide },
    { 185, 0xf0b9,  549, GN_notequal },
    { 186, 0xf0ba,  549, GN_equivalence },
    { 187, 0xf0bb,  549, GN_approxequal },
    { 188, 0xf0bc, 1000, GN_ellipsis },
    { 189, 0xf0bd,  603, GN_arrowvertex },
    { 190, 0xf0be, 1000, GN_arrowhorizex },
    { 191, 0xf0bf,  658, GN_carriagereturn },
    { 192, 0xf0c0,  823, GN_aleph },
    { 193, 0xf0c1,  686, GN_Ifraktur },
    { 194, 0xf0c2,  795, GN_Rfraktur },
    { 195, 0xf0c3,  987, GN_weierstrass },
    { 196, 0xf0c4,  768, GN_circlemultiply },
    { 197, 0xf0c5,  768, GN_circleplus },
    { 198, 0xf0c6,  823, GN_emptyset },
    { 199, 0xf0c7,  768, GN_intersection },
    { 200, 0xf0c8,  768, GN_union },
    { 201, 0xf0c9,  713, GN_propersuperset },
    { 202, 0xf0ca,  713, GN_reflexsuperset },
    { 203, 0xf0cb,  713, GN_notsubset },
    { 204, 0xf0cc,  713, GN_propersubset },
    { 205, 0xf0cd,  713, GN_reflexsubset },
    { 206, 0xf0ce,  713, GN_element },
    { 207, 0xf0cf,  713, GN_notelement },
    { 208, 0xf0d0,  768, GN_angle },
    { 209, 0xf0d1,  713, GN_gradient },
    { 210, 0xf0d2,  790, GN_registerserif },
    { 211, 0xf0d3,  790, GN_copyrightserif },
    { 212, 0xf0d4,  890, GN_trademarkserif },
    { 213, 0xf0d5,  823, GN_product },
    { 214, 0xf0d6,  549, GN_radical },
    { 215, 0xf0d7,  250, GN_dotmath },
    { 216, 0xf0d8,  713, GN_logicalnot },
    { 217, 0xf0d9,  603, GN_logicaland },
    { 218, 0xf0da,  603, GN_logicalor },
    { 219, 0xf0db, 1042, GN_arrowdblboth },
    { 220, 0xf0dc,  987, GN_arrowdblleft },
    { 221, 0xf0dd,  603, GN_arrowdblup },
    { 222, 0xf0de,  987, GN_arrowdblright },
    { 223, 0xf0df,  603, GN_arrowdbldown },
    { 224, 0xf0e0,  494, GN_lozenge },
    { 225, 0xf0e1,  329, GN_angleleft },
    { 226, 0xf0e2,  790, GN_registersans },
    { 227, 0xf0e3,  790, GN_copyrightsans },
    { 228, 0xf0e4,  786, GN_trademarksans },
    { 229, 0xf0e5,  713, GN_summation },
    { 230, 0xf0e6,  384, GN_parenlefttp },
    { 231, 0xf0e7,  384, GN_parenleftex },
    { 232, 0xf0e8,  384, GN_parenleftbt },
    { 233, 0xf0e9,  384, GN_bracketlefttp },
    { 234, 0xf0ea,  384, GN_bracketleftex },
    { 235, 0xf0eb,  384, GN_bracketleftbt },
    { 236, 0xf0ec,  494, GN_bracelefttp },
    { 237, 0xf0ed,  494, GN_braceleftmid },
    { 238, 0xf0ee,  494, GN_braceleftbt },
    { 239, 0xf0ef,  494, GN_braceex },
    { 241, 0xf0f1,  329, GN_angleright },
    { 242, 0xf0f2,  274, GN_integral },
    { 243, 0xf0f3,  686, GN_integraltp },
    { 244, 0xf0f4,  686, GN_integralex },
    { 245, 0xf0f5,  686, GN_integralbt },
    { 246, 0xf0f6,  384, GN_parenrighttp },
    { 247, 0xf0f7,  384, GN_parenrightex },
    { 248, 0xf0f8,  384, GN_parenrightbt },
    { 249, 0xf0f9,  384, GN_bracketrighttp },
    { 250, 0xf0fa,  384, GN_bracketrightex },
    { 251, 0xf0fb,  384, GN_bracketrightbt },
    { 252, 0xf0fc,  494, GN_bracerighttp },
    { 253, 0xf0fd,  494, GN_bracerightmid },
    { 254, 0xf0fe,  494, GN_bracerightbt }
};


/*
 *  Font metrics
 */

const AFM PSDRV_Symbol =
{
    "Symbol",				    /* FontName */
    "Symbol",				    /* FullName */
    "Symbol",				    /* FamilyName */
    "FontSpecific",			    /* EncodingScheme */
    FW_NORMAL,				    /* Weight */
    0,					    /* ItalicAngle */
    FALSE,				    /* IsFixedPitch */
    -98,				    /* UnderlinePosition */
    54,					    /* UnderlineThickness */
    { -180, -293, 1090, 1010 },		    /* FontBBox */
    1010,				    /* Ascender */
    -293,				    /* Descender */
    {
	1000,				    /* WinMetrics.usUnitsPerEm */
	1005,				    /* WinMetrics.sAscender */
	-220,				    /* WinMetrics.sDescender */
	0,				    /* WinMetrics.sLineGap */
	600,				    /* WinMetrics.sAvgCharWidth */
	693,				    /* WinMetrics.sTypoAscender */
	-216,				    /* WinMetrics.sTypoDescender */
	150,				    /* WinMetrics.sTypoLineGap */
	1005,				    /* WinMetrics.usWinAscent */
	220				    /* WinMetrics.usWinDescent */
    },
    188,				    /* NumofMetrics */
    metrics				    /* Metrics */
};
