# encoding: utf-8
# 2011 © Bruno Chareyre <bruno.chareyre@grenoble-inp.fr>
# Check the result of a triaxial test on a dense 100 spheres packing with position defined,
# comparing stresses at the "peak" state. The initial positions have been generated by
# internal compaction without friction, so that it is initially at equilibrium without shear forces. 
# Positions and reference results are in data folder.
from __future__ import print_function
from yade import pack,export,plot
import math,os,sys,shutil,tempfile

tolerance=0.01
interactive=False
tt=TriaxialTest(internalCompaction=True,numberOfGrains=100,compactionFrictionDeg=0,sphereFrictionDeg=30,importFilename=checksPath+'/data/checkTestTriax.spheres')
tt.generate("checkTest.yade")
O.load("checkTest.yade")
O.run(2020,True)
if interactive:
	print(O.engines[4].stress(0)[0],O.engines[4].stress(1)[0], O.engines[4].stress(2)[1], O.engines[4].stress(3)[1], O.engines[4].stress(4)[2], O.engines[4].stress(5)[2])
	os.system('gnuplot -e "plot \'./WallStresses\' using 1:3; replot'+checksPath+'\'/data/WallStressesCheckTest\' using 1:3; replot '+checksPath+'\'/data/WallStresses\' using 1:4; replot '+checksPath+'\'/data/WallStressesCheckTest\' using 1:4; pause -1"')

if abs((O.engines[4].stress(3)[1]+107157.2)/107157.2)>tolerance :
	raise YadeCheckError("Triaxial checkTest: difference on peak stress")       #Test is failed
if abs((O.engines[4].stress(1)[0]+50058.7)/50058.7)>tolerance :
	raise YadeCheckError("Triaxial checkTest: difference on confining stress")  #Test is failed
	
dirpath = tempfile.mkdtemp()

for fileName in ['./checkTest.yade', './_Unloaded_380_3.spheres', './_Unloaded_380_3.xml', './WallStresses', ]:
  if (os.path.exists(fileName)): shutil.move(fileName,dirpath)
  print("File %s moved into %s/ directory"%(fileName,dirpath))
