package ONVIF::Media::Types::FaultCodesOpenEnumType;
use strict;
use warnings;

sub get_xmlns { 'http://www.w3.org/2005/08/addressing'};

# derivation by union
# union is not fully supported yet - value space constraints are not
# checked yet.
# This implementation of union resorts to the simplest possible base, which
# is: "If the <list> or <union> alternative is chosen, then the
# simple ur-type definition·."
#

use base qw(
    SOAP::WSDL::XSD::Typelib::Builtin::anySimpleType
);



1;

__END__

=pod

=head1 NAME



=head1 DESCRIPTION

Perl data type class for the XML Schema defined simpleType
FaultCodesOpenEnumType from the namespace http://www.w3.org/2005/08/addressing.





This type class is derived by union.

Derivation by union is not fully supported yet - value space constraints are
not checked yet.

The current implementation of union resorts to inheriting from the base type,
which means (quoted from the XML Schema specs): "If the <list> or <union>
alternative is chosen, then the simple ur-type definition·."



=head1 METHODS

=head2 new

Constructor.

=head2 get_value / set_value

Getter and setter for the simpleType's value.

=head1 OVERLOADING

Depending on the simple type's base type, the following operations are overloaded

 Stringification
 Numerification
 Boolification

Check L<SOAP::WSDL::XSD::Typelib::Builtin> for more information.

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

